/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.pms.PMS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConfiguration.class);
    private static NetworkConfiguration config;
    private List<InterfaceAssociation> interfaces = new ArrayList<InterfaceAssociation>();
    private Map<String, InterfaceAssociation> mainAddress = new HashMap<String, InterfaceAssociation>();
    private Map<String, Set<InetAddress>> addressMap = new HashMap<String, Set<InetAddress>>();
    private List<String> skipNetworkInterfaces = PMS.getConfiguration().getSkipNetworkInterfaces();

    private NetworkConfiguration(Enumeration<NetworkInterface> networkInterfaces) {
        System.setProperty("java.net.preferIPv4Stack", "true");
        this.checkNetworkInterface(networkInterfaces, null);
    }

    private Set<InetAddress> addAvailableAddresses(NetworkInterface networkInterface) {
        HashSet<InetAddress> addrSet = new HashSet<InetAddress>();
        logger.trace("available addresses for {} is: {}", (Object)networkInterface.getName(), (Object)Collections.list(networkInterface.getInetAddresses()));
        for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
            if (address == null || !this.isRelevantAddress(address)) continue;
            addrSet.add(address);
        }
        logger.trace("non loopback/ipv4 addresses: {}", (Object)addrSet);
        this.addressMap.put(networkInterface.getName(), addrSet);
        return addrSet;
    }

    private boolean isRelevantAddress(InetAddress address) {
        return !(address instanceof Inet6Address) && !address.isLoopbackAddress();
    }

    private void checkNetworkInterface(Enumeration<NetworkInterface> networkInterfaces, String parentName) {
        if (networkInterfaces == null) {
            return;
        }
        logger.trace("checkNetworkInterface(parent = {}, child interfaces = {})", (Object)parentName, (Object)networkInterfaces);
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            if (!this.skipNetworkInterface(ni.getName(), ni.getDisplayName())) {
                this.checkNetworkInterface(ni, parentName);
                continue;
            }
            logger.trace("child network interface ({}, {}) skipped, because skip_network_interfaces='{}'", ni.getName(), ni.getDisplayName(), this.skipNetworkInterfaces);
        }
        logger.trace("checkNetworkInterface(parent = {}) finished", (Object)parentName);
    }

    private Set<InetAddress> getAllAvailableAddresses(Enumeration<NetworkInterface> networkInterfaces) {
        HashSet<InetAddress> addrSet = new HashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface ni = networkInterfaces.nextElement();
            Set<InetAddress> set = this.addressMap.get(ni.getName());
            if (set == null) continue;
            addrSet.addAll(set);
        }
        return addrSet;
    }

    private void checkNetworkInterface(NetworkInterface networkInterface, String parentName) {
        logger.trace("checking {}, display name: {}", (Object)networkInterface.getName(), (Object)networkInterface.getDisplayName());
        this.addAvailableAddresses(networkInterface);
        this.checkNetworkInterface(networkInterface.getSubInterfaces(), networkInterface.getName());
        Set<InetAddress> subAddress = this.getAllAvailableAddresses(networkInterface.getSubInterfaces());
        logger.trace("sub address for {} is {}", (Object)networkInterface.getName(), (Object)subAddress);
        boolean foundAddress = false;
        for (InetAddress address : Collections.list(networkInterface.getInetAddresses())) {
            if (address == null) continue;
            logger.trace("checking {} on {}", new Object[]{address, networkInterface.getName()});
            if (this.isRelevantAddress(address)) {
                if (subAddress.contains(address)) continue;
                logger.trace("found {} -> {}", (Object)networkInterface.getName(), (Object)address.getHostAddress());
                InterfaceAssociation ia = new InterfaceAssociation(address, networkInterface, parentName);
                this.interfaces.add(ia);
                this.mainAddress.put(networkInterface.getName(), ia);
                foundAddress = true;
                continue;
            }
            logger.trace("has {}, which is skipped, because loopback={}, ipv6={}", address, address.isLoopbackAddress(), address instanceof Inet6Address);
        }
        if (!foundAddress) {
            this.interfaces.add(new InterfaceAssociation(null, networkInterface, parentName));
            logger.trace("found {}, without valid address", (Object)networkInterface.getName());
        }
    }

    public List<String> getKeys() {
        ArrayList<String> result = new ArrayList<String>(this.interfaces.size());
        for (InterfaceAssociation i : this.interfaces) {
            result.add(i.getShortName());
        }
        return result;
    }

    public List<String> getDisplayNames() {
        ArrayList<String> result = new ArrayList<String>(this.interfaces.size());
        for (InterfaceAssociation i : this.interfaces) {
            result.add(i.getDisplayName());
        }
        return result;
    }

    public InterfaceAssociation getDefaultNetworkInterfaceAddress() {
        logger.trace("default network interface address from {}", (Object)this.interfaces);
        InterfaceAssociation association = this.getFirstInterfaceWithAddress();
        if (association != null) {
            if (association.getParentName() != null) {
                InterfaceAssociation ia = this.getAddressForNetworkInterfaceName(association.getParentName());
                logger.trace("first association has parent: {} -> {}", (Object)association, (Object)ia);
                return ia;
            }
            logger.trace("first network interface: {}", (Object)association);
            return association;
        }
        return null;
    }

    private InterfaceAssociation getFirstInterfaceWithAddress() {
        for (InterfaceAssociation ia : this.interfaces) {
            if (ia.getAddr() == null) continue;
            return ia;
        }
        return null;
    }

    public InterfaceAssociation getAddressForNetworkInterfaceName(String name) {
        return this.mainAddress.get(name);
    }

    private boolean skipNetworkInterface(String name, String displayName) {
        for (String current : this.skipNetworkInterfaces) {
            if (current == null) continue;
            if (name != null && name.toLowerCase().startsWith(current.toLowerCase())) {
                return true;
            }
            if (displayName == null || !displayName.toLowerCase().startsWith(current.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public NetworkInterface getNetworkInterfaceByServerName() throws SocketException, UnknownHostException {
        String hostname = PMS.getConfiguration().getServerHostname();
        if (hostname != null) {
            logger.trace("Searching network interface for " + hostname);
            return NetworkInterface.getByInetAddress(InetAddress.getByName(hostname));
        }
        return null;
    }

    public static synchronized NetworkConfiguration getInstance() {
        if (config == null) {
            try {
                config = new NetworkConfiguration(NetworkInterface.getNetworkInterfaces());
            }
            catch (SocketException e) {
                logger.error("Inspecting the network failed: " + e.getMessage(), e);
            }
        }
        return config;
    }

    public static synchronized void forgetConfiguration() {
        config = null;
    }

    public static class InterfaceAssociation {
        String parentName;
        InetAddress addr;
        NetworkInterface iface;

        public InterfaceAssociation(InetAddress addr, NetworkInterface iface, String parentName) {
            this.addr = addr;
            this.iface = iface;
            this.parentName = parentName;
        }

        public InetAddress getAddr() {
            return this.addr;
        }

        public NetworkInterface getIface() {
            return this.iface;
        }

        public String getParentName() {
            return this.parentName;
        }

        public String getShortName() {
            return this.iface.getName();
        }

        public String getDisplayName() {
            String displayName = this.iface.getDisplayName();
            displayName = displayName != null ? displayName.trim() : this.iface.getName();
            if (this.addr != null) {
                displayName = displayName + " (" + this.addr.getHostAddress() + ")";
            }
            return displayName;
        }

        public String toString() {
            return "InterfaceAssociation(addr=" + this.addr + ", iface=" + this.iface + ", parent=" + this.parentName + ')';
        }
    }
}

