/*
 * Decompiled with CFR 0.152.
 */
package net.pms.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Observable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.pms.PMS;
import net.pms.update.AutoUpdaterServerProperties;
import net.pms.update.UpdateException;
import net.pms.util.UriRetriever;
import net.pms.util.UriRetrieverCallback;
import net.pms.util.Version;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdater
extends Observable
implements UriRetrieverCallback {
    private static final String TARGET_FILENAME = "new-version.exe";
    private static final Logger logger = LoggerFactory.getLogger(AutoUpdater.class);
    private final String serverUrl;
    private final UriRetriever uriRetriever = new UriRetriever();
    private final AutoUpdaterServerProperties serverProperties = new AutoUpdaterServerProperties();
    private final Version currentVersion;
    private Executor executor = Executors.newSingleThreadExecutor();
    private State state = State.NOTHING_KNOWN;
    private Object stateLock = new Object();
    private Throwable errorStateCause;
    private int bytesDownloaded = -1;
    private int totalBytes = -1;
    private boolean downloadCancelled = false;

    public AutoUpdater(String updateServerUrl, String currentVersion) {
        this.serverUrl = updateServerUrl;
        this.currentVersion = new Version(currentVersion);
    }

    public void pollServer() {
        if (this.serverUrl != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        AutoUpdater.this.doPollServer();
                    }
                    catch (UpdateException e) {
                        AutoUpdater.this.setErrorState(e);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollServer() throws UpdateException {
        this.assertNotInErrorState();
        try {
            this.setState(State.POLLING_SERVER);
            byte[] propertiesAsData = this.uriRetriever.get(this.serverUrl);
            Object object = this.stateLock;
            synchronized (object) {
                this.serverProperties.loadFrom(propertiesAsData);
                this.setState(this.isUpdateAvailable() ? State.UPDATE_AVAILABLE : State.NO_UPDATE_AVAILABLE);
            }
        }
        catch (IOException e) {
            this.wrapException(this.serverUrl, "Cannot download properties", e);
        }
    }

    public void getUpdateFromNetwork() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AutoUpdater.this.doGetUpdateFromNetwork();
                }
                catch (UpdateException e) {
                    AutoUpdater.this.setErrorState(e);
                }
            }
        });
    }

    public void runUpdateAndExit() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    AutoUpdater.this.doRunUpdateAndExit();
                }
                catch (UpdateException e) {
                    AutoUpdater.this.setErrorState(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorState(UpdateException e) {
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(State.ERROR);
            this.errorStateCause = e;
        }
    }

    private void doGetUpdateFromNetwork() throws UpdateException {
        this.assertNotInErrorState();
        this.assertUpdateIsAvailable();
        this.setState(State.DOWNLOAD_IN_PROGRESS);
        this.downloadUpdate();
        this.setState(State.DOWNLOAD_FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunUpdateAndExit() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.DOWNLOAD_FINISHED) {
                throw new UpdateException("Must download before run");
            }
        }
        this.setState(State.EXECUTING_SETUP);
        this.launchExe();
        System.exit(0);
    }

    private void launchExe() throws UpdateException {
        try {
            File exe = new File(TARGET_FILENAME);
            if (!exe.exists()) {
                exe = new File(PMS.getConfiguration().getTempFolder(), TARGET_FILENAME);
            }
            Runtime.getRuntime().exec(exe.getAbsolutePath());
        }
        catch (IOException e) {
            this.wrapException(this.serverProperties.getDownloadUrl(), "Unable to run update. You may need to manually download it.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateIsAvailable() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.serverProperties.isStateValid()) {
                throw new UpdateException("Server error. Try again later.");
            }
            if (!this.isUpdateAvailable()) {
                throw new UpdateException("Attempt to perform non-existent update");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotInErrorState() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.ERROR) {
                throw new UpdateException("Update system must be reset after an error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(State value) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = value;
            if (this.state == State.DOWNLOAD_FINISHED) {
                this.bytesDownloaded = this.totalBytes;
            } else if (this.state != State.DOWNLOAD_IN_PROGRESS) {
                this.bytesDownloaded = -1;
                this.totalBytes = -1;
            }
            if (this.state != State.ERROR) {
                this.errorStateCause = null;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean isUpdateAvailable() {
        return Version.isPmsUpdatable(this.currentVersion, this.serverProperties.getLatestVersion());
    }

    private void downloadUpdate() throws UpdateException {
        String downloadUrl = this.serverProperties.getDownloadUrl();
        try {
            byte[] download = this.uriRetriever.getWithCallback(downloadUrl, this);
            this.writeToDisk(download);
        }
        catch (IOException e) {
            this.wrapException(downloadUrl, "Cannot download update", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToDisk(byte[] download) throws IOException {
        File target = new File(TARGET_FILENAME);
        ByteArrayInputStream downloadedFromNetwork = new ByteArrayInputStream(download);
        FileOutputStream fileOnDisk = null;
        try {
            try {
                fileOnDisk = new FileOutputStream(target);
                fileOnDisk.write("test".getBytes());
            }
            catch (Exception e) {
                target = new File(PMS.getConfiguration().getTempFolder(), TARGET_FILENAME);
            }
            finally {
                fileOnDisk.close();
            }
            fileOnDisk = new FileOutputStream(target);
            int bytesSaved = IOUtils.copy((InputStream)downloadedFromNetwork, (OutputStream)fileOnDisk);
            logger.info("Wrote " + bytesSaved + " bytes to " + target.getAbsolutePath());
        }
        finally {
            IOUtils.closeQuietly(downloadedFromNetwork);
            IOUtils.closeQuietly(fileOnDisk);
        }
    }

    private void wrapException(String downloadUrl, String message, Throwable cause) throws UpdateException {
        throw new UpdateException("Error: " + message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progressMade(String uri, int bytesDownloaded, int totalBytes) throws UriRetrieverCallback.CancelDownloadException {
        Object object = this.stateLock;
        synchronized (object) {
            this.bytesDownloaded = bytesDownloaded;
            this.totalBytes = totalBytes;
            if (this.downloadCancelled) {
                this.setErrorState(new UpdateException("Download cancelled"));
                throw new UriRetrieverCallback.CancelDownloadException();
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getErrorStateCause() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.errorStateCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesDownloaded() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.bytesDownloaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalBytes() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.totalBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownload() {
        Object object = this.stateLock;
        synchronized (object) {
            this.downloadCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadCancelled() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.downloadCancelled;
        }
    }

    public static enum State {
        NOTHING_KNOWN,
        POLLING_SERVER,
        NO_UPDATE_AVAILABLE,
        UPDATE_AVAILABLE,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOAD_FINISHED,
        EXECUTING_SETUP,
        ERROR;

    }
}

