# Kotlin Grammar for Tree-Sitter

[![Build](https://github.com/fwcd/tree-sitter-kotlin/actions/workflows/build.yml/badge.svg)](https://github.com/fwcd/tree-sitter-kotlin/actions/workflows/build.yml)

[Kotlin](https://kotlinlang.org) language grammar for [Tree-Sitter](http://tree-sitter.github.io/tree-sitter/). You can try it out directly [on the web](https://fwcd.github.io/tree-sitter-kotlin).

![Icon](Icon128.png)

The grammar is based on the [official language grammar](https://kotlinlang.org/docs/reference/grammar.html).

## Project Structure

| File | Description |
| ---- | ----------- |
| grammar.js | The Tree-Sitter grammar |
| grammar-reference.js | A direct translation of the Kotlin language grammar that is, however, ambiguous to Tree-Sitter |
| src | The generated parser |

## Setup

>`npm install`

## Development

### Compilation

To (re-)compile the grammar, run:

>`npm run generate`

Note that the grammar is written completely in JavaScript (`grammar.js`), the other source files are generated by `tree-sitter`.

### Testing

To run the unit tests, run:

>`npm run test`

## WebAssembly

### Compilation

First make sure to have [Emscripten](https://emscripten.org/) installed. If you use Homebrew, you can `brew install emscripten`. Then run:

>`npm run build-wasm`

### Playground

After compiling the grammar to WebAssembly, you can invoke

>`npm run playground`

to launch an interactive editing environment that displays the parsed syntax tree on-the-fly in the browser. You can also view a deployed version of this playground [on the web](https://fwcd.github.io/tree-sitter-kotlin).

![Screenshot](playground-screenshot.png)

## Documentation

More documentation on how to create Tree-Sitter grammars [can be found here](https://tree-sitter.github.io/tree-sitter/creating-parsers).

## See also

* [Kotlin Language Server](https://github.com/fwcd/kotlin-language-server) for code completion, diagnostics and more
* [Kotlin Debug Adapter](https://github.com/fwcd/kotlin-debug-adapter) for JVM debugging support
