/***************************************************************************
                          sndsrv.h  -  description
                             -------------------
    begin                : Thu Apr 20 2000
    copyright            : (C) 2000 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SNDSRV_H
#define SNDSRV_H

#ifdef __cplusplus
extern "C" {
#endif

/*
  *@author Michael Speck
  */

/*  SDL's sound is crashing on my computer  with a
    segmentation fault. If it does so on your computer too
    comment the following line...
*/
//#define SOUND

#ifdef SOUND

#include <SDL_audio.h>

// Wave //
typedef struct {
    unsigned char   *buf;
    unsigned int    len;
    SDL_AudioSpec   spec;
} Wave;
Wave* Wave_Load(char *fname);
void Wave_Free(Wave *w);
void Wave_Format(Wave *w, SDL_AudioSpec sp);

// Track //
typedef struct {
    Wave            *wave;
    unsigned char	*audio_pos;
    int             len;
    unsigned char   priority;
} Track;

// Soundserver //
typedef struct {
    SDL_AudioSpec   spec;
    Track           *tracks;
    int             track_num;
    char            volume;
    int             playing;
    int             sleeping;
    int             ok;
} SndSrv;
void SndSrv_Init(int t);
void SndSrv_Quit();
int  SndSrv_Open(SDL_AudioSpec wanted);
void SndSrv_Close();
void SndSrv_Pause(int p);
void SndSrv_Play(Wave *w, int p);
void SndSrv_SetVolume(char v);
void SndSrv_SetActive(int s);
void SndSrv_Callback(void *udata, unsigned char *stream, int len);

#endif

#ifdef __cplusplus
};
#endif

#endif
