/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.nntp;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ProtocolCommandSupport;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.nntp.NNTPCommand;
import org.apache.commons.net.nntp.NNTPConnectionClosedException;

public class NNTP
extends SocketClient {
    public static final int DEFAULT_PORT = 119;
    private static final String __DEFAULT_ENCODING = "ISO-8859-1";
    private StringBuffer __commandBuffer;
    boolean _isAllowedToPost;
    int _replyCode;
    String _replyString;
    protected BufferedReader _reader_;
    protected BufferedWriter _writer_;
    protected ProtocolCommandSupport _commandSupport_;

    public NNTP() {
        this.setDefaultPort(119);
        this.__commandBuffer = new StringBuffer();
        this._replyString = null;
        this._reader_ = null;
        this._writer_ = null;
        this._isAllowedToPost = false;
        this._commandSupport_ = new ProtocolCommandSupport(this);
    }

    private void __getReply() throws IOException {
        this._replyString = this._reader_.readLine();
        if (this._replyString == null) {
            throw new NNTPConnectionClosedException("Connection closed without indication.");
        }
        if (this._replyString.length() < 3) {
            throw new MalformedServerReplyException("Truncated server reply: " + this._replyString);
        }
        try {
            this._replyCode = Integer.parseInt(this._replyString.substring(0, 3));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse response code.\nServer Reply: " + this._replyString);
        }
        if (this._commandSupport_.getListenerCount() > 0) {
            this._commandSupport_.fireReplyReceived(this._replyCode, String.valueOf(this._replyString) + "\r\n");
        }
        if (this._replyCode == 400) {
            throw new NNTPConnectionClosedException("NNTP response 400 received.  Server closed connection.");
        }
    }

    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._reader_ = new BufferedReader(new InputStreamReader(this._input_, __DEFAULT_ENCODING));
        this._writer_ = new BufferedWriter(new OutputStreamWriter(this._output_, __DEFAULT_ENCODING));
        this.__getReply();
        this._isAllowedToPost = this._replyCode == 200;
    }

    public void addProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        this._commandSupport_.addProtocolCommandListener(protocolCommandListener);
    }

    public int article() throws IOException {
        return this.sendCommand(0);
    }

    public int article(int n) throws IOException {
        return this.sendCommand(0, Integer.toString(n));
    }

    public int article(String string) throws IOException {
        return this.sendCommand(0, string);
    }

    public int authinfoPass(String string) throws IOException {
        String string2 = "PASS " + string;
        return this.sendCommand(15, string2);
    }

    public int authinfoUser(String string) throws IOException {
        String string2 = "USER " + string;
        return this.sendCommand(15, string2);
    }

    public int body() throws IOException {
        return this.sendCommand(1);
    }

    public int body(int n) throws IOException {
        return this.sendCommand(1, Integer.toString(n));
    }

    public int body(String string) throws IOException {
        return this.sendCommand(1, string);
    }

    public void disconnect() throws IOException {
        super.disconnect();
        this._reader_ = null;
        this._writer_ = null;
        this._replyString = null;
        this._isAllowedToPost = false;
    }

    public int getReply() throws IOException {
        this.__getReply();
        return this._replyCode;
    }

    public int getReplyCode() {
        return this._replyCode;
    }

    public String getReplyString() {
        return this._replyString;
    }

    public int group(String string) throws IOException {
        return this.sendCommand(2, string);
    }

    public int head() throws IOException {
        return this.sendCommand(3);
    }

    public int head(int n) throws IOException {
        return this.sendCommand(3, Integer.toString(n));
    }

    public int head(String string) throws IOException {
        return this.sendCommand(3, string);
    }

    public int help() throws IOException {
        return this.sendCommand(4);
    }

    public int ihave(String string) throws IOException {
        return this.sendCommand(5, string);
    }

    public boolean isAllowedToPost() {
        return this._isAllowedToPost;
    }

    public int last() throws IOException {
        return this.sendCommand(6);
    }

    public int list() throws IOException {
        return this.sendCommand(7);
    }

    public int listActive(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("ACTIVE ");
        stringBuffer.append(string);
        return this.sendCommand(7, stringBuffer.toString());
    }

    public int newgroups(String string, String string2, boolean bl, String string3) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        if (bl) {
            stringBuffer.append(' ');
            stringBuffer.append("GMT");
        }
        if (string3 != null) {
            stringBuffer.append(" <");
            stringBuffer.append(string3);
            stringBuffer.append('>');
        }
        return this.sendCommand(8, stringBuffer.toString());
    }

    public int newnews(String string, String string2, String string3, boolean bl, String string4) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(string3);
        if (bl) {
            stringBuffer.append(' ');
            stringBuffer.append("GMT");
        }
        if (string4 != null) {
            stringBuffer.append(" <");
            stringBuffer.append(string4);
            stringBuffer.append('>');
        }
        return this.sendCommand(9, stringBuffer.toString());
    }

    public int next() throws IOException {
        return this.sendCommand(10);
    }

    public int post() throws IOException {
        return this.sendCommand(11);
    }

    public int quit() throws IOException {
        return this.sendCommand(12);
    }

    public void removeProtocolCommandListener(ProtocolCommandListener protocolCommandListener) {
        this._commandSupport_.removeProtocolCommandListener(protocolCommandListener);
    }

    public int sendCommand(int n) throws IOException {
        return this.sendCommand(n, null);
    }

    public int sendCommand(int n, String string) throws IOException {
        return this.sendCommand(NNTPCommand._commands[n], string);
    }

    public int sendCommand(String string) throws IOException {
        return this.sendCommand(string, null);
    }

    public int sendCommand(String string, String string2) throws IOException {
        this.__commandBuffer.setLength(0);
        this.__commandBuffer.append(string);
        if (string2 != null) {
            this.__commandBuffer.append(' ');
            this.__commandBuffer.append(string2);
        }
        this.__commandBuffer.append("\r\n");
        String string3 = this.__commandBuffer.toString();
        this._writer_.write(string3);
        this._writer_.flush();
        if (this._commandSupport_.getListenerCount() > 0) {
            this._commandSupport_.fireCommandSent(string, string3);
        }
        this.__getReply();
        return this._replyCode;
    }

    public int stat() throws IOException {
        return this.sendCommand(14);
    }

    public int stat(int n) throws IOException {
        return this.sendCommand(14, Integer.toString(n));
    }

    public int stat(String string) throws IOException {
        return this.sendCommand(14, string);
    }

    public int xhdr(String string, String string2) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" ");
        stringBuffer.append(string2);
        return this.sendCommand(17, stringBuffer.toString());
    }

    public int xover(String string) throws IOException {
        return this.sendCommand(16, string);
    }
}

