/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiElement;
import com.intellij.sql.inspections.dataflow.sql.SqlDfaListener;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlDfaAnchor;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblemKind;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u0010*\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0015\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor;", "Lcom/intellij/sql/inspections/dataflow/sql/SqlDfaListener;", "<init>", "()V", "constantExpressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor$ConstantResult;", "getConstantExpressions", "()Ljava/util/Map;", "nullabilityProblems", "", "Lcom/intellij/sql/inspections/dataflow/sql/problems/SqlNullabilityProblem;", "getNullabilityProblems", "()Ljava/util/List;", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "removeOverlaps", "Lcom/intellij/psi/PsiElement;", "getConstantResult", "dfType", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "ConstantResult", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlDataFlowInstructionVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlDataFlowInstructionVisitor.kt\ncom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1869#2,2:75\n1869#2,2:77\n*S KotlinDebug\n*F\n+ 1 SqlDataFlowInstructionVisitor.kt\ncom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor\n*L\n33#1:75,2\n59#1:77,2\n*E\n"})
public final class SqlDataFlowInstructionVisitor
implements SqlDfaListener {
    @NotNull
    private final Map<SqlExpression, ConstantResult> constantExpressions = new HashMap();
    @NotNull
    private final List<SqlNullabilityProblem<?>> nullabilityProblems = new ArrayList();

    @NotNull
    public final Map<SqlExpression, ConstantResult> getConstantExpressions() {
        return this.constantExpressions;
    }

    @NotNull
    public final List<SqlNullabilityProblem<?>> getNullabilityProblems() {
        return this.nullabilityProblems;
    }

    public void beforePush(@NotNull DfaValue[] args2, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        DfType dfType = state.getDfType(value);
        Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
        DfType dfType2 = dfType;
        if (!(anchor instanceof SqlDfaAnchor)) {
            return;
        }
        PsiElement element = ((SqlDfaAnchor)anchor).getElement();
        if (element instanceof SqlExpression && dfType2 instanceof DfConstantType) {
            ConstantResult constantResult = this.getConstantResult(dfType2);
            this.removeOverlaps(this.constantExpressions, element);
            this.constantExpressions.put((SqlExpression)element, constantResult);
            if (constantResult == ConstantResult.NULL) {
                JBIterable jBIterable = SqlImplUtil.sqlTraverser(element).filter(SqlExpression.class);
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable $this$forEach$iv = (Iterable)jBIterable;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    SqlExpression child = (SqlExpression)element$iv;
                    boolean bl = false;
                    this.nullabilityProblems.removeIf(arg_0 -> SqlDataFlowInstructionVisitor.beforePush$lambda$2$lambda$1(arg_0 -> SqlDataFlowInstructionVisitor.beforePush$lambda$2$lambda$0(child, arg_0), arg_0));
                }
                if ((SqlExpression)element instanceof SqlReferenceExpression) {
                    SqlNullabilityProblem<PsiElement> sqlNullabilityProblem;
                    ConstantResult targetConstantRes;
                    PsiElement target2 = ((SqlReferenceExpression)element).resolve();
                    if (target2 instanceof SqlAsExpression) {
                        target2 = (PsiElement)((SqlAsExpression)target2).getExpression();
                    }
                    if ((targetConstantRes = this.constantExpressions.get(target2)) == ConstantResult.NULL) {
                        SqlNullabilityProblemKind sqlNullabilityProblemKind = SqlNullabilityProblemKind.NullExpression.INSTANCE;
                        PsiElement psiElement = target2;
                        Intrinsics.checkNotNull((Object)psiElement);
                        sqlNullabilityProblem = new SqlNullabilityProblem<PsiElement>(element, sqlNullabilityProblemKind, psiElement);
                    } else {
                        sqlNullabilityProblem = new SqlNullabilityProblem<PsiElement>(element, SqlNullabilityProblemKind.NullExpression.INSTANCE, element);
                    }
                    v5 = this.nullabilityProblems.add(sqlNullabilityProblem);
                } else {
                    v5 = this.nullabilityProblems.add(new SqlNullabilityProblem<PsiElement>(element, SqlNullabilityProblemKind.NullExpression.INSTANCE, element));
                }
            }
        }
    }

    private final void removeOverlaps(Map<SqlExpression, ConstantResult> $this$removeOverlaps, PsiElement anchor) {
        JBIterable jBIterable = SqlImplUtil.sqlTraverser(anchor).filter(SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlExpression it = (SqlExpression)element$iv;
            boolean bl = false;
            $this$removeOverlaps.remove(it);
        }
    }

    private final ConstantResult getConstantResult(DfType dfType) {
        DfType dfType2 = dfType;
        return Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getTRUE()) ? ConstantResult.TRUE : (Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getFALSE()) ? ConstantResult.FALSE : (Intrinsics.areEqual((Object)dfType2, (Object)SqlDfTypesKt.getNULL()) ? ConstantResult.NULL : ConstantResult.UNKNOWN));
    }

    private static final boolean beforePush$lambda$2$lambda$0(SqlExpression $child, SqlNullabilityProblem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getAnchor(), (Object)$child);
    }

    private static final boolean beforePush$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/sql/inspections/dataflow/SqlDataFlowInstructionVisitor$ConstantResult;", "", "<init>", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "NULL", "UNKNOWN", "intellij.database.sql.core.impl"})
    public static final class ConstantResult
    extends Enum<ConstantResult> {
        public static final /* enum */ ConstantResult TRUE = new ConstantResult();
        public static final /* enum */ ConstantResult FALSE = new ConstantResult();
        public static final /* enum */ ConstantResult NULL = new ConstantResult();
        public static final /* enum */ ConstantResult UNKNOWN = new ConstantResult();
        private static final /* synthetic */ ConstantResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstantResult[] values() {
            return (ConstantResult[])$VALUES.clone();
        }

        public static ConstantResult valueOf(String value) {
            return Enum.valueOf(ConstantResult.class, value);
        }

        @NotNull
        public static EnumEntries<ConstantResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constantResultArray = new ConstantResult[]{ConstantResult.TRUE, ConstantResult.FALSE, ConstantResult.NULL, ConstantResult.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

