/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.tsx;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptorImpl;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptJSXTagUtil {
    private static final String DIV_TAG = "div";

    private static boolean isForceOptional(@Nullable JSType type2) {
        if (type2 == null) {
            return false;
        }
        return !type2.isSourceStrict() || type2 instanceof JSContextualUnionType;
    }

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@Nullable JSType type2) {
        return TypeScriptJSXTagUtil.getXmlAttributeDescriptors(type2, (Condition<? super JSRecordType.PropertySignature>)Conditions.alwaysTrue());
    }

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@Nullable JSType type2, @NotNull Condition<? super JSRecordType.PropertySignature> filter2) {
        if (filter2 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(0);
        }
        ArrayList members = new ArrayList();
        boolean forceOptional = TypeScriptJSXTagUtil.isForceOptional(type2);
        TypeScriptJSXTagUtil.processAttributes(type2, (Processor<? super JSRecordType.PropertySignature>)((Processor)signature -> {
            if (!filter2.value(signature)) {
                return true;
            }
            members.add(TypeScriptJSXTagUtil.createAttributeDescriptor(signature, forceOptional));
            return true;
        }));
        return members.toArray(XmlAttributeDescriptor.EMPTY);
    }

    public static XmlAttributeDescriptor @NotNull [] getXmlAttributeDescriptors(@NotNull JSRecordType.PropertySignature property) {
        if (property == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(1);
        }
        XmlAttributeDescriptor[] xmlAttributeDescriptorArray = TypeScriptJSXTagUtil.getXmlAttributeDescriptors(property.getJSType());
        if (xmlAttributeDescriptorArray == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(2);
        }
        return xmlAttributeDescriptorArray;
    }

    @Nullable
    public static JSRecordType.PropertySignature resolveTag(@NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(3);
        }
        if (JSXResolveUtil.isComponentName(tag.getName())) {
            return null;
        }
        return TypeScriptJSXTagUtil.findPropertySignature((PsiElement)tag, tag.getName());
    }

    @Nullable
    private static JSRecordType.PropertySignature findPropertySignature(PsiElement context2, String tagName) {
        return TypeScriptJSXTagUtil.getAllTags(context2).get(tagName);
    }

    @NotNull
    public static Map<String, JSRecordType.PropertySignature> getAllTags(@NotNull PsiElement _context) {
        JSElement scopeElement;
        if (_context == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(4);
        }
        if ((scopeElement = ES6PsiUtil.getNonStrictExportScope(_context)) == null) {
            Map<String, JSRecordType.PropertySignature> map2 = Collections.emptyMap();
            if (map2 == null) {
                TypeScriptJSXTagUtil.$$$reportNull$$$0(5);
            }
            return map2;
        }
        Map map3 = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, () -> TypeScriptJSXTagUtil.lambda$getAllTags$1((PsiElement)scopeElement));
        if (map3 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(6);
        }
        return map3;
    }

    @NotNull
    private static Map<String, JSRecordType.PropertySignature> getAllTagsForScope(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(7);
        }
        JSXImplementation implementation = JSXImplementation.getImplementation(scopeElement);
        JSType jsxType = implementation.getJsxChildInstance(scopeElement, "IntrinsicElements");
        Comparator<JSRecordType.PropertySignature> comparator = Comparator.comparing(TypeScriptJSXTagUtil.getSorter(scopeElement.getProject(), implementation.getLibraries()));
        JSRecordType recordType = jsxType.asRecordType();
        if (recordType.hasMembers()) {
            HashMap<String, JSRecordType.PropertySignature> map2 = new HashMap<String, JSRecordType.PropertySignature>();
            TypeScriptJSXTagUtil.fillFromRecordType(recordType, comparator, map2);
            Map<String, JSRecordType.PropertySignature> map3 = Collections.unmodifiableMap(map2);
            if (map3 == null) {
                TypeScriptJSXTagUtil.$$$reportNull$$$0(8);
            }
            return map3;
        }
        Map<String, JSRecordType.PropertySignature> map4 = Collections.emptyMap();
        if (map4 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(9);
        }
        return map4;
    }

    public static boolean hasClassAttribute(@NotNull PsiElement context2) {
        JSRecordType.PropertySignature div;
        if (context2 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(10);
        }
        if ((div = TypeScriptJSXTagUtil.findPropertySignature(context2, DIV_TAG)) == null) {
            return false;
        }
        JSType type2 = div.getJSType();
        if (type2 == null) {
            return false;
        }
        return type2.asRecordType().findPropertySignature("class") != null;
    }

    private static void fillFromRecordType(@NotNull JSRecordType recordType, @NotNull Comparator<JSRecordType.PropertySignature> comparator, @NotNull Map<String, JSRecordType.PropertySignature> result2) {
        if (recordType == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(11);
        }
        if (comparator == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(13);
        }
        ((StreamEx)StreamEx.of(recordType.getProperties()).sorted(comparator)).forEach(el -> result2.put(el.getMemberName(), (JSRecordType.PropertySignature)el));
    }

    @NotNull
    private static Function<JSRecordType.PropertySignature, String> getSorter(@NotNull Project project, @NotNull Set<VirtualFile> libraryFiles) {
        if (project == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(14);
        }
        if (libraryFiles == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(15);
        }
        Function<JSRecordType.PropertySignature, String> function = member -> {
            PsiElement el = member.getMemberSource().getSingleElement();
            if (el == null) {
                return "";
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)el);
            if (virtualFile == null) {
                return "";
            }
            JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, virtualFile);
            return libraryFiles.contains(virtualFile) || structure != null && Objects.equals(structure.getPackageName(), "@types/react") ? "" : virtualFile.getPath();
        };
        if (function == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(16);
        }
        return function;
    }

    @NotNull
    public static XmlAttributeDescriptor createAttributeDescriptor(@NotNull JSRecordType.PropertySignature signature, boolean forceOptional) {
        if (signature == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(17);
        }
        boolean optional = forceOptional || signature.isOptional();
        JSRecordType.MemberSource source = signature.getMemberSource();
        XmlAttributeDescriptor xmlAttributeDescriptor = JSXAttributeDescriptorImpl.create(signature.getMemberName(), source.getSingleElement(), signature.getJSType(), optional);
        if (xmlAttributeDescriptor == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(18);
        }
        return xmlAttributeDescriptor;
    }

    public static void processAttributes(@NotNull JSRecordType.PropertySignature propertyTag, @NotNull Processor<? super JSRecordType.PropertySignature> processor) {
        if (propertyTag == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(20);
        }
        TypeScriptJSXTagUtil.processAttributes(propertyTag.getJSType(), processor);
    }

    public static void processAttributes(@Nullable JSType type2, @NotNull Processor<? super JSRecordType.PropertySignature> processor) {
        if (processor == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(21);
        }
        if (type2 == null) {
            return;
        }
        List<JSRecordType.TypeMember> typeMembers = type2.asRecordType().getTypeMembers();
        for (JSRecordType.TypeMember member : typeMembers) {
            if (member instanceof JSRecordType.PropertySignature && !processor.process((Object)((JSRecordType.PropertySignature)member))) break;
        }
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$getAllTags$1(PsiElement scopeElement) {
        return CachedValueProvider.Result.create(TypeScriptJSXTagUtil.getAllTagsForScope(scopeElement), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 8, 9, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/tsx/TypeScriptJSXTagUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyTag";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/tsx/TypeScriptJSXTagUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlAttributeDescriptors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTagsForScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXmlAttributeDescriptors";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 18: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveTag";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllTagsForScope";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasClassAttribute";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillFromRecordType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSorter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeDescriptor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processAttributes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 8, 9, 16, 18 -> new IllegalStateException(string);
        };
    }
}

