/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal;

import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.openai.internal.Json;
import dev.langchain4j.model.openai.internal.OpenAiClient;
import dev.langchain4j.model.openai.internal.RequestExecutor;
import dev.langchain4j.model.openai.internal.SyncOrAsync;
import dev.langchain4j.model.openai.internal.SyncOrAsyncOrStreaming;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionRequest;
import dev.langchain4j.model.openai.internal.chat.ChatCompletionResponse;
import dev.langchain4j.model.openai.internal.completion.CompletionRequest;
import dev.langchain4j.model.openai.internal.completion.CompletionResponse;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingRequest;
import dev.langchain4j.model.openai.internal.embedding.EmbeddingResponse;
import dev.langchain4j.model.openai.internal.image.GenerateImagesRequest;
import dev.langchain4j.model.openai.internal.image.GenerateImagesResponse;
import dev.langchain4j.model.openai.internal.moderation.ModerationRequest;
import dev.langchain4j.model.openai.internal.moderation.ModerationResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class DefaultOpenAiClient
extends OpenAiClient {
    private final HttpClient httpClient;
    private final String baseUrl;
    private final Map<String, String> defaultHeaders;

    public DefaultOpenAiClient(Builder builder) {
        HttpClientBuilder httpClientBuilder = (HttpClientBuilder)Utils.getOrDefault((Object)builder.httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = httpClientBuilder.connectTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.connectTimeout, (Object)httpClientBuilder.connectTimeout())), (Object)Duration.ofSeconds(15L))).readTimeout((Duration)Utils.getOrDefault((Object)((Duration)Utils.getOrDefault((Object)builder.readTimeout, (Object)httpClientBuilder.readTimeout())), (Object)Duration.ofSeconds(60L))).build();
        this.httpClient = builder.logRequests || builder.logResponses ? new LoggingHttpClient(httpClient, builder.logRequests, builder.logResponses) : httpClient;
        this.baseUrl = ValidationUtils.ensureNotBlank((String)builder.baseUrl, (String)"baseUrl");
        HashMap<String, String> defaultHeaders = new HashMap<String, String>();
        if (builder.apiKey != null) {
            defaultHeaders.put("Authorization", "Bearer " + builder.apiKey);
        }
        if (builder.organizationId != null) {
            defaultHeaders.put("OpenAI-Organization", builder.organizationId);
        }
        if (builder.projectId != null) {
            defaultHeaders.put("OpenAI-Project", builder.projectId);
        }
        if (builder.userAgent != null) {
            defaultHeaders.put("User-Agent", builder.userAgent);
        }
        if (builder.customHeaders != null) {
            defaultHeaders.putAll(builder.customHeaders);
        }
        this.defaultHeaders = defaultHeaders;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SyncOrAsyncOrStreaming<CompletionResponse> completion(CompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "completions").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(CompletionRequest.builder().from(request).stream(false).build())).build();
        HttpRequest streamingHttpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "completions").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(CompletionRequest.builder().from(request).stream(true).build())).build();
        return new RequestExecutor<CompletionResponse>(this.httpClient, httpRequest, streamingHttpRequest, CompletionResponse.class);
    }

    @Override
    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(ChatCompletionRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "chat/completions").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(ChatCompletionRequest.builder().from(request).stream(false).build())).build();
        HttpRequest streamingHttpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "chat/completions").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(ChatCompletionRequest.builder().from(request).stream(true).build())).build();
        return new RequestExecutor<ChatCompletionResponse>(this.httpClient, httpRequest, streamingHttpRequest, ChatCompletionResponse.class);
    }

    @Override
    public SyncOrAsync<EmbeddingResponse> embedding(EmbeddingRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "embeddings").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(request)).build();
        return new RequestExecutor<EmbeddingResponse>(this.httpClient, httpRequest, EmbeddingResponse.class);
    }

    @Override
    public SyncOrAsync<ModerationResponse> moderation(ModerationRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "moderations").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(request)).build();
        return new RequestExecutor<ModerationResponse>(this.httpClient, httpRequest, ModerationResponse.class);
    }

    @Override
    public SyncOrAsync<GenerateImagesResponse> imagesGeneration(GenerateImagesRequest request) {
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).url(this.baseUrl, "images/generations").addHeader("Content-Type", "application/json").addHeaders(this.defaultHeaders).body(Json.toJson(request)).build();
        return new RequestExecutor<GenerateImagesResponse>(this.httpClient, httpRequest, GenerateImagesResponse.class);
    }

    public static class Builder
    extends OpenAiClient.Builder<DefaultOpenAiClient, Builder> {
        @Override
        public DefaultOpenAiClient build() {
            return new DefaultOpenAiClient(this);
        }
    }
}

