/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageLoadErrorReporter;
import com.intellij.coverage.CoverageLoadingResult;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.FailedCoverageLoadingResult;
import com.intellij.coverage.SimpleCoverageAnnotator;
import com.intellij.coverage.SuccessCoverageLoadingResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.pro.coverage.PyCoverageEngine;
import com.intellij.python.pro.coverage.PyCoverageUtil;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.PathMapper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class PyCoverageRunner
extends CoverageRunner {
    private static final Logger LOG = Logger.getInstance(PyCoverageRunner.class);
    private PathMapper myPathMapper = null;

    public void setPathMapper(PathMapper pathMapper) {
        this.myPathMapper = pathMapper;
    }

    /*
     * Loose catch block
     */
    @NotNull
    public CoverageLoadingResult loadCoverageData(@NotNull File sessionDataFile, @Nullable CoverageSuite baseCoverageSuite, @NotNull CoverageLoadErrorReporter reporter) {
        if (sessionDataFile == null) {
            PyCoverageRunner.$$$reportNull$$$0(0);
        }
        if (reporter == null) {
            PyCoverageRunner.$$$reportNull$$$0(1);
        }
        List<String> sysPath = new ArrayList<String>();
        Object fileName = sessionDataFile.getAbsolutePath();
        if (sessionDataFile.getAbsolutePath().endsWith(".coverage")) {
            fileName = PyCoverageRunner.getBaseFileName(sessionDataFile.getAbsolutePath());
            try {
                sysPath = PyCoverageRunner.loadSysPath((String)fileName);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                LOG.warn("Error reading syspath", (Throwable)e);
                reporter.reportWarning("Error reading syspath: " + e.getMessage(), e);
            }
            if (baseCoverageSuite != null && baseCoverageSuite.getProject() != null) {
                sysPath.addAll(PyCoverageRunner.projectPaths(baseCoverageSuite.getProject()));
            }
            if (!new File((String)fileName + ".xml").exists()) {
                PyCoverageRunner.generateCoverageXml(sessionDataFile, reporter);
            }
        }
        PyCoverageXmlOutputParser xmlOutputParser = new PyCoverageXmlOutputParser(sysPath, this.myPathMapper);
        if (!((String)fileName).endsWith(".xml")) {
            fileName = (String)fileName + ".xml";
        }
        LOG.info("Loading coverage data from " + (String)fileName);
        FileInputStream reader = new FileInputStream((String)fileName);
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new StringReader(""));
            }
        });
        xmlReader.setContentHandler(xmlOutputParser);
        xmlReader.parse(new InputSource(reader));
        ProjectData projectData = xmlOutputParser.getProjectInfo();
        SuccessCoverageLoadingResult successCoverageLoadingResult = new SuccessCoverageLoadingResult(projectData);
        reader.close();
        SuccessCoverageLoadingResult successCoverageLoadingResult2 = successCoverageLoadingResult;
        if (successCoverageLoadingResult2 == null) {
            PyCoverageRunner.$$$reportNull$$$0(2);
        }
        return successCoverageLoadingResult2;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)PythonProBundle.message((String)"python.coverage.results.not.found"), (String)PythonProBundle.message((String)"python.coverage.error")));
                    return new FailedCoverageLoadingResult((Exception)e, true);
                }
                catch (SAXParseException e) {
                    LOG.warn("Exception during parsing coverage results", (Throwable)e);
                    return new FailedCoverageLoadingResult((Exception)e, true, xmlOutputParser.getProjectInfo());
                }
                catch (Exception e) {
                    LOG.warn("Can't process coverage data output" + e.getMessage(), (Throwable)e);
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((String)PythonProBundle.message((String)"python.coverage.cant.read.data"), (String)PythonProBundle.message((String)"python.coverage.error")));
                    return new FailedCoverageLoadingResult(e, true);
                }
            }
        }
    }

    private static void generateCoverageXml(@NotNull File sessionDataFile, @NotNull CoverageLoadErrorReporter reporter) {
        Sdk sdk;
        if (sessionDataFile == null) {
            PyCoverageRunner.$$$reportNull$$$0(3);
        }
        if (reporter == null) {
            PyCoverageRunner.$$$reportNull$$$0(4);
        }
        if ((sdk = PythonSdkType.findLocalCPython(null)) != null) {
            GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{sdk.getHomePath()});
            ParamsGroup group = cmdLine.getParametersList().addParamsGroup("Coverage");
            PyCoverageUtil.addCoverageFileEnv(cmdLine, sessionDataFile.getAbsolutePath());
            PyCoverageUtil.addBundledCoverageToPythonPath(sdk, cmdLine.getEnvironment());
            PythonHelper.COVERAGE.addToGroup(group, cmdLine);
            cmdLine.getEnvironment().put("PYCHARM_RUN_COVERAGE_XML", "1");
            cmdLine.setWorkDirectory(sessionDataFile.getParent());
            try {
                CapturingProcessHandler h = new CapturingProcessHandler(cmdLine);
                ProcessOutput p = h.runProcess();
                p.checkSuccess(LOG);
            }
            catch (ExecutionException e) {
                LOG.error("Can't generate coverage xml", (Throwable)e);
                reporter.reportError((Exception)((Object)e));
            }
        } else {
            String message = "Can't find Python interpreter";
            LOG.warn(message);
            reporter.reportWarning(message, null);
        }
    }

    private static String getBaseFileName(String path2) {
        LOG.assertTrue(path2.endsWith(".coverage"));
        return path2.substring(0, path2.length() - ".coverage".length());
    }

    private static List<String> projectPaths(@NotNull Project project) {
        if (project == null) {
            PyCoverageRunner.$$$reportNull$$$0(5);
        }
        final ArrayList<String> result = new ArrayList<String>();
        RootVisitorHost.visitRootsInAllModules((Project)project, (RootVisitor)new RootVisitor(){

            public boolean visitRoot(VirtualFile root, @Nullable Module module, @Nullable Sdk sdk, boolean isModuleSource) {
                result.add(root.getPath());
                return true;
            }
        });
        return result;
    }

    private static List<String> loadSysPath(@NotNull String baseFileName) {
        if (baseFileName == null) {
            PyCoverageRunner.$$$reportNull$$$0(6);
        }
        try {
            return FileUtil.loadLines((File)new File(baseFileName + ".syspath.txt"));
        }
        catch (Exception e) {
            LOG.warn("Can't load syspath file", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @NotNull
    public String getPresentableName() {
        return "Python";
    }

    @NotNull
    public String getId() {
        return "coverage.py";
    }

    @NotNull
    public String getDataFileExtension() {
        return "coverage";
    }

    public String @NotNull [] getDataFileExtensions() {
        String[] stringArray = new String[]{"xml", "coverage"};
        if (stringArray == null) {
            PyCoverageRunner.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    public boolean acceptsCoverageEngine(@NotNull CoverageEngine engine2) {
        if (engine2 == null) {
            PyCoverageRunner.$$$reportNull$$$0(8);
        }
        return engine2 instanceof PyCoverageEngine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionDataFile";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/pro/coverage/PyCoverageRunner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/pro/coverage/PyCoverageRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCoverageData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFileExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadCoverageData";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateCoverageXml";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "projectPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadSysPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsCoverageEngine";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7 -> new IllegalStateException(string);
        };
    }

    private static final class PyCoverageXmlOutputParser
    extends DefaultHandler {
        final ProjectData myProjectInfo = new ProjectData();
        private String myCurrentClassFileName;
        private List<LineData> myLines;
        private final List<String> mySysPath;
        private final PathMapper myPathMapper;
        boolean myIsSource = false;

        PyCoverageXmlOutputParser(List<String> sysPath, PathMapper pathMapper) {
            this.mySysPath = sysPath;
            this.myPathMapper = pathMapper;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("source".equals(localName)) {
                this.myIsSource = true;
            } else if ("class".equals(localName)) {
                this.myCurrentClassFileName = attributes.getValue("filename");
                this.myLines = new ArrayList<LineData>();
            } else if ("line".equals(localName)) {
                LineData data = new LineData(Integer.parseInt(attributes.getValue("number")), "");
                int hits = Integer.parseInt(attributes.getValue("hits"));
                data.setHits(hits);
                if (attributes.getValue("missing-branches") != null) {
                    String[] lines;
                    for (String line : lines = attributes.getValue("missing-branches").split(",")) {
                        JumpData jd;
                        try {
                            jd = data.addJump(Integer.parseInt(line));
                        }
                        catch (NumberFormatException e) {
                            jd = data.addJump(0);
                        }
                        jd.setFalseHits(hits);
                    }
                    data.fillArrays();
                }
                this.myLines.add(data);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.myIsSource) {
                this.mySysPath.add(new String(ch, start, length));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if ("source".equals(localName)) {
                this.myIsSource = false;
            }
            if ("class".equals(localName)) {
                File classFile = new File(this.myCurrentClassFileName);
                if (this.myPathMapper != null) {
                    classFile = new File(this.myPathMapper.convertToLocal(this.myCurrentClassFileName));
                }
                if (!classFile.exists()) {
                    for (String path2 : this.mySysPath) {
                        classFile = new File(path2, this.myCurrentClassFileName);
                        if (this.myPathMapper != null) {
                            classFile = new File(this.myPathMapper.convertToLocal(classFile.getPath()));
                        }
                        if (!classFile.exists()) continue;
                        break;
                    }
                }
                ClassData data = this.myProjectInfo.getOrCreateClassData(SimpleCoverageAnnotator.getFilePath((String)classFile.getAbsolutePath()));
                int max = 0;
                for (LineData d : this.myLines) {
                    if (d.getLineNumber() <= max) continue;
                    max = d.getLineNumber();
                }
                LineData[] lines = new LineData[max + 1];
                Iterator<LineData> iterator = this.myLines.iterator();
                while (iterator.hasNext()) {
                    LineData d;
                    lines[d.getLineNumber()] = d = iterator.next();
                }
                data.setLines(lines);
            }
        }

        public ProjectData getProjectInfo() {
            return this.myProjectInfo;
        }
    }
}

