/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.figures.interactive;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.python.scientific.PyScientificBundle;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.handler.CefDownloadHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/python/scientific/figures/interactive/BasicCefDownloadHandler;", "Lorg/cef/handler/CefDownloadHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onBeforeDownload", "", "browser", "Lorg/cef/browser/CefBrowser;", "downloadItem", "Lorg/cef/callback/CefDownloadItem;", "suggestedName", "", "callback", "Lorg/cef/callback/CefBeforeDownloadCallback;", "onDownloadUpdated", "Lorg/cef/callback/CefDownloadItemCallback;", "notifyFinish", "path", "intellij.python.scientific"})
@SourceDebugExtension(value={"SMAP\nBasicCefDownloadHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicCefDownloadHandler.kt\ncom/intellij/python/scientific/figures/interactive/BasicCefDownloadHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n295#2,2:75\n*S KotlinDebug\n*F\n+ 1 BasicCefDownloadHandler.kt\ncom/intellij/python/scientific/figures/interactive/BasicCefDownloadHandler\n*L\n36#1:75,2\n*E\n"})
public final class BasicCefDownloadHandler
implements CefDownloadHandler {
    @NotNull
    private final Project project;

    public BasicCefDownloadHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void onBeforeDownload(@NotNull CefBrowser browser, @NotNull CefDownloadItem downloadItem, @Nullable String suggestedName, @Nullable CefBeforeDownloadCallback callback) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            Intrinsics.checkNotNullParameter((Object)downloadItem, (String)"downloadItem");
            Iterable $this$firstOrNull$iv = BaseProjectDirectories.Companion.getBaseDirectories(this.project);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!(it instanceof VirtualDirectoryImpl)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (VirtualFile)v0) == null || (object = object.getCanonicalPath()) == null) {
            String string = FileUtil.getTempDirectory();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
        }
        Object rootDir = object;
        FileSaverDescriptor descriptor = new FileSaverDescriptor(PyScientificBundle.message("plots.select.file.to.save.plot", new Object[0]), "");
        ActionsKt.invokeLater$default(null, () -> BasicCefDownloadHandler.onBeforeDownload$lambda$1(descriptor, this, (String)rootDir, callback), (int)1, null);
    }

    public void onDownloadUpdated(@NotNull CefBrowser browser, @NotNull CefDownloadItem downloadItem, @Nullable CefDownloadItemCallback callback) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)downloadItem, (String)"downloadItem");
        if (downloadItem.isComplete()) {
            String fullPath = downloadItem.getFullPath();
            Intrinsics.checkNotNull((Object)fullPath);
            this.notifyFinish(fullPath);
        }
    }

    private final void notifyFinish(String path2) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Plots");
        String string = PyScientificBundle.message("notification.save.file.is.finished", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        Notification notification = notificationGroup.createNotification(string, messageType).setDisplayId("file.saved");
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"setDisplayId(...)");
        Notification notification2 = notification;
        notification2.addAction((AnAction)NotificationAction.createSimple((String)RevealFileAction.getActionName(), () -> BasicCefDownloadHandler.notifyFinish$lambda$2(this, path2, notification2))).notify(this.project);
    }

    private static final Unit onBeforeDownload$lambda$1(FileSaverDescriptor $descriptor, BasicCefDownloadHandler this$0, String $rootDir, CefBeforeDownloadCallback $callback) {
        block1: {
            FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog($descriptor, this$0.project);
            Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"createSaveFileDialog(...)");
            FileSaverDialog chooser = fileSaverDialog;
            VirtualFileWrapper wrapper = chooser.save(NioPathUtil.toNioPathOrNull((String)$rootDir), "myplot.png");
            VirtualFileWrapper virtualFileWrapper = wrapper;
            if (virtualFileWrapper == null || (virtualFileWrapper = virtualFileWrapper.getVirtualFile()) == null) {
                return Unit.INSTANCE;
            }
            VirtualFileWrapper virtualFile = virtualFileWrapper;
            CefBeforeDownloadCallback cefBeforeDownloadCallback = $callback;
            if (cefBeforeDownloadCallback == null) break block1;
            cefBeforeDownloadCallback.Continue(virtualFile.getCanonicalPath(), false);
        }
        return Unit.INSTANCE;
    }

    private static final void notifyFinish$lambda$2(BasicCefDownloadHandler this$0, String $path, Notification $notification) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this$0.project);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Path path2 = Paths.get($path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        VirtualFile virtualFile = virtualFileManager.findFileByNioPath(path2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        virtualFile2.refresh(false, false);
        fileEditorManager.openFile(virtualFile2, true, true);
        $notification.expire();
    }
}

