/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.scientific.py.tables.providers;

import com.intellij.database.run.ui.table.statisticsPanel.types.ColumnDescriptionStatistics;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.scientific.py.tables.api.PyDevdID;
import com.intellij.scientific.py.tables.commands.DSTableParserKt;
import com.intellij.scientific.py.tables.providers.PyDevdTableDataProviderWithAdditionalData;
import com.intellij.scientific.tables.DSTableRawData;
import com.intellij.scientific.tables.DataId;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.api.FilterComparisonType;
import com.intellij.scientific.tables.api.FilterExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0014J4\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\"\u001a\u00020\u001bH\u0016J\"\u0010#\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u001bH\u0016J\u0018\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*H\u0016J \u0010+\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010&\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006,"}, d2={"Lcom/intellij/scientific/py/tables/providers/PyDatasetProvider;", "Lcom/intellij/scientific/py/tables/providers/PyDevdTableDataProviderWithAdditionalData;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getType", "Lcom/intellij/scientific/tables/api/DSTableDataType;", "getPydevdId", "Lcom/intellij/scientific/py/tables/api/PyDevdID;", "parseStaticTableToFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "text", "", "parseStaticTableToTableData", "Lcom/intellij/scientific/tables/DSTableRawData;", "dataId", "Lcom/intellij/scientific/tables/DataId;", "table", "isFallbackToStaticTableSupported", "", "parseDescribeCommandResult", "", "Lcom/intellij/database/run/ui/table/statisticsPanel/types/ColumnDescriptionStatistics;", "dataFrameRowsCount", "", "describeCommandResult", "getSortingCommand", "tableVariable", "sortKeys", "Ljavax/swing/RowSorter$SortKey;", "columns", "indexColumnWidth", "getFilteringCommand", "filters", "Lcom/intellij/scientific/tables/api/FilterExpression;", "tableColumnsNumber", "composeFilterCommandOneColumn", "columnVariable", "filterExpression", "Lcom/intellij/scientific/tables/api/FilterExpression$SingleExpression;", "getColumnVariableExpressionForFilterCommand", "intellij.scientific.py.tables"})
@SourceDebugExtension(value={"SMAP\nPyDatasetProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDatasetProvider.kt\ncom/intellij/scientific/py/tables/providers/PyDatasetProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1563#2:66\n1634#2,3:67\n1563#2:70\n1634#2,3:71\n*S KotlinDebug\n*F\n+ 1 PyDatasetProvider.kt\ncom/intellij/scientific/py/tables/providers/PyDatasetProvider\n*L\n38#1:66\n38#1:67,3\n39#1:70\n39#1:71,3\n*E\n"})
public final class PyDatasetProvider
extends PyDevdTableDataProviderWithAdditionalData {
    @NotNull
    private final Project project;

    public PyDatasetProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public DSTableDataType getType() {
        return DSTableDataType.HF_DATASET;
    }

    @Override
    @NotNull
    public PyDevdID getPydevdId() {
        return PyDevdID.DATASET;
    }

    @NotNull
    public DSDataFrameInfo parseStaticTableToFrameInfo(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DSDataFrameInfo dataFrameInfo = DSTableParserKt.parseStaticTableHtmlToFrameInfo(text);
        dataFrameInfo.setTableType(this.getType());
        return dataFrameInfo;
    }

    @NotNull
    public DSTableRawData parseStaticTableToTableData(@NotNull DataId dataId, @NotNull String table) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return DSTableParserKt.parseTableHtmlToData(dataId, table);
    }

    public boolean isFallbackToStaticTableSupported() {
        return false;
    }

    @Override
    @Nullable
    protected List<ColumnDescriptionStatistics> parseDescribeCommandResult(int dataFrameRowsCount, @NotNull String describeCommandResult) {
        Intrinsics.checkNotNullParameter((Object)describeCommandResult, (String)"describeCommandResult");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getSortingCommand(@NotNull String tableVariable, @NotNull List<? extends RowSorter.SortKey> sortKeys, @NotNull List<String> columns, int indexColumnWidth) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter(sortKeys, (String)"sortKeys");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (sortKeys.isEmpty()) {
            return tableVariable;
        }
        Iterable $this$map$iv = sortKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            RowSorter.SortKey sortKey = (RowSorter.SortKey)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(tableVariable + ".column_names[" + (it.getColumn() - indexColumnWidth) + "]");
        }
        List cols = (List)destination$iv$iv;
        Iterable $this$map$iv2 = sortKeys;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RowSorter.SortKey bl = (RowSorter.SortKey)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getSortOrder() == SortOrder.ASCENDING ? "False" : "True");
        }
        List orders = (List)destination$iv$iv2;
        String command = tableVariable + ".sort(column_names=" + cols + ", reverse=" + orders + ")";
        return command;
    }

    @NotNull
    public String getFilteringCommand(@NotNull String tableVariable, @Nullable FilterExpression filters, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        if (filters == null) {
            return tableVariable;
        }
        return tableVariable + ".filter(lambda x: " + this.composeFilterCommand(tableVariable, filters, tableColumnsNumber) + ")";
    }

    @Override
    @NotNull
    public String composeFilterCommandOneColumn(@NotNull String columnVariable, @NotNull FilterExpression.SingleExpression filterExpression) {
        Intrinsics.checkNotNullParameter((Object)columnVariable, (String)"columnVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return switch (WhenMappings.$EnumSwitchMapping$0[filterExpression.getCondition().ordinal()]) {
            case 1 -> columnVariable + " is None or " + columnVariable + " != " + columnVariable;
            case 2 -> columnVariable + " is not None and " + columnVariable + " == " + columnVariable;
            case 3 -> columnVariable + " in " + filterExpression.getFilterValue();
            case 4 -> columnVariable + " not in " + filterExpression.getFilterValue();
            case 5 -> columnVariable + ".find(" + filterExpression.getFilterValue() + ") != -1";
            case 6 -> columnVariable + ".startswith(" + filterExpression.getFilterValue() + ")";
            case 7 -> columnVariable + ".endswith(" + filterExpression.getFilterValue() + ")";
            default -> this.composeFilterCommandOneColumnCommon(columnVariable, filterExpression);
        };
    }

    @Override
    @NotNull
    public String getColumnVariableExpressionForFilterCommand(@NotNull String tableVariable, @NotNull FilterExpression.SingleExpression filterExpression, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter((Object)tableVariable, (String)"tableVariable");
        Intrinsics.checkNotNullParameter((Object)filterExpression, (String)"filterExpression");
        return "x['" + filterExpression.getColumnName() + "']";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FilterComparisonType.values().length];
            try {
                nArray[FilterComparisonType.IS_NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IS_NOT_NONE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.IN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.NOT_IN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.CONTAINS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.STARTS_WITH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FilterComparisonType.ENDS_WITH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

