/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModelListenerUtils;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public interface StreamingChatModel {
    default public void chat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        final ChatRequest finalChatRequest = ChatRequest.builder().messages(chatRequest.messages()).parameters(this.defaultRequestParameters().overrideWith(chatRequest.parameters())).build();
        final List<ChatModelListener> listeners = this.listeners();
        final ConcurrentHashMap<Object, Object> attributes = new ConcurrentHashMap<Object, Object>();
        StreamingChatResponseHandler observingHandler = new StreamingChatResponseHandler(){

            @Override
            public void onPartialResponse(String partialResponse) {
                handler.onPartialResponse(partialResponse);
            }

            @Override
            public void onCompleteResponse(ChatResponse completeResponse) {
                ChatModelListenerUtils.onResponse(completeResponse, finalChatRequest, StreamingChatModel.this.provider(), attributes, listeners);
                handler.onCompleteResponse(completeResponse);
            }

            @Override
            public void onError(Throwable error) {
                ChatModelListenerUtils.onError(error, finalChatRequest, StreamingChatModel.this.provider(), attributes, listeners);
                handler.onError(error);
            }
        };
        ChatModelListenerUtils.onRequest(finalChatRequest, this.provider(), attributes, listeners);
        this.doChat(finalChatRequest, observingHandler);
    }

    default public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        throw new RuntimeException("Not implemented");
    }

    default public ChatRequestParameters defaultRequestParameters() {
        return ChatRequestParameters.builder().build();
    }

    default public List<ChatModelListener> listeners() {
        return List.of();
    }

    default public ModelProvider provider() {
        return ModelProvider.OTHER;
    }

    default public void chat(String userMessage, StreamingChatResponseHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(UserMessage.from(userMessage)).build();
        this.chat(chatRequest, handler);
    }

    default public void chat(List<ChatMessage> messages, StreamingChatResponseHandler handler) {
        ChatRequest chatRequest = ChatRequest.builder().messages(messages).build();
        this.chat(chatRequest, handler);
    }

    default public Set<Capability> supportedCapabilities() {
        return Set.of();
    }
}

