//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// MTLCommandBufferStatus reports the current stage in the lifetime of MTLCommandBuffer, as it proceeds to enqueued, committed, scheduled, and completed.
///
///
/// The command buffer has not been enqueued yet.
///
///
/// This command buffer is enqueued, but not committed.
///
///
/// Commited to its command queue, but not yet scheduled for execution.
///
///
/// All dependencies have been resolved and the command buffer has been scheduled for execution.
///
///
/// The command buffer has finished executing successfully: any blocks set with -addCompletedHandler: may now be called.
///
///
/// Execution of the command buffer was aborted due to an error during execution.  Check -error for more information.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbufferstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCommandBufferStatus(pub NSUInteger);
impl MTLCommandBufferStatus {
    #[doc(alias = "MTLCommandBufferStatusNotEnqueued")]
    pub const NotEnqueued: Self = Self(0);
    #[doc(alias = "MTLCommandBufferStatusEnqueued")]
    pub const Enqueued: Self = Self(1);
    #[doc(alias = "MTLCommandBufferStatusCommitted")]
    pub const Committed: Self = Self(2);
    #[doc(alias = "MTLCommandBufferStatusScheduled")]
    pub const Scheduled: Self = Self(3);
    #[doc(alias = "MTLCommandBufferStatusCompleted")]
    pub const Completed: Self = Self(4);
    #[doc(alias = "MTLCommandBufferStatusError")]
    pub const Error: Self = Self(5);
}

unsafe impl Encode for MTLCommandBufferStatus {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCommandBufferStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// An error domain for NSError objects produced by MTLCommandBuffer
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbuffererrordomain?language=objc)
    pub static MTLCommandBufferErrorDomain: &'static NSErrorDomain;
}

/// Error codes that can be found in MTLCommandBuffer.error
///
///
/// An internal error that doesn't fit into the other categories. The actual low level error code is encoded in the local description.
///
///
/// Execution of this command buffer took too long, execution of this command was interrupted and aborted.
///
///
/// Execution of this command buffer generated an unserviceable GPU page fault. This can caused by buffer read write attribute mismatch or out of boundary access.
///
///
/// Access to this device has been revoked because this client has been responsible for too many timeouts or hangs.
///
///
/// This process does not have access to use this device.
///
///
/// Insufficient memory was available to execute this command buffer.
///
///
/// The command buffer referenced an invalid resource.  This is most commonly caused when the caller deletes a resource before executing a command buffer that refers to it.
///
///
/// One or more internal resources limits reached that prevent using memoryless render pass attachments. See error string for more detail.
///
///
/// The device was physically removed before the command could finish execution
///
///
/// Execution of the command buffer was stopped due to Stack Overflow Exception. [MTLComputePipelineDescriptor maxCallStackDepth] setting needs to be checked.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbuffererror?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCommandBufferError(pub NSUInteger);
impl MTLCommandBufferError {
    #[doc(alias = "MTLCommandBufferErrorNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLCommandBufferErrorInternal")]
    pub const Internal: Self = Self(1);
    #[doc(alias = "MTLCommandBufferErrorTimeout")]
    pub const Timeout: Self = Self(2);
    #[doc(alias = "MTLCommandBufferErrorPageFault")]
    pub const PageFault: Self = Self(3);
    #[doc(alias = "MTLCommandBufferErrorBlacklisted")]
    #[deprecated]
    pub const Blacklisted: Self = Self(4);
    #[doc(alias = "MTLCommandBufferErrorAccessRevoked")]
    pub const AccessRevoked: Self = Self(4);
    #[doc(alias = "MTLCommandBufferErrorNotPermitted")]
    pub const NotPermitted: Self = Self(7);
    #[doc(alias = "MTLCommandBufferErrorOutOfMemory")]
    pub const OutOfMemory: Self = Self(8);
    #[doc(alias = "MTLCommandBufferErrorInvalidResource")]
    pub const InvalidResource: Self = Self(9);
    #[doc(alias = "MTLCommandBufferErrorMemoryless")]
    pub const Memoryless: Self = Self(10);
    #[doc(alias = "MTLCommandBufferErrorDeviceRemoved")]
    pub const DeviceRemoved: Self = Self(11);
    #[doc(alias = "MTLCommandBufferErrorStackOverflow")]
    pub const StackOverflow: Self = Self(12);
}

unsafe impl Encode for MTLCommandBufferError {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCommandBufferError {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Key in the userInfo for MTLCommandBufferError NSErrors. Value is an NSArray of MTLCommandBufferEncoderInfo objects in recorded order if an appropriate MTLCommandBufferErrorOption was set, otherwise the key will not exist in the userInfo dictionary.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbufferencoderinfoerrorkey?language=objc)
    pub static MTLCommandBufferEncoderInfoErrorKey: &'static NSErrorUserInfoKey;
}

/// Options for controlling the error reporting for Metal command buffer objects.
///
///
/// No special error reporting.
///
///
/// Provide the execution status of the individual encoders within the command buffer. In the event of a command buffer error, populate the `userInfo` dictionary of the command buffer's NSError parameter, see MTLCommandBufferEncoderInfoErrorKey and MTLCommandBufferEncoderInfo. Note that enabling this error reporting option may increase CPU, GPU, and/or memory overhead on some platforms; testing for impact is suggested.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbuffererroroption?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCommandBufferErrorOption(pub NSUInteger);
bitflags::bitflags! {
    impl MTLCommandBufferErrorOption: NSUInteger {
        #[doc(alias = "MTLCommandBufferErrorOptionNone")]
        const None = 0;
        #[doc(alias = "MTLCommandBufferErrorOptionEncoderExecutionStatus")]
        const EncoderExecutionStatus = 1<<0;
    }
}

unsafe impl Encode for MTLCommandBufferErrorOption {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCommandBufferErrorOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The error states for a Metal command encoder after command buffer execution.
///
///
/// The state of the commands associated with the encoder is unknown (the error information was likely not requested).
///
///
/// The commands associated with the encoder were completed.
///
///
/// The commands associated with the encoder were affected by an error, which may or may not have been caused by the commands themselves, and failed to execute in full.
///
///
/// The commands associated with the encoder never started execution.
///
///
/// The commands associated with the encoder caused an error.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandencodererrorstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCommandEncoderErrorState(pub NSInteger);
impl MTLCommandEncoderErrorState {
    #[doc(alias = "MTLCommandEncoderErrorStateUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "MTLCommandEncoderErrorStateCompleted")]
    pub const Completed: Self = Self(1);
    #[doc(alias = "MTLCommandEncoderErrorStateAffected")]
    pub const Affected: Self = Self(2);
    #[doc(alias = "MTLCommandEncoderErrorStatePending")]
    pub const Pending: Self = Self(3);
    #[doc(alias = "MTLCommandEncoderErrorStateFaulted")]
    pub const Faulted: Self = Self(4);
}

unsafe impl Encode for MTLCommandEncoderErrorState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLCommandEncoderErrorState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// An object that you use to configure new Metal command buffer objects.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbufferdescriptor?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLCommandBufferDescriptor;
);

extern_conformance!(
    unsafe impl NSCopying for MTLCommandBufferDescriptor {}
);

unsafe impl CopyingHelper for MTLCommandBufferDescriptor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for MTLCommandBufferDescriptor {}
);

impl MTLCommandBufferDescriptor {
    extern_methods!(
        /// If YES, the created command buffer holds strong references to objects needed for it to execute. If NO, the created command buffer does not hold strong references to objects needed for it to execute.
        #[unsafe(method(retainedReferences))]
        #[unsafe(method_family = none)]
        pub unsafe fn retainedReferences(&self) -> bool;

        /// Setter for [`retainedReferences`][Self::retainedReferences].
        #[unsafe(method(setRetainedReferences:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRetainedReferences(&self, retained_references: bool);

        /// A set of options to influence the error reporting of the created command buffer. See MTLCommandBufferErrorOption.
        #[unsafe(method(errorOptions))]
        #[unsafe(method_family = none)]
        pub unsafe fn errorOptions(&self) -> MTLCommandBufferErrorOption;

        /// Setter for [`errorOptions`][Self::errorOptions].
        #[unsafe(method(setErrorOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setErrorOptions(&self, error_options: MTLCommandBufferErrorOption);

        #[cfg(feature = "MTLLogState")]
        /// Contains information related to shader logging.
        #[unsafe(method(logState))]
        #[unsafe(method_family = none)]
        pub unsafe fn logState(&self) -> Option<Retained<ProtocolObject<dyn MTLLogState>>>;

        #[cfg(feature = "MTLLogState")]
        /// Setter for [`logState`][Self::logState].
        #[unsafe(method(setLogState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setLogState(&self, log_state: Option<&ProtocolObject<dyn MTLLogState>>);
    );
}

/// Methods declared on superclass `NSObject`.
impl MTLCommandBufferDescriptor {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_protocol!(
    /// Provides execution status information for a Metal command encoder.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbufferencoderinfo?language=objc)
    pub unsafe trait MTLCommandBufferEncoderInfo: NSObjectProtocol {
        /// The debug label given to the associated Metal command encoder at command buffer submission.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        unsafe fn label(&self) -> Retained<NSString>;

        /// The debug signposts inserted into the associated Metal command encoder.
        #[unsafe(method(debugSignposts))]
        #[unsafe(method_family = none)]
        unsafe fn debugSignposts(&self) -> Retained<NSArray<NSString>>;

        /// The error state of the associated Metal command encoder.
        #[unsafe(method(errorState))]
        #[unsafe(method_family = none)]
        unsafe fn errorState(&self) -> MTLCommandEncoderErrorState;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbufferhandler?language=objc)
#[cfg(feature = "block2")]
pub type MTLCommandBufferHandler =
    *mut block2::DynBlock<dyn Fn(NonNull<ProtocolObject<dyn MTLCommandBuffer>>)>;

/// MTLDispatchType Describes how a command encoder will execute dispatched work.
///
///
/// Command encoder dispatches are executed in dispatched order.
///
///
/// Command encoder dispatches are executed in parallel with each other.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtldispatchtype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLDispatchType(pub NSUInteger);
impl MTLDispatchType {
    #[doc(alias = "MTLDispatchTypeSerial")]
    pub const Serial: Self = Self(0);
    #[doc(alias = "MTLDispatchTypeConcurrent")]
    pub const Concurrent: Self = Self(1);
}

unsafe impl Encode for MTLDispatchType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLDispatchType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// A serial list of commands for the device to execute.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/metal/mtlcommandbuffer?language=objc)
    pub unsafe trait MTLCommandBuffer: NSObjectProtocol {
        #[cfg(feature = "MTLDevice")]
        /// The device this resource was created against.
        #[unsafe(method(device))]
        #[unsafe(method_family = none)]
        unsafe fn device(&self) -> Retained<ProtocolObject<dyn MTLDevice>>;

        #[cfg(feature = "MTLCommandQueue")]
        /// The command queue this command buffer was created from.
        #[unsafe(method(commandQueue))]
        #[unsafe(method_family = none)]
        unsafe fn commandQueue(&self) -> Retained<ProtocolObject<dyn MTLCommandQueue>>;

        /// If YES, this command buffer holds strong references to objects needed to execute this command buffer.
        #[unsafe(method(retainedReferences))]
        #[unsafe(method_family = none)]
        unsafe fn retainedReferences(&self) -> bool;

        /// The set of options configuring the error reporting of the created command buffer.
        #[unsafe(method(errorOptions))]
        #[unsafe(method_family = none)]
        unsafe fn errorOptions(&self) -> MTLCommandBufferErrorOption;

        /// A string to help identify this object.
        #[unsafe(method(label))]
        #[unsafe(method_family = none)]
        fn label(&self) -> Option<Retained<NSString>>;

        /// Setter for [`label`][Self::label].
        #[unsafe(method(setLabel:))]
        #[unsafe(method_family = none)]
        fn setLabel(&self, label: Option<&NSString>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(kernelStartTime))]
        #[unsafe(method_family = none)]
        unsafe fn kernelStartTime(&self) -> CFTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(kernelEndTime))]
        #[unsafe(method_family = none)]
        unsafe fn kernelEndTime(&self) -> CFTimeInterval;

        #[cfg(feature = "MTLFunctionLog")]
        /// Logs generated by the command buffer during execution of the GPU commands. Valid after GPU execution is completed
        #[unsafe(method(logs))]
        #[unsafe(method_family = none)]
        unsafe fn logs(&self) -> Retained<ProtocolObject<dyn MTLLogContainer>>;

        #[cfg(feature = "objc2-core-foundation")]
        /// The host time in seconds that GPU starts executing this command buffer. Returns zero if it has not started. This usually can be called in command buffer completion handler.
        #[unsafe(method(GPUStartTime))]
        #[unsafe(method_family = none)]
        unsafe fn GPUStartTime(&self) -> CFTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        /// The host time in seconds that GPU finishes executing this command buffer. Returns zero if CPU has not received completion notification. This usually can be called in command buffer completion handler.
        #[unsafe(method(GPUEndTime))]
        #[unsafe(method_family = none)]
        unsafe fn GPUEndTime(&self) -> CFTimeInterval;

        /// Append this command buffer to the end of its MTLCommandQueue.
        #[unsafe(method(enqueue))]
        #[unsafe(method_family = none)]
        fn enqueue(&self);

        /// Commit a command buffer so it can be executed as soon as possible.
        #[unsafe(method(commit))]
        #[unsafe(method_family = none)]
        fn commit(&self);

        #[cfg(feature = "block2")]
        /// Adds a block to be called when this command buffer has been scheduled for execution.
        #[unsafe(method(addScheduledHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn addScheduledHandler(&self, block: MTLCommandBufferHandler);

        #[cfg(feature = "MTLDrawable")]
        /// Add a drawable present that will be invoked when this command buffer has been scheduled for execution.
        ///
        /// The submission thread will be lock stepped with present call been serviced by window server
        #[unsafe(method(presentDrawable:))]
        #[unsafe(method_family = none)]
        fn presentDrawable(&self, drawable: &ProtocolObject<dyn MTLDrawable>);

        #[cfg(all(feature = "MTLDrawable", feature = "objc2-core-foundation"))]
        /// Add a drawable present for a specific host time that will be invoked when this command buffer has been scheduled for execution.
        ///
        /// The submission thread will be lock stepped with present call been serviced by window server
        #[unsafe(method(presentDrawable:atTime:))]
        #[unsafe(method_family = none)]
        unsafe fn presentDrawable_atTime(
            &self,
            drawable: &ProtocolObject<dyn MTLDrawable>,
            presentation_time: CFTimeInterval,
        );

        #[cfg(all(feature = "MTLDrawable", feature = "objc2-core-foundation"))]
        /// Add a drawable present for a specific host time that allows previous frame to be on screen for at least duration time.
        ///
        /// Parameter `drawable`: The drawable to be presented
        ///
        /// Parameter `duration`: The minimum time that previous frame should be displayed. The time is double preceision floating point in the unit of seconds.
        ///
        /// The difference of this API versus presentDrawable:atTime is that this API defers calculation of the presentation time until the previous frame's actual presentation time is known, thus to be able to maintain a more consistent and stable frame time. This also provides an easy way to set frame rate.
        /// The submission thread will be lock stepped with present call been serviced by window server
        #[unsafe(method(presentDrawable:afterMinimumDuration:))]
        #[unsafe(method_family = none)]
        unsafe fn presentDrawable_afterMinimumDuration(
            &self,
            drawable: &ProtocolObject<dyn MTLDrawable>,
            duration: CFTimeInterval,
        );

        /// Synchronously wait for this command buffer to be scheduled.
        #[unsafe(method(waitUntilScheduled))]
        #[unsafe(method_family = none)]
        fn waitUntilScheduled(&self);

        #[cfg(feature = "block2")]
        /// Add a block to be called when this command buffer has completed execution.
        #[unsafe(method(addCompletedHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn addCompletedHandler(&self, block: MTLCommandBufferHandler);

        /// Synchronously wait for this command buffer to complete.
        #[unsafe(method(waitUntilCompleted))]
        #[unsafe(method_family = none)]
        unsafe fn waitUntilCompleted(&self);

        /// status reports the current stage in the lifetime of MTLCommandBuffer, as it proceeds to enqueued, committed, scheduled, and completed.
        #[unsafe(method(status))]
        #[unsafe(method_family = none)]
        fn status(&self) -> MTLCommandBufferStatus;

        /// If an error occurred during execution, the NSError may contain more details about the problem.
        #[unsafe(method(error))]
        #[unsafe(method_family = none)]
        unsafe fn error(&self) -> Option<Retained<NSError>>;

        #[cfg(all(feature = "MTLBlitCommandEncoder", feature = "MTLCommandEncoder"))]
        /// returns a blit command encoder to encode into this command buffer.
        #[unsafe(method(blitCommandEncoder))]
        #[unsafe(method_family = none)]
        fn blitCommandEncoder(&self)
            -> Option<Retained<ProtocolObject<dyn MTLBlitCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLCommandEncoder",
            feature = "MTLRenderCommandEncoder",
            feature = "MTLRenderPass"
        ))]
        /// returns a render command endcoder to encode into this command buffer.
        #[unsafe(method(renderCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        fn renderCommandEncoderWithDescriptor(
            &self,
            render_pass_descriptor: &MTLRenderPassDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLRenderCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLCommandEncoder",
            feature = "MTLComputeCommandEncoder",
            feature = "MTLComputePass"
        ))]
        /// returns a compute command endcoder to encode into this command buffer.
        #[unsafe(method(computeCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        unsafe fn computeCommandEncoderWithDescriptor(
            &self,
            compute_pass_descriptor: &MTLComputePassDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLComputeCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLBlitCommandEncoder",
            feature = "MTLBlitPass",
            feature = "MTLCommandEncoder"
        ))]
        /// returns a blit command endcoder to encode into this command buffer.
        #[unsafe(method(blitCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        unsafe fn blitCommandEncoderWithDescriptor(
            &self,
            blit_pass_descriptor: &MTLBlitPassDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLBlitCommandEncoder>>>;

        #[cfg(all(feature = "MTLCommandEncoder", feature = "MTLComputeCommandEncoder"))]
        /// returns a compute command encoder to encode into this command buffer.
        #[unsafe(method(computeCommandEncoder))]
        #[unsafe(method_family = none)]
        fn computeCommandEncoder(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLComputeCommandEncoder>>>;

        #[cfg(all(feature = "MTLCommandEncoder", feature = "MTLComputeCommandEncoder"))]
        /// returns a compute command encoder to encode into this command buffer. Optionally allow this command encoder to execute dispatches concurrently.
        ///
        /// On devices that do not support concurrent command encoders, this call is equivalent to computeCommandEncoder
        #[unsafe(method(computeCommandEncoderWithDispatchType:))]
        #[unsafe(method_family = none)]
        fn computeCommandEncoderWithDispatchType(
            &self,
            dispatch_type: MTLDispatchType,
        ) -> Option<Retained<ProtocolObject<dyn MTLComputeCommandEncoder>>>;

        #[cfg(feature = "MTLEvent")]
        /// Encodes a command that pauses execution of this command buffer until the specified event reaches a given value.
        ///
        /// This method may only be called if there is no current command encoder on the receiver.
        #[unsafe(method(encodeWaitForEvent:value:))]
        #[unsafe(method_family = none)]
        fn encodeWaitForEvent_value(&self, event: &ProtocolObject<dyn MTLEvent>, value: u64);

        #[cfg(feature = "MTLEvent")]
        /// Encodes a command that signals an event with a given value.
        ///
        /// This method may only be called if there is no current command encoder on the receiver.
        #[unsafe(method(encodeSignalEvent:value:))]
        #[unsafe(method_family = none)]
        fn encodeSignalEvent_value(&self, event: &ProtocolObject<dyn MTLEvent>, value: u64);

        #[cfg(all(
            feature = "MTLCommandEncoder",
            feature = "MTLParallelRenderCommandEncoder",
            feature = "MTLRenderPass"
        ))]
        /// returns a parallel render pass encoder to encode into this command buffer.
        #[unsafe(method(parallelRenderCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        fn parallelRenderCommandEncoderWithDescriptor(
            &self,
            render_pass_descriptor: &MTLRenderPassDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLParallelRenderCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLCommandEncoder",
            feature = "MTLResourceStateCommandEncoder"
        ))]
        #[unsafe(method(resourceStateCommandEncoder))]
        #[unsafe(method_family = none)]
        unsafe fn resourceStateCommandEncoder(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLResourceStateCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLCommandEncoder",
            feature = "MTLResourceStateCommandEncoder",
            feature = "MTLResourceStatePass"
        ))]
        #[unsafe(method(resourceStateCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        unsafe fn resourceStateCommandEncoderWithDescriptor(
            &self,
            resource_state_pass_descriptor: &MTLResourceStatePassDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLResourceStateCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLAccelerationStructureCommandEncoder",
            feature = "MTLCommandEncoder"
        ))]
        #[unsafe(method(accelerationStructureCommandEncoder))]
        #[unsafe(method_family = none)]
        fn accelerationStructureCommandEncoder(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLAccelerationStructureCommandEncoder>>>;

        #[cfg(all(
            feature = "MTLAccelerationStructureCommandEncoder",
            feature = "MTLCommandEncoder"
        ))]
        #[unsafe(method(accelerationStructureCommandEncoderWithDescriptor:))]
        #[unsafe(method_family = none)]
        unsafe fn accelerationStructureCommandEncoderWithDescriptor(
            &self,
            descriptor: &MTLAccelerationStructurePassDescriptor,
        ) -> Retained<ProtocolObject<dyn MTLAccelerationStructureCommandEncoder>>;

        /// Push a new named string onto a stack of string labels.
        #[unsafe(method(pushDebugGroup:))]
        #[unsafe(method_family = none)]
        fn pushDebugGroup(&self, string: &NSString);

        /// Pop the latest named string off of the stack.
        #[unsafe(method(popDebugGroup))]
        #[unsafe(method_family = none)]
        fn popDebugGroup(&self);

        #[cfg(feature = "MTLResidencySet")]
        /// Marks the residency set as part of the current command buffer execution. This ensures that the residency set is resident during execution of the command buffer.
        #[unsafe(method(useResidencySet:))]
        #[unsafe(method_family = none)]
        unsafe fn useResidencySet(&self, residency_set: &ProtocolObject<dyn MTLResidencySet>);

        #[cfg(feature = "MTLResidencySet")]
        /// Marks the residency sets as part of the current command buffer execution. This ensures that the residency sets are resident during execution of the command buffer.
        #[unsafe(method(useResidencySets:count:))]
        #[unsafe(method_family = none)]
        unsafe fn useResidencySets_count(
            &self,
            residency_sets: NonNull<NonNull<ProtocolObject<dyn MTLResidencySet>>>,
            count: NSUInteger,
        );
    }
);
