//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimodaltransitionstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIModalTransitionStyle(pub NSInteger);
impl UIModalTransitionStyle {
    #[doc(alias = "UIModalTransitionStyleCoverVertical")]
    pub const CoverVertical: Self = Self(0);
    #[doc(alias = "UIModalTransitionStyleFlipHorizontal")]
    pub const FlipHorizontal: Self = Self(1);
    #[doc(alias = "UIModalTransitionStyleCrossDissolve")]
    pub const CrossDissolve: Self = Self(2);
    #[doc(alias = "UIModalTransitionStylePartialCurl")]
    pub const PartialCurl: Self = Self(3);
}

unsafe impl Encode for UIModalTransitionStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIModalTransitionStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uimodalpresentationstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIModalPresentationStyle(pub NSInteger);
impl UIModalPresentationStyle {
    #[doc(alias = "UIModalPresentationFullScreen")]
    pub const FullScreen: Self = Self(0);
    #[doc(alias = "UIModalPresentationPageSheet")]
    pub const PageSheet: Self = Self(1);
    #[doc(alias = "UIModalPresentationFormSheet")]
    pub const FormSheet: Self = Self(2);
    #[doc(alias = "UIModalPresentationCurrentContext")]
    pub const CurrentContext: Self = Self(3);
    #[doc(alias = "UIModalPresentationCustom")]
    pub const Custom: Self = Self(4);
    #[doc(alias = "UIModalPresentationOverFullScreen")]
    pub const OverFullScreen: Self = Self(5);
    #[doc(alias = "UIModalPresentationOverCurrentContext")]
    pub const OverCurrentContext: Self = Self(6);
    #[doc(alias = "UIModalPresentationPopover")]
    pub const Popover: Self = Self(7);
    #[doc(alias = "UIModalPresentationBlurOverFullScreen")]
    pub const BlurOverFullScreen: Self = Self(8);
    #[doc(alias = "UIModalPresentationNone")]
    pub const None: Self = Self(-1);
    #[doc(alias = "UIModalPresentationAutomatic")]
    pub const Automatic: Self = Self(-2);
}

unsafe impl Encode for UIModalPresentationStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIModalPresentationStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontentcontainer?language=objc)
    pub unsafe trait UIContentContainer: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(preferredContentSize))]
        #[unsafe(method_family = none)]
        unsafe fn preferredContentSize(&self) -> CGSize;

        #[unsafe(method(preferredContentSizeDidChangeForChildContentContainer:))]
        #[unsafe(method_family = none)]
        unsafe fn preferredContentSizeDidChangeForChildContentContainer(
            &self,
            container: &ProtocolObject<dyn UIContentContainer>,
        );

        #[unsafe(method(systemLayoutFittingSizeDidChangeForChildContentContainer:))]
        #[unsafe(method_family = none)]
        unsafe fn systemLayoutFittingSizeDidChangeForChildContentContainer(
            &self,
            container: &ProtocolObject<dyn UIContentContainer>,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(sizeForChildContentContainer:withParentContainerSize:))]
        #[unsafe(method_family = none)]
        unsafe fn sizeForChildContentContainer_withParentContainerSize(
            &self,
            container: &ProtocolObject<dyn UIContentContainer>,
            parent_size: CGSize,
        ) -> CGSize;

        #[cfg(all(
            feature = "UIViewControllerTransitionCoordinator",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(viewWillTransitionToSize:withTransitionCoordinator:))]
        #[unsafe(method_family = none)]
        unsafe fn viewWillTransitionToSize_withTransitionCoordinator(
            &self,
            size: CGSize,
            coordinator: &ProtocolObject<dyn UIViewControllerTransitionCoordinator>,
        );

        #[cfg(all(
            feature = "UITraitCollection",
            feature = "UIViewControllerTransitionCoordinator"
        ))]
        #[unsafe(method(willTransitionToTraitCollection:withTransitionCoordinator:))]
        #[unsafe(method_family = none)]
        unsafe fn willTransitionToTraitCollection_withTransitionCoordinator(
            &self,
            new_collection: &UITraitCollection,
            coordinator: &ProtocolObject<dyn UIViewControllerTransitionCoordinator>,
        );
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontrollershowdetailtargetdidchangenotification?language=objc)
    pub static UIViewControllerShowDetailTargetDidChangeNotification: &'static NSNotificationName;
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontroller?language=objc)
    #[unsafe(super(UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIResponder")]
    pub struct UIViewController;
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSCoding for UIViewController {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIViewController {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIAppearanceContainer for UIViewController {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl UIContentContainer for UIViewController {}
);

#[cfg(all(feature = "UIFocus", feature = "UIResponder"))]
extern_conformance!(
    unsafe impl UIFocusEnvironment for UIViewController {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIViewController {}
);

#[cfg(all(feature = "UIResponder", feature = "UITraitCollection"))]
extern_conformance!(
    unsafe impl UITraitEnvironment for UIViewController {}
);

#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(initWithNibName:bundle:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithNibName_bundle(
            this: Allocated<Self>,
            nib_name_or_nil: Option<&NSString>,
            nib_bundle_or_nil: Option<&NSBundle>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "UIView")]
        #[unsafe(method(view))]
        #[unsafe(method_family = none)]
        pub fn view(&self) -> Option<Retained<UIView>>;

        #[cfg(feature = "UIView")]
        /// Setter for [`view`][Self::view].
        #[unsafe(method(setView:))]
        #[unsafe(method_family = none)]
        pub fn setView(&self, view: Option<&UIView>);

        #[unsafe(method(loadView))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadView(&self);

        #[unsafe(method(loadViewIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn loadViewIfNeeded(&self);

        #[cfg(feature = "UIView")]
        #[unsafe(method(viewIfLoaded))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewIfLoaded(&self) -> Option<Retained<UIView>>;

        #[deprecated]
        #[unsafe(method(viewWillUnload))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillUnload(&self);

        #[deprecated]
        #[unsafe(method(viewDidUnload))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidUnload(&self);

        #[unsafe(method(viewDidLoad))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidLoad(&self);

        #[unsafe(method(isViewLoaded))]
        #[unsafe(method_family = none)]
        pub unsafe fn isViewLoaded(&self) -> bool;

        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(nibName))]
        #[unsafe(method_family = none)]
        pub unsafe fn nibName(&self) -> Option<Retained<NSString>>;

        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(nibBundle))]
        #[unsafe(method_family = none)]
        pub unsafe fn nibBundle(&self) -> Option<Retained<NSBundle>>;

        #[cfg(feature = "UIStoryboard")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(storyboard))]
        #[unsafe(method_family = none)]
        pub unsafe fn storyboard(&self) -> Option<Retained<UIStoryboard>>;

        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(performSegueWithIdentifier:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performSegueWithIdentifier_sender(
            &self,
            identifier: &NSString,
            sender: Option<&AnyObject>,
        );

        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(shouldPerformSegueWithIdentifier:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldPerformSegueWithIdentifier_sender(
            &self,
            identifier: &NSString,
            sender: Option<&AnyObject>,
        ) -> bool;

        #[cfg(feature = "UIStoryboardSegue")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(prepareForSegue:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn prepareForSegue_sender(
            &self,
            segue: &UIStoryboardSegue,
            sender: Option<&AnyObject>,
        );

        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(canPerformUnwindSegueAction:fromViewController:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canPerformUnwindSegueAction_fromViewController_sender(
            &self,
            action: Sel,
            from_view_controller: &UIViewController,
            sender: Option<&AnyObject>,
        ) -> bool;

        #[deprecated]
        #[unsafe(method(canPerformUnwindSegueAction:fromViewController:withSender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn canPerformUnwindSegueAction_fromViewController_withSender(
            &self,
            action: Sel,
            from_view_controller: &UIViewController,
            sender: &AnyObject,
        ) -> bool;

        #[cfg(feature = "UIStoryboardSegue")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(allowedChildViewControllersForUnwindingFromSource:))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowedChildViewControllersForUnwindingFromSource(
            &self,
            source: &UIStoryboardUnwindSegueSource,
        ) -> Retained<NSArray<UIViewController>>;

        #[cfg(feature = "UIStoryboardSegue")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(childViewControllerContainingSegueSource:))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerContainingSegueSource(
            &self,
            source: &UIStoryboardUnwindSegueSource,
        ) -> Option<Retained<UIViewController>>;

        #[deprecated]
        #[unsafe(method(viewControllerForUnwindSegueAction:fromViewController:withSender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewControllerForUnwindSegueAction_fromViewController_withSender(
            &self,
            action: Sel,
            from_view_controller: &UIViewController,
            sender: Option<&AnyObject>,
        ) -> Option<Retained<UIViewController>>;

        #[cfg(feature = "UIStoryboardSegue")]
        #[deprecated = "Loading Interface Builder products will not be supported in a future version of visionOS."]
        #[unsafe(method(unwindForSegue:towardsViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unwindForSegue_towardsViewController(
            &self,
            unwind_segue: &UIStoryboardSegue,
            subsequent_vc: &UIViewController,
        );

        #[cfg(feature = "UIStoryboardSegue")]
        #[deprecated]
        #[unsafe(method(segueForUnwindingToViewController:fromViewController:identifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn segueForUnwindingToViewController_fromViewController_identifier(
            &self,
            to_view_controller: &UIViewController,
            from_view_controller: &UIViewController,
            identifier: Option<&NSString>,
        ) -> Option<Retained<UIStoryboardSegue>>;

        /// Called when the view is about to made visible, before it is added to the hierarchy.
        /// Because the view is not yet in the hierarchy at the time this method is called, it
        /// is too early in the appearance transition for many usages. Prefer -viewIsAppearing:
        /// instead of this method when possible. Only use this method when its exact timing
        /// before the appearance transition starts running is desired, such as to set up an
        /// alongside animation with a transition coordinator, or as a counterpart for paired
        /// code in a viewWillDisappear/viewDidDisappear callback that does not rely on the
        /// view or view controller's trait collection or the view hierarchy.
        #[unsafe(method(viewWillAppear:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillAppear(&self, animated: bool);

        /// Called when the view is becoming visible at the beginning of the appearance transition,
        /// after it has been added to the hierarchy and been laid out by its superview. This method
        /// is very similar to -viewWillAppear: and is always called shortly afterwards (so changes
        /// made in either callback will be visible to the user at the same time), but unlike
        /// -viewWillAppear:, at the time when -viewIsAppearing: is called all of the following are
        /// valid for the view controller and its own view:
        /// - View controller and view's trait collection
        /// - View's superview chain and window
        /// - View's geometry (e.g. frame/bounds, safe area insets, layout margins)
        /// Choose this method instead of -viewWillAppear: by default, as it is a direct replacement
        /// that provides equivalent or superior behavior in nearly all cases.
        #[unsafe(method(viewIsAppearing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewIsAppearing(&self, animated: bool);

        /// Called after the view has fully transitioned to visible, when any transition animations have completed.
        #[unsafe(method(viewDidAppear:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidAppear(&self, animated: bool);

        /// Called when the view is about to be dismissed, covered, or otherwise hidden.
        #[unsafe(method(viewWillDisappear:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillDisappear(&self, animated: bool);

        /// Called after the view has fully been dismissed, covered, or otherwise hidden, when any transition animations have completed.
        #[unsafe(method(viewDidDisappear:))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidDisappear(&self, animated: bool);

        #[unsafe(method(viewWillLayoutSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewWillLayoutSubviews(&self);

        #[unsafe(method(viewDidLayoutSubviews))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewDidLayoutSubviews(&self);

        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Option<Retained<NSString>>;

        /// Setter for [`title`][Self::title].
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: Option<&NSString>);

        #[unsafe(method(didReceiveMemoryWarning))]
        #[unsafe(method_family = none)]
        pub unsafe fn didReceiveMemoryWarning(&self);

        #[unsafe(method(parentViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn parentViewController(&self) -> Option<Retained<UIViewController>>;

        #[deprecated]
        #[unsafe(method(modalViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn modalViewController(&self) -> Option<Retained<UIViewController>>;

        #[unsafe(method(presentedViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentedViewController(&self) -> Option<Retained<UIViewController>>;

        #[unsafe(method(presentingViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentingViewController(&self) -> Option<Retained<UIViewController>>;

        #[unsafe(method(definesPresentationContext))]
        #[unsafe(method_family = none)]
        pub unsafe fn definesPresentationContext(&self) -> bool;

        /// Setter for [`definesPresentationContext`][Self::definesPresentationContext].
        #[unsafe(method(setDefinesPresentationContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDefinesPresentationContext(&self, defines_presentation_context: bool);

        #[unsafe(method(providesPresentationContextTransitionStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn providesPresentationContextTransitionStyle(&self) -> bool;

        /// Setter for [`providesPresentationContextTransitionStyle`][Self::providesPresentationContextTransitionStyle].
        #[unsafe(method(setProvidesPresentationContextTransitionStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProvidesPresentationContextTransitionStyle(
            &self,
            provides_presentation_context_transition_style: bool,
        );

        #[unsafe(method(restoresFocusAfterTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn restoresFocusAfterTransition(&self) -> bool;

        /// Setter for [`restoresFocusAfterTransition`][Self::restoresFocusAfterTransition].
        #[unsafe(method(setRestoresFocusAfterTransition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRestoresFocusAfterTransition(&self, restores_focus_after_transition: bool);

        /// The identifier of the focus group that this view controller belongs to. If this is nil, the view controller inherits the focus group of its parent focus environment.
        #[unsafe(method(focusGroupIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn focusGroupIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`focusGroupIdentifier`][Self::focusGroupIdentifier].
        #[unsafe(method(setFocusGroupIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFocusGroupIdentifier(&self, focus_group_identifier: Option<&NSString>);

        /// The base name for tracking user interactions as activities hosted by this view controller.
        #[unsafe(method(interactionActivityTrackingBaseName))]
        #[unsafe(method_family = none)]
        pub unsafe fn interactionActivityTrackingBaseName(&self) -> Option<Retained<NSString>>;

        /// Setter for [`interactionActivityTrackingBaseName`][Self::interactionActivityTrackingBaseName].
        #[unsafe(method(setInteractionActivityTrackingBaseName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInteractionActivityTrackingBaseName(
            &self,
            interaction_activity_tracking_base_name: Option<&NSString>,
        );

        #[unsafe(method(isBeingPresented))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBeingPresented(&self) -> bool;

        #[unsafe(method(isBeingDismissed))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBeingDismissed(&self) -> bool;

        #[unsafe(method(isMovingToParentViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMovingToParentViewController(&self) -> bool;

        #[unsafe(method(isMovingFromParentViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn isMovingFromParentViewController(&self) -> bool;

        #[cfg(feature = "block2")]
        #[unsafe(method(presentViewController:animated:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentViewController_animated_completion(
            &self,
            view_controller_to_present: &UIViewController,
            flag: bool,
            completion: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[cfg(feature = "block2")]
        #[unsafe(method(dismissViewControllerAnimated:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dismissViewControllerAnimated_completion(
            &self,
            flag: bool,
            completion: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[deprecated]
        #[unsafe(method(presentModalViewController:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentModalViewController_animated(
            &self,
            modal_view_controller: &UIViewController,
            animated: bool,
        );

        #[deprecated]
        #[unsafe(method(dismissModalViewControllerAnimated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn dismissModalViewControllerAnimated(&self, animated: bool);

        #[unsafe(method(modalTransitionStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn modalTransitionStyle(&self) -> UIModalTransitionStyle;

        /// Setter for [`modalTransitionStyle`][Self::modalTransitionStyle].
        #[unsafe(method(setModalTransitionStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setModalTransitionStyle(
            &self,
            modal_transition_style: UIModalTransitionStyle,
        );

        #[cfg(feature = "UIViewControllerTransition")]
        /// Preferred system provided transition to use when displaying this
        /// view controller. Note that this only indicates a preference.
        /// The provided transition may be ignored if not supported by the
        /// current context. For example, `UINavigationController` supports
        /// the .zoom transition, but not the .coverVertical transition.
        #[unsafe(method(preferredTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredTransition(&self) -> Option<Retained<UIViewControllerTransition>>;

        #[cfg(feature = "UIViewControllerTransition")]
        /// Setter for [`preferredTransition`][Self::preferredTransition].
        #[unsafe(method(setPreferredTransition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredTransition(
            &self,
            preferred_transition: Option<&UIViewControllerTransition>,
        );

        #[unsafe(method(modalPresentationStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn modalPresentationStyle(&self) -> UIModalPresentationStyle;

        /// Setter for [`modalPresentationStyle`][Self::modalPresentationStyle].
        #[unsafe(method(setModalPresentationStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setModalPresentationStyle(
            &self,
            modal_presentation_style: UIModalPresentationStyle,
        );

        #[unsafe(method(modalPresentationCapturesStatusBarAppearance))]
        #[unsafe(method_family = none)]
        pub unsafe fn modalPresentationCapturesStatusBarAppearance(&self) -> bool;

        /// Setter for [`modalPresentationCapturesStatusBarAppearance`][Self::modalPresentationCapturesStatusBarAppearance].
        #[unsafe(method(setModalPresentationCapturesStatusBarAppearance:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setModalPresentationCapturesStatusBarAppearance(
            &self,
            modal_presentation_captures_status_bar_appearance: bool,
        );

        #[unsafe(method(disablesAutomaticKeyboardDismissal))]
        #[unsafe(method_family = none)]
        pub unsafe fn disablesAutomaticKeyboardDismissal(&self) -> bool;

        #[deprecated]
        #[unsafe(method(wantsFullScreenLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn wantsFullScreenLayout(&self) -> bool;

        /// Setter for [`wantsFullScreenLayout`][Self::wantsFullScreenLayout].
        #[deprecated]
        #[unsafe(method(setWantsFullScreenLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWantsFullScreenLayout(&self, wants_full_screen_layout: bool);

        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(edgesForExtendedLayout))]
        #[unsafe(method_family = none)]
        pub unsafe fn edgesForExtendedLayout(&self) -> UIRectEdge;

        #[cfg(feature = "UIGeometry")]
        /// Setter for [`edgesForExtendedLayout`][Self::edgesForExtendedLayout].
        #[unsafe(method(setEdgesForExtendedLayout:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEdgesForExtendedLayout(&self, edges_for_extended_layout: UIRectEdge);

        #[unsafe(method(extendedLayoutIncludesOpaqueBars))]
        #[unsafe(method_family = none)]
        pub unsafe fn extendedLayoutIncludesOpaqueBars(&self) -> bool;

        /// Setter for [`extendedLayoutIncludesOpaqueBars`][Self::extendedLayoutIncludesOpaqueBars].
        #[unsafe(method(setExtendedLayoutIncludesOpaqueBars:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExtendedLayoutIncludesOpaqueBars(
            &self,
            extended_layout_includes_opaque_bars: bool,
        );

        #[deprecated = "Use UIScrollView's contentInsetAdjustmentBehavior instead"]
        #[unsafe(method(automaticallyAdjustsScrollViewInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn automaticallyAdjustsScrollViewInsets(&self) -> bool;

        /// Setter for [`automaticallyAdjustsScrollViewInsets`][Self::automaticallyAdjustsScrollViewInsets].
        #[deprecated = "Use UIScrollView's contentInsetAdjustmentBehavior instead"]
        #[unsafe(method(setAutomaticallyAdjustsScrollViewInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAutomaticallyAdjustsScrollViewInsets(
            &self,
            automatically_adjusts_scroll_view_insets: bool,
        );

        #[cfg(all(feature = "UIGeometry", feature = "UIScrollView", feature = "UIView"))]
        /// Aggregate values (e.g., NSDirectionalRectEdgeAll) are accepted in the `edge` parameter; NSDirectionalRectEdgeLeading and Trailing are ignored on iOS 15.0
        #[unsafe(method(setContentScrollView:forEdge:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentScrollView_forEdge(
            &self,
            scroll_view: Option<&UIScrollView>,
            edge: NSDirectionalRectEdge,
        );

        #[cfg(all(feature = "UIGeometry", feature = "UIScrollView", feature = "UIView"))]
        /// Pass only a single edge (e.g., NSDirectionalRectEdgeTop) in the `edge` parameter. Raises an exception when passed an aggregate edge (e.g., NSDirectionalRectEdgeAll)
        #[unsafe(method(contentScrollViewForEdge:))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentScrollViewForEdge(
            &self,
            edge: NSDirectionalRectEdge,
        ) -> Option<Retained<UIScrollView>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(preferredContentSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredContentSize(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`preferredContentSize`][Self::preferredContentSize].
        #[unsafe(method(setPreferredContentSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredContentSize(&self, preferred_content_size: CGSize);

        #[cfg(feature = "UIApplication")]
        #[deprecated = "Has no effect on visionOS"]
        #[unsafe(method(preferredStatusBarStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredStatusBarStyle(&self) -> UIStatusBarStyle;

        #[deprecated = "Has no effect on visionOS"]
        #[unsafe(method(prefersStatusBarHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersStatusBarHidden(&self) -> bool;

        #[cfg(feature = "UIApplication")]
        #[deprecated = "Has no effect on visionOS"]
        #[unsafe(method(preferredStatusBarUpdateAnimation))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredStatusBarUpdateAnimation(&self) -> UIStatusBarAnimation;

        #[unsafe(method(setNeedsStatusBarAppearanceUpdate))]
        #[unsafe(method_family = none)]
        pub fn setNeedsStatusBarAppearanceUpdate(&self);

        #[unsafe(method(targetViewControllerForAction:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn targetViewControllerForAction_sender(
            &self,
            action: Sel,
            sender: Option<&AnyObject>,
        ) -> Option<Retained<UIViewController>>;

        #[unsafe(method(showViewController:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showViewController_sender(
            &self,
            vc: &UIViewController,
            sender: Option<&AnyObject>,
        );

        #[unsafe(method(showDetailViewController:sender:))]
        #[unsafe(method_family = none)]
        pub unsafe fn showDetailViewController_sender(
            &self,
            vc: &UIViewController,
            sender: Option<&AnyObject>,
        );

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(preferredUserInterfaceStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredUserInterfaceStyle(&self) -> UIUserInterfaceStyle;

        #[unsafe(method(setNeedsUserInterfaceAppearanceUpdate))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUserInterfaceAppearanceUpdate(&self);

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(overrideUserInterfaceStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn overrideUserInterfaceStyle(&self) -> UIUserInterfaceStyle;

        #[cfg(feature = "UIInterface")]
        /// Setter for [`overrideUserInterfaceStyle`][Self::overrideUserInterfaceStyle].
        #[unsafe(method(setOverrideUserInterfaceStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOverrideUserInterfaceStyle(
            &self,
            override_user_interface_style: UIUserInterfaceStyle,
        );
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// UIViewControllerRotation.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[deprecated = "Please use instance method `setNeedsUpdateOfSupportedInterfaceOrientations`."]
        #[unsafe(method(attemptRotationToDeviceOrientation))]
        #[unsafe(method_family = none)]
        pub fn attemptRotationToDeviceOrientation(mtm: MainThreadMarker);

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(shouldAutorotateToInterfaceOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldAutorotateToInterfaceOrientation(
            &self,
            to_interface_orientation: UIInterfaceOrientation,
        ) -> bool;

        #[deprecated = "Update supported interface orientations and call setNeedsUpdateOfSupportedInterfaceOrientations to indicate a change."]
        #[unsafe(method(shouldAutorotate))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldAutorotate(&self) -> bool;

        #[cfg(feature = "UIOrientation")]
        #[unsafe(method(supportedInterfaceOrientations))]
        #[unsafe(method_family = none)]
        pub unsafe fn supportedInterfaceOrientations(&self) -> UIInterfaceOrientationMask;

        #[cfg(feature = "UIOrientation")]
        #[unsafe(method(preferredInterfaceOrientationForPresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredInterfaceOrientationForPresentation(&self)
            -> UIInterfaceOrientation;

        /// Notifies the view controller that a change occurred that affects supported interface orientations or the preferred interface orientation for presentation.
        /// By default, this will animate any changes to orientation. To perform a non-animated update, call within `[UIView performWithoutAnimation:]`.
        #[unsafe(method(setNeedsUpdateOfSupportedInterfaceOrientations))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUpdateOfSupportedInterfaceOrientations(&self);

        #[cfg(feature = "UIView")]
        #[deprecated = "Header views are animated along with the rest of the view hierarchy"]
        #[unsafe(method(rotatingHeaderView))]
        #[unsafe(method_family = none)]
        pub unsafe fn rotatingHeaderView(&self) -> Option<Retained<UIView>>;

        #[cfg(feature = "UIView")]
        #[deprecated = "Footer views are animated along with the rest of the view hierarchy"]
        #[unsafe(method(rotatingFooterView))]
        #[unsafe(method_family = none)]
        pub unsafe fn rotatingFooterView(&self) -> Option<Retained<UIView>>;

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(interfaceOrientation))]
        #[unsafe(method_family = none)]
        pub unsafe fn interfaceOrientation(&self) -> UIInterfaceOrientation;

        #[cfg(feature = "UIOrientation")]
        #[deprecated = "Implement viewWillTransitionToSize:withTransitionCoordinator: instead"]
        #[unsafe(method(willRotateToInterfaceOrientation:duration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willRotateToInterfaceOrientation_duration(
            &self,
            to_interface_orientation: UIInterfaceOrientation,
            duration: NSTimeInterval,
        );

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(didRotateFromInterfaceOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didRotateFromInterfaceOrientation(
            &self,
            from_interface_orientation: UIInterfaceOrientation,
        );

        #[cfg(feature = "UIOrientation")]
        #[deprecated = "Implement viewWillTransitionToSize:withTransitionCoordinator: instead"]
        #[unsafe(method(willAnimateRotationToInterfaceOrientation:duration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willAnimateRotationToInterfaceOrientation_duration(
            &self,
            to_interface_orientation: UIInterfaceOrientation,
            duration: NSTimeInterval,
        );

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(willAnimateFirstHalfOfRotationToInterfaceOrientation:duration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willAnimateFirstHalfOfRotationToInterfaceOrientation_duration(
            &self,
            to_interface_orientation: UIInterfaceOrientation,
            duration: NSTimeInterval,
        );

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(didAnimateFirstHalfOfRotationToInterfaceOrientation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didAnimateFirstHalfOfRotationToInterfaceOrientation(
            &self,
            to_interface_orientation: UIInterfaceOrientation,
        );

        #[cfg(feature = "UIOrientation")]
        #[deprecated]
        #[unsafe(method(willAnimateSecondHalfOfRotationFromInterfaceOrientation:duration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willAnimateSecondHalfOfRotationFromInterfaceOrientation_duration(
            &self,
            from_interface_orientation: UIInterfaceOrientation,
            duration: NSTimeInterval,
        );
    );
}

/// UIViewControllerEditing.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(isEditing))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEditing(&self) -> bool;

        /// Setter for [`isEditing`][Self::isEditing].
        #[unsafe(method(setEditing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditing(&self, editing: bool);

        #[unsafe(method(setEditing:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEditing_animated(&self, editing: bool, animated: bool);

        #[cfg(all(feature = "UIBarButtonItem", feature = "UIBarItem"))]
        #[unsafe(method(editButtonItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn editButtonItem(&self) -> Retained<UIBarButtonItem>;
    );
}

/// UISearchDisplayControllerSupport.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UISearchDisplayController")]
        #[deprecated]
        #[unsafe(method(searchDisplayController))]
        #[unsafe(method_family = none)]
        pub unsafe fn searchDisplayController(&self)
            -> Option<Retained<UISearchDisplayController>>;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontrollerhierarchyinconsistencyexception?language=objc)
    pub static UIViewControllerHierarchyInconsistencyException: &'static NSExceptionName;
}

/// UIContainerViewControllerProtectedMethods.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(childViewControllers))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllers(&self) -> Retained<NSArray<UIViewController>>;

        #[unsafe(method(addChildViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addChildViewController(&self, child_controller: &UIViewController);

        #[unsafe(method(removeFromParentViewController))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFromParentViewController(&self);

        #[cfg(all(feature = "UIView", feature = "block2"))]
        #[unsafe(method(transitionFromViewController:toViewController:duration:options:animations:completion:))]
        #[unsafe(method_family = none)]
        pub unsafe fn transitionFromViewController_toViewController_duration_options_animations_completion(
            &self,
            from_view_controller: &UIViewController,
            to_view_controller: &UIViewController,
            duration: NSTimeInterval,
            options: UIViewAnimationOptions,
            animations: Option<&block2::DynBlock<dyn Fn()>>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[unsafe(method(beginAppearanceTransition:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn beginAppearanceTransition_animated(&self, is_appearing: bool, animated: bool);

        #[unsafe(method(endAppearanceTransition))]
        #[unsafe(method_family = none)]
        pub unsafe fn endAppearanceTransition(&self);

        #[deprecated = "Has no effect on visionOS"]
        #[unsafe(method(childViewControllerForStatusBarStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForStatusBarStyle(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[deprecated = "Has no effect on visionOS"]
        #[unsafe(method(childViewControllerForStatusBarHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForStatusBarHidden(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[cfg(feature = "UITraitCollection")]
        #[deprecated = "Use the traitOverrides property on the child view controller instead"]
        #[unsafe(method(setOverrideTraitCollection:forChildViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOverrideTraitCollection_forChildViewController(
            &self,
            collection: Option<&UITraitCollection>,
            child_view_controller: &UIViewController,
        );

        #[cfg(feature = "UITraitCollection")]
        #[deprecated = "Use the traitOverrides property on the child view controller instead"]
        #[unsafe(method(overrideTraitCollectionForChildViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn overrideTraitCollectionForChildViewController(
            &self,
            child_view_controller: &UIViewController,
        ) -> Option<Retained<UITraitCollection>>;

        #[unsafe(method(childViewControllerForUserInterfaceStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForUserInterfaceStyle(
            &self,
        ) -> Option<Retained<UIViewController>>;
    );
}

/// UIContainerViewControllerCallbacks.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(automaticallyForwardAppearanceAndRotationMethodsToChildViewControllers))]
        #[unsafe(method_family = none)]
        pub unsafe fn automaticallyForwardAppearanceAndRotationMethodsToChildViewControllers(
            &self,
        ) -> bool;

        #[deprecated = "Manually forward viewWillTransitionToSize:withTransitionCoordinator: if necessary"]
        #[unsafe(method(shouldAutomaticallyForwardRotationMethods))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldAutomaticallyForwardRotationMethods(&self) -> bool;

        #[unsafe(method(shouldAutomaticallyForwardAppearanceMethods))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldAutomaticallyForwardAppearanceMethods(&self) -> bool;

        #[unsafe(method(willMoveToParentViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn willMoveToParentViewController(&self, parent: Option<&UIViewController>);

        #[unsafe(method(didMoveToParentViewController:))]
        #[unsafe(method_family = none)]
        pub unsafe fn didMoveToParentViewController(&self, parent: Option<&UIViewController>);
    );
}

/// UIStateRestoration.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(restorationIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn restorationIdentifier(&self) -> Option<Retained<NSString>>;

        /// Setter for [`restorationIdentifier`][Self::restorationIdentifier].
        #[unsafe(method(setRestorationIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRestorationIdentifier(&self, restoration_identifier: Option<&NSString>);

        #[cfg(feature = "UIStateRestoration")]
        #[unsafe(method(restorationClass))]
        #[unsafe(method_family = none)]
        pub unsafe fn restorationClass(&self) -> Option<&'static AnyClass>;

        #[cfg(feature = "UIStateRestoration")]
        /// Setter for [`restorationClass`][Self::restorationClass].
        #[unsafe(method(setRestorationClass:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRestorationClass(&self, restoration_class: Option<&AnyClass>);

        #[unsafe(method(encodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn encodeRestorableStateWithCoder(&self, coder: &NSCoder);

        #[unsafe(method(decodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn decodeRestorableStateWithCoder(&self, coder: &NSCoder);

        #[unsafe(method(applicationFinishedRestoringState))]
        #[unsafe(method_family = none)]
        pub unsafe fn applicationFinishedRestoringState(&self);
    );
}

#[cfg(all(feature = "UIResponder", feature = "UIStateRestoration"))]
extern_conformance!(
    unsafe impl UIStateRestoring for UIViewController {}
);

/// UIConstraintBasedLayoutCoreMethods.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(updateViewConstraints))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateViewConstraints(&self);
    );
}

/// UIViewControllerTransitioning.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UIViewControllerTransitioning")]
        #[unsafe(method(transitioningDelegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn transitioningDelegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIViewControllerTransitioningDelegate>>>;

        #[cfg(feature = "UIViewControllerTransitioning")]
        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`transitioningDelegate`][Self::transitioningDelegate].
        #[unsafe(method(setTransitioningDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTransitioningDelegate(
            &self,
            transitioning_delegate: Option<
                &ProtocolObject<dyn UIViewControllerTransitioningDelegate>,
            >,
        );
    );
}

/// UILayoutSupport.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "NSLayoutConstraint")]
        #[deprecated = "Use view.safeAreaLayoutGuide.topAnchor instead of topLayoutGuide.bottomAnchor"]
        #[unsafe(method(topLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn topLayoutGuide(&self) -> Retained<ProtocolObject<dyn UILayoutSupport>>;

        #[cfg(feature = "NSLayoutConstraint")]
        #[deprecated = "Use view.safeAreaLayoutGuide.bottomAnchor instead of bottomLayoutGuide.topAnchor"]
        #[unsafe(method(bottomLayoutGuide))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottomLayoutGuide(&self) -> Retained<ProtocolObject<dyn UILayoutSupport>>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(additionalSafeAreaInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn additionalSafeAreaInsets(&self) -> UIEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`additionalSafeAreaInsets`][Self::additionalSafeAreaInsets].
        #[unsafe(method(setAdditionalSafeAreaInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAdditionalSafeAreaInsets(&self, additional_safe_area_insets: UIEdgeInsets);

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(systemMinimumLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemMinimumLayoutMargins(&self) -> NSDirectionalEdgeInsets;

        #[unsafe(method(viewRespectsSystemMinimumLayoutMargins))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewRespectsSystemMinimumLayoutMargins(&self) -> bool;

        /// Setter for [`viewRespectsSystemMinimumLayoutMargins`][Self::viewRespectsSystemMinimumLayoutMargins].
        #[unsafe(method(setViewRespectsSystemMinimumLayoutMargins:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setViewRespectsSystemMinimumLayoutMargins(
            &self,
            view_respects_system_minimum_layout_margins: bool,
        );

        #[unsafe(method(viewLayoutMarginsDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewLayoutMarginsDidChange(&self);

        #[unsafe(method(viewSafeAreaInsetsDidChange))]
        #[unsafe(method_family = none)]
        pub unsafe fn viewSafeAreaInsetsDidChange(&self);
    );
}

/// UIKeyCommand.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(all(
            feature = "UICommand",
            feature = "UIKeyCommand",
            feature = "UIMenuElement"
        ))]
        #[unsafe(method(addKeyCommand:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addKeyCommand(&self, key_command: &UIKeyCommand);

        #[cfg(all(
            feature = "UICommand",
            feature = "UIKeyCommand",
            feature = "UIMenuElement"
        ))]
        #[unsafe(method(removeKeyCommand:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeKeyCommand(&self, key_command: &UIKeyCommand);
    );
}

/// UIPerformsActions.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        /// Determines whether the receiver continues to respond to actions while it is presenting a view controller modally.
        ///
        /// Defaults to YES. You can change the default return value by providing a value for UIViewControllerPerformsActionsWhilePresentingModally in your Info.plist file.
        #[unsafe(method(performsActionsWhilePresentingModally))]
        #[unsafe(method_family = none)]
        pub unsafe fn performsActionsWhilePresentingModally(&self) -> bool;
    );
}

/// NSExtensionAdditions.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(extensionContext))]
        #[unsafe(method_family = none)]
        pub unsafe fn extensionContext(&self) -> Option<Retained<NSExtensionContext>>;
    );
}

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSExtensionRequestHandling for UIViewController {}
);

/// UIPresentationController.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UIPresentationController")]
        #[unsafe(method(presentationController))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentationController(&self) -> Option<Retained<UIPresentationController>>;

        #[cfg(all(
            feature = "UIPresentationController",
            feature = "UISheetPresentationController"
        ))]
        #[unsafe(method(sheetPresentationController))]
        #[unsafe(method_family = none)]
        pub unsafe fn sheetPresentationController(
            &self,
        ) -> Option<Retained<UISheetPresentationController>>;

        #[cfg(all(
            feature = "UIPopoverPresentationController",
            feature = "UIPresentationController"
        ))]
        #[unsafe(method(popoverPresentationController))]
        #[unsafe(method_family = none)]
        pub unsafe fn popoverPresentationController(
            &self,
        ) -> Option<Retained<UIPopoverPresentationController>>;

        #[cfg(feature = "UIPresentationController")]
        #[unsafe(method(activePresentationController))]
        #[unsafe(method_family = none)]
        pub unsafe fn activePresentationController(
            &self,
        ) -> Option<Retained<UIPresentationController>>;

        #[unsafe(method(isModalInPresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn isModalInPresentation(&self) -> bool;

        /// Setter for [`isModalInPresentation`][Self::isModalInPresentation].
        #[unsafe(method(setModalInPresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setModalInPresentation(&self, modal_in_presentation: bool);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontrollerpreviewing?language=objc)
    pub unsafe trait UIViewControllerPreviewing: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "UIGestureRecognizer")]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(previewingGestureRecognizerForFailureRelationship))]
        #[unsafe(method_family = none)]
        unsafe fn previewingGestureRecognizerForFailureRelationship(
            &self,
        ) -> Retained<UIGestureRecognizer>;

        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        unsafe fn delegate(
            &self,
        ) -> Retained<ProtocolObject<dyn UIViewControllerPreviewingDelegate>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(sourceView))]
        #[unsafe(method_family = none)]
        unsafe fn sourceView(&self) -> Retained<UIView>;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(sourceRect))]
        #[unsafe(method_family = none)]
        unsafe fn sourceRect(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`sourceRect`][Self::sourceRect].
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(setSourceRect:))]
        #[unsafe(method_family = none)]
        unsafe fn setSourceRect(&self, source_rect: CGRect);
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiviewcontrollerpreviewingdelegate?language=objc)
    pub unsafe trait UIViewControllerPreviewingDelegate:
        NSObjectProtocol + MainThreadOnly
    {
        #[cfg(all(feature = "UIResponder", feature = "objc2-core-foundation"))]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(previewingContext:viewControllerForLocation:))]
        #[unsafe(method_family = none)]
        unsafe fn previewingContext_viewControllerForLocation(
            &self,
            previewing_context: &ProtocolObject<dyn UIViewControllerPreviewing>,
            location: CGPoint,
        ) -> Option<Retained<UIViewController>>;

        #[cfg(feature = "UIResponder")]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(previewingContext:commitViewController:))]
        #[unsafe(method_family = none)]
        unsafe fn previewingContext_commitViewController(
            &self,
            previewing_context: &ProtocolObject<dyn UIViewControllerPreviewing>,
            view_controller_to_commit: &UIViewController,
        );
    }
);

/// UIViewControllerPreviewingRegistration.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UIView")]
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(registerForPreviewingWithDelegate:sourceView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn registerForPreviewingWithDelegate_sourceView(
            &self,
            delegate: &ProtocolObject<dyn UIViewControllerPreviewingDelegate>,
            source_view: &UIView,
        ) -> Retained<ProtocolObject<dyn UIViewControllerPreviewing>>;

        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(unregisterForPreviewingWithContext:))]
        #[unsafe(method_family = none)]
        pub unsafe fn unregisterForPreviewingWithContext(
            &self,
            previewing: &ProtocolObject<dyn UIViewControllerPreviewing>,
        );
    );
}

/// UIScreenEdgesDeferringSystemGestures.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(childViewControllerForScreenEdgesDeferringSystemGestures))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForScreenEdgesDeferringSystemGestures(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(preferredScreenEdgesDeferringSystemGestures))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredScreenEdgesDeferringSystemGestures(&self) -> UIRectEdge;

        #[unsafe(method(setNeedsUpdateOfScreenEdgesDeferringSystemGestures))]
        #[unsafe(method_family = none)]
        pub fn setNeedsUpdateOfScreenEdgesDeferringSystemGestures(&self);
    );
}

/// UIHomeIndicatorAutoHidden.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(childViewControllerForHomeIndicatorAutoHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForHomeIndicatorAutoHidden(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[unsafe(method(prefersHomeIndicatorAutoHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersHomeIndicatorAutoHidden(&self) -> bool;

        #[unsafe(method(setNeedsUpdateOfHomeIndicatorAutoHidden))]
        #[unsafe(method_family = none)]
        pub fn setNeedsUpdateOfHomeIndicatorAutoHidden(&self);
    );
}

/// UIPointerLockSupport.
#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(childViewControllerForPointerLock))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForPointerLock(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[unsafe(method(prefersPointerLocked))]
        #[unsafe(method_family = none)]
        pub unsafe fn prefersPointerLocked(&self) -> bool;

        #[unsafe(method(setNeedsUpdateOfPrefersPointerLocked))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUpdateOfPrefersPointerLocked(&self);
    );
}

#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UIContentConfiguration")]
        /// Setting a content unavailable configuration replaces the existing content unavailable view of the view controller with a new content unavailable view instance from the configuration,
        /// or directly applies the configuration to the existing content unavailable view if the configuration is compatible with the existing content unavailable view type.
        /// The default value is nil.
        #[unsafe(method(contentUnavailableConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentUnavailableConfiguration(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIContentConfiguration>>>;

        #[cfg(feature = "UIContentConfiguration")]
        /// Setter for [`contentUnavailableConfiguration`][Self::contentUnavailableConfiguration].
        #[unsafe(method(setContentUnavailableConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentUnavailableConfiguration(
            &self,
            content_unavailable_configuration: Option<&ProtocolObject<dyn UIContentConfiguration>>,
        );

        #[cfg(feature = "UIContentUnavailableConfigurationState")]
        /// Returns the current content unavailable configuration state for the view.
        /// To add your own custom state(s), override the getter and call super to obtain an instance with the
        /// system properties set, then set your own custom states as desired.
        #[unsafe(method(contentUnavailableConfigurationState))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentUnavailableConfigurationState(
            &self,
        ) -> Retained<UIContentUnavailableConfigurationState>;

        /// Requests the view update its content unavailable configuration for its current state. This method is called automatically
        /// when the view's `contentUnavailableConfigurationState` may have changed, as well as in other circumstances where an
        /// update may be required. Multiple requests may be coalesced into a single update at the appropriate time.
        #[unsafe(method(setNeedsUpdateContentUnavailableConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUpdateContentUnavailableConfiguration(&self);

        #[cfg(feature = "UIContentUnavailableConfigurationState")]
        /// Subclasses should override this method and update the content unavailable's configuration using the state provided.
        /// This method should not be called directly, use `setNeedsUpdateContentUnavailableConfiguration` to request an update.
        #[unsafe(method(updateContentUnavailableConfigurationUsingState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateContentUnavailableConfigurationUsingState(
            &self,
            state: &UIContentUnavailableConfigurationState,
        );
    );
}

#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[deprecated = "UIViewControllerPreviewing is deprecated. Please use UIContextMenuInteraction."]
        #[unsafe(method(previewActionItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn previewActionItems(
            &self,
        ) -> Retained<NSArray<ProtocolObject<dyn UIPreviewActionItem>>>;
    );
}

#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[cfg(feature = "UITraitCollection")]
        #[unsafe(method(traitOverrides))]
        #[unsafe(method_family = none)]
        pub unsafe fn traitOverrides(&self) -> Retained<ProtocolObject<dyn UITraitOverrides>>;

        /// Forces an immediate trait update for this view controller and its view, including any view
        /// controllers and views in this subtree. Any trait change callbacks are sent synchronously.
        #[unsafe(method(updateTraitsIfNeeded))]
        #[unsafe(method_family = none)]
        pub unsafe fn updateTraitsIfNeeded(&self);
    );
}

#[cfg(all(feature = "UIResponder", feature = "UITraitCollection"))]
extern_conformance!(
    unsafe impl UITraitChangeObservable for UIViewController {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontainerbackgroundstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIContainerBackgroundStyle(pub NSInteger);
impl UIContainerBackgroundStyle {
    #[doc(alias = "UIContainerBackgroundStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIContainerBackgroundStyleGlass")]
    pub const Glass: Self = Self(1);
    #[doc(alias = "UIContainerBackgroundStyleHidden")]
    pub const Hidden: Self = Self(2);
}

unsafe impl Encode for UIContainerBackgroundStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIContainerBackgroundStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "UIResponder")]
impl UIViewController {
    extern_methods!(
        #[unsafe(method(preferredContainerBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredContainerBackgroundStyle(&self) -> UIContainerBackgroundStyle;

        #[unsafe(method(childViewControllerForPreferredContainerBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn childViewControllerForPreferredContainerBackgroundStyle(
            &self,
        ) -> Option<Retained<UIViewController>>;

        #[unsafe(method(setNeedsUpdateOfPreferredContainerBackgroundStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNeedsUpdateOfPreferredContainerBackgroundStyle(&self);
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipreviewactionitem?language=objc)
    pub unsafe trait UIPreviewActionItem: NSObjectProtocol + MainThreadOnly {
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        unsafe fn title(&self) -> Retained<NSString>;
    }
);

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipreviewactionstyle?language=objc)
// NS_ENUM
#[deprecated = "Please use UIContextMenuInteraction."]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIPreviewActionStyle(pub NSInteger);
impl UIPreviewActionStyle {
    #[doc(alias = "UIPreviewActionStyleDefault")]
    #[deprecated = "Please use UIContextMenuInteraction."]
    pub const Default: Self = Self(0);
    #[doc(alias = "UIPreviewActionStyleSelected")]
    #[deprecated = "Please use UIContextMenuInteraction."]
    pub const Selected: Self = Self(1);
    #[doc(alias = "UIPreviewActionStyleDestructive")]
    #[deprecated = "Please use UIContextMenuInteraction."]
    pub const Destructive: Self = Self(2);
}

unsafe impl Encode for UIPreviewActionStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIPreviewActionStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipreviewaction?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated = "Please use UIContextMenuInteraction."]
    pub struct UIPreviewAction;
);

extern_conformance!(
    unsafe impl NSCopying for UIPreviewAction {}
);

unsafe impl CopyingHelper for UIPreviewAction {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPreviewAction {}
);

extern_conformance!(
    unsafe impl UIPreviewActionItem for UIPreviewAction {}
);

impl UIPreviewAction {
    extern_methods!(
        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        #[unsafe(method(handler))]
        #[unsafe(method_family = none)]
        pub unsafe fn handler(
            &self,
        ) -> NonNull<
            block2::DynBlock<
                dyn Fn(NonNull<ProtocolObject<dyn UIPreviewActionItem>>, NonNull<UIViewController>),
            >,
        >;

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        #[unsafe(method(actionWithTitle:style:handler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionWithTitle_style_handler(
            title: &NSString,
            style: UIPreviewActionStyle,
            handler: &block2::DynBlock<dyn Fn(NonNull<UIPreviewAction>, NonNull<UIViewController>)>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIPreviewAction {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uipreviewactiongroup?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[deprecated = "Please use UIContextMenuInteraction."]
    pub struct UIPreviewActionGroup;
);

extern_conformance!(
    unsafe impl NSCopying for UIPreviewActionGroup {}
);

unsafe impl CopyingHelper for UIPreviewActionGroup {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIPreviewActionGroup {}
);

extern_conformance!(
    unsafe impl UIPreviewActionItem for UIPreviewActionGroup {}
);

impl UIPreviewActionGroup {
    extern_methods!(
        #[unsafe(method(actionGroupWithTitle:style:actions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn actionGroupWithTitle_style_actions(
            title: &NSString,
            style: UIPreviewActionStyle,
            actions: &NSArray<UIPreviewAction>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIPreviewActionGroup {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
