/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'search_binary_handler' syscall
 *
 * Notes:
 *  - We are maintianing Red-Black tree of pid's for Exploit Detection feature.
 *    When process calls execve, we need to update RB tree.
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - 18.I.2021:   Replace one 'search_binary_handler' hook with two
 *                 independent one to reduce the race window while
 *                 the process is not being verified
 *  - 28.XII.2020: Replace various execve syscall hooks with one hook
 *                 of the function 'search_binary_handler'
 *  - Created:     18.IX.2017
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../../p_lkrg_main.h"


char p_security_bprm_committing_creds_kretprobe_state = 0;

LKRG_DEBUG_TRACE int p_security_bprm_committing_creds_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) { return 0; }

static struct kretprobe p_security_bprm_committing_creds_kretprobe = {
    .kp.symbol_name = "security_bprm_committing_creds",
    .handler = p_security_bprm_committing_creds_ret,
    .entry_handler = p_security_bprm_committing_creds_entry,
    .data_size = sizeof(struct p_security_bprm_committing_creds_data),
};


LKRG_DEBUG_TRACE int p_security_bprm_committing_creds_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp;
   unsigned long p_flags;

   p_ed_enforce_validation();

   p_tasks_write_lock(&p_flags);
   if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
      p_verify_addr_limit(p_tmp, current);
#ifdef P_LKRG_TASK_OFF_DEBUG
      p_debug_off_flag_off(p_tmp, 39);
#endif
      // This process is on the ED list - set temporary 'disable' flag!
      p_set_ed_process_off(p_tmp);
   }
   p_tasks_write_unlock(&p_flags);

   return 0;
}

GENERATE_INSTALL_FUNC(security_bprm_committing_creds)
