// @HEADER
// ************************************************************************
//
//                           MiniTensor Package
//                 Copyright (2016) Sandia Corporation
//
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions: Alejandro Mota (amota@sandia.gov)
//
// ************************************************************************
// @HEADER

#ifndef MINITENSOR_DOXYGEN_DOCUMENTATION_HPP
#define MINITENSOR_DOXYGEN_DOCUMENTATION_HPP

/*!

\mainpage

\section minitensor_index Table of Contents

- \ref minitensor_overview
- \ref minitensor_copyright
- \ref minitensor_questions

\section minitensor_overview MiniTensor Overview

MiniTensor is a library for the use, manipulation, algebra and optimization of small vectors and tensors and problems that depend on them.
Its purpose is to provide a compact representation of vector and tensor expressions.
Its emphasis is on ease of use, and accurate algorithms, specifically those used for the development of constitutive models in finite deformation solid mechanics.
More information can be found at https://trilinos.org/packages/minitensor.

\section minitensor_copyright Copyright and License

\verbinclude COPYRIGHT_AND_LICENSE

\section minitensor_questions For All Questions and Comments...

   Please contact the authors listed in the License above,
   or open an issue in the Trilinos GitHub repository (https://github.com/trilinos/Trilinos).

*/

/* ************************************************************************ */
/* ************************************************************************ */

#endif //ifndef MINITENSOR_DOXYGEN_DOCUMENTATION_HPP
