/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.util.JoinedIterator;
import net.sf.hibernate.util.Stringable;

public abstract class PersistentClass
extends Stringable {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    private Class persistentClass;
    private String discriminatorValue;
    private ArrayList properties = new ArrayList();
    private Table table;
    private Class proxyInterface;
    private final ArrayList subclasses = new ArrayList();
    private final ArrayList subclassProperties = new ArrayList();
    private final ArrayList subclassTables = new ArrayList();
    private boolean dynamicInsert;
    private boolean dynamicUpdate;

    public boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void addSubclass(Subclass subclass) {
        this.subclasses.add(subclass);
    }

    public boolean hasSubclasses() {
        return this.subclasses.size() > 0;
    }

    public int getSubclassSpan() {
        int n = this.subclasses.size();
        Iterator iter = this.subclasses.iterator();
        while (iter.hasNext()) {
            n += ((Subclass)iter.next()).getSubclassSpan();
        }
        return n;
    }

    public Iterator getSubclassIterator() {
        Iterator[] iters = new Iterator[this.subclasses.size() + 1];
        Iterator iter = this.subclasses.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Subclass)iter.next()).getSubclassIterator();
        }
        iters[i] = this.subclasses.iterator();
        return new JoinedIterator(iters);
    }

    public Iterator getDirectSubclasses() {
        return this.subclasses.iterator();
    }

    public void addProperty(Property p) {
        this.properties.add(p);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Iterator getPropertyIterator() {
        return this.properties.iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public Class getPersistentClass() {
        return this.persistentClass;
    }

    public String getName() {
        return this.persistentClass.getName();
    }

    public abstract boolean isMutable();

    public abstract boolean hasIdentifierProperty();

    public abstract Property getIdentifierProperty();

    public abstract Value getIdentifier();

    public abstract Property getVersion();

    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    public abstract boolean isVersioned();

    public abstract CacheConcurrencyStrategy getCache();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract Iterator getPropertyClosureIterator();

    public abstract Iterator getTableClosureIterator();

    protected void addSubclassProperty(Property p) {
        this.subclassProperties.add(p);
    }

    protected void addSubclassTable(Table table) {
        this.subclassTables.add(table);
    }

    public Iterator getSubclassPropertyClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getPropertyClosureIterator(), this.subclassProperties.iterator()});
    }

    public Iterator getSubclassTableClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getTableClosureIterator(), this.subclassTables.iterator()});
    }

    public Class getProxyInterface() {
        return this.proxyInterface;
    }

    public abstract boolean hasEmbeddedIdentifier();

    public abstract Class getPersister();

    public abstract Table getRootTable();

    public abstract RootClass getRootClass();

    public abstract Value getKey();

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setPersistentClass(Class persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void setProxyInterface(Class proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    public boolean isForceDiscriminator() {
        return false;
    }

    public void createPrimaryKey() {
        PrimaryKey pk = new PrimaryKey();
        pk.setTable(this.table);
        pk.setName(PK_ALIAS.toAliasString(this.table.getName()));
        this.table.setPrimaryKey(pk);
        Iterator iter = this.getKey().getColumnIterator();
        while (iter.hasNext()) {
            pk.addColumn((Column)iter.next());
        }
    }
}

