/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEProtectionRemoverFactory
implements PBEProtectionRemoverFactory {
    private final char[] passPhrase;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);
    private JcaPGPDigestCalculatorProviderBuilder calculatorProviderBuilder;

    public JcePBEProtectionRemoverFactory(char[] cArray) {
        this.passPhrase = cArray;
        this.calculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    }

    public JcePBEProtectionRemoverFactory(char[] cArray, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.passPhrase = cArray;
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBEProtectionRemoverFactory setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(provider);
        }
        return this;
    }

    public JcePBEProtectionRemoverFactory setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.aeadUtil = new JceAEADUtil(this.helper);
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(string);
        }
        return this;
    }

    @Override
    public PBESecretKeyDecryptor createDecryptor(String string) throws PGPException {
        if (this.calculatorProvider == null) {
            this.calculatorProvider = this.calculatorProviderBuilder.build();
        }
        if (string.indexOf("ocb") >= 0) {
            return new PGPSecretKeyDecryptorWithAAD(this.passPhrase, this.calculatorProvider){

                @Override
                public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) throws PGPException {
                    try {
                        Cipher cipher = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/OCB/NoPadding");
                        cipher.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(n, byArray), new AEADParameterSpec(byArray2, 128, byArray3));
                        return cipher.doFinal(byArray4, n2, n3);
                    }
                    catch (IllegalBlockSizeException illegalBlockSizeException) {
                        throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                    }
                    catch (BadPaddingException badPaddingException) {
                        throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                    }
                }

                @Override
                public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                    return JceAEADUtil.processAeadKeyData(JcePBEProtectionRemoverFactory.this.aeadUtil, 2, n, n2, byArray, byArray2, n3, n4, byArray3, 0, byArray3.length, byArray4);
                }
            };
        }
        return new PBESecretKeyDecryptor(this.passPhrase, this.calculatorProvider){

            @Override
            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    Cipher cipher = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(n) + "/CBC/NoPadding");
                    cipher.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(n, byArray), new IvParameterSpec(byArray2));
                    return cipher.doFinal(byArray3, n2, n3);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new PGPException("invalid parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }

            @Override
            public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                return JceAEADUtil.processAeadKeyData(JcePBEProtectionRemoverFactory.this.aeadUtil, 2, n, n2, byArray, byArray2, n3, n4, byArray3, 0, byArray3.length, byArray4);
            }
        };
    }
}

