/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.regex.Matcher;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Tag(value="class-filter")
public class ClassFilter
implements JDOMExternalizable,
Cloneable {
    private static final Logger LOG = Logger.getInstance(ClassFilter.class);
    public static final ClassFilter[] EMPTY_ARRAY = new ClassFilter[0];
    @Attribute(value="pattern")
    public String PATTERN = "";
    @Attribute(value="enabled")
    public boolean ENABLED = true;
    @Attribute(value="include")
    public boolean INCLUDE = true;
    private Matcher myMatcher;

    public ClassFilter() {
    }

    public ClassFilter(String pattern) {
        this.PATTERN = pattern;
    }

    @Transient
    public String getPattern() {
        return this.PATTERN;
    }

    @Transient
    public boolean isEnabled() {
        return this.ENABLED;
    }

    @Transient
    public boolean isInclude() {
        return this.INCLUDE;
    }

    public void setPattern(String pattern) {
        if (pattern != null && !pattern.equals(this.PATTERN)) {
            this.PATTERN = pattern;
            this.myMatcher = null;
        }
    }

    public void setEnabled(boolean value) {
        this.ENABLED = value;
    }

    public void setInclude(boolean value) {
        this.INCLUDE = value;
    }

    public String toString() {
        return this.getPattern();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal(this, element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        element.addContent(new Element("option").setAttribute("name", "PATTERN").setAttribute("value", this.PATTERN));
        element.addContent(new Element("option").setAttribute("name", "ENABLED").setAttribute("value", String.valueOf(this.ENABLED)));
        if (!this.INCLUDE) {
            element.addContent(new Element("option").setAttribute("name", "INCLUDE").setAttribute("value", "false"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassFilter)) {
            return false;
        }
        ClassFilter classFilter = (ClassFilter)o;
        return this.isEnabled() == classFilter.isEnabled() && this.getPattern().equals(classFilter.getPattern());
    }

    public int hashCode() {
        int result2 = this.PATTERN.hashCode();
        result2 = 29 * result2 + (this.ENABLED ? 1 : 0);
        return result2;
    }

    public ClassFilter clone() {
        try {
            return (ClassFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOG.error(e);
            return null;
        }
    }

    public boolean matches(String name) {
        return this.getMatcher(name).matches();
    }

    private Matcher getMatcher(String name) {
        if (this.myMatcher == null) {
            this.myMatcher = PatternUtil.fromMask(this.getPattern()).matcher(name);
        } else {
            this.myMatcher.reset(name);
        }
        return this.myMatcher;
    }

    public static ClassFilter @NotNull [] deepCopyOf(ClassFilter @NotNull [] original) {
        if (original == null) {
            ClassFilter.$$$reportNull$$$0(0);
        }
        ClassFilter[] classFilterArray = ContainerUtil.map(original, ClassFilter::clone, EMPTY_ARRAY);
        if (classFilterArray == null) {
            ClassFilter.$$$reportNull$$$0(1);
        }
        return classFilterArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/classFilter/ClassFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/classFilter/ClassFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopyOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "deepCopyOf";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

