/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.run.actions.ChangePageSizeAction;
import com.intellij.database.run.ui.CustomPageSizeForm;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SetCustomPageSizeAction
extends DumbAwareAction {
    public SetCustomPageSizeAction() {
        super(ApplicationBundle.messagePointer((String)"custom.option", (Object[])new Object[0]), ApplicationBundle.messagePointer((String)"custom.option.description", (Object[])new Object[0]), (Icon)null);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetCustomPageSizeAction.$$$reportNull$$$0(0);
        }
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabledAndVisible(grid != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SetCustomPageSizeAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            SetCustomPageSizeAction.$$$reportNull$$$0(2);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        final GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        new SetPageSizeDialogWrapper(SetCustomPageSizeAction.getEventProject((AnActionEvent)e)){

            @Override
            protected int getPageSize() {
                boolean unlimited = GridUtilCore.isPageSizeUnlimited((int)pageModel.getPageSize());
                return unlimited ? GridUtilCore.getPageSize((DataGridSettings)GridUtil.getSettings(grid)) : pageModel.getPageSize();
            }

            @Override
            protected boolean isLimitPageSize() {
                return !GridUtilCore.isPageSizeUnlimited((int)pageModel.getPageSize());
            }

            protected void doOKAction() {
                super.doOKAction();
                ChangePageSizeAction.setPageSizeAndReload(this.myForm.getPageSize(), grid);
            }
        }.show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/SetCustomPageSizeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/SetCustomPageSizeAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static abstract class SetPageSizeDialogWrapper
    extends DialogWrapper {
        protected final CustomPageSizeForm myForm = new CustomPageSizeForm();

        public SetPageSizeDialogWrapper(@Nullable Project project) {
            super(project);
            this.setTitle(DataGridBundle.message((String)"dialog.title.change.page.size", (Object[])new Object[0]));
            this.initListeners();
            this.init();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myForm.getResultPageSizeTextField();
        }

        private void initListeners() {
            this.myForm.getResultPageSizeTextField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.updateOk();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.updateOk();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.updateOk();
                }
            });
        }

        private void updateOk() {
            this.getOKAction().setEnabled(this.isOKActionEnabled());
        }

        public boolean isOKActionEnabled() {
            try {
                this.myForm.getResultPageSizeTextField().validateContent();
                return true;
            }
            catch (ConfigurationException ignored) {
                return false;
            }
        }

        protected abstract int getPageSize();

        protected abstract boolean isLimitPageSize();

        @NotNull
        protected JComponent createCenterPanel() {
            this.myForm.reset(this.isLimitPageSize(), this.getPageSize());
            JPanel jPanel = this.myForm.getPanel();
            if (jPanel == null) {
                SetPageSizeDialogWrapper.$$$reportNull$$$0(0);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/SetCustomPageSizeAction$SetPageSizeDialogWrapper", "createCenterPanel"));
        }
    }
}

