/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.attach;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PyRemoteDebugProcess;
import com.jetbrains.python.debugger.attach.PyAttachToProcessCommandLineState;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.io.IOException;
import java.net.ServerSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAttachToProcessDebugRunner
extends PyDebugRunner {
    private final Project myProject;
    private final int myPid;
    private final String mySdkPath;
    private final Sdk mySdk;

    public PyAttachToProcessDebugRunner(@NotNull Project project, int pid, @Nullable Sdk sdk2) {
        if (project == null) {
            PyAttachToProcessDebugRunner.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myPid = pid;
        this.mySdk = sdk2;
        this.mySdkPath = this.mySdk != null ? sdk2.getHomePath() : null;
    }

    @Deprecated(forRemoval=true)
    public PyAttachToProcessDebugRunner(@NotNull Project project, int pid, @Nullable String sdkPath) {
        if (project == null) {
            PyAttachToProcessDebugRunner.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myPid = pid;
        this.mySdkPath = sdkPath;
        this.mySdk = PythonSdkUtil.findSdkByPath(this.mySdkPath);
    }

    public XDebugSession launch() throws ExecutionException {
        FileDocumentManager.getInstance().saveAllDocuments();
        return this.launchRemoteDebugServer();
    }

    private XDebugSession launchRemoteDebugServer() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            throw new ExecutionException(PyBundle.message("debugger.attach.to.process.failed.to.find.free.socket.port", new Object[0]), (Throwable)e);
        }
        PyAttachToProcessCommandLineState state = PyAttachToProcessCommandLineState.create(this.myProject, this.mySdk, serverSocket.getLocalPort(), this.myPid);
        final ExecutionResult result2 = state.execute(state.getEnvironment().getExecutor(), this);
        return XDebuggerManager.getInstance((Project)this.myProject).startSessionAndShowTab(String.valueOf(this.myPid), null, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                PyRemoteDebugProcess pyDebugProcess = new PyRemoteDebugProcess(session, serverSocket, result2.getExecutionConsole(), result2.getProcessHandler(), ""){

                    @Override
                    protected void printConsoleInfo() {
                    }

                    @Override
                    public int getConnectTimeout() {
                        return AdvancedSettings.getInt((String)"python.debugger.attach.timeout");
                    }

                    @Override
                    protected void detachDebuggedProcess() {
                        this.handleStop();
                    }

                    @Override
                    protected String getConnectionMessage() {
                        return PyBundle.message("python.debugger.attaching.to.process.with.pid", PyAttachToProcessDebugRunner.this.myPid);
                    }

                    @Override
                    protected String getConnectionTitle() {
                        return PyBundle.message("python.debugger.attaching", new Object[0]);
                    }
                };
                pyDebugProcess.setPositionConverter(new PyLocalPositionConverter());
                PyDebugRunner.createConsoleCommunicationAndSetupActions(PyAttachToProcessDebugRunner.this.myProject, result2, pyDebugProcess, session);
                PyRemoteDebugProcess pyRemoteDebugProcess = pyDebugProcess;
                if (pyRemoteDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return pyRemoteDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/debugger/attach/PyAttachToProcessDebugRunner", "<init>"));
    }
}

