/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.utils.mpp;

import ai.grazie.utils.mpp.DataLoader;
import ai.grazie.utils.mpp.Resources;
import ai.grazie.utils.mpp.RootStreamDataLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\r"}, d2={"Lai/grazie/utils/mpp/FromServerResourcesDataLoader;", "Lai/grazie/utils/mpp/RootStreamDataLoader;", "()V", "absolute", "Lai/grazie/utils/mpp/DataLoader$Path;", "path", "bytes", "", "(Lai/grazie/utils/mpp/DataLoader$Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stream", "Ljava/io/InputStream;", "text", "", "utils-common"})
public final class FromServerResourcesDataLoader
implements RootStreamDataLoader {
    @NotNull
    public static final FromServerResourcesDataLoader INSTANCE = new FromServerResourcesDataLoader();

    private FromServerResourcesDataLoader() {
    }

    @Override
    @NotNull
    public InputStream stream(@NotNull DataLoader.Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = Resources.INSTANCE.streamOrNull(path.toAbsolutePath());
        if (inputStream == null) {
            inputStream = new FileInputStream(new File(this.absolute(path).toAbsolutePath()));
        }
        return inputStream;
    }

    @Override
    @Nullable
    public Object bytes(@NotNull DataLoader.Path path, @NotNull Continuation<? super byte[]> $completion) {
        byte[] byArray = Resources.INSTANCE.bytesOrNull(path.toAbsolutePath());
        if (byArray == null) {
            byArray = FilesKt.readBytes((File)new File(this.absolute(path).toAbsolutePath()));
        }
        return byArray;
    }

    @Override
    @Nullable
    public Object text(@NotNull DataLoader.Path path, @NotNull Continuation<? super String> $completion) {
        String string = Resources.INSTANCE.textOrNull(path.toAbsolutePath());
        if (string == null) {
            string = FilesKt.readText$default((File)new File(this.absolute(path).toAbsolutePath()), null, (int)1, null);
        }
        return string;
    }

    @Override
    @NotNull
    public DataLoader.Path absolute(@NotNull DataLoader.Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DataLoader.Path serverRoot = new DataLoader.Path("/server/lib", path);
        if (new File(serverRoot.toAbsolutePath()).exists()) {
            return serverRoot;
        }
        DataLoader.Path serverUser = new DataLoader.Path("/home/grazie/server/lib", path);
        if (new File(serverUser.toAbsolutePath()).exists()) {
            return serverUser;
        }
        DataLoader.Path test = new DataLoader.Path("build/resources/main", path);
        if (new File(test.toRelativePath()).exists()) {
            String string = new File(test.toRelativePath()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(test.toRelativePath()).absolutePath");
            return new DataLoader.Path(string);
        }
        DataLoader.Path lfsFilePath = new DataLoader.Path("build/processedResources/lfs", path);
        if (new File(lfsFilePath.toRelativePath()).exists()) {
            String string = new File(lfsFilePath.toRelativePath()).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File(lfsFilePath.toRelativePath()).absolutePath");
            return new DataLoader.Path(string);
        }
        throw new IllegalStateException(("Can't find " + path.toAbsolutePath() + " in test resources or in server/lib directory").toString());
    }
}

