/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.IdeStatusBarImpl;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.ClickListener;
import com.intellij.util.ApplicationKt;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ide.model.ComponentRect;
import com.jetbrains.rd.ide.model.CustomWidgetModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconWidgetPresentationModel;
import com.jetbrains.rd.ide.model.MouseEventModel;
import com.jetbrains.rd.ide.model.MultipleTextValuesWidgetPresentationModel;
import com.jetbrains.rd.ide.model.PredefinedWidgetModel;
import com.jetbrains.rd.ide.model.RectangleModel;
import com.jetbrains.rd.ide.model.StatusBarModel;
import com.jetbrains.rd.ide.model.TextWidgetPresentationModel;
import com.jetbrains.rd.ide.model.WidgetModel;
import com.jetbrains.rd.ide.model.WidgetPresentationModel;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.bindable.ConverterStorage;
import com.jetbrains.rd.ui.bindable.ViewRegistryKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.status.FrontendStatusBarModelListener;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J0\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00192\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0016\u001a\u0004\u0018\u00010\u001a*\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0016\u001a\u00020\u001a*\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0016\u001a\u00020\u001a*\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0014\u0010\u0016\u001a\u00020\u001a*\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u001c\u0010\u0016\u001a\u00020\u0017*\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdclient/status/FrontendStatusBarModelListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rd/ide/model/StatusBarModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "shouldAddHostWidget", "", "project", "Lcom/intellij/openapi/project/Project;", "widgetId", "", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "addProtocolWidgetToStatusBar", "Lcom/jetbrains/rd/ide/model/WidgetModel;", "fromProtocol", "Lcom/intellij/openapi/wm/StatusBarWidget;", "widgetLifetime", "Lcom/jetbrains/rd/ide/model/PredefinedWidgetModel;", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "Lcom/jetbrains/rd/ide/model/WidgetPresentationModel;", "Lcom/jetbrains/rd/ide/model/MultipleTextValuesWidgetPresentationModel;", "Lcom/jetbrains/rd/ide/model/TextWidgetPresentationModel;", "Lcom/jetbrains/rd/ide/model/IconWidgetPresentationModel;", "Lcom/jetbrains/rd/ide/model/CustomWidgetModel;", "getComponentScreenBounds", "Lcom/jetbrains/rd/ide/model/RectangleModel;", "component", "Ljava/awt/Component;", "Companion", "DelegatingWidgetPresentation", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendStatusBarModelListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendStatusBarModelListener.kt\ncom/jetbrains/rdclient/status/FrontendStatusBarModelListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,241:1\n62#2,5:242\n62#2,5:249\n62#2,5:255\n62#2,5:260\n62#2,5:265\n62#2,5:270\n62#2,5:275\n15#2:280\n31#3,2:247\n1#4:254\n*S KotlinDebug\n*F\n+ 1 FrontendStatusBarModelListener.kt\ncom/jetbrains/rdclient/status/FrontendStatusBarModelListener\n*L\n58#1:242,5\n65#1:249,5\n71#1:255,5\n75#1:260,5\n88#1:265,5\n44#1:270,5\n47#1:275,5\n36#1:280\n63#1:247,2\n*E\n"})
public final class FrontendStatusBarModelListener
implements SolutionExtListener<StatusBarModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull StatusBarModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.getId2Widgets().view(lifetime, (arg_0, arg_1, arg_2) -> FrontendStatusBarModelListener.extensionCreated$lambda$2(session, this, arg_0, arg_1, arg_2));
    }

    private final boolean shouldAddHostWidget(Project project, String widgetId, StatusBar statusBar) {
        Throwable e$iv;
        Object v1;
        block9: {
            StatusBarWidget clientWidget = statusBar.getWidget(widgetId);
            if (clientWidget != null) {
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv2 = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Widget with ID '" + widgetId + "' already exists on a client side. No need to add it on a status bar.", e$iv2);
                }
                return false;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<StatusBarWidgetsManager> serviceClass$iv = StatusBarWidgetsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            boolean wasWidgetCreated = ((StatusBarWidgetsManager)object).wasWidgetCreated(widgetId);
            if (wasWidgetCreated) {
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv3 = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Widget with ID '" + widgetId + "' have registered factory on a client side. Check if widget enabled.", e$iv3);
                }
                return false;
            }
            Iterable $i$f$debug = StatusBarWidgetFactory.EP_NAME.getExtensionList();
            for (Object t : $i$f$debug) {
                StatusBarWidgetFactory it = (StatusBarWidgetFactory)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)widgetId)) continue;
                v1 = t;
                break block9;
            }
            v1 = null;
        }
        StatusBarWidgetFactory factory = v1;
        if (factory != null) {
            Logger $this$debug_u24default$iv = logger;
            e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Widget with ID '" + widgetId + "' have registered factory EP on a client side. Ignore backend widget version.", e$iv);
            }
            return false;
        }
        Logger $this$debug_u24default$iv = logger;
        e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Widget with ID '" + widgetId + "' not found on a client side. Allow to add this widget on a status bar.", e$iv);
        }
        return true;
    }

    private final void addProtocolWidgetToStatusBar(Lifetime lifetime, Project project, WidgetModel model, String widgetId, StatusBar statusBar) {
        StatusBarWidget statusBarWidget = this.fromProtocol(model, lifetime, widgetId, project);
        if (statusBarWidget == null) {
            return;
        }
        StatusBarWidget widget = statusBarWidget;
        String string = model.getAnchor();
        if (string == null) {
            string = "";
        }
        String anchor = string;
        Disposable parentDisposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Add host widget with ID '" + widgetId + "' presentation on client status bar.", e$iv);
        }
        statusBar.addWidget(widget, anchor, parentDisposable);
        model.getUpdated().advise(lifetime, arg_0 -> FrontendStatusBarModelListener.addProtocolWidgetToStatusBar$lambda$9(statusBar, widgetId, arg_0));
    }

    private final StatusBarWidget fromProtocol(WidgetModel $this$fromProtocol, Lifetime widgetLifetime, String widgetId, Project project) {
        WidgetModel widgetModel = $this$fromProtocol;
        return widgetModel instanceof PredefinedWidgetModel ? this.fromProtocol((PredefinedWidgetModel)$this$fromProtocol, widgetLifetime, widgetId, project) : (widgetModel instanceof CustomWidgetModel ? this.fromProtocol((CustomWidgetModel)$this$fromProtocol, widgetLifetime, widgetId) : null);
    }

    private final StatusBarWidget fromProtocol(PredefinedWidgetModel $this$fromProtocol, Lifetime widgetLifetime, String widgetId, Project project) {
        StatusBarWidget.WidgetPresentation widgetPresentation = this.fromProtocol($this$fromProtocol.getPresentation(), widgetLifetime, widgetId, project);
        if (widgetPresentation == null) {
            return null;
        }
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"com/jetbrains/rdclient/status/FrontendStatusBarModelListener$fromProtocol$HostStatusBarWidget", "Lcom/intellij/openapi/wm/StatusBarWidget;", "myId", "", "myPresentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;)V", "ID", "getPresentation", "intellij.rd.client"})
        public final class HostStatusBarWidget
        implements StatusBarWidget {
            private final String myId;
            private final StatusBarWidget.WidgetPresentation myPresentation;

            public HostStatusBarWidget(String myId, StatusBarWidget.WidgetPresentation myPresentation) {
                Intrinsics.checkNotNullParameter((Object)myId, (String)"myId");
                Intrinsics.checkNotNullParameter((Object)myPresentation, (String)"myPresentation");
                this.myId = myId;
                this.myPresentation = myPresentation;
            }

            public String ID() {
                return this.myId;
            }

            public StatusBarWidget.WidgetPresentation getPresentation() {
                return this.myPresentation;
            }
        }
        return new HostStatusBarWidget(widgetId, widgetPresentation);
    }

    private final StatusBarWidget.WidgetPresentation fromProtocol(WidgetPresentationModel $this$fromProtocol, Lifetime widgetLifetime, String widgetId, Project project) {
        WidgetPresentationModel widgetPresentationModel = $this$fromProtocol;
        return widgetPresentationModel instanceof MultipleTextValuesWidgetPresentationModel ? this.fromProtocol((MultipleTextValuesWidgetPresentationModel)$this$fromProtocol, widgetLifetime, widgetId, project) : (widgetPresentationModel instanceof IconWidgetPresentationModel ? this.fromProtocol((IconWidgetPresentationModel)$this$fromProtocol, widgetLifetime) : (widgetPresentationModel instanceof TextWidgetPresentationModel ? this.fromProtocol((TextWidgetPresentationModel)$this$fromProtocol, widgetLifetime) : null));
    }

    private final StatusBarWidget.WidgetPresentation fromProtocol(MultipleTextValuesWidgetPresentationModel $this$fromProtocol, Lifetime widgetLifetime, String widgetId, Project project) {
        return (StatusBarWidget.WidgetPresentation)new StatusBarWidget.MultipleTextValuesPresentation(widgetLifetime, $this$fromProtocol, project, widgetId, this){
            final /* synthetic */ Lifetime $widgetLifetime;
            final /* synthetic */ MultipleTextValuesWidgetPresentationModel $this_fromProtocol;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $widgetId;
            final /* synthetic */ FrontendStatusBarModelListener this$0;
            {
                this.$widgetLifetime = $widgetLifetime;
                this.$this_fromProtocol = $receiver;
                this.$project = $project;
                this.$widgetId = $widgetId;
                this.this$0 = $receiver2;
                super($widgetLifetime, (WidgetPresentationModel)$receiver);
            }

            public ListPopup getPopup() {
                if (RLifetimeKt.isAlive((Lifetime)this.$widgetLifetime)) {
                    this.$this_fromProtocol.getShowPopup().fire((Object)this.getWidgetComponentScreenPosition());
                }
                return null;
            }

            public String getSelectedValue() {
                return (String)this.$this_fromProtocol.getSelectedValue().getValue();
            }

            public Icon getIcon() {
                IconModel iconModel = (IconModel)this.$this_fromProtocol.getIcon().getValue();
                return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
            }

            private final RectangleModel getWidgetComponentScreenPosition() {
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.$project);
                IdeStatusBarImpl ideStatusBarImpl = statusBar instanceof IdeStatusBarImpl ? (IdeStatusBarImpl)statusBar : null;
                if (ideStatusBarImpl == null) {
                    return null;
                }
                IdeStatusBarImpl statusBar2 = ideStatusBarImpl;
                JComponent jComponent = statusBar2.getWidgetComponent(this.$widgetId);
                if (jComponent == null) {
                    return null;
                }
                JComponent widgetComponent = jComponent;
                return FrontendStatusBarModelListener.access$getComponentScreenBounds(this.this$0, widgetComponent);
            }

            public Consumer<MouseEvent> getClickConsumer() {
                return super.getClickConsumer();
            }
        };
    }

    private final StatusBarWidget.WidgetPresentation fromProtocol(TextWidgetPresentationModel $this$fromProtocol, Lifetime widgetLifetime) {
        return (StatusBarWidget.WidgetPresentation)new StatusBarWidget.TextPresentation(widgetLifetime, $this$fromProtocol){
            final /* synthetic */ TextWidgetPresentationModel $this_fromProtocol;
            {
                this.$this_fromProtocol = $receiver;
                super($widgetLifetime, (WidgetPresentationModel)$receiver);
            }

            public String getText() {
                String string = (String)this.$this_fromProtocol.getText().getValueOrNull();
                if (string == null) {
                    string = "";
                }
                return string;
            }

            public float getAlignment() {
                Float f = (Float)this.$this_fromProtocol.getAlignment().getValueOrNull();
                return f != null ? f.floatValue() : 0.0f;
            }
        };
    }

    private final StatusBarWidget.WidgetPresentation fromProtocol(IconWidgetPresentationModel $this$fromProtocol, Lifetime widgetLifetime) {
        return (StatusBarWidget.WidgetPresentation)new StatusBarWidget.IconPresentation(widgetLifetime, $this$fromProtocol){
            final /* synthetic */ IconWidgetPresentationModel $this_fromProtocol;
            {
                this.$this_fromProtocol = $receiver;
                super($widgetLifetime, (WidgetPresentationModel)$receiver);
            }

            public Icon getIcon() {
                IconModel iconModel = (IconModel)this.$this_fromProtocol.getIcon().getValue();
                return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
            }
        };
    }

    private final StatusBarWidget fromProtocol(CustomWidgetModel $this$fromProtocol, Lifetime widgetLifetime, String widgetId) {
        JComponent component = ViewRegistryKt.getView((BeControl)$this$fromProtocol.getContent(), (Lifetime)widgetLifetime);
        ClickListener listener2 = new ClickListener(component, $this$fromProtocol, this){
            final /* synthetic */ JComponent $component;
            final /* synthetic */ CustomWidgetModel $this_fromProtocol;
            final /* synthetic */ FrontendStatusBarModelListener this$0;
            {
                this.$component = $component;
                this.$this_fromProtocol = $receiver;
                this.this$0 = $receiver2;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!event.isPopupTrigger() && event.getButton() == 1 && this.$component.isEnabled()) {
                    this.$this_fromProtocol.getClick().fire((Object)FrontendStatusBarModelListener.access$getComponentScreenBounds(this.this$0, this.$component));
                }
                return true;
            }
        };
        boolean bl = false;
        UIUtil.forEachComponentInHierarchy((Component)component, arg_0 -> FrontendStatusBarModelListener.fromProtocol$lambda$12$lambda$11(arg_0 -> FrontendStatusBarModelListener.fromProtocol$lambda$12$lambda$10(listener2, arg_0), arg_0));
        return (StatusBarWidget)new CustomStatusBarWidget(widgetId, component){
            final /* synthetic */ String $widgetId;
            final /* synthetic */ JComponent $component;
            {
                this.$widgetId = $widgetId;
                this.$component = $component;
            }

            public String ID() {
                return this.$widgetId;
            }

            public JComponent getComponent() {
                return this.$component;
            }
        };
    }

    private final RectangleModel getComponentScreenBounds(Component component) {
        return BeUtilKt.toModel((Rectangle)new Rectangle(component.getLocationOnScreen(), component.getSize()));
    }

    private static final Unit extensionCreated$lambda$2(ClientProjectSession $session, FrontendStatusBarModelListener this$0, Lifetime widgetLifetime, String widgetId, WidgetModel widgetModel) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)widgetLifetime, (String)"widgetLifetime");
        Intrinsics.checkNotNullParameter((Object)widgetId, (String)"widgetId");
        Intrinsics.checkNotNullParameter((Object)widgetModel, (String)"widgetModel");
        StatusBar statusBar = WindowManager.getInstance().getStatusBar($session.getProject());
        if (statusBar == null) {
            return Unit.INSTANCE;
        }
        StatusBar statusBar2 = statusBar;
        StatusBarWidget clientWidget = statusBar2.getWidget(widgetId);
        Logger $this$debug_u24default$iv = FrontendStatusBarModelListener.logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Got the following current widget with ID '" + widgetId + "': " + clientWidget + ".", e$iv);
        }
        if (this$0.shouldAddHostWidget($session.getProject(), widgetId, statusBar2)) {
            $this$debug_u24default$iv = FrontendStatusBarModelListener.logger;
            e$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Widget with ID '" + widgetId + "' not found on a clint side. Proceed with the widget.", e$iv);
            }
            this$0.addProtocolWidgetToStatusBar(widgetLifetime, $session.getProject(), widgetModel, widgetId, statusBar2);
        }
        return Unit.INSTANCE;
    }

    private static final Unit addProtocolWidgetToStatusBar$lambda$9(StatusBar $statusBar, String $widgetId, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $statusBar.updateWidget($widgetId);
        return Unit.INSTANCE;
    }

    private static final Unit fromProtocol$lambda$12$lambda$10(fromProtocol.4 $listener, Component it) {
        $listener.installOn(it, true);
        return Unit.INSTANCE;
    }

    private static final void fromProtocol$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ RectangleModel access$getComponentScreenBounds(FrontendStatusBarModelListener $this, Component component) {
        return $this.getComponentScreenBounds(component);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FrontendStatusBarModelListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendStatusBarModelListener.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/status/FrontendStatusBarModelListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/status/FrontendStatusBarModelListener$DelegatingWidgetPresentation;", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "widgetLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "presentationModel", "Lcom/jetbrains/rd/ide/model/WidgetPresentationModel;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/ide/model/WidgetPresentationModel;)V", "mouseClickConsumer", "Lcom/intellij/util/Consumer;", "Ljava/awt/event/MouseEvent;", "getTooltipText", "", "getShortcutText", "getClickConsumer", "toProtocol", "Lcom/jetbrains/rd/ide/model/MouseEventModel;", "intellij.rd.client"})
    private static abstract class DelegatingWidgetPresentation
    implements StatusBarWidget.WidgetPresentation {
        @NotNull
        private final Lifetime widgetLifetime;
        @NotNull
        private final WidgetPresentationModel presentationModel;
        @NotNull
        private final Consumer<MouseEvent> mouseClickConsumer;

        public DelegatingWidgetPresentation(@NotNull Lifetime widgetLifetime, @NotNull WidgetPresentationModel presentationModel) {
            Intrinsics.checkNotNullParameter((Object)widgetLifetime, (String)"widgetLifetime");
            Intrinsics.checkNotNullParameter((Object)presentationModel, (String)"presentationModel");
            this.widgetLifetime = widgetLifetime;
            this.presentationModel = presentationModel;
            this.mouseClickConsumer = arg_0 -> DelegatingWidgetPresentation.mouseClickConsumer$lambda$0(this, arg_0);
        }

        @Nullable
        public String getTooltipText() {
            return (String)this.presentationModel.getTooltipText().getValue();
        }

        @Nullable
        public String getShortcutText() {
            return (String)this.presentationModel.getShortcutText().getValue();
        }

        @Nullable
        public Consumer<MouseEvent> getClickConsumer() {
            return this.mouseClickConsumer;
        }

        private final MouseEventModel toProtocol(MouseEvent $this$toProtocol) {
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, $this$toProtocol.getComponent());
            Component component = $this$toProtocol.getComponent();
            Integer componentId = component != null ? ConverterStorage.Companion.getComponentId(component, ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication())) : null;
            return new MouseEventModel($this$toProtocol.getID(), $this$toProtocol.getModifiersEx(), $this$toProtocol.getX(), $this$toProtocol.getY(), $this$toProtocol.getClickCount(), $this$toProtocol.getButton(), new ComponentRect(point.x, point.y, $this$toProtocol.getComponent().getWidth(), $this$toProtocol.getComponent().getHeight()), componentId);
        }

        private static final void mouseClickConsumer$lambda$0(DelegatingWidgetPresentation this$0, MouseEvent mouseEvent) {
            if (RLifetimeKt.isAlive((Lifetime)this$0.widgetLifetime)) {
                ISignal iSignal = this$0.presentationModel.getClick();
                Intrinsics.checkNotNull((Object)mouseEvent);
                iSignal.fire((Object)this$0.toProtocol(mouseEvent));
            }
        }
    }
}

