/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session.scraper;

import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.TerminalLine;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.session.scraper.StringCollector;
import org.jetbrains.plugins.terminal.block.session.scraper.TerminalLinesCollector;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/scraper/SimpleTerminalLinesCollector;", "Lorg/jetbrains/plugins/terminal/block/session/scraper/TerminalLinesCollector;", "delegate", "Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/scraper/StringCollector;)V", "addLine", "", "line", "Lcom/jediterm/terminal/model/TerminalLine;", "flush", "intellij.terminal"})
public final class SimpleTerminalLinesCollector
implements TerminalLinesCollector {
    @NotNull
    private final StringCollector delegate;

    public SimpleTerminalLinesCollector(@NotNull StringCollector delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    public void addLine(@NotNull TerminalLine line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        line.forEachEntry(arg_0 -> SimpleTerminalLinesCollector.addLine$lambda$0(this, arg_0));
        if (!line.isWrapped()) {
            this.delegate.newline();
        }
    }

    @Override
    public void flush() {
        this.delegate.buildText();
    }

    private static final void addLine$lambda$0(SimpleTerminalLinesCollector this$0, TerminalLine.TextEntry entry) {
        CharBuffer charBuffer = entry.getText();
        Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
        String text = TerminalUiUtilsKt.normalize(charBuffer);
        if (((CharSequence)text).length() > 0 && !entry.isNul()) {
            this$0.delegate.write(text);
        }
    }
}

