/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.StatusText;
import com.jetbrains.ide.model.uiautomation.BeBackgroundColorModifier;
import com.jetbrains.ide.model.uiautomation.BeStyleControl;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeAndTableExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeOrTableKt;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B'\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\tH\u0014J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTree;", "Lcom/intellij/ui/treeStructure/Tree;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ui/tree/TreePathBackgroundSupplier;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "showAsList", "", "viewModel", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGrid;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljavax/swing/tree/DefaultTreeModel;ZLcom/jetbrains/ide/model/uiautomation/BeTreeGrid;)V", "getShowAsList", "()Z", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPathBackground", "Ljava/awt/Color;", "path", "Ljavax/swing/tree/TreePath;", "row", "", "shouldShowBusyIconIfNeeded", "getRendererComponentToolTip", "", "event", "Ljava/awt/event/MouseEvent;", "getToolTipText", "intellij.rd.ui"})
public final class BeTree
extends Tree
implements UiDataProvider,
TreePathBackgroundSupplier {
    private final boolean showAsList;
    @NotNull
    private final BeTreeGrid viewModel;
    @NotNull
    private final DefaultTreeExpander treeExpander;

    public BeTree(@NotNull Lifetime lifetime, @NotNull DefaultTreeModel treeModel, boolean showAsList, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        super((TreeModel)treeModel);
        this.showAsList = showAsList;
        this.viewModel = viewModel;
        this.treeExpander = new DefaultTreeExpander((JTree)((Object)this));
        if (!this.showAsList) {
            this.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
        } else {
            this.setBorder((Border)new JBEmptyBorder(0));
            KeyStroke pressedEnter = KeyStroke.getKeyStroke(10, 0);
            InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)((Object)this), 2);
            if (inputMap != null) {
                inputMap.remove(pressedEnter);
            }
            InputMap inputMap2 = SwingUtilities.getUIInputMap((JComponent)((Object)this), 0);
            if (inputMap2 != null) {
                inputMap2.remove(pressedEnter);
            }
        }
        BeTreeAndTableExtensionsKt.bindProgress(lifetime, this.viewModel.getProgress(), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> BeTree._init_$lambda$0(this, arg_0)));
        StatusText statusText = this.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        ModelRichTextExKt.bindToBeEmptyText(statusText, lifetime, this.viewModel.getEmptyText());
    }

    public final boolean getShowAsList() {
        return this.showAsList;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = LangDataKeys.NO_NEW_ACTION;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NO_NEW_ACTION");
        sink.set(dataKey, (Object)true);
        DataKey dataKey2 = PlatformDataKeys.TREE_EXPANDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"TREE_EXPANDER");
        sink.set(dataKey2, (Object)this.treeExpander);
        if (this.getSelectionCount() == 0) {
            return;
        }
        BeTreeAndTableExtensionsKt.treeGetData(sink, this, (String)this.viewModel.getControlId().getValue());
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        DefaultMutableTreeNode node;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = node = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (node == null) {
            return super.getPathBackground(path, row);
        }
        Object object2 = (IProperty<BeBackgroundColorModifier>)SequencesKt.firstOrNull(BeGetterExtensionsKt.descendantsOfType(BeTreeOrTableKt.line(node), BeStyleControl.class));
        if (object2 == null || (object2 = ((BeStyleControl)((Object)object2)).getBackgroundColor()) == null || (object2 = (BeBackgroundColorModifier)((Object)object2.getValue())) == null || (object2 = ((BeBackgroundColorModifier)((Object)object2)).getColor()) == null || (object2 = ColorHostKt.toColor((AbstractColor)object2)) == null) {
            return super.getPathBackground(path, row);
        }
        return object2;
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return true;
    }

    private final String getRendererComponentToolTip(MouseEvent event) {
        Point point = event.getPoint();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return null;
        }
        TreePath path = treePath;
        Rectangle rectangle = this.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        Rectangle pathBounds = rectangle;
        int row = this.getRowForPath(path);
        if (row == -1) {
            return null;
        }
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer == null) {
            return null;
        }
        TreeCellRenderer renderer = treeCellRenderer;
        Object lastPathComponent = path.getLastPathComponent();
        Component rendererComponent = renderer.getTreeCellRendererComponent((JTree)((Object)this), lastPathComponent, this.isRowSelected(row), super.isExpanded(row), this.getModel().isLeaf(lastPathComponent), row, true);
        if (!(rendererComponent instanceof JComponent)) {
            return null;
        }
        JComponent jComponent = SwingTreeUtilsKt.getDeepestRendererComponentByEvent((Container)((Object)this), rendererComponent, pathBounds, event);
        if (jComponent == null) {
            return null;
        }
        JComponent activeComponent = jComponent;
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(SwingTreeUtilsKt.pathToRoot(activeComponent, (Component)((Object)this)), BeTree::getRendererComponentToolTip$lambda$1));
    }

    @Nullable
    public String getToolTipText(@Nullable MouseEvent event) {
        if (event == null) {
            return this.getToolTipText();
        }
        String string = this.getRendererComponentToolTip(event);
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    private static final Unit _init_$lambda$0(BeTree this$0, boolean it) {
        this$0.setPaintBusy(it);
        return Unit.INSTANCE;
    }

    private static final String getRendererComponentToolTip$lambda$1(Component it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        JComponent jComponent = it instanceof JComponent ? (JComponent)it : null;
        return jComponent != null ? jComponent.getToolTipText() : null;
    }
}

