/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table.links;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.LinkDescriptor;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.TextRangeUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.ui.table.links.CommitLinksProvider;
import com.intellij.vcs.log.ui.table.links.NavigateToCommit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ%\u0010\u000f\u001a\u00020\u00102\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/ui/table/links/VcsLinksRenderer;", "", "project", "Lcom/intellij/openapi/project/Project;", "coloredComponent", "Lcom/intellij/ui/SimpleColoredComponent;", "commitPrefixLinkRenderer", "Lcom/intellij/vcs/log/ui/table/links/CommitLinksProvider;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/SimpleColoredComponent;Lcom/intellij/vcs/log/ui/table/links/CommitLinksProvider;)V", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ui/SimpleColoredComponent;)V", "issueNavigationConfiguration", "Lcom/intellij/openapi/vcs/IssueNavigationConfiguration;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/IssueNavigationConfiguration;", "appendTextWithLinks", "", "textWithLinks", "", "Lcom/intellij/openapi/util/NlsSafe;", "baseStyle", "Lcom/intellij/ui/SimpleTextAttributes;", "commitId", "Lcom/intellij/vcs/log/CommitId;", "asTag", "Lcom/intellij/openapi/vcs/LinkDescriptor;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLinksRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLinksRenderer.kt\ncom/intellij/vcs/log/ui/table/links/VcsLinksRenderer\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n51#2:87\n827#3:88\n855#3:89\n1557#3:90\n1628#3,3:91\n856#3:94\n*S KotlinDebug\n*F\n+ 1 VcsLinksRenderer.kt\ncom/intellij/vcs/log/ui/table/links/VcsLinksRenderer\n*L\n25#1:87\n47#1:88\n47#1:89\n47#1:90\n47#1:91,3\n47#1:94\n*E\n"})
public final class VcsLinksRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SimpleColoredComponent coloredComponent;
    @Nullable
    private final CommitLinksProvider commitPrefixLinkRenderer;
    private final IssueNavigationConfiguration issueNavigationConfiguration;

    public VcsLinksRenderer(@NotNull Project project, @NotNull SimpleColoredComponent coloredComponent, @Nullable CommitLinksProvider commitPrefixLinkRenderer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coloredComponent, (String)"coloredComponent");
        this.coloredComponent = coloredComponent;
        this.commitPrefixLinkRenderer = commitPrefixLinkRenderer;
        this.issueNavigationConfiguration = IssueNavigationConfiguration.getInstance((Project)project);
    }

    public VcsLinksRenderer(@NotNull Project project, @NotNull SimpleColoredComponent coloredComponent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coloredComponent, (String)"coloredComponent");
        ComponentManager $this$serviceOrNull$iv = (ComponentManager)project;
        boolean $i$f$serviceOrNull = false;
        this(project, coloredComponent, (CommitLinksProvider)$this$serviceOrNull$iv.getService(CommitLinksProvider.class));
    }

    /*
     * WARNING - void declaration
     */
    public final void appendTextWithLinks(@NotNull String textWithLinks, @NotNull SimpleTextAttributes baseStyle, @Nullable CommitId commitId) {
        void $this$filterNotTo$iv$iv;
        List<LinkDescriptor> linksToCommits;
        Intrinsics.checkNotNullParameter((Object)textWithLinks, (String)"textWithLinks");
        Intrinsics.checkNotNullParameter((Object)baseStyle, (String)"baseStyle");
        List issuesLinks = this.issueNavigationConfiguration.findIssueLinks((CharSequence)textWithLinks);
        List<LinkDescriptor> list = linksToCommits = commitId != null && this.commitPrefixLinkRenderer != null ? this.commitPrefixLinkRenderer.getLinks(commitId) : CollectionsKt.emptyList();
        if (issuesLinks.isEmpty() && linksToCommits.isEmpty()) {
            this.coloredComponent.append(textWithLinks, baseStyle);
            return;
        }
        Intrinsics.checkNotNull((Object)issuesLinks);
        Iterable $this$filterNot$iv = issuesLinks;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IssueNavigationConfiguration.LinkMatch it = (IssueNavigationConfiguration.LinkMatch)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = linksToCommits;
            TextRange textRange = it.getRange();
            boolean $i$f$map = false;
            void var19_19 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                LinkDescriptor linkDescriptor = (LinkDescriptor)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(p0.getRange());
            }
            if (TextRangeUtil.intersectsOneOf((TextRange)textRange, (List)((List)destination$iv$iv2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allMatched = CollectionsKt.sortedWith((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)linksToCommits), (arg_0, arg_1) -> VcsLinksRenderer.appendTextWithLinks$lambda$2(VcsLinksRenderer::appendTextWithLinks$lambda$1, arg_0, arg_1));
        SimpleTextAttributes linkStyle = IssueLinkRenderer.getLinkAttributes((SimpleTextAttributes)baseStyle);
        int processedOffset = 0;
        for (LinkDescriptor link : allMatched) {
            TextRange textRange = link.getRange();
            if (textRange.getStartOffset() > processedOffset) {
                String string = textWithLinks.substring(processedOffset, textRange.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                this.coloredComponent.append(string, baseStyle);
            }
            this.coloredComponent.append(textRange.substring(textWithLinks), linkStyle, this.asTag(link));
            processedOffset = textRange.getEndOffset();
        }
        if (processedOffset < textWithLinks.length()) {
            String string = textWithLinks.substring(processedOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.coloredComponent.append(string, baseStyle);
        }
    }

    private final Object asTag(LinkDescriptor $this$asTag) {
        LinkDescriptor linkDescriptor = $this$asTag;
        return linkDescriptor instanceof NavigateToCommit ? $this$asTag : (linkDescriptor instanceof IssueNavigationConfiguration.LinkMatch ? new SimpleColoredComponent.BrowserLauncherTag(((IssueNavigationConfiguration.LinkMatch)$this$asTag).getTargetUrl()) : null);
    }

    private static final int appendTextWithLinks$lambda$1(LinkDescriptor l1, LinkDescriptor l2) {
        return TextRangeUtil.RANGE_COMPARATOR.compare(l1.getRange(), l2.getRange());
    }

    private static final int appendTextWithLinks$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @JvmStatic
    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/table/links/VcsLinksRenderer$Companion;", "", "<init>", "()V", "isEnabled", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isEnabled() {
            return Registry.Companion.is("vcs.log.render.commit.links", false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

