/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.wikilink.internal;

import com.vladsch.flexmark.ext.wikilink.WikiImage;
import com.vladsch.flexmark.ext.wikilink.WikiLink;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.ext.wikilink.WikiNode;
import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkOptions;
import com.vladsch.flexmark.parser.LinkRefProcessor;
import com.vladsch.flexmark.parser.LinkRefProcessorFactory;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.ast.TextCollectingVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import org.jetbrains.annotations.NotNull;

public class WikiLinkLinkRefProcessor
implements LinkRefProcessor {
    static final int BRACKET_NESTING_LEVEL = 1;
    private final WikiLinkOptions options;

    public WikiLinkLinkRefProcessor(Document document) {
        this.options = new WikiLinkOptions(document);
    }

    @Override
    public boolean getWantExclamationPrefix() {
        return this.options.imageLinks;
    }

    @Override
    public int getBracketNestingLevel() {
        return 1;
    }

    @Override
    public boolean isMatch(@NotNull BasedSequence nodeChars) {
        int length = nodeChars.length();
        if (this.options.imageLinks) {
            if (length >= 5 && nodeChars.charAt(0) == '!') {
                return nodeChars.charAt(1) == '[' && nodeChars.charAt(2) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
            if (length >= 4) {
                return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
            }
        } else if (length >= 4) {
            return nodeChars.charAt(0) == '[' && nodeChars.charAt(1) == '[' && nodeChars.endCharAt(1) == ']' && nodeChars.endCharAt(2) == ']';
        }
        return false;
    }

    @Override
    @NotNull
    public BasedSequence adjustInlineText(@NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return wikiNode.getText().ifNull(wikiNode.getLink());
    }

    @Override
    public boolean allowDelimiters(@NotNull BasedSequence chars, @NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        return node instanceof WikiLink && WikiLinkExtension.ALLOW_INLINES.get(document) != false && wikiNode.getText().ifNull(wikiNode.getLink()).containsAllOf(chars);
    }

    @Override
    public void updateNodeElements(@NotNull Document document, @NotNull Node node) {
        assert (node instanceof WikiNode);
        WikiNode wikiNode = (WikiNode)node;
        if (node instanceof WikiLink && WikiLinkExtension.ALLOW_INLINES.get(document).booleanValue() && wikiNode.getText().isNull()) {
            BasedSequence link2 = new TextCollectingVisitor().collectAndGetSequence(node, TextContainer.F_NODE_TEXT);
            wikiNode.setLink(link2, WikiLinkExtension.ALLOW_ANCHORS.get(document), WikiLinkExtension.ALLOW_ANCHOR_ESCAPE.get(document));
        }
    }

    @Override
    @NotNull
    public Node createNode(@NotNull BasedSequence nodeChars) {
        return nodeChars.firstChar() == '!' ? new WikiImage(nodeChars, this.options.linkFirstSyntax, this.options.allowPipeEscape) : new WikiLink(nodeChars, this.options.linkFirstSyntax, this.options.allowAnchors, this.options.allowPipeEscape, this.options.allowAnchorEscape);
    }

    public static class Factory
    implements LinkRefProcessorFactory {
        @Override
        @NotNull
        public LinkRefProcessor apply(@NotNull Document document) {
            return new WikiLinkLinkRefProcessor(document);
        }

        @Override
        public boolean getWantExclamationPrefix(@NotNull DataHolder options) {
            return WikiLinkExtension.IMAGE_LINKS.get(options);
        }

        @Override
        public int getBracketNestingLevel(@NotNull DataHolder options) {
            return 1;
        }
    }
}

