/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColor;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DImageEncoder;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DPaintApplier;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import de.rototor.pdfbox.graphics2d.PrivateFieldAccessor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.multipdf.PDFCloneUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType3;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType3;
import org.apache.pdfbox.pdmodel.graphics.shading.ShadingPaint;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.util.Matrix;

public class PdfBoxGraphics2DPaintApplier
implements IPdfBoxGraphics2DPaintApplier {
    private final ExtGStateCache extGStateCache = new ExtGStateCache();
    private final PDShadingCache shadingCache = new PDShadingCache();
    private static final double EPSILON = 1.0E-5;
    private Object BATIK_GRADIENT_NO_CYCLE;
    private Object BATIK_GRADIENT_REFLECT;
    private Object BATIK_GRADIENT_REPEAT;
    private Object BATIK_COLORSPACE_SRGB;
    private Object BATIK_COLORSPACE_LINEAR_RGB;

    @Override
    public PDShading applyPaint(Paint paint, PDPageContentStream contentStream, AffineTransform tf, IPdfBoxGraphics2DPaintApplier.IPaintEnv env2) throws IOException {
        PaintApplierState state = new PaintApplierState();
        state.document = env2.getDocument();
        state.resources = env2.getResources();
        state.contentStream = contentStream;
        state.colorMapper = env2.getColorMapper();
        state.imageEncoder = env2.getImageEncoder();
        state.composite = env2.getComposite();
        state.pdExtendedGraphicsState = null;
        state.env = env2;
        state.tf = tf;
        state.nestedTransform = null;
        PDShading shading = this.applyPaint(paint, state);
        if (state.pdExtendedGraphicsState != null) {
            contentStream.setGraphicsStateParameters(this.extGStateCache.makeUnqiue(state.pdExtendedGraphicsState));
        }
        return shading;
    }

    protected void applyAsStrokingColor(Color color, PaintApplierState state) throws IOException {
        PDPageContentStream contentStream = state.contentStream;
        IPdfBoxGraphics2DColorMapper colorMapper = state.colorMapper;
        contentStream.setStrokingColor(colorMapper.mapColor(contentStream, color));
        contentStream.setNonStrokingColor(colorMapper.mapColor(contentStream, color));
        int alpha = color.getAlpha();
        if (alpha < 255) {
            state.ensureExtendedState();
            Float strokingAlphaConstant = state.pdExtendedGraphicsState.getStrokingAlphaConstant();
            if (strokingAlphaConstant == null) {
                strokingAlphaConstant = Float.valueOf(1.0f);
            }
            state.pdExtendedGraphicsState.setStrokingAlphaConstant(Float.valueOf(strokingAlphaConstant.floatValue() * ((float)alpha / 255.0f)));
            Float nonStrokingAlphaConstant = state.pdExtendedGraphicsState.getNonStrokingAlphaConstant();
            if (nonStrokingAlphaConstant == null) {
                nonStrokingAlphaConstant = Float.valueOf(1.0f);
            }
            state.pdExtendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(nonStrokingAlphaConstant.floatValue() * ((float)alpha / 255.0f)));
        }
        if (color instanceof IPdfBoxGraphics2DColor && ((IPdfBoxGraphics2DColor)((Object)color)).isOverprint()) {
            state.ensureExtendedState();
            state.pdExtendedGraphicsState.setOverprintMode(Float.valueOf(1.0f));
            state.pdExtendedGraphicsState.setNonStrokingOverprintControl(true);
            state.pdExtendedGraphicsState.setStrokingOverprintControl(true);
        }
    }

    private PDShading applyPaint(Paint paint, PaintApplierState state) throws IOException {
        this.applyComposite(state);
        if (paint == null) {
            return null;
        }
        String simpleName = paint.getClass().getSimpleName();
        if (paint instanceof Color) {
            this.applyAsStrokingColor((Color)paint, state);
        } else {
            if (simpleName.equals("LinearGradientPaint")) {
                return this.shadingCache.makeUnqiue(this.buildLinearGradientShading(paint, state));
            }
            if (simpleName.equals("RadialGradientPaint")) {
                return this.shadingCache.makeUnqiue(this.buildRadialGradientShading(paint, state));
            }
            if (simpleName.equals("PatternPaint")) {
                this.applyPatternPaint(paint, state);
            } else if (simpleName.equals("TilingPaint")) {
                this.applyPdfBoxTilingPaint(paint, state);
            } else {
                if (paint instanceof GradientPaint) {
                    return this.shadingCache.makeUnqiue(this.buildGradientShading((GradientPaint)paint, state));
                }
                if (paint instanceof TexturePaint) {
                    this.applyTexturePaint((TexturePaint)paint, state);
                } else {
                    if (paint instanceof ShadingPaint) {
                        return this.shadingCache.makeUnqiue(this.importPDFBoxShadingPaint((ShadingPaint)paint, state));
                    }
                    System.err.printf("Don't know paint %s", paint.getClass().getName());
                }
            }
        }
        return null;
    }

    private PDShading importPDFBoxShadingPaint(ShadingPaint<?> paint, PaintApplierState state) throws IOException {
        PDFCloneUtility pdfCloneUtility = new PDFCloneUtility(state.document);
        Matrix matrix = paint.getMatrix();
        Object shading = paint.getShading();
        state.contentStream.transform(matrix);
        return PDShading.create((COSDictionary)pdfCloneUtility.cloneForNewDocument(((PDShading)shading).getCOSObject()));
    }

    private void applyPatternPaint(Paint paint, PaintApplierState state) throws IOException {
        Rectangle2D anchorRect = (Rectangle2D)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getPatternRect");
        AffineTransform paintPatternTransform = (AffineTransform)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getPatternTransform");
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        pattern.setBBox(new PDRectangle((float)anchorRect.getX(), (float)anchorRect.getY(), (float)anchorRect.getWidth(), (float)anchorRect.getHeight()));
        pattern.setXStep((float)anchorRect.getWidth());
        pattern.setYStep((float)anchorRect.getHeight());
        AffineTransform patternTransform = new AffineTransform();
        if (paintPatternTransform != null) {
            paintPatternTransform = new AffineTransform(paintPatternTransform);
            paintPatternTransform.preConcatenate(state.tf);
            patternTransform.concatenate(paintPatternTransform);
        } else {
            patternTransform.concatenate(state.tf);
        }
        patternTransform.scale(1.0, -1.0);
        pattern.setMatrix(patternTransform);
        PDAppearanceStream appearance = new PDAppearanceStream(state.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        Object graphicsNode = PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getGraphicsNode");
        PdfBoxGraphics2D pdfBoxGraphics2D = new PdfBoxGraphics2D(state.document, pattern.getBBox(), state.env.getGraphics2D());
        try {
            Method paintMethod = graphicsNode.getClass().getMethod("paint", Graphics2D.class);
            paintMethod.invoke(graphicsNode, pdfBoxGraphics2D);
        }
        catch (Exception e) {
            System.err.printf("PdfBoxGraphics2DPaintApplier error while drawing Batik PatternPaint %s", e.getMessage());
            return;
        }
        pdfBoxGraphics2D.dispose();
        PDFormXObject xFormObject = pdfBoxGraphics2D.getXFormObject();
        PDPageContentStream imageContentStream = new PDPageContentStream(state.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        imageContentStream.drawForm(xFormObject);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null);
        COSName tilingPatternName = state.resources.add(pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        state.contentStream.setNonStrokingColor(patternColor);
        state.contentStream.setStrokingColor(patternColor);
    }

    private void applyPdfBoxTilingPaint(Paint paint, PaintApplierState state) {
        try {
            Paint tilingPaint = (Paint)PrivateFieldAccessor.getPrivateField(paint, "paint");
            Matrix patternMatrix = (Matrix)PrivateFieldAccessor.getPrivateField(paint, "patternMatrix");
            state.nestedTransform = patternMatrix.createAffineTransform();
            this.applyPaint(tilingPaint, state);
        }
        catch (Exception e) {
            System.err.printf("PdfBoxGraphics2DPaintApplier error while drawing Tiling Paint %s", e.getMessage());
        }
    }

    private void applyComposite(PaintApplierState state) {
        if (state.composite == null) {
            return;
        }
        float alpha = 1.0f;
        COSName blendMode = COSName.COMPATIBLE;
        int rule = 2;
        if (state.composite instanceof AlphaComposite) {
            AlphaComposite composite = (AlphaComposite)state.composite;
            alpha = composite.getAlpha();
            rule = composite.getRule();
        } else if (state.composite.getClass().getSimpleName().equals("SVGComposite")) {
            alpha = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(state.composite, "alpha")).floatValue();
            rule = (Integer)PdfBoxGraphics2DPaintApplier.getPropertyValue(state.composite, "rule");
        } else {
            System.err.printf("Unknown composite %s", state.composite.getClass().getSimpleName());
        }
        state.ensureExtendedState();
        if (alpha < 1.0f) {
            assert (state.pdExtendedGraphicsState != null);
            state.pdExtendedGraphicsState.setStrokingAlphaConstant(Float.valueOf(alpha));
            state.pdExtendedGraphicsState.setNonStrokingAlphaConstant(Float.valueOf(alpha));
        }
        switch (rule) {
            case 1: {
                break;
            }
            case 2: {
                blendMode = COSName.NORMAL;
                break;
            }
            case 3: {
                blendMode = COSName.COMPATIBLE;
                break;
            }
            case 12: {
                blendMode = COSName.EXCLUSION;
                break;
            }
            case 9: {
                break;
            }
            case 11: {
                break;
            }
            case 10: {
                blendMode = COSName.COMPATIBLE;
                break;
            }
            case 6: {
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
        }
        state.dictExtendedState.setItem(COSName.BM, (COSBase)blendMode);
    }

    private Point2D clonePoint(Point2D point2D) {
        return new Point2D.Double(point2D.getX(), point2D.getY());
    }

    private PDShading buildLinearGradientShading(Paint paint, PaintApplierState state) throws IOException {
        AffineTransform gradientTransform;
        boolean isBatikGradient = paint.getClass().getPackage().getName().equals("org.apache.batik.ext.awt");
        boolean isObjectBoundingBox = false;
        if (isBatikGradient && !(gradientTransform = (AffineTransform)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getTransform")).isIdentity() && Math.abs(gradientTransform.getScaleX() - gradientTransform.getScaleY()) > 1.0E-5) {
            isObjectBoundingBox = true;
        }
        if (isObjectBoundingBox) {
            return this.linearGradientObjectBoundingBoxShading(paint, state);
        }
        return this.linearGradientUserSpaceOnUseShading(paint, state);
    }

    private PDShading linearGradientObjectBoundingBoxShading(Paint paint, PaintApplierState state) throws IOException {
        PDShadingType3 shading = this.setupBasicLinearShading(paint, state);
        Point2D startPoint = this.clonePoint((Point2D.Double)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getStartPoint"));
        Point2D endPoint = this.clonePoint((Point2D.Double)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getEndPoint"));
        AffineTransform gradientTransform = (AffineTransform)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getTransform");
        state.tf.concatenate(gradientTransform);
        MultipleGradientPaint.CycleMethod cycleMethod = this.getCycleMethod(paint);
        MultipleGradientPaint.ColorSpaceType colorSpaceType = this.getColorSpaceType(paint);
        this.setupShadingCoords(shading, startPoint, endPoint);
        float calculatedX = (float)Math.min(startPoint.getX(), endPoint.getX());
        float calculatedY = (float)Math.max(1.0, Math.max(startPoint.getY(), endPoint.getY()));
        float calculatedWidth = Math.max(1.0f, Math.abs((float)(endPoint.getX() - startPoint.getX())));
        float negativeHeight = -1.0f * Math.max(1.0f, Math.abs((float)(endPoint.getY() - startPoint.getY())));
        state.contentStream.addRect(calculatedX, calculatedY, calculatedWidth, negativeHeight);
        state.env.getGraphics2D().markPathIsOnStream();
        state.env.getGraphics2D().internalClip(false);
        state.contentStream.transform(new Matrix(state.tf));
        return shading;
    }

    private void setupShadingCoords(PDShadingType3 shading, Point2D startPoint, Point2D endPoint) {
        COSArray coords = new COSArray();
        coords.add(new COSFloat((float)startPoint.getX()));
        coords.add(new COSFloat((float)startPoint.getY()));
        coords.add(new COSFloat((float)endPoint.getX()));
        coords.add(new COSFloat((float)endPoint.getY()));
        shading.setCoords(coords);
    }

    private PDShading linearGradientUserSpaceOnUseShading(Paint paint, PaintApplierState state) throws IOException {
        PDShadingType3 shading = this.setupBasicLinearShading(paint, state);
        Point2D startPoint = this.clonePoint((Point2D.Double)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getStartPoint"));
        Point2D endPoint = this.clonePoint((Point2D.Double)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getEndPoint"));
        AffineTransform gradientTransform = (AffineTransform)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getTransform");
        state.tf.concatenate(gradientTransform);
        MultipleGradientPaint.CycleMethod cycleMethod = this.getCycleMethod(paint);
        MultipleGradientPaint.ColorSpaceType colorSpaceType = this.getColorSpaceType(paint);
        state.tf.transform(startPoint, startPoint);
        state.tf.transform(endPoint, endPoint);
        this.setupShadingCoords(shading, startPoint, endPoint);
        return shading;
    }

    private PDShadingType3 setupBasicLinearShading(Paint paint, PaintApplierState state) throws IOException {
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        Color[] colors = (Color[])PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        float[] fractions = (float[])PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getFractions");
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        shading.setAntiAlias(true);
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        shading.setFunction(type3);
        shading.setExtend(this.setupExtends());
        return shading;
    }

    private COSArray setupExtends() {
        COSArray extend = new COSArray();
        extend.add(COSBoolean.TRUE);
        extend.add(COSBoolean.TRUE);
        return extend;
    }

    private MultipleGradientPaint.CycleMethod getCycleMethod(Paint paint) {
        if (paint instanceof MultipleGradientPaint) {
            return ((MultipleGradientPaint)paint).getCycleMethod();
        }
        if (paint.getClass().getPackage().getName().equals("org.apache.batik.ext.awt")) {
            this.setupBatikReflectionAccess(paint);
            Object cycleMethod = PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getCycleMethod");
            if (cycleMethod == this.BATIK_GRADIENT_NO_CYCLE) {
                return MultipleGradientPaint.CycleMethod.NO_CYCLE;
            }
            if (cycleMethod == this.BATIK_GRADIENT_REFLECT) {
                return MultipleGradientPaint.CycleMethod.REFLECT;
            }
            if (cycleMethod == this.BATIK_GRADIENT_REPEAT) {
                return MultipleGradientPaint.CycleMethod.REPEAT;
            }
        }
        return MultipleGradientPaint.CycleMethod.NO_CYCLE;
    }

    private MultipleGradientPaint.ColorSpaceType getColorSpaceType(Paint paint) {
        if (paint instanceof MultipleGradientPaint) {
            return ((MultipleGradientPaint)paint).getColorSpace();
        }
        if (paint.getClass().getPackage().getName().equals("org.apache.batik.ext.awt")) {
            this.setupBatikReflectionAccess(paint);
            Object cycleMethod = PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getColorSpace");
            if (cycleMethod == this.BATIK_COLORSPACE_SRGB) {
                return MultipleGradientPaint.ColorSpaceType.SRGB;
            }
            if (cycleMethod == this.BATIK_COLORSPACE_LINEAR_RGB) {
                return MultipleGradientPaint.ColorSpaceType.LINEAR_RGB;
            }
        }
        return MultipleGradientPaint.ColorSpaceType.SRGB;
    }

    private void setupBatikReflectionAccess(Paint paint) {
        if (this.BATIK_GRADIENT_NO_CYCLE != null) {
            return;
        }
        try {
            Class<?> cls = paint.getClass();
            if (cls.getSimpleName().equals("MultipleGradientPaint")) {
                this.BATIK_GRADIENT_NO_CYCLE = cls.getDeclaredField("NO_CYCLE");
                this.BATIK_GRADIENT_REFLECT = cls.getDeclaredField("REFLECT");
                this.BATIK_GRADIENT_REPEAT = cls.getDeclaredField("REPEAT");
                this.BATIK_COLORSPACE_SRGB = cls.getDeclaredField("SRGB");
                this.BATIK_COLORSPACE_LINEAR_RGB = cls.getDeclaredField("LINEAR_RGB");
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private PDShading buildRadialGradientShading(Paint paint, PaintApplierState state) throws IOException {
        Color[] colors = (Color[])PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getColors");
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setAntiAlias(true);
        shading.setShadingType(3);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = (float[])PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getFractions");
        Point2D centerPoint = this.clonePoint((Point2D)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getCenterPoint"));
        Point2D focusPoint = this.clonePoint((Point2D)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getFocusPoint"));
        AffineTransform gradientTransform = (AffineTransform)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getTransform");
        state.tf.concatenate(gradientTransform);
        state.tf.transform(centerPoint, centerPoint);
        state.tf.transform(focusPoint, focusPoint);
        float radius = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(paint, "getRadius")).floatValue();
        radius = (float)Math.abs((double)radius * state.tf.getScaleX());
        COSArray coords = new COSArray();
        coords.add(new COSFloat((float)centerPoint.getX()));
        coords.add(new COSFloat((float)centerPoint.getY()));
        coords.add(new COSFloat(0.0f));
        coords.add(new COSFloat((float)focusPoint.getX()));
        coords.add(new COSFloat((float)focusPoint.getY()));
        coords.add(new COSFloat(radius));
        shading.setCoords(coords);
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        shading.setFunction(type3);
        shading.setExtend(this.setupExtends());
        return shading;
    }

    private PDShading buildGradientShading(GradientPaint gradientPaint, PaintApplierState state) throws IOException {
        Color[] colors = new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()};
        Color firstColor = colors[0];
        PDColor firstColorMapped = state.colorMapper.mapColor(state.contentStream, firstColor);
        this.applyAsStrokingColor(firstColor, state);
        PDShadingType3 shading = new PDShadingType3(new COSDictionary());
        shading.setShadingType(2);
        shading.setColorSpace(firstColorMapped.getColorSpace());
        float[] fractions = new float[]{0.0f, 1.0f};
        PDFunctionType3 type3 = this.buildType3Function(colors, fractions, state);
        Point2D startPoint = gradientPaint.getPoint1();
        Point2D endPoint = gradientPaint.getPoint2();
        state.tf.transform(startPoint, startPoint);
        state.tf.transform(endPoint, endPoint);
        this.setupShadingCoords(shading, startPoint, endPoint);
        shading.setFunction(type3);
        shading.setExtend(this.setupExtends());
        return shading;
    }

    private void applyTexturePaint(TexturePaint texturePaint, PaintApplierState state) throws IOException {
        Rectangle2D anchorRect = texturePaint.getAnchorRect();
        PDTilingPattern pattern = new PDTilingPattern();
        pattern.setPaintType(1);
        pattern.setTilingType(3);
        pattern.setBBox(new PDRectangle((float)anchorRect.getX(), (float)anchorRect.getY(), (float)anchorRect.getWidth(), (float)anchorRect.getHeight()));
        pattern.setXStep((float)anchorRect.getWidth());
        pattern.setYStep((float)anchorRect.getHeight());
        AffineTransform patternTransform = new AffineTransform();
        patternTransform.translate(0.0, anchorRect.getHeight());
        patternTransform.scale(1.0, -1.0);
        pattern.setMatrix(patternTransform);
        PDAppearanceStream appearance = new PDAppearanceStream(state.document);
        appearance.setResources(pattern.getResources());
        appearance.setBBox(pattern.getBBox());
        PDPageContentStream imageContentStream = new PDPageContentStream(state.document, appearance, ((COSStream)pattern.getCOSObject()).createOutputStream());
        BufferedImage texturePaintImage = texturePaint.getImage();
        PDImageXObject imageXObject = state.imageEncoder.encodeImage(state.document, imageContentStream, texturePaintImage);
        float ratioW = (float)(anchorRect.getWidth() / (double)texturePaintImage.getWidth());
        float ratioH = (float)(anchorRect.getHeight() / (double)texturePaintImage.getHeight());
        float paintHeight = (float)texturePaintImage.getHeight() * ratioH;
        if (state.nestedTransform != null) {
            imageContentStream.transform(new Matrix(state.nestedTransform));
        }
        imageContentStream.drawImage(imageXObject, (float)anchorRect.getX(), (float)((double)paintHeight + anchorRect.getY()), (float)texturePaintImage.getWidth() * ratioW, -paintHeight);
        imageContentStream.close();
        PDPattern patternCS1 = new PDPattern(null, imageXObject.getColorSpace());
        COSName tilingPatternName = state.resources.add(pattern);
        PDColor patternColor = new PDColor(tilingPatternName, (PDColorSpace)patternCS1);
        state.contentStream.setNonStrokingColor(patternColor);
        state.contentStream.setStrokingColor(patternColor);
    }

    private PDFunctionType3 buildType3Function(Color[] colors, float[] fractions, PaintApplierState state) {
        COSDictionary function = new COSDictionary();
        function.setInt(COSName.FUNCTION_TYPE, 3);
        COSArray domain = new COSArray();
        domain.add(new COSFloat(0.0f));
        domain.add(new COSFloat(1.0f));
        COSArray encode = new COSArray();
        COSArray range = new COSArray();
        range.add(new COSFloat(0.0f));
        range.add(new COSFloat(1.0f));
        ArrayList<Color> colorList = new ArrayList<Color>(Arrays.asList(colors));
        COSArray bounds = new COSArray();
        if ((double)Math.abs(fractions[0]) > 1.0E-5) {
            colorList.add(0, colors[0]);
            bounds.add(new COSFloat(fractions[0]));
        }
        for (int i = 1; i < fractions.length - 1; ++i) {
            float fraction = fractions[i];
            bounds.add(new COSFloat(fraction));
        }
        if ((double)Math.abs(fractions[fractions.length - 1] - 1.0f) > 1.0E-5) {
            colorList.add(colors[colors.length - 1]);
            bounds.add(new COSFloat(fractions[fractions.length - 1]));
        }
        COSArray type2Functions = this.buildType2Functions(colorList, domain, encode, state);
        function.setItem(COSName.FUNCTIONS, (COSBase)type2Functions);
        function.setItem(COSName.BOUNDS, (COSBase)bounds);
        function.setItem(COSName.ENCODE, (COSBase)encode);
        PDFunctionType3 type3 = new PDFunctionType3(function);
        type3.setDomainValues(domain);
        return type3;
    }

    private COSArray buildType2Functions(List<Color> colors, COSArray domain, COSArray encode, PaintApplierState state) {
        Color prevColor = colors.get(0);
        COSArray functions = new COSArray();
        for (int i = 1; i < colors.size(); ++i) {
            Color color = colors.get(i);
            PDColor prevPdColor = state.colorMapper.mapColor(state.contentStream, prevColor);
            PDColor pdColor = state.colorMapper.mapColor(state.contentStream, color);
            COSArray c0 = new COSArray();
            COSArray c1 = new COSArray();
            for (float component : prevPdColor.getComponents()) {
                c0.add(new COSFloat(component));
            }
            for (float component : pdColor.getComponents()) {
                c1.add(new COSFloat(component));
            }
            COSDictionary type2Function = new COSDictionary();
            type2Function.setInt(COSName.FUNCTION_TYPE, 2);
            type2Function.setItem(COSName.C0, (COSBase)c0);
            type2Function.setItem(COSName.C1, (COSBase)c1);
            type2Function.setInt(COSName.N, 1);
            type2Function.setItem(COSName.DOMAIN, (COSBase)domain);
            functions.add(type2Function);
            encode.add(new COSFloat(0.0f));
            encode.add(new COSFloat(1.0f));
            prevColor = color;
        }
        return functions;
    }

    protected static <T> T getPropertyValue(Object obj, String propertyGetter) {
        try {
            for (Class<?> c = obj.getClass(); c != null; c = c.getSuperclass()) {
                try {
                    Method m = c.getMethod(propertyGetter, null);
                    return (T)m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    continue;
                }
            }
            throw new NullPointerException("Method " + propertyGetter + " not found!");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class PDShadingCache
    extends COSResourceCacheBase<PDShading> {
        private PDShadingCache() {
        }

        @Override
        protected int getKey(PDShading obj) {
            return obj.getCOSObject().size();
        }
    }

    private static class ExtGStateCache
    extends COSResourceCacheBase<PDExtendedGraphicsState> {
        private ExtGStateCache() {
        }

        @Override
        protected int getKey(PDExtendedGraphicsState obj) {
            return obj.getCOSObject().size();
        }
    }

    private static abstract class COSResourceCacheBase<TObject extends COSObjectable> {
        private final Map<Integer, List<TObject>> states = new HashMap<Integer, List<TObject>>();

        private COSResourceCacheBase() {
        }

        private static boolean equalsCOSDictionary(COSDictionary cosDictionary, COSDictionary cosDictionary1) {
            if (cosDictionary.size() != cosDictionary1.size()) {
                return false;
            }
            for (COSName name : cosDictionary.keySet()) {
                COSBase item2;
                COSBase item = cosDictionary.getItem(name);
                if (COSResourceCacheBase.equalsCOSBase(item, item2 = cosDictionary1.getItem(name))) continue;
                return false;
            }
            return true;
        }

        private static boolean equalsCOSBase(COSBase item, COSBase item2) {
            if (item == item2) {
                return true;
            }
            if (item == null) {
                return false;
            }
            if (item2 == null) {
                return false;
            }
            if (item.equals(item2)) {
                return true;
            }
            if (item instanceof COSDictionary && item2 instanceof COSDictionary) {
                return COSResourceCacheBase.equalsCOSDictionary((COSDictionary)item, (COSDictionary)item2);
            }
            if (item instanceof COSArray && item2 instanceof COSArray) {
                return COSResourceCacheBase.equalsCOSArray((COSArray)item, (COSArray)item2);
            }
            return false;
        }

        private static boolean equalsCOSArray(COSArray item, COSArray item2) {
            if (item.size() != item2.size()) {
                return false;
            }
            for (int i = 0; i < item.size(); ++i) {
                COSBase i2;
                COSBase i1 = item.getObject(i);
                if (COSResourceCacheBase.equalsCOSBase(i1, i2 = item2.getObject(i))) continue;
                return false;
            }
            return true;
        }

        protected abstract int getKey(TObject var1);

        TObject makeUnqiue(TObject state) {
            int key = this.getKey(state);
            List<TObject> pdExtendedGraphicsStates = this.states.get(key);
            if (pdExtendedGraphicsStates == null) {
                pdExtendedGraphicsStates = new ArrayList<TObject>();
                this.states.put(key, pdExtendedGraphicsStates);
            }
            for (COSObjectable s : pdExtendedGraphicsStates) {
                if (!this.stateEquals(s, state)) continue;
                return (TObject)s;
            }
            pdExtendedGraphicsStates.add(state);
            return state;
        }

        private boolean stateEquals(TObject s, TObject state) {
            COSBase base1 = s.getCOSObject();
            COSBase base2 = state.getCOSObject();
            return COSResourceCacheBase.equalsCOSBase(base1, base2);
        }
    }

    protected static class PaintApplierState {
        protected PDDocument document;
        protected PDPageContentStream contentStream;
        protected IPdfBoxGraphics2DColorMapper colorMapper;
        protected IPdfBoxGraphics2DImageEncoder imageEncoder;
        protected PDResources resources;
        protected PDExtendedGraphicsState pdExtendedGraphicsState;
        protected Composite composite;
        private COSDictionary dictExtendedState;
        private IPdfBoxGraphics2DPaintApplier.IPaintEnv env;
        public AffineTransform tf;
        protected AffineTransform nestedTransform;

        protected PaintApplierState() {
        }

        private void ensureExtendedState() {
            if (this.pdExtendedGraphicsState == null) {
                this.dictExtendedState = new COSDictionary();
                this.dictExtendedState.setItem(COSName.TYPE, (COSBase)COSName.EXT_G_STATE);
                this.pdExtendedGraphicsState = new PDExtendedGraphicsState(this.dictExtendedState);
            }
            assert (this.pdExtendedGraphicsState != null);
        }
    }
}

