/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/prometheusoperator/scheme"
)

// ProbesGetter has a method to return a ProbeInterface.
// A group's client should implement this interface.
type ProbesGetter interface {
	Probes(namespace string) ProbeInterface
}

// ProbeInterface has methods to work with Probe resources.
type ProbeInterface interface {
	Create(ctx context.Context, probe *v1.Probe, opts metav1.CreateOptions) (*v1.Probe, error)
	Update(ctx context.Context, probe *v1.Probe, opts metav1.UpdateOptions) (*v1.Probe, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.Probe, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ProbeList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.Probe, err error)
	ProbeExpansion
}

// probes implements ProbeInterface
type probes struct {
	*gentype.ClientWithList[*v1.Probe, *v1.ProbeList]
}

// newProbes returns a Probes
func newProbes(c *MonitoringV1Client, namespace string) *probes {
	return &probes{
		gentype.NewClientWithList[*v1.Probe, *v1.ProbeList](
			"probes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1.Probe { return &v1.Probe{} },
			func() *v1.ProbeList { return &v1.ProbeList{} }),
	}
}
