/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jmx;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jmx.ConfiguratorMBean;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.Status;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator
extends ContextAwareBase
implements ConfiguratorMBean {
    private static String EMPTY = "";

    public Configurator(LoggerContext loggerContext) {
        this.context = loggerContext;
    }

    @Override
    public void reload() {
        LoggerContext lc = (LoggerContext)this.context;
        this.addInfo("Shutting down context: " + lc.getName());
        lc.shutdownAndReset();
        try {
            ContextInitializer.autoConfig(lc, lc.getClass().getClassLoader());
            this.addInfo("Context: " + lc.getName() + " reloaded.");
        }
        catch (JoranException je) {
            this.addError("Reloading of context: " + lc.getName() + " failed.", je);
        }
    }

    @Override
    public void reload(String fileName) throws JoranException {
        LoggerContext lc = (LoggerContext)this.context;
        this.addInfo("Shutting down context: " + lc.getName());
        lc.shutdownAndReset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        configurator.doConfigure(fileName);
        this.addInfo("Context: " + lc.getName() + " reloaded.");
    }

    @Override
    public void reload(URL url) throws JoranException {
        LoggerContext lc = (LoggerContext)this.context;
        this.addInfo("Shutting down context: " + lc.getName());
        lc.shutdownAndReset();
        ContextInitializer.configureByResource(lc, url);
        this.addInfo("Context: " + lc.getName() + " reloaded.");
    }

    @Override
    public void setLoggerLevel(String loggerName, String levelStr) {
        if (loggerName == null) {
            return;
        }
        if (levelStr == null) {
            return;
        }
        loggerName = loggerName.trim();
        levelStr = levelStr.trim();
        this.addInfo("Trying to set level " + levelStr + " to logger " + loggerName);
        LoggerContext lc = (LoggerContext)this.context;
        Logger logger = lc.getLogger(loggerName);
        if ("null".equalsIgnoreCase(levelStr)) {
            logger.setLevel(null);
        } else {
            Level level = Level.toLevel(levelStr, null);
            if (level != null) {
                logger.setLevel(level);
            }
        }
    }

    @Override
    public String getLoggerLevel(String loggerName) {
        if (loggerName == null) {
            return EMPTY;
        }
        LoggerContext lc = (LoggerContext)this.context;
        Logger logger = lc.exists(loggerName = loggerName.trim());
        if (logger != null) {
            return logger.getLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public String getLoggerEffectiveLevel(String loggerName) {
        if (loggerName == null) {
            return EMPTY;
        }
        LoggerContext lc = (LoggerContext)this.context;
        Logger logger = lc.exists(loggerName = loggerName.trim());
        if (logger != null) {
            return logger.getEffectiveLevel().toString();
        }
        return EMPTY;
    }

    @Override
    public List<String> getLoggerList() {
        LoggerContext lc = (LoggerContext)this.context;
        ArrayList<String> strList = new ArrayList<String>();
        for (Logger log : lc.getLoggerList()) {
            strList.add(log.getName());
        }
        return strList;
    }

    @Override
    public List<String> getStatuses() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator it = this.context.getStatusManager().iterator();
        while (it.hasNext()) {
            list.add(((Status)it.next()).toString());
        }
        return list;
    }
}

