/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.xml.sax.Attributes;

public class JndiSubstitutionPropertyAction
extends Action {
    private Context namingContext;

    protected Context getNamingContext() {
        return this.namingContext;
    }

    protected void findNamingContext() throws NamingException {
        if (this.getNamingContext() != null) {
            this.getLogger().warn("Overwriting existing naming context.");
        }
        InitialContext ic = new InitialContext();
        this.namingContext = (Context)ic.lookup("java:comp/env");
    }

    public void begin(ExecutionContext ec, String name, Attributes attributes) {
        String jndiName;
        if (this.getNamingContext() == null) {
            try {
                this.findNamingContext();
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Couldn't find JNDI naming context: ", e);
                ec.addError(new ErrorItem("Couldn't find JNDI naming context.", e));
            }
        }
        if ((jndiName = attributes.getValue("name")) == null || jndiName.trim().length() < 1) {
            this.getLogger().warn((Object)"Missing {} attribute, ignoring.", "name");
        } else if (this.getNamingContext() != null) {
            Object value = null;
            try {
                value = this.getNamingContext().lookup(jndiName);
            }
            catch (Exception e) {
                this.getLogger().error((Object)("Error looking up " + jndiName + ": "), e);
                ec.addError(new ErrorItem("Error looking up " + jndiName, e));
            }
            if (value == null) {
                this.getLogger().warn((Object)"No JNDI value found for {}.", jndiName);
            } else if (!(value instanceof String)) {
                this.getLogger().warn((Object)"Value for {} is not a String.", jndiName);
            } else {
                ec.addProperty(jndiName, (String)value);
            }
        } else {
            this.getLogger().warn((Object)"Naming context is null, cannot lookup {}", jndiName);
        }
    }

    public void end(ExecutionContext ec, String name) {
    }
}

