/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import org.apache.log4j.Logger;
import org.apache.log4j.ULogger;
import org.apache.log4j.spi.Component;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.NOPULogger;
import org.apache.log4j.spi.SimpleULogger;

public class ComponentBase
implements Component {
    private static final int ERROR_COUNT_LIMIT = 3;
    protected LoggerRepository repository;
    private ULogger logger;
    private int errorCount = 0;

    protected void resetErrorCount() {
        this.errorCount = 0;
    }

    public void setLoggerRepository(LoggerRepository repository) {
        if (this.repository == null) {
            this.repository = repository;
        } else if (this.repository != repository) {
            throw new IllegalStateException("Repository has been already set");
        }
    }

    protected LoggerRepository getLoggerRepository() {
        return this.repository;
    }

    protected ULogger getLogger() {
        if (this.logger == null) {
            this.logger = this.repository != null ? this.repository.getLogger(this.getClass().getName()) : SimpleULogger.getLogger(this.getClass().getName());
        } else if (this.repository == null || !(this.logger instanceof Logger)) {
            // empty if block
        }
        return this.logger;
    }

    protected ULogger getNonFloodingLogger() {
        if (this.errorCount++ >= 3) {
            return NOPULogger.NOP_LOGGER;
        }
        return this.getLogger();
    }
}

