/* fit-parser.c generated by valac 0.20.1, the Vala compiler
 * generated from fit-parser.vala, do not modify */

/* Gpx Viewer
 * Copyright (C) 2013 Qball Cow <qball@sarine.nl>
 * Project homepage: http://blog.sarine.nl/

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <glib.h>
#include <glib-object.h>
#include "gpx.h"
#include <gio/gio.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define GPX_FIT_FILE_TYPE_FIELD_DEFINITION (gpx_fit_file_field_definition_get_type ())

#define GPX_FIT_FILE_TYPE_FIELD_DEFINITION_HEADER (gpx_fit_file_field_definition_header_get_type ())
typedef struct _GpxFitFileFieldDefinitionHeader GpxFitFileFieldDefinitionHeader;
typedef struct _GpxFitFileFieldDefinition GpxFitFileFieldDefinition;

#define GPX_FIT_FILE_TYPE_FIT_TYPES (gpx_fit_file_fit_types_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gpx_point_unref0(var) ((var == NULL) ? NULL : (var = (gpx_point_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GpxFitFileFieldDefinitionHeader {
	guint8 def_num;
	guint8 size;
	guint8 base_type;
};

struct _GpxFitFileFieldDefinition {
	gboolean endian;
	guint16 type;
	GpxFitFileFieldDefinitionHeader* fields;
	gint fields_length1;
	gint _fields_size_;
};

struct _GpxFitFilePrivate {
	GpxTrack* track;
	guint32 data_length;
	GpxFitFileFieldDefinition* defs;
	gint defs_length1;
	gint _defs_size_;
};

typedef enum  {
	GPX_FIT_FILE_FIT_TYPES_LAP = 19,
	GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY = 20
} GpxFitFileFitTypes;


static gpointer gpx_fit_file_parent_class = NULL;

#define MAX_LOCAL_DEFINITIONS 16
static GType gpx_fit_file_field_definition_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType gpx_fit_file_field_definition_header_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GpxFitFileFieldDefinitionHeader* gpx_fit_file_field_definition_header_dup (const GpxFitFileFieldDefinitionHeader* self);
static void gpx_fit_file_field_definition_header_free (GpxFitFileFieldDefinitionHeader* self);
static GpxFitFileFieldDefinition* gpx_fit_file_field_definition_dup (const GpxFitFileFieldDefinition* self);
static void gpx_fit_file_field_definition_free (GpxFitFileFieldDefinition* self);
static void gpx_fit_file_field_definition_copy (const GpxFitFileFieldDefinition* self, GpxFitFileFieldDefinition* dest);
static void gpx_fit_file_field_definition_destroy (GpxFitFileFieldDefinition* self);
#define GPX_FIT_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GPX_TYPE_FIT_FILE, GpxFitFilePrivate))
enum  {
	GPX_FIT_FILE_DUMMY_PROPERTY
};
static GType gpx_fit_file_fit_types_get_type (void) G_GNUC_UNUSED;
static void _vala_GpxFitFileFieldDefinition_array_free (GpxFitFileFieldDefinition* array, gint array_length);
static GpxFitFileFieldDefinition* gpx_fit_file_get_field_def (GpxFitFile* self, guint id);
static void gpx_fit_file_parse_apply_definition_endian (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def);
static void gpx_fit_file_parse_header (GpxFitFile* self, GDataInputStream* fs, GError** error);
static gboolean gpx_fit_file_parse_record (GpxFitFile* self, GDataInputStream* fs);
static void gpx_fit_file_parse_definition_record (GpxFitFile* self, GDataInputStream* fs, guint8 local_message_type, GError** error);
static void gpx_fit_file_parse_data_record (GpxFitFile* self, GDataInputStream* fs, guint8 local_message_type, GError** error);
static guint32 gpx_fit_file_parse_field (GpxFitFile* self, GpxFitFileFieldDefinitionHeader* field, GDataInputStream* fp, GError** error);
static void gpx_fit_file_parse_data_record_lap (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def, GError** error);
static void gpx_fit_file_parse_data_record_activity_summary (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def, GError** error);
static GpxFitFileFieldDefinitionHeader* _vala_array_dup1 (GpxFitFileFieldDefinitionHeader* self, int length);
static void gpx_fit_file_finalize (GObject* obj);


static GType gpx_fit_file_fit_types_get_type (void) {
	static volatile gsize gpx_fit_file_fit_types_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_fit_file_fit_types_type_id__volatile)) {
		static const GEnumValue values[] = {{GPX_FIT_FILE_FIT_TYPES_LAP, "GPX_FIT_FILE_FIT_TYPES_LAP", "lap"}, {GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY, "GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY", "activity-summary"}, {0, NULL, NULL}};
		GType gpx_fit_file_fit_types_type_id;
		gpx_fit_file_fit_types_type_id = g_enum_register_static ("GpxFitFileFitTypes", values);
		g_once_init_leave (&gpx_fit_file_fit_types_type_id__volatile, gpx_fit_file_fit_types_type_id);
	}
	return gpx_fit_file_fit_types_type_id__volatile;
}


static void _vala_GpxFitFileFieldDefinition_array_free (GpxFitFileFieldDefinition* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			gpx_fit_file_field_definition_destroy (&array[i]);
		}
	}
	g_free (array);
}


/**
         * Get the field description belonging to the id.
         */
static GpxFitFileFieldDefinition* gpx_fit_file_get_field_def (GpxFitFile* self, guint id) {
	GpxFitFileFieldDefinition* result = NULL;
	guint _tmp0_;
	GpxFitFileFieldDefinition* _tmp1_;
	gint _tmp1__length1;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = id;
	if (_tmp0_ >= ((guint) MAX_LOCAL_DEFINITIONS)) {
		g_error ("fit-parser.vala:54: To many local definitions specified.");
	}
	_tmp1_ = self->priv->defs;
	_tmp1__length1 = self->priv->defs_length1;
	_tmp2_ = id;
	result = &_tmp1_[_tmp2_];
	return result;
}


/**
         * Depending on the definition, switch endianess
         */
static void gpx_fit_file_parse_apply_definition_endian (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def) {
	GpxFitFileFieldDefinition* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	_tmp0_ = def;
	_tmp1_ = (*_tmp0_).endian;
	if (_tmp1_) {
		GDataInputStream* _tmp2_;
		_tmp2_ = fs;
		g_data_input_stream_set_byte_order (_tmp2_, G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN);
	} else {
		GDataInputStream* _tmp3_;
		_tmp3_ = fs;
		g_data_input_stream_set_byte_order (_tmp3_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
	}
}


/**
         * Parse the file.
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


GpxFitFile* gpx_fit_file_construct (GType object_type, GFile* file, GError** error) {
	GpxFitFile * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GpxFitFile*) gpx_file_base_construct (object_type);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (((GpxFileBase*) self)->file);
	((GpxFileBase*) self)->file = _tmp1_;
	{
		GFile* _tmp2_;
		GFileInputStream* _tmp3_ = NULL;
		GFileInputStream* istr;
		GFileInputStream* _tmp4_;
		GDataInputStream* _tmp5_;
		GDataInputStream* fs;
		GDataInputStream* _tmp6_;
		GDataInputStream* _tmp8_;
		GDataStreamByteOrder _tmp9_ = 0;
		GDataInputStream* _tmp11_;
		GpxTrack* _tmp14_;
		_tmp2_ = file;
		_tmp3_ = g_file_read (_tmp2_, NULL, &_inner_error_);
		istr = _tmp3_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
		_tmp4_ = istr;
		_tmp5_ = g_data_input_stream_new ((GInputStream*) _tmp4_);
		fs = _tmp5_;
		_tmp6_ = fs;
		if (_tmp6_ == NULL) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, "Failed to create input stream.");
			_inner_error_ = _tmp7_;
			_g_object_unref0 (fs);
			_g_object_unref0 (istr);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
		_tmp8_ = fs;
		_tmp9_ = g_data_input_stream_get_byte_order (_tmp8_);
		if (_tmp9_ != G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN) {
			GDataInputStream* _tmp10_;
			_tmp10_ = fs;
			g_data_input_stream_set_byte_order (_tmp10_, G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN);
		}
		_tmp11_ = fs;
		gpx_fit_file_parse_header (self, _tmp11_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (fs);
			_g_object_unref0 (istr);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
		while (TRUE) {
			GDataInputStream* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp12_ = fs;
			_tmp13_ = gpx_fit_file_parse_record (self, _tmp12_);
			if (!_tmp13_) {
				break;
			}
		}
		_tmp14_ = self->priv->track;
		if (_tmp14_ != NULL) {
			GpxTrack* _tmp15_;
			GpxTrack* _tmp16_;
			GpxTrack* _tmp17_;
			_tmp15_ = self->priv->track;
			gpx_track_filter_points (_tmp15_);
			_tmp16_ = self->priv->track;
			_tmp17_ = _g_object_ref0 (_tmp16_);
			((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp17_);
		}
		_g_object_unref0 (fs);
		_g_object_unref0 (istr);
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		GError* _tmp20_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = err;
		_tmp19_ = _tmp18_->message;
		_tmp20_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, _tmp19_);
		_inner_error_ = _tmp20_;
		_g_error_free0 (err);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		GError* _tmp23_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = err;
		_tmp22_ = _tmp21_->message;
		_tmp23_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_IO_ERROR, _tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (err);
		goto __finally3;
	}
	goto __finally3;
	__catch3_gpx_file_error:
	{
		GError* err = NULL;
		GError* _tmp24_;
		GError* _tmp25_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = err;
		_tmp25_ = _g_error_copy0 (_tmp24_);
		_inner_error_ = _tmp25_;
		_g_error_free0 (err);
		goto __finally3;
	}
	__finally3:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GPX_FILE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


GpxFitFile* gpx_fit_file_new (GFile* file, GError** error) {
	return gpx_fit_file_construct (GPX_TYPE_FIT_FILE, file, error);
}


/**
         * Parse record
         */
static gboolean gpx_fit_file_parse_record (GpxFitFile* self, GDataInputStream* fs) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (fs != NULL, FALSE);
	{
		guint32 _tmp0_;
		GDataInputStream* _tmp1_;
		guint8 _tmp2_ = 0U;
		guint8 record_id;
		guint32 _tmp3_;
		guint8 _tmp4_;
		gboolean normal_header;
		gboolean definition_header = FALSE;
		guint8 local_message_type = 0U;
		gboolean _tmp5_;
		gboolean _tmp9_;
		_tmp0_ = self->priv->data_length;
		if (_tmp0_ == ((guint32) 0)) {
			result = FALSE;
			return result;
		}
		_tmp1_ = fs;
		_tmp2_ = g_data_input_stream_read_byte (_tmp1_, NULL, &_inner_error_);
		record_id = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		_tmp3_ = self->priv->data_length;
		self->priv->data_length = _tmp3_ - 1;
		_tmp4_ = record_id;
		normal_header = ((gint) (_tmp4_ & 0x80)) == 0;
		_tmp5_ = normal_header;
		if (_tmp5_) {
			guint8 _tmp6_;
			guint8 _tmp7_;
			_tmp6_ = record_id;
			definition_header = ((gint) (_tmp6_ & 0x40)) > 0;
			_tmp7_ = record_id;
			local_message_type = _tmp7_ & 0x0F;
		} else {
			guint8 _tmp8_;
			definition_header = FALSE;
			_tmp8_ = record_id;
			local_message_type = (guint8) ((_tmp8_ & 0x60) >> 5);
		}
		_tmp9_ = definition_header;
		if (_tmp9_) {
			GDataInputStream* _tmp10_;
			guint8 _tmp11_;
			_tmp10_ = fs;
			_tmp11_ = local_message_type;
			gpx_fit_file_parse_definition_record (self, _tmp10_, _tmp11_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		} else {
			GDataInputStream* _tmp12_;
			guint8 _tmp13_;
			_tmp12_ = fs;
			_tmp13_ = local_message_type;
			gpx_fit_file_parse_data_record (self, _tmp12_, _tmp13_, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch4_g_error;
			}
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static void gpx_fit_file_parse_definition_record (GpxFitFile* self, GDataInputStream* fs, guint8 local_message_type, GError** error) {
	guint8 _tmp0_;
	GpxFitFileFieldDefinition* _tmp1_ = NULL;
	GpxFitFileFieldDefinition* def;
	GDataInputStream* _tmp2_;
	guint32 _tmp3_;
	GDataInputStream* _tmp4_;
	guint8 _tmp5_ = 0U;
	guint8 endian;
	guint32 _tmp6_;
	guint8 _tmp7_;
	GDataInputStream* _tmp10_;
	GpxFitFileFieldDefinition* _tmp11_;
	GDataInputStream* _tmp12_;
	guint16 _tmp13_ = 0U;
	guint16 _tmp14_;
	GpxFitFileFieldDefinition* _tmp15_;
	guint32 _tmp16_;
	GDataInputStream* _tmp17_;
	guint8 _tmp18_ = 0U;
	guint8 num_fields;
	guint32 _tmp19_;
	GpxFitFileFieldDefinition* _tmp20_;
	guint8 _tmp21_;
	GpxFitFileFieldDefinitionHeader* _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	_tmp0_ = local_message_type;
	_tmp1_ = gpx_fit_file_get_field_def (self, (guint) _tmp0_);
	def = _tmp1_;
	_tmp2_ = fs;
	g_input_stream_skip ((GInputStream*) _tmp2_, (gsize) 1, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = self->priv->data_length;
	self->priv->data_length = _tmp3_ - 1;
	_tmp4_ = fs;
	_tmp5_ = g_data_input_stream_read_byte (_tmp4_, NULL, &_inner_error_);
	endian = _tmp5_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp6_ = self->priv->data_length;
	self->priv->data_length = _tmp6_ - 1;
	_tmp7_ = endian;
	if (((gint) _tmp7_) == 1) {
		GpxFitFileFieldDefinition* _tmp8_;
		_tmp8_ = def;
		(*_tmp8_).endian = TRUE;
	} else {
		GpxFitFileFieldDefinition* _tmp9_;
		_tmp9_ = def;
		(*_tmp9_).endian = FALSE;
	}
	_tmp10_ = fs;
	_tmp11_ = def;
	gpx_fit_file_parse_apply_definition_endian (self, _tmp10_, _tmp11_);
	_tmp12_ = fs;
	_tmp13_ = g_data_input_stream_read_uint16 (_tmp12_, NULL, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp15_ = def;
	(*_tmp15_).type = _tmp14_;
	_tmp16_ = self->priv->data_length;
	self->priv->data_length = _tmp16_ - 2;
	_tmp17_ = fs;
	_tmp18_ = g_data_input_stream_read_byte (_tmp17_, NULL, &_inner_error_);
	num_fields = _tmp18_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp19_ = self->priv->data_length;
	self->priv->data_length = _tmp19_ - 1;
	_tmp20_ = def;
	_tmp21_ = num_fields;
	_tmp22_ = g_new0 (GpxFitFileFieldDefinitionHeader, _tmp21_);
	(*_tmp20_).fields = (g_free ((*_tmp20_).fields), NULL);
	(*_tmp20_).fields = _tmp22_;
	(*_tmp20_).fields_length1 = _tmp21_;
	(*_tmp20_)._fields_size_ = (*_tmp20_).fields_length1;
	{
		guint8 field;
		field = (guint8) 0;
		{
			gboolean _tmp23_;
			_tmp23_ = TRUE;
			while (TRUE) {
				gboolean _tmp24_;
				guint8 _tmp26_;
				guint8 _tmp27_;
				GpxFitFileFieldDefinitionHeader* header = NULL;
				guint8* _tmp28_ = NULL;
				guint8* temp;
				gint temp_length1;
				gint _temp_size_;
				GDataInputStream* _tmp29_;
				guint8* _tmp30_;
				gint _tmp30__length1;
				guint8* _tmp31_;
				gint _tmp31__length1;
				GpxFitFileFieldDefinition* _tmp32_;
				GpxFitFileFieldDefinitionHeader* _tmp33_;
				gint _tmp33__length1;
				guint8 _tmp34_;
				GpxFitFileFieldDefinitionHeader* _tmp35_;
				GpxFitFileFieldDefinitionHeader _tmp36_;
				guint32 _tmp37_;
				_tmp24_ = _tmp23_;
				if (!_tmp24_) {
					guint8 _tmp25_;
					_tmp25_ = field;
					field = _tmp25_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp26_ = field;
				_tmp27_ = num_fields;
				if (!(_tmp26_ < _tmp27_)) {
					break;
				}
				_tmp28_ = g_new0 (guint8, sizeof (GpxFitFileFieldDefinitionHeader));
				temp = _tmp28_;
				temp_length1 = sizeof (GpxFitFileFieldDefinitionHeader);
				_temp_size_ = temp_length1;
				_tmp29_ = fs;
				_tmp30_ = temp;
				_tmp30__length1 = temp_length1;
				g_input_stream_read ((GInputStream*) _tmp29_, _tmp30_, (gsize) _tmp30__length1, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
						g_propagate_error (error, _inner_error_);
						temp = (g_free (temp), NULL);
						return;
					} else {
						temp = (g_free (temp), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_tmp31_ = temp;
				_tmp31__length1 = temp_length1;
				header = (GpxFitFileFieldDefinitionHeader*) (&_tmp31_[0]);
				_tmp32_ = def;
				_tmp33_ = (*_tmp32_).fields;
				_tmp33__length1 = (*_tmp32_).fields_length1;
				_tmp34_ = field;
				_tmp35_ = header;
				_tmp33_[_tmp34_] = *_tmp35_;
				_tmp36_ = _tmp33_[_tmp34_];
				_tmp37_ = self->priv->data_length;
				self->priv->data_length = _tmp37_ - ((guint32) sizeof (GpxFitFileFieldDefinitionHeader));
				temp = (g_free (temp), NULL);
			}
		}
	}
}


static guint32 gpx_fit_file_parse_field (GpxFitFile* self, GpxFitFileFieldDefinitionHeader* field, GDataInputStream* fp, GError** error) {
	guint32 result = 0U;
	guint32 retv;
	GpxFitFileFieldDefinitionHeader _tmp0_;
	guint8 _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (field != NULL, 0U);
	g_return_val_if_fail (fp != NULL, 0U);
	retv = (guint32) 0;
	_tmp0_ = *field;
	_tmp1_ = _tmp0_.base_type;
	switch (_tmp1_) {
		case 1:
		case 2:
		{
			GDataInputStream* _tmp2_;
			guint8 _tmp3_ = 0U;
			guint8 _tmp4_;
			guint32 _tmp5_;
			_tmp2_ = fp;
			_tmp3_ = g_data_input_stream_read_byte (_tmp2_, NULL, &_inner_error_);
			_tmp4_ = _tmp3_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return 0U;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			retv = (guint32) _tmp4_;
			_tmp5_ = self->priv->data_length;
			self->priv->data_length = _tmp5_ - 1;
			break;
		}
		case 0x83:
		case 0x84:
		{
			GDataInputStream* _tmp6_;
			guint16 _tmp7_ = 0U;
			guint16 _tmp8_;
			guint32 _tmp9_;
			_tmp6_ = fp;
			_tmp7_ = g_data_input_stream_read_uint16 (_tmp6_, NULL, &_inner_error_);
			_tmp8_ = _tmp7_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return 0U;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			retv = (guint32) _tmp8_;
			_tmp9_ = self->priv->data_length;
			self->priv->data_length = _tmp9_ - 2;
			break;
		}
		case 0x85:
		case 0x86:
		{
			GDataInputStream* _tmp10_;
			guint32 _tmp11_ = 0U;
			guint32 _tmp12_;
			guint32 _tmp13_;
			_tmp10_ = fp;
			_tmp11_ = g_data_input_stream_read_uint32 (_tmp10_, NULL, &_inner_error_);
			_tmp12_ = _tmp11_;
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return 0U;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			retv = _tmp12_;
			_tmp13_ = self->priv->data_length;
			self->priv->data_length = _tmp13_ - 4;
			break;
		}
		default:
		{
			GDataInputStream* _tmp14_;
			GpxFitFileFieldDefinitionHeader _tmp15_;
			guint8 _tmp16_;
			guint32 _tmp17_;
			GpxFitFileFieldDefinitionHeader _tmp18_;
			guint8 _tmp19_;
			_tmp14_ = fp;
			_tmp15_ = *field;
			_tmp16_ = _tmp15_.size;
			g_input_stream_skip ((GInputStream*) _tmp14_, (gsize) _tmp16_, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return 0U;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0U;
				}
			}
			_tmp17_ = self->priv->data_length;
			_tmp18_ = *field;
			_tmp19_ = _tmp18_.size;
			self->priv->data_length = _tmp17_ - _tmp19_;
			break;
		}
	}
	result = retv;
	return result;
}


static void gpx_fit_file_parse_data_record_lap (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def, GError** error) {
	GpxFitFileFieldDefinition* _tmp0_;
	GpxFitFileFieldDefinitionHeader* _tmp1_;
	gint _tmp1__length1;
	GpxTrack* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	_tmp0_ = def;
	_tmp1_ = (*_tmp0_).fields;
	_tmp1__length1 = (*_tmp0_).fields_length1;
	{
		GpxFitFileFieldDefinitionHeader* field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp1_;
		field_collection_length1 = _tmp1__length1;
		for (field_it = 0; field_it < _tmp1__length1; field_it = field_it + 1) {
			GpxFitFileFieldDefinitionHeader field = {0};
			field = field_collection[field_it];
			{
				GpxFitFileFieldDefinitionHeader _tmp2_;
				guint8 _tmp3_;
				_tmp2_ = field;
				_tmp3_ = _tmp2_.def_num;
				switch (_tmp3_) {
					case 11:
					{
						GpxFitFileFieldDefinitionHeader _tmp4_;
						GDataInputStream* _tmp5_;
						guint32 _tmp6_ = 0U;
						guint32 val;
						GpxTrack* _tmp7_;
						guint32 _tmp8_;
						_tmp4_ = field;
						_tmp5_ = fs;
						_tmp6_ = gpx_fit_file_parse_field (self, &_tmp4_, _tmp5_, &_inner_error_);
						val = _tmp6_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp7_ = self->priv->track;
						_tmp8_ = val;
						_tmp7_->hrmt.calories = _tmp8_;
						break;
					}
					case 15:
					{
						GpxFitFileFieldDefinitionHeader _tmp9_;
						GDataInputStream* _tmp10_;
						guint32 _tmp11_ = 0U;
						guint32 val;
						_tmp9_ = field;
						_tmp10_ = fs;
						_tmp11_ = gpx_fit_file_parse_field (self, &_tmp9_, _tmp10_, &_inner_error_);
						val = _tmp11_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
					case 16:
					{
						GpxFitFileFieldDefinitionHeader _tmp12_;
						GDataInputStream* _tmp13_;
						guint32 _tmp14_ = 0U;
						guint32 val;
						_tmp12_ = field;
						_tmp13_ = fs;
						_tmp14_ = gpx_fit_file_parse_field (self, &_tmp12_, _tmp13_, &_inner_error_);
						val = _tmp14_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						break;
					}
					default:
					{
						GpxFitFileFieldDefinitionHeader _tmp15_;
						GDataInputStream* _tmp16_;
						guint32 _tmp17_ = 0U;
						guint32 val;
						FILE* _tmp18_;
						GpxFitFileFieldDefinitionHeader _tmp19_;
						guint8 _tmp20_;
						guint32 _tmp21_;
						_tmp15_ = field;
						_tmp16_ = fs;
						_tmp17_ = gpx_fit_file_parse_field (self, &_tmp15_, _tmp16_, &_inner_error_);
						val = _tmp17_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp18_ = stdout;
						_tmp19_ = field;
						_tmp20_ = _tmp19_.def_num;
						_tmp21_ = val;
						fprintf (_tmp18_, "%d %u\n", (gint) _tmp20_, (guint) _tmp21_);
						break;
					}
				}
			}
		}
	}
	_tmp22_ = self->priv->track;
	if (_tmp22_ != NULL) {
		GpxTrack* _tmp23_;
		GpxTrack* _tmp24_;
		GpxTrack* _tmp25_;
		_tmp23_ = self->priv->track;
		gpx_track_filter_points (_tmp23_);
		_tmp24_ = self->priv->track;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		((GpxFileBase*) self)->tracks = g_list_append (((GpxFileBase*) self)->tracks, _tmp25_);
		_g_object_unref0 (self->priv->track);
		self->priv->track = NULL;
	}
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	g_return_val_if_fail (format != NULL, NULL);
	_tmp0_ = g_new0 (gchar, 64);
	buffer = _tmp0_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	_tmp1_ = buffer;
	_tmp1__length1 = buffer_length1;
	_tmp2_ = format;
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
	_tmp3_ = buffer;
	_tmp3__length1 = buffer_length1;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static gpointer _gpx_point_ref0 (gpointer self) {
	return self ? gpx_point_ref (self) : NULL;
}


static void gpx_fit_file_parse_data_record_activity_summary (GpxFitFile* self, GDataInputStream* fs, GpxFitFileFieldDefinition* def, GError** error) {
	GpxTrack* _tmp0_;
	GpxPoint* _tmp2_;
	GpxPoint* p;
	GpxFitFileFieldDefinition* _tmp3_;
	GpxFitFileFieldDefinitionHeader* _tmp4_;
	gint _tmp4__length1;
	GpxTrack* _tmp51_;
	GpxPoint* _tmp52_ = NULL;
	GpxPoint* _tmp53_;
	GpxPoint* lastp;
	gboolean _tmp54_ = FALSE;
	GpxPoint* _tmp55_;
	gboolean _tmp60_;
	GpxPoint* _tmp61_;
	gboolean _tmp62_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	_tmp0_ = self->priv->track;
	if (_tmp0_ == NULL) {
		GpxTrack* _tmp1_;
		_tmp1_ = gpx_track_new ();
		_g_object_unref0 (self->priv->track);
		self->priv->track = _tmp1_;
	}
	_tmp2_ = gpx_point_new ();
	p = _tmp2_;
	_tmp3_ = def;
	_tmp4_ = (*_tmp3_).fields;
	_tmp4__length1 = (*_tmp3_).fields_length1;
	{
		GpxFitFileFieldDefinitionHeader* field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = _tmp4_;
		field_collection_length1 = _tmp4__length1;
		for (field_it = 0; field_it < _tmp4__length1; field_it = field_it + 1) {
			GpxFitFileFieldDefinitionHeader field = {0};
			field = field_collection[field_it];
			{
				GpxFitFileFieldDefinitionHeader _tmp5_;
				guint8 _tmp6_;
				_tmp5_ = field;
				_tmp6_ = _tmp5_.def_num;
				switch (_tmp6_) {
					case 253:
					{
						GpxFitFileFieldDefinitionHeader _tmp7_;
						GDataInputStream* _tmp8_;
						guint32 _tmp9_ = 0U;
						guint32 timestp;
						guint32 _tmp10_;
						guint32 _tmp11_;
						struct tm _tmp12_ = {0};
						struct tm t;
						gchar* _tmp13_ = NULL;
						gchar* str;
						GpxPoint* _tmp14_;
						const gchar* _tmp15_;
						gchar* _tmp16_;
						_tmp7_ = field;
						_tmp8_ = fs;
						_tmp9_ = gpx_fit_file_parse_field (self, &_tmp7_, _tmp8_, &_inner_error_);
						timestp = _tmp9_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp10_ = timestp;
						timestp = _tmp10_ + 631065600;
						_tmp11_ = timestp;
						g_time_local ((time_t) _tmp11_, &_tmp12_);
						t = _tmp12_;
						_tmp13_ = g_time_format (&t, "%FT%T%z");
						str = _tmp13_;
						_tmp14_ = p;
						_tmp15_ = str;
						_tmp16_ = g_strdup (_tmp15_);
						_g_free0 (_tmp14_->time);
						_tmp14_->time = _tmp16_;
						_g_free0 (str);
						break;
					}
					case 0:
					{
						GpxFitFileFieldDefinitionHeader _tmp17_;
						GDataInputStream* _tmp18_;
						guint32 _tmp19_ = 0U;
						guint32 val;
						guint32 _tmp20_;
						_tmp17_ = field;
						_tmp18_ = fs;
						_tmp19_ = gpx_fit_file_parse_field (self, &_tmp17_, _tmp18_, &_inner_error_);
						val = _tmp19_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp20_ = val;
						if (_tmp20_ != ((guint32) 0x7FFFFFFF)) {
							guint32 _tmp21_;
							gdouble _tmp22_ = 0.0;
							gdouble lat_dec;
							GpxPoint* _tmp23_;
							gdouble _tmp24_;
							_tmp21_ = val;
							_tmp22_ = pow (2.0, 31.0);
							lat_dec = ((gdouble) _tmp21_) * (180.0 / _tmp22_);
							_tmp23_ = p;
							_tmp24_ = lat_dec;
							gpx_point_set_position_lat (_tmp23_, _tmp24_);
						}
						break;
					}
					case 1:
					{
						GpxFitFileFieldDefinitionHeader _tmp25_;
						GDataInputStream* _tmp26_;
						guint32 _tmp27_ = 0U;
						guint32 val;
						guint32 _tmp28_;
						_tmp25_ = field;
						_tmp26_ = fs;
						_tmp27_ = gpx_fit_file_parse_field (self, &_tmp25_, _tmp26_, &_inner_error_);
						val = _tmp27_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp28_ = val;
						if (_tmp28_ != ((guint32) 0x7FFFFFFF)) {
							guint32 _tmp29_;
							gdouble _tmp30_ = 0.0;
							gdouble lon_dec;
							GpxPoint* _tmp31_;
							gdouble _tmp32_;
							_tmp29_ = val;
							_tmp30_ = pow (2.0, 31.0);
							lon_dec = ((gdouble) _tmp29_) * (180.0 / _tmp30_);
							_tmp31_ = p;
							_tmp32_ = lon_dec;
							gpx_point_set_position_lon (_tmp31_, _tmp32_);
						}
						break;
					}
					case 2:
					{
						GpxFitFileFieldDefinitionHeader _tmp33_;
						GDataInputStream* _tmp34_;
						guint32 _tmp35_ = 0U;
						guint32 val;
						guint32 _tmp36_;
						_tmp33_ = field;
						_tmp34_ = fs;
						_tmp35_ = gpx_fit_file_parse_field (self, &_tmp33_, _tmp34_, &_inner_error_);
						val = _tmp35_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp36_ = val;
						if (_tmp36_ != ((guint32) 0xFFFF)) {
							GpxPoint* _tmp37_;
							guint32 _tmp38_;
							_tmp37_ = p;
							_tmp38_ = val;
							_tmp37_->elevation = (_tmp38_ / 5.0) - 500;
						}
						break;
					}
					case 3:
					{
						GpxFitFileFieldDefinitionHeader _tmp39_;
						GDataInputStream* _tmp40_;
						guint32 _tmp41_ = 0U;
						guint32 val;
						guint32 _tmp42_;
						_tmp39_ = field;
						_tmp40_ = fs;
						_tmp41_ = gpx_fit_file_parse_field (self, &_tmp39_, _tmp40_, &_inner_error_);
						val = _tmp41_;
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp42_ = val;
						if (_tmp42_ != ((guint32) 0xFF)) {
							GpxPoint* _tmp43_;
							guint32 _tmp44_;
							_tmp43_ = p;
							_tmp44_ = val;
							_tmp43_->tpe.heartrate = (gint) _tmp44_;
						}
						break;
					}
					default:
					{
						GDataInputStream* _tmp45_;
						GpxFitFileFieldDefinitionHeader _tmp46_;
						guint8 _tmp47_;
						guint32 _tmp48_;
						GpxFitFileFieldDefinitionHeader _tmp49_;
						guint8 _tmp50_;
						_tmp45_ = fs;
						_tmp46_ = field;
						_tmp47_ = _tmp46_.size;
						g_input_stream_skip ((GInputStream*) _tmp45_, (gsize) _tmp47_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								_gpx_point_unref0 (p);
								return;
							} else {
								_gpx_point_unref0 (p);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp48_ = self->priv->data_length;
						_tmp49_ = field;
						_tmp50_ = _tmp49_.size;
						self->priv->data_length = _tmp48_ - _tmp50_;
						break;
					}
				}
			}
		}
	}
	_tmp51_ = self->priv->track;
	_tmp52_ = gpx_track_get_last (_tmp51_);
	_tmp53_ = _gpx_point_ref0 (_tmp52_);
	lastp = _tmp53_;
	_tmp55_ = lastp;
	if (_tmp55_ != NULL) {
		GpxPoint* _tmp56_;
		time_t _tmp57_ = 0;
		GpxPoint* _tmp58_;
		time_t _tmp59_ = 0;
		_tmp56_ = lastp;
		_tmp57_ = gpx_point_get_time (_tmp56_);
		_tmp58_ = p;
		_tmp59_ = gpx_point_get_time (_tmp58_);
		_tmp54_ = _tmp57_ == _tmp59_;
	} else {
		_tmp54_ = FALSE;
	}
	_tmp60_ = _tmp54_;
	if (_tmp60_) {
		_gpx_point_unref0 (lastp);
		_gpx_point_unref0 (p);
		return;
	}
	_tmp61_ = p;
	_tmp62_ = gpx_point_has_position (_tmp61_);
	if (_tmp62_) {
		gboolean _tmp63_ = FALSE;
		GpxPoint* _tmp64_;
		gboolean _tmp67_;
		GpxTrack* _tmp94_;
		GpxPoint* _tmp95_;
		_tmp64_ = lastp;
		if (_tmp64_ != NULL) {
			GpxPoint* _tmp65_;
			gboolean _tmp66_ = FALSE;
			_tmp65_ = lastp;
			_tmp66_ = gpx_point_has_position (_tmp65_);
			_tmp63_ = !_tmp66_;
		} else {
			_tmp63_ = FALSE;
		}
		_tmp67_ = _tmp63_;
		if (_tmp67_) {
			GpxTrack* _tmp68_;
			GList* _tmp69_;
			GList* _tmp70_ = NULL;
			GList* ll;
			_tmp68_ = self->priv->track;
			_tmp69_ = _tmp68_->points;
			_tmp70_ = g_list_last (_tmp69_);
			ll = _tmp70_;
			while (TRUE) {
				gboolean _tmp71_ = FALSE;
				GList* _tmp72_;
				gboolean _tmp76_;
				GList* _tmp77_;
				gconstpointer _tmp78_;
				GpxPoint* _tmp79_;
				GpxPoint* last;
				GpxPoint* _tmp80_;
				GpxPoint* _tmp81_;
				gdouble _tmp82_;
				GpxPoint* _tmp83_;
				GpxPoint* _tmp84_;
				gdouble _tmp85_;
				GpxPoint* _tmp86_;
				GpxPoint* _tmp87_;
				gdouble _tmp88_;
				GpxPoint* _tmp89_;
				GpxPoint* _tmp90_;
				gdouble _tmp91_;
				GList* _tmp92_;
				GList* _tmp93_;
				_tmp72_ = ll;
				if (_tmp72_ != NULL) {
					GList* _tmp73_;
					gconstpointer _tmp74_;
					gboolean _tmp75_ = FALSE;
					_tmp73_ = ll;
					_tmp74_ = _tmp73_->data;
					_tmp75_ = gpx_point_has_position ((GpxPoint*) _tmp74_);
					_tmp71_ = !_tmp75_;
				} else {
					_tmp71_ = FALSE;
				}
				_tmp76_ = _tmp71_;
				if (!_tmp76_) {
					break;
				}
				_tmp77_ = ll;
				_tmp78_ = _tmp77_->data;
				_tmp79_ = _gpx_point_ref0 ((GpxPoint*) _tmp78_);
				last = _tmp79_;
				_tmp80_ = last;
				_tmp81_ = p;
				_tmp82_ = _tmp81_->lat_dec;
				_tmp80_->lat_dec = _tmp82_;
				_tmp83_ = last;
				_tmp84_ = p;
				_tmp85_ = _tmp84_->lon_dec;
				_tmp83_->lon_dec = _tmp85_;
				_tmp86_ = last;
				_tmp87_ = p;
				_tmp88_ = _tmp87_->lat;
				_tmp86_->lat = _tmp88_;
				_tmp89_ = last;
				_tmp90_ = p;
				_tmp91_ = _tmp90_->lon;
				_tmp89_->lon = _tmp91_;
				_tmp92_ = ll;
				_tmp93_ = _tmp92_->prev;
				ll = _tmp93_;
				_gpx_point_unref0 (last);
			}
		}
		_tmp94_ = self->priv->track;
		_tmp95_ = p;
		gpx_track_add_point (_tmp94_, _tmp95_);
	} else {
		GpxPoint* _tmp96_;
		_tmp96_ = lastp;
		if (_tmp96_ != NULL) {
			GpxPoint* _tmp97_;
			GpxPoint* _tmp98_;
			gdouble _tmp99_;
			GpxPoint* _tmp100_;
			GpxPoint* _tmp101_;
			gdouble _tmp102_;
			GpxPoint* _tmp103_;
			GpxPoint* _tmp104_;
			gdouble _tmp105_;
			GpxPoint* _tmp106_;
			GpxPoint* _tmp107_;
			gdouble _tmp108_;
			GpxTrack* _tmp109_;
			GpxPoint* _tmp110_;
			_tmp97_ = p;
			_tmp98_ = lastp;
			_tmp99_ = _tmp98_->lat_dec;
			_tmp97_->lat_dec = _tmp99_;
			_tmp100_ = p;
			_tmp101_ = lastp;
			_tmp102_ = _tmp101_->lon_dec;
			_tmp100_->lon_dec = _tmp102_;
			_tmp103_ = p;
			_tmp104_ = lastp;
			_tmp105_ = _tmp104_->lat;
			_tmp103_->lat = _tmp105_;
			_tmp106_ = p;
			_tmp107_ = lastp;
			_tmp108_ = _tmp107_->lon;
			_tmp106_->lon = _tmp108_;
			_tmp109_ = self->priv->track;
			_tmp110_ = p;
			gpx_track_add_point (_tmp109_, _tmp110_);
		} else {
			GpxTrack* _tmp111_;
			GpxPoint* _tmp112_;
			_tmp111_ = self->priv->track;
			_tmp112_ = p;
			gpx_track_add_point (_tmp111_, _tmp112_);
		}
	}
	_gpx_point_unref0 (lastp);
	_gpx_point_unref0 (p);
}


static void gpx_fit_file_parse_data_record (GpxFitFile* self, GDataInputStream* fs, guint8 local_message_type, GError** error) {
	guint8 _tmp0_;
	GpxFitFileFieldDefinition* _tmp1_ = NULL;
	GpxFitFileFieldDefinition* def;
	GDataInputStream* _tmp2_;
	GpxFitFileFieldDefinition* _tmp3_;
	GpxFitFileFieldDefinition* _tmp4_;
	guint16 _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	_tmp0_ = local_message_type;
	_tmp1_ = gpx_fit_file_get_field_def (self, (guint) _tmp0_);
	def = _tmp1_;
	_tmp2_ = fs;
	_tmp3_ = def;
	gpx_fit_file_parse_apply_definition_endian (self, _tmp2_, _tmp3_);
	_tmp4_ = def;
	_tmp5_ = (*_tmp4_).type;
	switch (_tmp5_) {
		case GPX_FIT_FILE_FIT_TYPES_ACTIVITY_SUMMARY:
		{
			GDataInputStream* _tmp6_;
			GpxFitFileFieldDefinition* _tmp7_;
			_tmp6_ = fs;
			_tmp7_ = def;
			gpx_fit_file_parse_data_record_activity_summary (self, _tmp6_, _tmp7_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		case GPX_FIT_FILE_FIT_TYPES_LAP:
		{
			GDataInputStream* _tmp8_;
			GpxFitFileFieldDefinition* _tmp9_;
			_tmp8_ = fs;
			_tmp9_ = def;
			gpx_fit_file_parse_data_record_lap (self, _tmp8_, _tmp9_, &_inner_error_);
			if (_inner_error_ != NULL) {
				if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		default:
		{
			FILE* _tmp10_;
			GpxFitFileFieldDefinition* _tmp11_;
			guint16 _tmp12_;
			GpxFitFileFieldDefinition* _tmp13_;
			GpxFitFileFieldDefinitionHeader* _tmp14_;
			gint _tmp14__length1;
			_tmp10_ = stdout;
			_tmp11_ = def;
			_tmp12_ = (*_tmp11_).type;
			fprintf (_tmp10_, "Unknown record: %d\n", (gint) _tmp12_);
			_tmp13_ = def;
			_tmp14_ = (*_tmp13_).fields;
			_tmp14__length1 = (*_tmp13_).fields_length1;
			{
				GpxFitFileFieldDefinitionHeader* field_collection = NULL;
				gint field_collection_length1 = 0;
				gint _field_collection_size_ = 0;
				gint field_it = 0;
				field_collection = _tmp14_;
				field_collection_length1 = _tmp14__length1;
				for (field_it = 0; field_it < _tmp14__length1; field_it = field_it + 1) {
					GpxFitFileFieldDefinitionHeader field = {0};
					field = field_collection[field_it];
					{
						GDataInputStream* _tmp15_;
						GpxFitFileFieldDefinitionHeader _tmp16_;
						guint8 _tmp17_;
						guint32 _tmp18_;
						GpxFitFileFieldDefinitionHeader _tmp19_;
						guint8 _tmp20_;
						_tmp15_ = fs;
						_tmp16_ = field;
						_tmp17_ = _tmp16_.size;
						g_input_stream_skip ((GInputStream*) _tmp15_, (gsize) _tmp17_, NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
						_tmp18_ = self->priv->data_length;
						_tmp19_ = field;
						_tmp20_ = _tmp19_.size;
						self->priv->data_length = _tmp18_ - _tmp20_;
					}
				}
			}
			break;
		}
	}
}


/**
         * Parse the header.
         */
static void gpx_fit_file_parse_header (GpxFitFile* self, GDataInputStream* fs, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (fs != NULL);
	{
		GDataInputStream* _tmp0_;
		guint8 _tmp1_ = 0U;
		guint8 _tmp2_;
		guchar header_size;
		guchar _tmp3_;
		gboolean _tmp5_ = FALSE;
		guchar _tmp6_;
		gboolean _tmp8_;
		GDataInputStream* _tmp10_;
		guint8 _tmp11_ = 0U;
		guint8 _tmp12_;
		guchar version;
		guchar _tmp13_;
		guchar low;
		guchar _tmp14_;
		guchar high;
		GDataInputStream* _tmp15_;
		guint16 _tmp16_ = 0U;
		guint16 _tmp17_;
		guint16 profver;
		GDataInputStream* _tmp18_;
		guint32 _tmp19_ = 0U;
		guint32 _tmp20_;
		guint8* _tmp21_ = NULL;
		guint8* signature;
		gint signature_length1;
		gint _signature_size_;
		GDataInputStream* _tmp22_;
		guint8* _tmp23_;
		gint _tmp23__length1;
		gssize _tmp24_ = 0L;
		gssize size;
		gssize _tmp25_;
		guchar _tmp41_;
		_tmp0_ = fs;
		_tmp1_ = g_data_input_stream_read_byte (_tmp0_, NULL, &_inner_error_);
		_tmp2_ = _tmp1_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		header_size = (guchar) _tmp2_;
		_tmp3_ = header_size;
		if (((gint) _tmp3_) == EOF) {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "Empty header");
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp6_ = header_size;
		if (((gint) _tmp6_) == 12) {
			_tmp5_ = TRUE;
		} else {
			guchar _tmp7_;
			_tmp7_ = header_size;
			_tmp5_ = ((gint) _tmp7_) == 14;
		}
		_tmp8_ = _tmp5_;
		if (!_tmp8_) {
			GError* _tmp9_;
			_tmp9_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "Unsupported FIT Header size");
			_inner_error_ = _tmp9_;
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = fs;
		_tmp11_ = g_data_input_stream_read_byte (_tmp10_, NULL, &_inner_error_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		version = (guchar) _tmp12_;
		_tmp13_ = version;
		low = _tmp13_ & 0x0f;
		_tmp14_ = version;
		high = (guchar) ((_tmp14_ & 0xf0) >> 4);
		_tmp15_ = fs;
		_tmp16_ = g_data_input_stream_read_uint16 (_tmp15_, NULL, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		profver = (guint16) _tmp17_;
		_tmp18_ = fs;
		_tmp19_ = g_data_input_stream_read_uint32 (_tmp18_, NULL, &_inner_error_);
		_tmp20_ = _tmp19_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->data_length = (guint32) _tmp20_;
		_tmp21_ = g_new0 (guint8, 4);
		_tmp21_[0] = (guint8) 0;
		_tmp21_[1] = (guint8) 0;
		_tmp21_[2] = (guint8) 0;
		_tmp21_[3] = (guint8) 0;
		signature = _tmp21_;
		signature_length1 = 4;
		_signature_size_ = signature_length1;
		_tmp22_ = fs;
		_tmp23_ = signature;
		_tmp23__length1 = signature_length1;
		_tmp24_ = g_input_stream_read ((GInputStream*) _tmp22_, _tmp23_, (gsize) _tmp23__length1, NULL, &_inner_error_);
		size = _tmp24_;
		if (_inner_error_ != NULL) {
			signature = (g_free (signature), NULL);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch5_g_io_error;
			}
			if (_inner_error_->domain == GPX_FILE_ERROR) {
				goto __catch5_gpx_file_error;
			}
			signature = (g_free (signature), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp25_ = size;
		if (_tmp25_ == ((gssize) 4)) {
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
			gboolean _tmp28_ = FALSE;
			guint8* _tmp29_;
			gint _tmp29__length1;
			guint8 _tmp30_;
			gboolean _tmp33_;
			gboolean _tmp36_;
			gboolean _tmp39_;
			_tmp29_ = signature;
			_tmp29__length1 = signature_length1;
			_tmp30_ = _tmp29_[0];
			if (_tmp30_ == ((guint8) '.')) {
				guint8* _tmp31_;
				gint _tmp31__length1;
				guint8 _tmp32_;
				_tmp31_ = signature;
				_tmp31__length1 = signature_length1;
				_tmp32_ = _tmp31_[1];
				_tmp28_ = _tmp32_ == ((guint8) 'F');
			} else {
				_tmp28_ = FALSE;
			}
			_tmp33_ = _tmp28_;
			if (_tmp33_) {
				guint8* _tmp34_;
				gint _tmp34__length1;
				guint8 _tmp35_;
				_tmp34_ = signature;
				_tmp34__length1 = signature_length1;
				_tmp35_ = _tmp34_[2];
				_tmp27_ = _tmp35_ == ((guint8) 'I');
			} else {
				_tmp27_ = FALSE;
			}
			_tmp36_ = _tmp27_;
			if (_tmp36_) {
				guint8* _tmp37_;
				gint _tmp37__length1;
				guint8 _tmp38_;
				_tmp37_ = signature;
				_tmp37__length1 = signature_length1;
				_tmp38_ = _tmp37_[3];
				_tmp26_ = _tmp38_ == ((guint8) 'T');
			} else {
				_tmp26_ = FALSE;
			}
			_tmp39_ = _tmp26_;
			if (!_tmp39_) {
				GError* _tmp40_;
				_tmp40_ = g_error_new_literal (GPX_FILE_ERROR, GPX_FILE_ERROR_INVALID_FILE, "No valid FIT signature found.");
				_inner_error_ = _tmp40_;
				signature = (g_free (signature), NULL);
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch5_g_io_error;
				}
				if (_inner_error_->domain == GPX_FILE_ERROR) {
					goto __catch5_gpx_file_error;
				}
				signature = (g_free (signature), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp41_ = header_size;
		if (((gint) _tmp41_) == 14) {
			GDataInputStream* _tmp42_;
			guint16 _tmp43_ = 0U;
			guint16 crc;
			_tmp42_ = fs;
			_tmp43_ = g_data_input_stream_read_uint16 (_tmp42_, NULL, &_inner_error_);
			crc = _tmp43_;
			if (_inner_error_ != NULL) {
				signature = (g_free (signature), NULL);
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch5_g_io_error;
				}
				if (_inner_error_->domain == GPX_FILE_ERROR) {
					goto __catch5_gpx_file_error;
				}
				signature = (g_free (signature), NULL);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		signature = (g_free (signature), NULL);
	}
	goto __finally5;
	__catch5_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp44_;
		GError* _tmp45_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = err;
		_tmp45_ = _g_error_copy0 (_tmp44_);
		_inner_error_ = _tmp45_;
		_g_error_free0 (err);
		goto __finally5;
	}
	goto __finally5;
	__catch5_gpx_file_error:
	{
		GError* err = NULL;
		GError* _tmp46_;
		GError* _tmp47_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = err;
		_tmp47_ = _g_error_copy0 (_tmp46_);
		_inner_error_ = _tmp47_;
		_g_error_free0 (err);
		goto __finally5;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == GPX_FILE_ERROR) || (_inner_error_->domain == G_IO_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static GpxFitFileFieldDefinitionHeader* _vala_array_dup1 (GpxFitFileFieldDefinitionHeader* self, int length) {
	return g_memdup (self, length * sizeof (GpxFitFileFieldDefinitionHeader));
}


static void gpx_fit_file_field_definition_copy (const GpxFitFileFieldDefinition* self, GpxFitFileFieldDefinition* dest) {
	gboolean _tmp0_;
	guint16 _tmp1_;
	GpxFitFileFieldDefinitionHeader* _tmp2_;
	gint _tmp2__length1;
	GpxFitFileFieldDefinitionHeader* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).endian;
	(*dest).endian = _tmp0_;
	_tmp1_ = (*self).type;
	(*dest).type = _tmp1_;
	_tmp2_ = (*self).fields;
	_tmp2__length1 = (*self).fields_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
	_tmp3__length1 = _tmp2__length1;
	(*dest).fields = (g_free ((*dest).fields), NULL);
	(*dest).fields = _tmp3_;
	(*dest).fields_length1 = _tmp3__length1;
	(*dest)._fields_size_ = (*dest).fields_length1;
}


static void gpx_fit_file_field_definition_destroy (GpxFitFileFieldDefinition* self) {
	(*self).fields = (g_free ((*self).fields), NULL);
}


static GpxFitFileFieldDefinition* gpx_fit_file_field_definition_dup (const GpxFitFileFieldDefinition* self) {
	GpxFitFileFieldDefinition* dup;
	dup = g_new0 (GpxFitFileFieldDefinition, 1);
	gpx_fit_file_field_definition_copy (self, dup);
	return dup;
}


static void gpx_fit_file_field_definition_free (GpxFitFileFieldDefinition* self) {
	gpx_fit_file_field_definition_destroy (self);
	g_free (self);
}


static GType gpx_fit_file_field_definition_get_type (void) {
	static volatile gsize gpx_fit_file_field_definition_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_fit_file_field_definition_type_id__volatile)) {
		GType gpx_fit_file_field_definition_type_id;
		gpx_fit_file_field_definition_type_id = g_boxed_type_register_static ("GpxFitFileFieldDefinition", (GBoxedCopyFunc) gpx_fit_file_field_definition_dup, (GBoxedFreeFunc) gpx_fit_file_field_definition_free);
		g_once_init_leave (&gpx_fit_file_field_definition_type_id__volatile, gpx_fit_file_field_definition_type_id);
	}
	return gpx_fit_file_field_definition_type_id__volatile;
}


static GpxFitFileFieldDefinitionHeader* gpx_fit_file_field_definition_header_dup (const GpxFitFileFieldDefinitionHeader* self) {
	GpxFitFileFieldDefinitionHeader* dup;
	dup = g_new0 (GpxFitFileFieldDefinitionHeader, 1);
	memcpy (dup, self, sizeof (GpxFitFileFieldDefinitionHeader));
	return dup;
}


static void gpx_fit_file_field_definition_header_free (GpxFitFileFieldDefinitionHeader* self) {
	g_free (self);
}


static GType gpx_fit_file_field_definition_header_get_type (void) {
	static volatile gsize gpx_fit_file_field_definition_header_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_fit_file_field_definition_header_type_id__volatile)) {
		GType gpx_fit_file_field_definition_header_type_id;
		gpx_fit_file_field_definition_header_type_id = g_boxed_type_register_static ("GpxFitFileFieldDefinitionHeader", (GBoxedCopyFunc) gpx_fit_file_field_definition_header_dup, (GBoxedFreeFunc) gpx_fit_file_field_definition_header_free);
		g_once_init_leave (&gpx_fit_file_field_definition_header_type_id__volatile, gpx_fit_file_field_definition_header_type_id);
	}
	return gpx_fit_file_field_definition_header_type_id__volatile;
}


static void gpx_fit_file_class_init (GpxFitFileClass * klass) {
	gpx_fit_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GpxFitFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = gpx_fit_file_finalize;
}


static void gpx_fit_file_instance_init (GpxFitFile * self) {
	GpxFitFileFieldDefinition* _tmp0_ = NULL;
	self->priv = GPX_FIT_FILE_GET_PRIVATE (self);
	self->priv->track = NULL;
	self->priv->data_length = (guint32) 0;
	_tmp0_ = g_new0 (GpxFitFileFieldDefinition, MAX_LOCAL_DEFINITIONS);
	self->priv->defs = _tmp0_;
	self->priv->defs_length1 = MAX_LOCAL_DEFINITIONS;
	self->priv->_defs_size_ = self->priv->defs_length1;
}


static void gpx_fit_file_finalize (GObject* obj) {
	GpxFitFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GPX_TYPE_FIT_FILE, GpxFitFile);
	_g_object_unref0 (self->priv->track);
	self->priv->defs = (_vala_GpxFitFileFieldDefinition_array_free (self->priv->defs, self->priv->defs_length1), NULL);
	G_OBJECT_CLASS (gpx_fit_file_parent_class)->finalize (obj);
}


GType gpx_fit_file_get_type (void) {
	static volatile gsize gpx_fit_file_type_id__volatile = 0;
	if (g_once_init_enter (&gpx_fit_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GpxFitFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gpx_fit_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GpxFitFile), 0, (GInstanceInitFunc) gpx_fit_file_instance_init, NULL };
		GType gpx_fit_file_type_id;
		gpx_fit_file_type_id = g_type_register_static (GPX_TYPE_FILE_BASE, "GpxFitFile", &g_define_type_info, 0);
		g_once_init_leave (&gpx_fit_file_type_id__volatile, gpx_fit_file_type_id);
	}
	return gpx_fit_file_type_id__volatile;
}



