// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/app_stats.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import time "time"

import encoding_binary "encoding/binary"
import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type StatementStatistics struct {
	// Count is the total number of times this statement was executed
	// since the begin of the reporting period.
	// When transmitted to the reporting server, this value gets
	// quantized into buckets (few <10, dozens 10+, 100 or more).
	Count int64 `protobuf:"varint,1,opt,name=count" json:"count"`
	// FirstAttemptCount collects the total number of times a first
	// attempt was executed (either the one time in explicitly committed
	// statements, or the first time in implicitly committed statements
	// with implicit retries).
	// The proportion of statements that could be executed without retry
	// can be computed as FirstAttemptCount / Count.
	// The cumulative number of retries can be computed with
	// Count - FirstAttemptCount.
	//
	// When transmitted to the reporting server, this value gets
	// simplified so that the proportion of statements that could be
	// executed without retry remains as FirstAttemptCount / Count.
	FirstAttemptCount int64 `protobuf:"varint,2,opt,name=first_attempt_count,json=firstAttemptCount" json:"first_attempt_count"`
	// MaxRetries collects the maximum observed number of automatic
	// retries in the reporting period.
	// When transmitted to the reporting server, this value gets
	// quantized into buckets (few <10, dozens 10+, 100 or more).
	MaxRetries int64 `protobuf:"varint,3,opt,name=max_retries,json=maxRetries" json:"max_retries"`
	// DEPRECATED: LastErr collects the last error encountered.
	// Use sensitive_info.last_err instead.
	LegacyLastErr string `protobuf:"bytes,4,opt,name=legacy_last_err,json=legacyLastErr" json:"legacy_last_err"`
	// DEPRECATED: LastErrRedacted collects the last error, redacted for reporting.
	LegacyLastErrRedacted string `protobuf:"bytes,11,opt,name=legacy_last_err_redacted,json=legacyLastErrRedacted" json:"legacy_last_err_redacted"`
	// NumRows collects the number of rows returned or observed.
	NumRows NumericStat `protobuf:"bytes,5,opt,name=num_rows,json=numRows" json:"num_rows"`
	// ParseLat is the time to transform the SQL string into an AST.
	ParseLat NumericStat `protobuf:"bytes,6,opt,name=parse_lat,json=parseLat" json:"parse_lat"`
	// PlanLat is the time to transform the AST into a logical query plan.
	PlanLat NumericStat `protobuf:"bytes,7,opt,name=plan_lat,json=planLat" json:"plan_lat"`
	// RunLat is the time to run the query and fetch/compute the result rows.
	RunLat NumericStat `protobuf:"bytes,8,opt,name=run_lat,json=runLat" json:"run_lat"`
	// ServiceLat is the time to service the query, from start of parse to end of execute.
	ServiceLat NumericStat `protobuf:"bytes,9,opt,name=service_lat,json=serviceLat" json:"service_lat"`
	// OverheadLat is the difference between ServiceLat and the sum of parse+plan+run latencies.
	// We store it separately (as opposed to computing it post-hoc) because the combined
	// variance for the overhead cannot be derived from the variance of the separate latencies.
	OverheadLat NumericStat `protobuf:"bytes,10,opt,name=overhead_lat,json=overheadLat" json:"overhead_lat"`
	// SensitiveInfo is info that needs to be scrubbed or redacted before being
	// sent to the reg cluster.
	SensitiveInfo        SensitiveInfo `protobuf:"bytes,12,opt,name=sensitive_info,json=sensitiveInfo" json:"sensitive_info"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *StatementStatistics) Reset()         { *m = StatementStatistics{} }
func (m *StatementStatistics) String() string { return proto.CompactTextString(m) }
func (*StatementStatistics) ProtoMessage()    {}
func (*StatementStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{0}
}
func (m *StatementStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatementStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *StatementStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatementStatistics.Merge(dst, src)
}
func (m *StatementStatistics) XXX_Size() int {
	return m.Size()
}
func (m *StatementStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_StatementStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_StatementStatistics proto.InternalMessageInfo

type SensitiveInfo struct {
	// LastErr collects the last error encountered.
	// It is only reported once it's been redacted.
	LastErr string `protobuf:"bytes,1,opt,name=last_err,json=lastErr" json:"last_err"`
	// MostRecentPlanDescription is a serialized representation of the logical plan most recently captured for this query.
	MostRecentPlanDescription ExplainTreePlanNode `protobuf:"bytes,2,opt,name=most_recent_plan_description,json=mostRecentPlanDescription" json:"most_recent_plan_description"`
	// Timestamp is the time at which the logical plan was last sampled.
	MostRecentPlanTimestamp time.Time `protobuf:"bytes,3,opt,name=most_recent_plan_timestamp,json=mostRecentPlanTimestamp,stdtime" json:"most_recent_plan_timestamp"`
	XXX_NoUnkeyedLiteral    struct{}  `json:"-"`
	XXX_sizecache           int32     `json:"-"`
}

func (m *SensitiveInfo) Reset()         { *m = SensitiveInfo{} }
func (m *SensitiveInfo) String() string { return proto.CompactTextString(m) }
func (*SensitiveInfo) ProtoMessage()    {}
func (*SensitiveInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{1}
}
func (m *SensitiveInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SensitiveInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *SensitiveInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SensitiveInfo.Merge(dst, src)
}
func (m *SensitiveInfo) XXX_Size() int {
	return m.Size()
}
func (m *SensitiveInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SensitiveInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SensitiveInfo proto.InternalMessageInfo

type NumericStat struct {
	// NumericStat keeps track of two running values --- the running mean and
	// the running sum of squared differences from the mean. Using this along
	// with the total count of values, we can compute variance using Welford's
	// method. This is more reliable than keeping track of the sum of
	// squared values, which is liable to overflow. See
	// https://en.wikipedia.org/wiki/Algorithms_for_calculating_variance#Online_algorithm
	Mean                 float64  `protobuf:"fixed64,1,opt,name=mean" json:"mean"`
	SquaredDiffs         float64  `protobuf:"fixed64,2,opt,name=squared_diffs,json=squaredDiffs" json:"squared_diffs"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NumericStat) Reset()         { *m = NumericStat{} }
func (m *NumericStat) String() string { return proto.CompactTextString(m) }
func (*NumericStat) ProtoMessage()    {}
func (*NumericStat) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{2}
}
func (m *NumericStat) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *NumericStat) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *NumericStat) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NumericStat.Merge(dst, src)
}
func (m *NumericStat) XXX_Size() int {
	return m.Size()
}
func (m *NumericStat) XXX_DiscardUnknown() {
	xxx_messageInfo_NumericStat.DiscardUnknown(m)
}

var xxx_messageInfo_NumericStat proto.InternalMessageInfo

type StatementStatisticsKey struct {
	Query                string   `protobuf:"bytes,1,opt,name=query" json:"query"`
	App                  string   `protobuf:"bytes,2,opt,name=app" json:"app"`
	DistSQL              bool     `protobuf:"varint,3,opt,name=distSQL" json:"distSQL"`
	Failed               bool     `protobuf:"varint,4,opt,name=failed" json:"failed"`
	Opt                  bool     `protobuf:"varint,5,opt,name=opt" json:"opt"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StatementStatisticsKey) Reset()         { *m = StatementStatisticsKey{} }
func (m *StatementStatisticsKey) String() string { return proto.CompactTextString(m) }
func (*StatementStatisticsKey) ProtoMessage()    {}
func (*StatementStatisticsKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{3}
}
func (m *StatementStatisticsKey) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StatementStatisticsKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *StatementStatisticsKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StatementStatisticsKey.Merge(dst, src)
}
func (m *StatementStatisticsKey) XXX_Size() int {
	return m.Size()
}
func (m *StatementStatisticsKey) XXX_DiscardUnknown() {
	xxx_messageInfo_StatementStatisticsKey.DiscardUnknown(m)
}

var xxx_messageInfo_StatementStatisticsKey proto.InternalMessageInfo

// CollectedStats wraps collected timings and metadata for some query's execution.
type CollectedStatementStatistics struct {
	Key                  StatementStatisticsKey `protobuf:"bytes,1,opt,name=key" json:"key"`
	Stats                StatementStatistics    `protobuf:"bytes,2,opt,name=stats" json:"stats"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *CollectedStatementStatistics) Reset()         { *m = CollectedStatementStatistics{} }
func (m *CollectedStatementStatistics) String() string { return proto.CompactTextString(m) }
func (*CollectedStatementStatistics) ProtoMessage()    {}
func (*CollectedStatementStatistics) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{4}
}
func (m *CollectedStatementStatistics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CollectedStatementStatistics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *CollectedStatementStatistics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CollectedStatementStatistics.Merge(dst, src)
}
func (m *CollectedStatementStatistics) XXX_Size() int {
	return m.Size()
}
func (m *CollectedStatementStatistics) XXX_DiscardUnknown() {
	xxx_messageInfo_CollectedStatementStatistics.DiscardUnknown(m)
}

var xxx_messageInfo_CollectedStatementStatistics proto.InternalMessageInfo

// ExplainTreePlanNode is a serialized representation of an EXPLAIN tree for a logical plan.
type ExplainTreePlanNode struct {
	// Name is the type of node this is, e.g. "scan" or "index-join".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	// Attrs are attributes of this plan node.
	// Often there are many attributes with the same key, e.g. "render".
	Attrs []*ExplainTreePlanNode_Attr `protobuf:"bytes,2,rep,name=attrs" json:"attrs,omitempty"`
	// Children are the nodes that feed into this one, e.g. two scans for a join.
	Children             []*ExplainTreePlanNode `protobuf:"bytes,3,rep,name=children" json:"children,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ExplainTreePlanNode) Reset()         { *m = ExplainTreePlanNode{} }
func (m *ExplainTreePlanNode) String() string { return proto.CompactTextString(m) }
func (*ExplainTreePlanNode) ProtoMessage()    {}
func (*ExplainTreePlanNode) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{5}
}
func (m *ExplainTreePlanNode) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExplainTreePlanNode) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExplainTreePlanNode) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplainTreePlanNode.Merge(dst, src)
}
func (m *ExplainTreePlanNode) XXX_Size() int {
	return m.Size()
}
func (m *ExplainTreePlanNode) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplainTreePlanNode.DiscardUnknown(m)
}

var xxx_messageInfo_ExplainTreePlanNode proto.InternalMessageInfo

type ExplainTreePlanNode_Attr struct {
	Key                  string   `protobuf:"bytes,1,opt,name=key" json:"key"`
	Value                string   `protobuf:"bytes,2,opt,name=value" json:"value"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplainTreePlanNode_Attr) Reset()         { *m = ExplainTreePlanNode_Attr{} }
func (m *ExplainTreePlanNode_Attr) String() string { return proto.CompactTextString(m) }
func (*ExplainTreePlanNode_Attr) ProtoMessage()    {}
func (*ExplainTreePlanNode_Attr) Descriptor() ([]byte, []int) {
	return fileDescriptor_app_stats_786d835d6f7e091f, []int{5, 0}
}
func (m *ExplainTreePlanNode_Attr) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExplainTreePlanNode_Attr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalTo(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (dst *ExplainTreePlanNode_Attr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplainTreePlanNode_Attr.Merge(dst, src)
}
func (m *ExplainTreePlanNode_Attr) XXX_Size() int {
	return m.Size()
}
func (m *ExplainTreePlanNode_Attr) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplainTreePlanNode_Attr.DiscardUnknown(m)
}

var xxx_messageInfo_ExplainTreePlanNode_Attr proto.InternalMessageInfo

func init() {
	proto.RegisterType((*StatementStatistics)(nil), "cockroach.sql.StatementStatistics")
	proto.RegisterType((*SensitiveInfo)(nil), "cockroach.sql.SensitiveInfo")
	proto.RegisterType((*NumericStat)(nil), "cockroach.sql.NumericStat")
	proto.RegisterType((*StatementStatisticsKey)(nil), "cockroach.sql.StatementStatisticsKey")
	proto.RegisterType((*CollectedStatementStatistics)(nil), "cockroach.sql.CollectedStatementStatistics")
	proto.RegisterType((*ExplainTreePlanNode)(nil), "cockroach.sql.ExplainTreePlanNode")
	proto.RegisterType((*ExplainTreePlanNode_Attr)(nil), "cockroach.sql.ExplainTreePlanNode.Attr")
}
func (m *StatementStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.Count))
	dAtA[i] = 0x10
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.FirstAttemptCount))
	dAtA[i] = 0x18
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.MaxRetries))
	dAtA[i] = 0x22
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.LegacyLastErr)))
	i += copy(dAtA[i:], m.LegacyLastErr)
	dAtA[i] = 0x2a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.NumRows.Size()))
	n1, err := m.NumRows.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x32
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.ParseLat.Size()))
	n2, err := m.ParseLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x3a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.PlanLat.Size()))
	n3, err := m.PlanLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x42
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.RunLat.Size()))
	n4, err := m.RunLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x4a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.ServiceLat.Size()))
	n5, err := m.ServiceLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x52
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.OverheadLat.Size()))
	n6, err := m.OverheadLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x5a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.LegacyLastErrRedacted)))
	i += copy(dAtA[i:], m.LegacyLastErrRedacted)
	dAtA[i] = 0x62
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.SensitiveInfo.Size()))
	n7, err := m.SensitiveInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *SensitiveInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SensitiveInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.LastErr)))
	i += copy(dAtA[i:], m.LastErr)
	dAtA[i] = 0x12
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.MostRecentPlanDescription.Size()))
	n8, err := m.MostRecentPlanDescription.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x1a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdTime(m.MostRecentPlanTimestamp)))
	n9, err := github_com_gogo_protobuf_types.StdTimeMarshalTo(m.MostRecentPlanTimestamp, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *NumericStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NumericStat) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Mean))))
	i += 8
	dAtA[i] = 0x11
	i++
	encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.SquaredDiffs))))
	i += 8
	return i, nil
}

func (m *StatementStatisticsKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementStatisticsKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.Query)))
	i += copy(dAtA[i:], m.Query)
	dAtA[i] = 0x12
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.App)))
	i += copy(dAtA[i:], m.App)
	dAtA[i] = 0x18
	i++
	if m.DistSQL {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	if m.Failed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x28
	i++
	if m.Opt {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *CollectedStatementStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CollectedStatementStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.Key.Size()))
	n10, err := m.Key.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x12
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.Stats.Size()))
	n11, err := m.Stats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func (m *ExplainTreePlanNode) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExplainTreePlanNode) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	if len(m.Attrs) > 0 {
		for _, msg := range m.Attrs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintAppStats(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Children) > 0 {
		for _, msg := range m.Children {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintAppStats(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ExplainTreePlanNode_Attr) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExplainTreePlanNode_Attr) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x12
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func encodeVarintAppStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StatementStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovAppStats(uint64(m.Count))
	n += 1 + sovAppStats(uint64(m.FirstAttemptCount))
	n += 1 + sovAppStats(uint64(m.MaxRetries))
	l = len(m.LegacyLastErr)
	n += 1 + l + sovAppStats(uint64(l))
	l = m.NumRows.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.ParseLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.PlanLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.RunLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.ServiceLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.OverheadLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = len(m.LegacyLastErrRedacted)
	n += 1 + l + sovAppStats(uint64(l))
	l = m.SensitiveInfo.Size()
	n += 1 + l + sovAppStats(uint64(l))
	return n
}

func (m *SensitiveInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.LastErr)
	n += 1 + l + sovAppStats(uint64(l))
	l = m.MostRecentPlanDescription.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdTime(m.MostRecentPlanTimestamp)
	n += 1 + l + sovAppStats(uint64(l))
	return n
}

func (m *NumericStat) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 9
	n += 9
	return n
}

func (m *StatementStatisticsKey) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Query)
	n += 1 + l + sovAppStats(uint64(l))
	l = len(m.App)
	n += 1 + l + sovAppStats(uint64(l))
	n += 2
	n += 2
	n += 2
	return n
}

func (m *CollectedStatementStatistics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Key.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.Stats.Size()
	n += 1 + l + sovAppStats(uint64(l))
	return n
}

func (m *ExplainTreePlanNode) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovAppStats(uint64(l))
	if len(m.Attrs) > 0 {
		for _, e := range m.Attrs {
			l = e.Size()
			n += 1 + l + sovAppStats(uint64(l))
		}
	}
	if len(m.Children) > 0 {
		for _, e := range m.Children {
			l = e.Size()
			n += 1 + l + sovAppStats(uint64(l))
		}
	}
	return n
}

func (m *ExplainTreePlanNode_Attr) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovAppStats(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovAppStats(uint64(l))
	return n
}

func sovAppStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAppStats(x uint64) (n int) {
	return sovAppStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StatementStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatementStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatementStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstAttemptCount", wireType)
			}
			m.FirstAttemptCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstAttemptCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetries", wireType)
			}
			m.MaxRetries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetries |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LegacyLastErr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LegacyLastErr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.NumRows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParseLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ParseLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlanLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PlanLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RunLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ServiceLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverheadLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OverheadLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LegacyLastErrRedacted", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LegacyLastErrRedacted = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SensitiveInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SensitiveInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SensitiveInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SensitiveInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SensitiveInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastErr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastErr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MostRecentPlanDescription", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MostRecentPlanDescription.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MostRecentPlanTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdTimeUnmarshal(&m.MostRecentPlanTimestamp, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NumericStat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NumericStat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NumericStat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mean", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Mean = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SquaredDiffs", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.SquaredDiffs = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatementStatisticsKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatementStatisticsKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatementStatisticsKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Query = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field App", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.App = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistSQL", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DistSQL = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Failed = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Opt", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Opt = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CollectedStatementStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CollectedStatementStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CollectedStatementStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Key.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExplainTreePlanNode) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExplainTreePlanNode: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExplainTreePlanNode: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attrs = append(m.Attrs, &ExplainTreePlanNode_Attr{})
			if err := m.Attrs[len(m.Attrs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Children", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Children = append(m.Children, &ExplainTreePlanNode{})
			if err := m.Children[len(m.Children)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExplainTreePlanNode_Attr) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attr: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attr: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAppStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAppStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAppStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAppStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAppStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAppStats   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/app_stats.proto", fileDescriptor_app_stats_786d835d6f7e091f) }

var fileDescriptor_app_stats_786d835d6f7e091f = []byte{
	// 787 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x55, 0xcb, 0x6e, 0xc3, 0x44,
	0x14, 0xad, 0x49, 0xd2, 0x24, 0xd7, 0x0d, 0x88, 0x29, 0xb4, 0x26, 0x8a, 0x92, 0x12, 0xa9, 0x22,
	0x48, 0x28, 0x91, 0x22, 0x36, 0x80, 0x52, 0xa9, 0xaf, 0x45, 0x45, 0x55, 0x81, 0xdb, 0x15, 0x1b,
	0x6b, 0x6a, 0xdf, 0xa4, 0xa3, 0xda, 0x1e, 0x77, 0x66, 0x9c, 0x36, 0x7f, 0xd1, 0x1f, 0x60, 0xc3,
	0xa7, 0xb0, 0xea, 0x92, 0x25, 0x2b, 0x1e, 0x61, 0xc7, 0x47, 0x20, 0x34, 0x63, 0x3b, 0x24, 0x21,
	0x88, 0xec, 0x9c, 0x73, 0xcf, 0x39, 0x73, 0xe7, 0x3e, 0x26, 0x70, 0x28, 0x38, 0xf5, 0x1f, 0x92,
	0xfb, 0x01, 0x4d, 0x12, 0x4f, 0x2a, 0xaa, 0x64, 0x3f, 0x11, 0x5c, 0x71, 0xd2, 0xf0, 0xb9, 0xff,
	0x68, 0x82, 0x7d, 0xf9, 0x14, 0x36, 0x3f, 0x98, 0xf0, 0x09, 0x37, 0x91, 0x81, 0xfe, 0xca, 0x48,
	0xcd, 0xce, 0x84, 0xf3, 0x49, 0x88, 0x03, 0xf3, 0xeb, 0x3e, 0x1d, 0x0f, 0x14, 0x8b, 0x50, 0x2a,
	0x1a, 0x25, 0x19, 0xa1, 0xfb, 0x63, 0x05, 0xf6, 0x6f, 0x15, 0x55, 0x18, 0x61, 0xac, 0xf4, 0x07,
	0x93, 0x8a, 0xf9, 0x92, 0x34, 0xa1, 0xe2, 0xf3, 0x34, 0x56, 0x8e, 0x75, 0x64, 0xf5, 0x4a, 0x67,
	0xe5, 0xb7, 0x5f, 0x3a, 0x3b, 0x6e, 0x06, 0x91, 0xcf, 0x61, 0x7f, 0xcc, 0x84, 0x54, 0x1e, 0x55,
	0x0a, 0xa3, 0x44, 0x79, 0x19, 0xf3, 0x9d, 0x25, 0xe6, 0xfb, 0x86, 0x70, 0x9a, 0xc5, 0xcf, 0x8d,
	0xea, 0x18, 0xec, 0x88, 0xbe, 0x78, 0x02, 0x95, 0x60, 0x28, 0x9d, 0xd2, 0x12, 0x1b, 0x22, 0xfa,
	0xe2, 0x66, 0x38, 0xf9, 0x0c, 0xde, 0x0b, 0x71, 0x42, 0xfd, 0x99, 0x17, 0x52, 0xa9, 0x3c, 0x14,
	0xc2, 0x29, 0x1f, 0x59, 0xbd, 0x7a, 0x4e, 0x6d, 0x64, 0xc1, 0x6b, 0x2a, 0xd5, 0xa5, 0x10, 0xe4,
	0x2b, 0xa8, 0xc5, 0x69, 0xe4, 0x09, 0xfe, 0x2c, 0x9d, 0xca, 0x91, 0xd5, 0xb3, 0x87, 0xcd, 0xfe,
	0x4a, 0x5d, 0xfa, 0x37, 0x69, 0x84, 0x82, 0xf9, 0xfa, 0x6a, 0xb9, 0x45, 0x35, 0x4e, 0x23, 0x97,
	0x3f, 0x4b, 0x32, 0x82, 0x7a, 0x42, 0x85, 0x44, 0x2f, 0xa4, 0xca, 0xd9, 0xdd, 0x52, 0x5d, 0x33,
	0x92, 0x6b, 0xaa, 0xf4, 0xd9, 0x49, 0x48, 0x63, 0xa3, 0xae, 0x6e, 0x7b, 0xb6, 0x56, 0x68, 0xf1,
	0x17, 0x50, 0x15, 0x69, 0xa6, 0xad, 0x6d, 0xa9, 0xdd, 0x15, 0xa9, 0x91, 0x9e, 0x82, 0x2d, 0x51,
	0x4c, 0x99, 0x9f, 0x25, 0x5e, 0xdf, 0x52, 0x0e, 0xb9, 0x48, 0x5b, 0x9c, 0xc3, 0x1e, 0x9f, 0xa2,
	0x78, 0x40, 0x1a, 0x18, 0x0f, 0xd8, 0xd2, 0xc3, 0x2e, 0x54, 0xda, 0x64, 0x04, 0xce, 0x5a, 0xa7,
	0x3c, 0x81, 0x01, 0xf5, 0x15, 0x06, 0x8e, 0xbd, 0xd4, 0xb2, 0x0f, 0x57, 0x5a, 0xe6, 0xe6, 0x14,
	0x72, 0x05, 0xef, 0x4a, 0x8c, 0x25, 0x53, 0x6c, 0x8a, 0x1e, 0x8b, 0xc7, 0xdc, 0xd9, 0x33, 0x59,
	0xb4, 0xd6, 0xb2, 0xb8, 0x2d, 0x48, 0x57, 0xf1, 0x98, 0x17, 0x53, 0x20, 0x97, 0xc1, 0xee, 0x5f,
	0x16, 0x34, 0x56, 0x68, 0xa4, 0x03, 0xb5, 0xc5, 0xf8, 0x58, 0x4b, 0xb9, 0x54, 0xc3, 0x7c, 0x70,
	0x18, 0xb4, 0x22, 0x2e, 0x95, 0x27, 0xd0, 0xc7, 0x58, 0x79, 0xa6, 0x91, 0x01, 0x4a, 0x5f, 0xb0,
	0x44, 0x31, 0x1e, 0x9b, 0x61, 0xb6, 0x87, 0xdd, 0xb5, 0x5c, 0x2e, 0x5f, 0x92, 0x90, 0xb2, 0xf8,
	0x4e, 0x20, 0x7e, 0x13, 0xd2, 0xf8, 0x86, 0x07, 0x98, 0x1b, 0x7f, 0xa4, 0xdd, 0x5c, 0x63, 0xa6,
	0x23, 0x17, 0xff, 0x58, 0x11, 0x0a, 0xcd, 0x7f, 0x1d, 0xb5, 0x58, 0x43, 0xb3, 0x07, 0xba, 0xf4,
	0xd9, 0xa2, 0xf6, 0x8b, 0x45, 0xed, 0xdf, 0x15, 0x8c, 0xb3, 0x9a, 0x3e, 0xe0, 0xf5, 0xd7, 0x8e,
	0xe5, 0x1e, 0xae, 0x1e, 0xb2, 0xa0, 0x74, 0x5d, 0xb0, 0x97, 0x9a, 0x45, 0x1c, 0x28, 0x47, 0x48,
	0x63, 0x73, 0x73, 0x2b, 0x4f, 0xd0, 0x20, 0xe4, 0x53, 0x68, 0xc8, 0xa7, 0x94, 0x0a, 0x0c, 0xbc,
	0x80, 0x8d, 0xc7, 0xd2, 0xdc, 0xb3, 0xa0, 0xec, 0xe5, 0xa1, 0x0b, 0x1d, 0xe9, 0xfe, 0x60, 0xc1,
	0xc1, 0x86, 0x97, 0xe1, 0x6b, 0x9c, 0xe9, 0xc7, 0xe1, 0x29, 0x45, 0x31, 0x5b, 0x29, 0x6d, 0x06,
	0x91, 0x03, 0x28, 0xd1, 0x24, 0x31, 0xbe, 0x45, 0x44, 0x03, 0xa4, 0x0d, 0xd5, 0x80, 0x49, 0x75,
	0xfb, 0xed, 0xb5, 0xb9, 0x72, 0xad, 0x68, 0x48, 0x0e, 0x92, 0x16, 0xec, 0x8e, 0x29, 0x0b, 0x31,
	0x30, 0xeb, 0x5e, 0x84, 0x73, 0x4c, 0xbb, 0xf2, 0x44, 0x99, 0x15, 0x2f, 0x42, 0x1a, 0xe8, 0x7e,
	0x6f, 0x41, 0xeb, 0x9c, 0x87, 0x21, 0xea, 0x91, 0xda, 0xf4, 0x8e, 0x8d, 0xa0, 0xf4, 0x88, 0x59,
	0xa2, 0xf6, 0xf0, 0x78, 0x7d, 0xb4, 0x36, 0x5e, 0xaf, 0xf0, 0x7f, 0xc4, 0x19, 0x39, 0x81, 0x8a,
	0x79, 0x73, 0xff, 0x63, 0x1e, 0x36, 0x18, 0x14, 0xd5, 0x30, 0xb2, 0xee, 0x9f, 0x16, 0xec, 0x6f,
	0x18, 0x1a, 0xdd, 0xa1, 0x98, 0x46, 0xb8, 0x52, 0x40, 0x83, 0x90, 0x11, 0x54, 0xa8, 0x52, 0x42,
	0x9f, 0x58, 0xea, 0xd9, 0xc3, 0x4f, 0xfe, 0x7f, 0x02, 0xfb, 0xa7, 0x4a, 0x09, 0x37, 0x53, 0x91,
	0x13, 0xa8, 0xf9, 0x0f, 0x2c, 0x0c, 0x04, 0xc6, 0x4e, 0xc9, 0x38, 0x6c, 0x31, 0xc3, 0xee, 0x42,
	0xd3, 0xfc, 0x12, 0xca, 0xda, 0x4e, 0x17, 0xbc, 0xa8, 0x5b, 0x7d, 0xb9, 0x20, 0x4d, 0xa8, 0x4c,
	0x69, 0x98, 0xe2, 0x4a, 0x83, 0x33, 0xe8, 0xec, 0xe3, 0xb7, 0xdf, 0xdb, 0x3b, 0x6f, 0xf3, 0xb6,
	0xf5, 0xd3, 0xbc, 0x6d, 0xfd, 0x3c, 0x6f, 0x5b, 0xbf, 0xcd, 0xdb, 0xd6, 0xeb, 0x1f, 0xed, 0x9d,
	0xef, 0xaa, 0xf9, 0x9f, 0xd8, 0xdf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x4c, 0xf8, 0xae, 0x44, 0xce,
	0x06, 0x00, 0x00,
}
