// Code generated by execgen; DO NOT EDIT.

package exec

import (
	"bytes"

	"github.com/cockroachdb/apd"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/coldata"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types"
	"github.com/cockroachdb/cockroach/pkg/sql/exec/types/conv"
	"github.com/cockroachdb/cockroach/pkg/sql/sem/tree"
	"github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
	"github.com/pkg/errors"
)

type projEQBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projEQBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQBoolBoolConstOp) Init() {
	p.input.Init()
}

type projEQBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projEQBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQBoolConstBoolOp) Init() {
	p.input.Init()
}

type projEQBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQBoolBoolOp) Init() {
	p.input.Init()
}

type projNEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projNEBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEBoolBoolConstOp) Init() {
	p.input.Init()
}

type projNEBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projNEBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEBoolConstBoolOp) Init() {
	p.input.Init()
}

type projNEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEBoolBoolOp) Init() {
	p.input.Init()
}

type projLTBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projLTBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) < 0
		}
	}
	return batch
}

func (p projLTBoolBoolConstOp) Init() {
	p.input.Init()
}

type projLTBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projLTBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) < 0
		}
	}
	return batch
}

func (p projLTBoolConstBoolOp) Init() {
	p.input.Init()
}

type projLTBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) < 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) < 0
		}
	}
	return batch
}

func (p projLTBoolBoolOp) Init() {
	p.input.Init()
}

type projLEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projLEBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) <= 0
		}
	}
	return batch
}

func (p projLEBoolBoolConstOp) Init() {
	p.input.Init()
}

type projLEBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projLEBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) <= 0
		}
	}
	return batch
}

func (p projLEBoolConstBoolOp) Init() {
	p.input.Init()
}

type projLEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) <= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) <= 0
		}
	}
	return batch
}

func (p projLEBoolBoolOp) Init() {
	p.input.Init()
}

type projGTBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projGTBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) > 0
		}
	}
	return batch
}

func (p projGTBoolBoolConstOp) Init() {
	p.input.Init()
}

type projGTBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projGTBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) > 0
		}
	}
	return batch
}

func (p projGTBoolConstBoolOp) Init() {
	p.input.Init()
}

type projGTBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) > 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) > 0
		}
	}
	return batch
}

func (p projGTBoolBoolOp) Init() {
	p.input.Init()
}

type projGEBoolBoolConstOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projGEBoolBoolConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(coldata[i], p.constArg) >= 0
		}
	}
	return batch
}

func (p projGEBoolBoolConstOp) Init() {
	p.input.Init()
}

type projGEBoolConstBoolOp struct {
	input Operator

	colIdx   int
	constArg bool

	outputIdx int
}

func (p *projGEBoolConstBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareBools(p.constArg, coldata[i]) >= 0
		}
	}
	return batch
}

func (p projGEBoolConstBoolOp) Init() {
	p.input.Init()
}

type projGEBoolBoolOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEBoolBoolOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bool()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bool()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) >= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareBools(col1[i], col2[i]) >= 0
		}
	}
	return batch
}

func (p projGEBoolBoolOp) Init() {
	p.input.Init()
}

type projEQBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projEQBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Equal(coldata[i], p.constArg)
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Equal(coldata[i], p.constArg)
		}
	}
	return batch
}

func (p projEQBytesBytesConstOp) Init() {
	p.input.Init()
}

type projEQBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projEQBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Equal(p.constArg, coldata[i])
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Equal(p.constArg, coldata[i])
		}
	}
	return batch
}

func (p projEQBytesConstBytesOp) Init() {
	p.input.Init()
}

type projEQBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Equal(col1[i], col2[i])
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = bytes.Equal(col1[i], col2[i])
		}
	}
	return batch
}

func (p projEQBytesBytesOp) Init() {
	p.input.Init()
}

type projNEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projNEBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = !bytes.Equal(coldata[i], p.constArg)
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = !bytes.Equal(coldata[i], p.constArg)
		}
	}
	return batch
}

func (p projNEBytesBytesConstOp) Init() {
	p.input.Init()
}

type projNEBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projNEBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = !bytes.Equal(p.constArg, coldata[i])
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = !bytes.Equal(p.constArg, coldata[i])
		}
	}
	return batch
}

func (p projNEBytesConstBytesOp) Init() {
	p.input.Init()
}

type projNEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = !bytes.Equal(col1[i], col2[i])
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = !bytes.Equal(col1[i], col2[i])
		}
	}
	return batch
}

func (p projNEBytesBytesOp) Init() {
	p.input.Init()
}

type projLTBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projLTBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) < 0
		}
	}
	return batch
}

func (p projLTBytesBytesConstOp) Init() {
	p.input.Init()
}

type projLTBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projLTBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) < 0
		}
	}
	return batch
}

func (p projLTBytesConstBytesOp) Init() {
	p.input.Init()
}

type projLTBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(col1[i], col2[i]) < 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = bytes.Compare(col1[i], col2[i]) < 0
		}
	}
	return batch
}

func (p projLTBytesBytesOp) Init() {
	p.input.Init()
}

type projLEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projLEBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) <= 0
		}
	}
	return batch
}

func (p projLEBytesBytesConstOp) Init() {
	p.input.Init()
}

type projLEBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projLEBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) <= 0
		}
	}
	return batch
}

func (p projLEBytesConstBytesOp) Init() {
	p.input.Init()
}

type projLEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(col1[i], col2[i]) <= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = bytes.Compare(col1[i], col2[i]) <= 0
		}
	}
	return batch
}

func (p projLEBytesBytesOp) Init() {
	p.input.Init()
}

type projGTBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projGTBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) > 0
		}
	}
	return batch
}

func (p projGTBytesBytesConstOp) Init() {
	p.input.Init()
}

type projGTBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projGTBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) > 0
		}
	}
	return batch
}

func (p projGTBytesConstBytesOp) Init() {
	p.input.Init()
}

type projGTBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(col1[i], col2[i]) > 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = bytes.Compare(col1[i], col2[i]) > 0
		}
	}
	return batch
}

func (p projGTBytesBytesOp) Init() {
	p.input.Init()
}

type projGEBytesBytesConstOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projGEBytesBytesConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(coldata[i], p.constArg) >= 0
		}
	}
	return batch
}

func (p projGEBytesBytesConstOp) Init() {
	p.input.Init()
}

type projGEBytesConstBytesOp struct {
	input Operator

	colIdx   int
	constArg []byte

	outputIdx int
}

func (p *projGEBytesConstBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = bytes.Compare(p.constArg, coldata[i]) >= 0
		}
	}
	return batch
}

func (p projGEBytesConstBytesOp) Init() {
	p.input.Init()
}

type projGEBytesBytesOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEBytesBytesOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Bytes()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Bytes()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = bytes.Compare(col1[i], col2[i]) >= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = bytes.Compare(col1[i], col2[i]) >= 0
		}
	}
	return batch
}

func (p projGEBytesBytesOp) Init() {
	p.input.Init()
}

type projPlusDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projPlusDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projPlusDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projPlusDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projPlusDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projPlusDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projPlusDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			if _, err := tree.DecimalCtx.Add(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projPlusDecimalDecimalOp) Init() {
	p.input.Init()
}

type projMinusDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projMinusDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMinusDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projMinusDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projMinusDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMinusDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projMinusDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			if _, err := tree.DecimalCtx.Sub(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMinusDecimalDecimalOp) Init() {
	p.input.Init()
}

type projMultDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projMultDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMultDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projMultDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projMultDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMultDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projMultDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			if _, err := tree.DecimalCtx.Mul(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projMultDecimalDecimalOp) Init() {
	p.input.Init()
}

type projDivDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projDivDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &coldata[i], &p.constArg); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projDivDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projDivDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projDivDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &p.constArg, &coldata[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projDivDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projDivDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Decimal)
	}
	projCol := batch.ColVec(p.outputIdx).Decimal()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			if _, err := tree.DecimalCtx.Quo(&projCol[i], &col1[i], &col2[i]); err != nil {
				panic(err)
			}
		}
	}
	return batch
}

func (p projDivDecimalDecimalOp) Init() {
	p.input.Init()
}

type projEQDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projEQDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) == 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) == 0
		}
	}
	return batch
}

func (p projEQDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projEQDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projEQDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) == 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) == 0
		}
	}
	return batch
}

func (p projEQDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projEQDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) == 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) == 0
		}
	}
	return batch
}

func (p projEQDecimalDecimalOp) Init() {
	p.input.Init()
}

type projNEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projNEDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) != 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) != 0
		}
	}
	return batch
}

func (p projNEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projNEDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projNEDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) != 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) != 0
		}
	}
	return batch
}

func (p projNEDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projNEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) != 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) != 0
		}
	}
	return batch
}

func (p projNEDecimalDecimalOp) Init() {
	p.input.Init()
}

type projLTDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projLTDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) < 0
		}
	}
	return batch
}

func (p projLTDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projLTDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projLTDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) < 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) < 0
		}
	}
	return batch
}

func (p projLTDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projLTDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) < 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) < 0
		}
	}
	return batch
}

func (p projLTDecimalDecimalOp) Init() {
	p.input.Init()
}

type projLEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projLEDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) <= 0
		}
	}
	return batch
}

func (p projLEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projLEDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projLEDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) <= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) <= 0
		}
	}
	return batch
}

func (p projLEDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projLEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) <= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) <= 0
		}
	}
	return batch
}

func (p projLEDecimalDecimalOp) Init() {
	p.input.Init()
}

type projGTDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projGTDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) > 0
		}
	}
	return batch
}

func (p projGTDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projGTDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projGTDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) > 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) > 0
		}
	}
	return batch
}

func (p projGTDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projGTDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) > 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) > 0
		}
	}
	return batch
}

func (p projGTDecimalDecimalOp) Init() {
	p.input.Init()
}

type projGEDecimalDecimalConstOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projGEDecimalDecimalConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&coldata[i], &p.constArg) >= 0
		}
	}
	return batch
}

func (p projGEDecimalDecimalConstOp) Init() {
	p.input.Init()
}

type projGEDecimalConstDecimalOp struct {
	input Operator

	colIdx   int
	constArg apd.Decimal

	outputIdx int
}

func (p *projGEDecimalConstDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) >= 0
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = tree.CompareDecimals(&p.constArg, &coldata[i]) >= 0
		}
	}
	return batch
}

func (p projGEDecimalConstDecimalOp) Init() {
	p.input.Init()
}

type projGEDecimalDecimalOp struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEDecimalDecimalOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Decimal()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Decimal()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) >= 0
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = tree.CompareDecimals(&col1[i], &col2[i]) >= 0
		}
	}
	return batch
}

func (p projGEDecimalDecimalOp) Init() {
	p.input.Init()
}

type projPlusInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projPlusInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projPlusInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projPlusInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projPlusInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusInt8Int8Op) Init() {
	p.input.Init()
}

type projMinusInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projMinusInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projMinusInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projMinusInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projMinusInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusInt8Int8Op) Init() {
	p.input.Init()
}

type projMultInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projMultInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projMultInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projMultInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projMultInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultInt8Int8Op) Init() {
	p.input.Init()
}

type projDivInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projDivInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projDivInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projDivInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projDivInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int8)
	}
	projCol := batch.ColVec(p.outputIdx).Int8()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivInt8Int8Op) Init() {
	p.input.Init()
}

type projEQInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projEQInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projEQInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projEQInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projEQInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQInt8Int8Op) Init() {
	p.input.Init()
}

type projNEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projNEInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projNEInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projNEInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projNEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEInt8Int8Op) Init() {
	p.input.Init()
}

type projLTInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projLTInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projLTInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projLTInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projLTInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTInt8Int8Op) Init() {
	p.input.Init()
}

type projLEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projLEInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projLEInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projLEInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projLEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEInt8Int8Op) Init() {
	p.input.Init()
}

type projGTInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projGTInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projGTInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projGTInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projGTInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTInt8Int8Op) Init() {
	p.input.Init()
}

type projGEInt8Int8ConstOp struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projGEInt8Int8ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEInt8Int8ConstOp) Init() {
	p.input.Init()
}

type projGEInt8ConstInt8Op struct {
	input Operator

	colIdx   int
	constArg int8

	outputIdx int
}

func (p *projGEInt8ConstInt8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEInt8ConstInt8Op) Init() {
	p.input.Init()
}

type projGEInt8Int8Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEInt8Int8Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int8()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int8()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEInt8Int8Op) Init() {
	p.input.Init()
}

type projPlusInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projPlusInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projPlusInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projPlusInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projPlusInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusInt16Int16Op) Init() {
	p.input.Init()
}

type projMinusInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projMinusInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projMinusInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projMinusInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projMinusInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusInt16Int16Op) Init() {
	p.input.Init()
}

type projMultInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projMultInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projMultInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projMultInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projMultInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultInt16Int16Op) Init() {
	p.input.Init()
}

type projDivInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projDivInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projDivInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projDivInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projDivInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int16)
	}
	projCol := batch.ColVec(p.outputIdx).Int16()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivInt16Int16Op) Init() {
	p.input.Init()
}

type projEQInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projEQInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projEQInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projEQInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projEQInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQInt16Int16Op) Init() {
	p.input.Init()
}

type projNEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projNEInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projNEInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projNEInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projNEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEInt16Int16Op) Init() {
	p.input.Init()
}

type projLTInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projLTInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projLTInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projLTInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projLTInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTInt16Int16Op) Init() {
	p.input.Init()
}

type projLEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projLEInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projLEInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projLEInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projLEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEInt16Int16Op) Init() {
	p.input.Init()
}

type projGTInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projGTInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projGTInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projGTInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projGTInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTInt16Int16Op) Init() {
	p.input.Init()
}

type projGEInt16Int16ConstOp struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projGEInt16Int16ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEInt16Int16ConstOp) Init() {
	p.input.Init()
}

type projGEInt16ConstInt16Op struct {
	input Operator

	colIdx   int
	constArg int16

	outputIdx int
}

func (p *projGEInt16ConstInt16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEInt16ConstInt16Op) Init() {
	p.input.Init()
}

type projGEInt16Int16Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEInt16Int16Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int16()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int16()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEInt16Int16Op) Init() {
	p.input.Init()
}

type projPlusInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projPlusInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projPlusInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projPlusInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projPlusInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusInt32Int32Op) Init() {
	p.input.Init()
}

type projMinusInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projMinusInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projMinusInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projMinusInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projMinusInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusInt32Int32Op) Init() {
	p.input.Init()
}

type projMultInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projMultInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projMultInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projMultInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projMultInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultInt32Int32Op) Init() {
	p.input.Init()
}

type projDivInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projDivInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projDivInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projDivInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projDivInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int32)
	}
	projCol := batch.ColVec(p.outputIdx).Int32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivInt32Int32Op) Init() {
	p.input.Init()
}

type projEQInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projEQInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projEQInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projEQInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projEQInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQInt32Int32Op) Init() {
	p.input.Init()
}

type projNEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projNEInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projNEInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projNEInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projNEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEInt32Int32Op) Init() {
	p.input.Init()
}

type projLTInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projLTInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projLTInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projLTInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projLTInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTInt32Int32Op) Init() {
	p.input.Init()
}

type projLEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projLEInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projLEInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projLEInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projLEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEInt32Int32Op) Init() {
	p.input.Init()
}

type projGTInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projGTInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projGTInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projGTInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projGTInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTInt32Int32Op) Init() {
	p.input.Init()
}

type projGEInt32Int32ConstOp struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projGEInt32Int32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEInt32Int32ConstOp) Init() {
	p.input.Init()
}

type projGEInt32ConstInt32Op struct {
	input Operator

	colIdx   int
	constArg int32

	outputIdx int
}

func (p *projGEInt32ConstInt32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEInt32ConstInt32Op) Init() {
	p.input.Init()
}

type projGEInt32Int32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEInt32Int32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEInt32Int32Op) Init() {
	p.input.Init()
}

type projPlusInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projPlusInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projPlusInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projPlusInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projPlusInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusInt64Int64Op) Init() {
	p.input.Init()
}

type projMinusInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projMinusInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projMinusInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projMinusInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projMinusInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusInt64Int64Op) Init() {
	p.input.Init()
}

type projMultInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projMultInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projMultInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projMultInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projMultInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultInt64Int64Op) Init() {
	p.input.Init()
}

type projDivInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projDivInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projDivInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projDivInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projDivInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Int64)
	}
	projCol := batch.ColVec(p.outputIdx).Int64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivInt64Int64Op) Init() {
	p.input.Init()
}

type projEQInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projEQInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projEQInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projEQInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projEQInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQInt64Int64Op) Init() {
	p.input.Init()
}

type projNEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projNEInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projNEInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projNEInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projNEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEInt64Int64Op) Init() {
	p.input.Init()
}

type projLTInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projLTInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projLTInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projLTInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projLTInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTInt64Int64Op) Init() {
	p.input.Init()
}

type projLEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projLEInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projLEInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projLEInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projLEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEInt64Int64Op) Init() {
	p.input.Init()
}

type projGTInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projGTInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projGTInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projGTInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projGTInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTInt64Int64Op) Init() {
	p.input.Init()
}

type projGEInt64Int64ConstOp struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projGEInt64Int64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEInt64Int64ConstOp) Init() {
	p.input.Init()
}

type projGEInt64ConstInt64Op struct {
	input Operator

	colIdx   int
	constArg int64

	outputIdx int
}

func (p *projGEInt64ConstInt64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEInt64ConstInt64Op) Init() {
	p.input.Init()
}

type projGEInt64Int64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEInt64Int64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Int64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Int64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEInt64Int64Op) Init() {
	p.input.Init()
}

type projPlusFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projPlusFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projPlusFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projPlusFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projPlusFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusFloat32Float32Op) Init() {
	p.input.Init()
}

type projMinusFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projMinusFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projMinusFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projMinusFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projMinusFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusFloat32Float32Op) Init() {
	p.input.Init()
}

type projMultFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projMultFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projMultFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projMultFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projMultFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultFloat32Float32Op) Init() {
	p.input.Init()
}

type projDivFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projDivFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projDivFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projDivFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projDivFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float32)
	}
	projCol := batch.ColVec(p.outputIdx).Float32()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivFloat32Float32Op) Init() {
	p.input.Init()
}

type projEQFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projEQFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projEQFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projEQFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projEQFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQFloat32Float32Op) Init() {
	p.input.Init()
}

type projNEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projNEFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projNEFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projNEFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projNEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEFloat32Float32Op) Init() {
	p.input.Init()
}

type projLTFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projLTFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projLTFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projLTFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projLTFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTFloat32Float32Op) Init() {
	p.input.Init()
}

type projLEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projLEFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projLEFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projLEFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projLEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEFloat32Float32Op) Init() {
	p.input.Init()
}

type projGTFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projGTFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projGTFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projGTFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projGTFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTFloat32Float32Op) Init() {
	p.input.Init()
}

type projGEFloat32Float32ConstOp struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projGEFloat32Float32ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEFloat32Float32ConstOp) Init() {
	p.input.Init()
}

type projGEFloat32ConstFloat32Op struct {
	input Operator

	colIdx   int
	constArg float32

	outputIdx int
}

func (p *projGEFloat32ConstFloat32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEFloat32ConstFloat32Op) Init() {
	p.input.Init()
}

type projGEFloat32Float32Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEFloat32Float32Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float32()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float32()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEFloat32Float32Op) Init() {
	p.input.Init()
}

type projPlusFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projPlusFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] + p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] + p.constArg
		}
	}
	return batch
}

func (p projPlusFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projPlusFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projPlusFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg + coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg + coldata[i]
		}
	}
	return batch
}

func (p projPlusFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projPlusFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projPlusFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] + col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] + col2[i]
		}
	}
	return batch
}

func (p projPlusFloat64Float64Op) Init() {
	p.input.Init()
}

type projMinusFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projMinusFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] - p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] - p.constArg
		}
	}
	return batch
}

func (p projMinusFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projMinusFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projMinusFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg - coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg - coldata[i]
		}
	}
	return batch
}

func (p projMinusFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projMinusFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMinusFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] - col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] - col2[i]
		}
	}
	return batch
}

func (p projMinusFloat64Float64Op) Init() {
	p.input.Init()
}

type projMultFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projMultFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] * p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] * p.constArg
		}
	}
	return batch
}

func (p projMultFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projMultFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projMultFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg * coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg * coldata[i]
		}
	}
	return batch
}

func (p projMultFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projMultFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projMultFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] * col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] * col2[i]
		}
	}
	return batch
}

func (p projMultFloat64Float64Op) Init() {
	p.input.Init()
}

type projDivFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projDivFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] / p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] / p.constArg
		}
	}
	return batch
}

func (p projDivFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projDivFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projDivFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg / coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg / coldata[i]
		}
	}
	return batch
}

func (p projDivFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projDivFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projDivFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Float64)
	}
	projCol := batch.ColVec(p.outputIdx).Float64()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] / col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] / col2[i]
		}
	}
	return batch
}

func (p projDivFloat64Float64Op) Init() {
	p.input.Init()
}

type projEQFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projEQFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] == p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] == p.constArg
		}
	}
	return batch
}

func (p projEQFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projEQFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projEQFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg == coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg == coldata[i]
		}
	}
	return batch
}

func (p projEQFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projEQFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projEQFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] == col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] == col2[i]
		}
	}
	return batch
}

func (p projEQFloat64Float64Op) Init() {
	p.input.Init()
}

type projNEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projNEFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] != p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] != p.constArg
		}
	}
	return batch
}

func (p projNEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projNEFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projNEFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg != coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg != coldata[i]
		}
	}
	return batch
}

func (p projNEFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projNEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projNEFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] != col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] != col2[i]
		}
	}
	return batch
}

func (p projNEFloat64Float64Op) Init() {
	p.input.Init()
}

type projLTFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projLTFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] < p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] < p.constArg
		}
	}
	return batch
}

func (p projLTFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projLTFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projLTFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg < coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg < coldata[i]
		}
	}
	return batch
}

func (p projLTFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projLTFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLTFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] < col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] < col2[i]
		}
	}
	return batch
}

func (p projLTFloat64Float64Op) Init() {
	p.input.Init()
}

type projLEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projLEFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] <= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] <= p.constArg
		}
	}
	return batch
}

func (p projLEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projLEFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projLEFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg <= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg <= coldata[i]
		}
	}
	return batch
}

func (p projLEFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projLEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projLEFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] <= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] <= col2[i]
		}
	}
	return batch
}

func (p projLEFloat64Float64Op) Init() {
	p.input.Init()
}

type projGTFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projGTFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] > p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] > p.constArg
		}
	}
	return batch
}

func (p projGTFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projGTFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projGTFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg > coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg > coldata[i]
		}
	}
	return batch
}

func (p projGTFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projGTFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGTFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] > col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] > col2[i]
		}
	}
	return batch
}

func (p projGTFloat64Float64Op) Init() {
	p.input.Init()
}

type projGEFloat64Float64ConstOp struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projGEFloat64Float64ConstOp) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = coldata[i] >= p.constArg
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = coldata[i] >= p.constArg
		}
	}
	return batch
}

func (p projGEFloat64Float64ConstOp) Init() {
	p.input.Init()
}

type projGEFloat64ConstFloat64Op struct {
	input Operator

	colIdx   int
	constArg float64

	outputIdx int
}

func (p *projGEFloat64ConstFloat64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	coldata := batch.ColVec(p.colIdx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = p.constArg >= coldata[i]
		}
	} else {
		coldata = coldata[:n]
		for i := range coldata {
			projCol[i] = p.constArg >= coldata[i]
		}
	}
	return batch
}

func (p projGEFloat64ConstFloat64Op) Init() {
	p.input.Init()
}

type projGEFloat64Float64Op struct {
	input Operator

	col1Idx int
	col2Idx int

	outputIdx int
}

func (p *projGEFloat64Float64Op) Next() coldata.Batch {
	batch := p.input.Next()
	if p.outputIdx == batch.Width() {
		batch.AppendCol(types.Bool)
	}
	projCol := batch.ColVec(p.outputIdx).Bool()[:coldata.BatchSize]
	col1 := batch.ColVec(p.col1Idx).Float64()[:coldata.BatchSize]
	col2 := batch.ColVec(p.col2Idx).Float64()[:coldata.BatchSize]
	n := batch.Length()
	if sel := batch.Selection(); sel != nil {
		for _, i := range sel {
			projCol[i] = col1[i] >= col2[i]
		}
	} else {
		col1 = col1[:n]
		for i := range col1 {
			projCol[i] = col1[i] >= col2[i]
		}
	}
	return batch
}

func (p projGEFloat64Float64Op) Init() {
	p.input.Init()
}

// GetProjectionConstOperator returns the appropriate constant projection
// operator for the given column type and comparison.
func GetProjectionRConstOperator(
	ct sqlbase.ColumnType,
	op tree.Operator,
	input Operator,
	colIdx int,
	constArg tree.Datum,
	outputIdx int,
) (Operator, error) {
	c, err := conv.GetDatumToPhysicalFn(ct)(constArg)
	if err != nil {
		return nil, err
	}
	switch t := conv.FromColumnType(ct); t {

	case types.Bool:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBoolBoolConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Bytes:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBytesBytesConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Decimal:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEDecimalDecimalConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int8:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt8Int8ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int16:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt16Int16ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt32Int32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt64Int64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat32Float32ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat64Float64ConstOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	default:
		return nil, errors.Errorf("unhandled type: %s", t)
	}
}

// GetProjectionConstOperator returns the appropriate constant projection
// operator for the given column type and comparison.
func GetProjectionLConstOperator(
	ct sqlbase.ColumnType,
	op tree.Operator,
	input Operator,
	colIdx int,
	constArg tree.Datum,
	outputIdx int,
) (Operator, error) {
	c, err := conv.GetDatumToPhysicalFn(ct)(constArg)
	if err != nil {
		return nil, err
	}
	switch t := conv.FromColumnType(ct); t {

	case types.Bool:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBoolConstBoolOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(bool),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Bytes:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBytesConstBytesOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.([]byte),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Decimal:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEDecimalConstDecimalOp{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(apd.Decimal),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int8:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt8ConstInt8Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int8),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int16:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt16ConstInt16Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int16),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt32ConstInt32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt64ConstInt64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(int64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat32ConstFloat32Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float32),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat64ConstFloat64Op{
					input:     input,
					colIdx:    colIdx,
					constArg:  c.(float64),
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	default:
		return nil, errors.Errorf("unhandled type: %s", t)
	}
}

// GetProjectionOperator returns the appropriate projection operator for the
// given column type and comparison.
func GetProjectionOperator(
	ct sqlbase.ColumnType,
	op tree.Operator,
	input Operator,
	col1Idx int,
	col2Idx int,
	outputIdx int,
) (Operator, error) {
	switch t := conv.FromColumnType(ct); t {

	case types.Bool:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBoolBoolOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Bytes:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEBytesBytesOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Decimal:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEDecimalDecimalOp{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int8:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt8Int8Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int16:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt16Int16Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt32Int32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Int64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEInt64Int64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float32:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat32Float32Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	case types.Float64:
		switch op.(type) {
		case tree.BinaryOperator:
			switch op {

			case tree.Plus:
				return &projPlusFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Minus:
				return &projMinusFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Mult:
				return &projMultFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.Div:
				return &projDivFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled binary operator: %s", op)
			}
		case tree.ComparisonOperator:
			switch op {

			case tree.EQ:
				return &projEQFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.NE:
				return &projNEFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LT:
				return &projLTFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.LE:
				return &projLEFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GT:
				return &projGTFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			case tree.GE:
				return &projGEFloat64Float64Op{
					input:     input,
					col1Idx:   col1Idx,
					col2Idx:   col2Idx,
					outputIdx: outputIdx,
				}, nil

			default:
				return nil, errors.Errorf("unhandled comparison operator: %s", op)
			}
		default:
			return nil, errors.New("unhandled operator type")
		}

	default:
		return nil, errors.Errorf("unhandled type: %s", t)
	}
}
