/* $Id$ */
#if !defined ITALIC_H
#define ITALIC_H

#include "common.h"

#define SLANT_DEEP       3 /* level of slant deep, 2 is minimum and deepest */
#define PIXEL_CORRECTION 3 /* level of correction >= 0 */

typedef struct pattern Pattern;
typedef struct bitmap Bitmap;

Pattern *pattern_new(int correct);
void pattern_delete(Pattern *p);
void print_ptable(FILE *fp, int correct);

void bitmap_correct_pixel(Bitmap *bitmap, Pattern *ptable, int width, int height, int dy);
void bitmap_make_slant(Bitmap *bitmap, int width, int height, int dy);
char **bitmap_make_bdf_tmp(Bitmap *bitmap, int width, int height);
void bitmap_output(FILE *fp, Bitmap *bitmap, int width, int height);
void bitmap_get_line(Bitmap *bitmap, int width, size_t h, const char *src);
Bitmap *bitmap_new(size_t width, size_t height);
void bitmap_delete(Bitmap *bitmap);

int recast_bbx(char *dst, int *width, int *height, int *dw, int dy, const char *src);

#endif /* !ITALIC_H */
