/** VSys:$ndsad.cc:0.0.3-020$ **/
/*
 *  Transfered by VSys script on   11 17:05:08 MSK 2003
 *  Project: ndsad; Project version: 0.0.3-025;
 *  Branch: ;
 *  File: ndsad.cc; File version: 0.0.3-020
 */
/*
 * Ethernet IP packets parser.
 * Thanks to TCPDUMP Group for their code - it was very usefull in
 * learning BPF/PCAP usage
 */


#define conf_path "/netup/utm5/ndsad.cfg"

#include "pcap.local.h"

#ifdef WIN32
#include <winsock2.h>
#include "win32/version.h"
#include "win32/process.h"
#include <direct.h>
#else
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef WIN32
#else
#ifdef __OS_SOLARIS_LIKE
#include <sys/ethernet.h>
#else
#include <net/ethernet.h>
#endif
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <iostream>

#include "nf.h"
#include "nfc.h"
#include "handlers.h"
#include "iptonf.h"
#include "iflist.h"
#include "thr.h"
#include "config.h"
#include "logger.h"
#include "linux_ulog.h"
#include "bsd_divert.h"

#include "debug.h"

#include <string>
using namespace std;

#ifdef WIN32
#include "win32/winnt_service.h"
#define REG_UTM5 "SOFTWARE\\NetUP\\UTM5"
#define REG_BASEPATH "BasePath"
#define CONFIG_FILENAME "ndsad.cfg"
#endif


char signame[][16] = {
	"ZERO",      // 0 signal?
	"SIGHUP",    // SIGHUP -    1
	"SIGINT",    // SIGINT -    2
	"SIGQUIT",   // SIGQUIT -   3
	"SIGILL",    // SIGILL -    4
	"SIGTRAP",   // SIGTRAP -   5
	"SIGABRT",   // SIGABRT -   6
	"SIGBUS",    // SIGBUS -    7
	"SIGFPE",    // SIGFPE -    8
	"SIGKILL",   // SIGKILL -   9
	"SIGUSR1",   // SIGUSR1 -   10
	"SIGSEGV",   // SIGSEGV -   11
	"SIGUSR2",   // SIGUSR2 -   12
	"SIGPIPE",   // SIGPIPE -   13
	"SIGALRM",   // SIGALRM -   14
	"SIGTERM",   // SIGTERM -   15
	"SIGSTKFLT", // SIGSTKFLT - 16
	"SIGCHLD",   // SIGCHLD -   17
	"SIGCONT",   // SIGCONT -   18
	"SIGSTOP",   // SIGSTOP -   19
	"SIGTSTP",   // SIGTSTP -   20
	"SIGTTIN",   // SIGTTIN -   21
	"SIGTTOU",   // SIGTTOU -   22
	"SIGURG",    // SIGURG -    23
	"SIGXCPU",   // SIGXCPU -   24
	"SIGXFSZ",   // SIGXFSZ -   25
	"SIGVTALRM", // SIGVTALRM - 26
	"SIGPROF",   // SIGPROF -   27
	"SIGWINCH",  // SIGWINCH -  28
	"SIGIO",     // SIGIO -     29
	"SIGPWR",    // SIGPWR -    30
	"SIGSYS",    // SIGSYS -    31
	"SIGRTMIN",  // SIGRTMIN -  32
};


void print_version( const char * name ) {
    std::cout << "NetUP UTM Data Stream Accounting Daemon (NDSAD)" << std::endl;
	std::cout << "Copyright (c) 2001-2004 NetUP Inc. www.netup.ru" << std::endl;
	std::cout << "Compile date: " << __DATE__ << " " << __TIME__ << std::endl;
	printf( "`%s' version: %s;\n", name, VERSION);
}

void print_help( const char * name ) {
	printf( "Usage:\n" );
	printf( "\t %s -dhc...\n", name );
#ifndef WIN32
	printf( "\t\t-d : daemonize\n" );
	printf( "\t\t-w : enable WatchDog\n" );
#endif
	printf( "\t\t-D : enter dummy mode\n" );
	printf( "\t\t-h : print this and exit\n" );
	printf( "\t\t-v : print version and exit\n" );
	printf( "\t\t-s <val>  : make statistical dumps every <val> iterations\n" );
	printf( "\t\t-c <path> : use alternative config file\n" );
	printf( "\t\t-l <path> : use alternative log file,\n" );
	printf( "\t\t            `-' is recognized as `stderr'\n" );
}

#ifndef WIN32

int daemonize() {
	int pid = fork();
	if( pid < 0 ) {
		// Error 
		DEB(__rep_error( "daemonize" , 0 ));
		return 0;
	} else if( pid ) {
		// Parent 
		return 0;
	} else {
		// Child - have to log it.
		writelog( "Child process started." );
		return 1;
	}
}

int unpidfile( int pid_in = 0, const char * pidfile = 0 );

void sig_handler( int sig ) {
	printf( "Signal %s cought...\n", signame[sig] );
	if( sig == SIGHUP ) {
		ifl_dump = 1;
		unpidfile(getpid(), cfg.pidfile);
		return;
		exit(0);
#ifdef TRAP_SIGSEGV
	} else if( sig == SIGSEGV ) {
		std::cout << "TRAP_SIGSEGV defined" << std::endl;
		static int called = 0;
		if( getpid() != cfg.pid_child ) {
			std::cout << "PID MISMATCH ! getpid()=" << getpid() << " cfg.pid_child=" << cfg.pid_child << std::endl;
			kill( cfg.pid_child, SIGSEGV );
			waitpid(  cfg.pid_child, 0, 0 );
			return;
		}
		if( called ) return;
		called = 1;
		ifl_panic();
		signal( SIGSEGV, SIG_DFL );
		raise( SIGSEGV );
#endif//TRAP_SIGSEGV
	} else if ( sig == SIGTERM ) {
		ifl_halt();
		return;
	} else if ( sig == SIGINT ) {
		unpidfile(getpid(), cfg.pidfile);
		// Restart child with a core dumped
		// if( cfg.pid_child ) { printf( "Killing!\n" ); kill( cfg.pid_child, SIGQUIT ); }
		exit(0);
	}
}

void sig_setup() {
	signal( SIGHUP,  sig_handler );	
#ifdef  TRAP_SIGSEGV
	signal( SIGSEGV, sig_handler );
#endif//TRAP_SIGSEGV
	signal( SIGTERM, sig_handler );
	signal( SIGINT,  SIG_IGN     );
}

int pidfile( const char * pidfile = 0 )
{
	const char * cfile = "/var/run/ndsad.pid";
	const char *file = cfile;
	int err = 0;
	int fd = 0;
	if (pidfile)
		file = pidfile;
	fd = open( file, O_WRONLY|O_CREAT|O_EXCL, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
	if( fd==-1 && errno == EEXIST )
	{
		FILE* fp = fopen( file, "r" );
		bool exist = true;
		if( fp!=0 )
		{
			int pid;
			if( fscanf( fp, "%i", &pid ) == 1 )
			{
				char buf[1024];
				snprintf( buf, 1000, "/proc/%i/cmdline", pid );
				fclose( fp );
				fp = fopen( buf, "r" );
				if( fp!= 0 )
				{
					fgets( buf, 1000, fp );
					fclose( fp );
					if( strncmp( "/netup/utm5/bin/ndsad", buf, 21 ) != 0 ) // FIXME
					{
						exist = false;
					}
				} else
				{
					exist = false;
				}
			}
		}
		if( exist )
		{
			writelog("Pid file found:");
			writelog(file);
			writelog("Check, if other instance is running");
			return -1;
		} else
		{
			writelog("Deleting pid file");
			unlink( file );
			fd = open( file, O_WRONLY|O_CREAT|O_EXCL, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
		}
	}
	if (fd > 0) {
		char buf[128];
		err = snprintf(buf, 128, "%d", getpid()); 
		if (err > 127 || err < 0)
			writelog("Unable to write to pid file");
		else
			write(fd, buf, err);
		close(fd);
		return 0;
	}
	if( errno == EEXIST )
	{
		writelog("Pid file found:");
		writelog(file);
		writelog("Check, if other instance is running");
	} else
	{
		writelog("Unable to create pidfile:");
		writelog(file);
		writelog(strerror(errno));
	}
	return -1;
}

int unpidfile( int pid_in, const char * pidfile )
{
	const char * cfile = "/var/run/ndsad.pid";
	const char *file = cfile;
	int err = 0;
	int fd = 0;
	int pid = pid_in;
	if (!pid)
		pid = getpid();
	if (pidfile)
		file = pidfile;
	fd = open( file, O_RDONLY );
	if (fd > 0) {
		char buf[128];
		err = read(fd, buf, 128);
		if (err < 128)
			buf[err] = 0;
		else
			buf[127] = 0;
		err = atoi(buf);
		if (err != pid) {
			writelog("Unable to unlink pid file of another process");
			close(fd);
			return -1;
		}
		close(fd);
		err = unlink(file);
		if (err == -1) {
			writelog("Unable to unlink pid file:");
			writelog(file);
			writelog(strerror(errno));
			return -1;
		}
		return 0;
	} else {
		writelog("Unable to open pidfile:");
		writelog(file);
		writelog(strerror(errno));
	}
	return 0;
}

int watchdog() {
	char buf[128];
	time_t ts;
	writelog( "WatchDog: Dog waken..." );
	signal( SIGHUP,  SIG_IGN     );
	signal( SIGINT,  sig_handler );
	signal( SIGTERM, SIG_IGN     );
	signal( SIGSEGV, SIG_DFL     );
watchdog:
	pid_t child = fork();
	if( child < 0 ) {
		writelog( "WatchDog: Unable to fork..." );
		return 0;
	} else if( child ) {
		time( &ts );
		int stat, ps;
		cfg.pid_child = child;
		ps = snprintf( buf, 128, "WatchDog: child[%d] started on %s",
				child, ctime( &ts ) );
		if( ps < 128 ) buf[ps-1] = 0;
		writelog( buf );
		waitpid( child, &stat, 0 );
		cfg.pid_child = 0;
		if( WIFEXITED( stat ) ) {
			snprintf(buf,128,"WatchDog: child[%d]: %d return code...\n",
				   child, WEXITSTATUS(stat) );
			writelog( buf );
			writelog( "WatchDog: terminating..." );
			return 0;
		} else if ( WIFSIGNALED(stat) ) {
			snprintf(buf,128,"WatchDog: child[%d]: %s signal cought...\n",
				   child, signame[WTERMSIG(stat)] );
			writelog(buf);
			unpidfile(child, cfg.pidfile);
			if( WTERMSIG(stat) == SIGQUIT || WTERMSIG(stat) == SIGSEGV ) {
				writelog( "WatchDog: recovering abnormal termination..." );
				goto watchdog;
			}
			writelog( "WatchDog: terminating..." );
			return 0;
		}
		snprintf( buf, 128, "WatchDog: Child[%d]: Unknown state...", child );
		writelog( buf );
		writelog( "WatchDog: terminating..." );
		return 0;
	} else {
#ifndef WIN32
		sig_setup();
#endif
		return 1;
	}
}

#endif

#ifdef WIN32
#define PATHLEN 255

char* get_working_path()
{
	
	DWORD type;
	static char data[PATHLEN+1];
	DWORD size = PATHLEN;
	HKEY key;
	if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,REG_UTM5,0,KEY_READ,&key) != ERROR_SUCCESS)
	{
		return 0;
	}
	if (RegQueryValueEx(key,REG_BASEPATH,0,&type,(LPBYTE)&data,&size) != ERROR_SUCCESS)
	{
		return 0;
	}
	if (RegCloseKey(key) != ERROR_SUCCESS)
	{
		//error
	}
	
	return data;
}


string get_config_filename()
{
	string path = get_working_path();
	if (path.length() > 0) path += "\\" CONFIG_FILENAME;
	return path;
}
#endif


#ifdef WIN32
int start_system(int argc, char* argv[] ) { 
#else
int main( int argc, char * argv[] ) {
#endif

	/*
	 * INIT section - initialization, flag processing
	 */
	int i, j, loop = 1;
	int d_flag = 0;
	int w_flag = 0;
	int D_flag = 0; 
	int l_flag = 0;
	int s_flag = 0, s_val = 0;
	int retval = 0;
#ifdef WIN32
	string c_path = get_config_filename();
#else
	char _c_path[] = conf_path;
	string c_path = _c_path;
#endif
	char * l_path = 0;
#ifndef WIN32
	if( geteuid() ) {
		fprintf( stderr, "Warning: Not enough privelegies...\n" );
		fprintf( stderr, "Result is unpredictable!\n" );
	//              return -1;
	}
#endif
	// Process flags
	for( i = 0; i < argc; i++ ) {
		if( argv[i][0] == '-' ) {
			// Flag
			loop = 1;
			j = 1;
			while( argv[i][j] && loop ) {
			 switch( argv[i][j] ) {
				case 'v':
					 // Print version end exit
					print_version( argv[0] );
					return 1;
				case 'h':
					 // Print help end exit
					print_help( argv[0] );
					return 1;
				case 'D':
					// Dummy mode
					D_flag = 1;
					break;
				case 'w':
					// Wake WatchDog
					w_flag = 1;
					break;
				case 'd':
					// Daemonize
					d_flag = 1;
					break;
				case 's':
					// Statistical dump delay 
					if( i < argc - 1 ) {
						i++;
						s_flag = 1;
						s_val = atoi(argv[i]);
						loop = 0;
					}
					break;
				case 'c':
					// Configuration file path
					if( i < argc - 1 ) {
						i++;
						c_path = argv[i];
						loop = 0;
					}
					break;
				case 'l':
					// Log file path
					if( i < argc - 1 ) {
						i++;
						l_flag = 1;
						l_path = argv[i];
						if( l_path[0] == '-' && l_path[1] == 0 ) {
							l_path = 0;
						}
						loop = 0;
					}
					break;
				default:
					break;
			 }
			 j++;
			}
		}
	}
	cfg.pidfile = 0;
	cfg.log = 0;
	cfg.file = strdup(c_path.c_str());

	if( strchr( argv[0], '/' ) ) {
		cfg.bin = strdup(strrchr(argv[0], '/')+1);
	} else
		cfg.bin  = strdup(argv[0]);
	/*
	 * INIT section end
	 */
#ifdef WIN32
	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(1,1),&wsadata) != 0)
	{
		printf("WSAStartup error: %d\n",WSAGetLastError());
		return 1;
	}
#endif
	/*
	 * SETUP section - different complex initializations -
	 * such as signal handlers and so on...
	 */
#ifndef WIN32
	if( d_flag ) {
		if( !daemonize() )
			return 1;
	}
#else
    char* path = get_working_path();
    if (path && _chdir(path))
    {
		cerr << "Unable to chdir to " << path << "\n";
	}

#endif
	load_config();
	if( D_flag ) cfg.dummy_mode = 1;
	if( s_flag ) cfg.stat       = s_val;
	if( l_flag ) {
		if( cfg.log ) delete cfg.log;
		cfg.log = 0;
		if( l_path ) cfg.log = strdup( l_path );
	}
	openlog();
#ifdef WIN32
	service_started();
#endif
	
#ifndef WIN32 // watchdog not yet supported on win32
	if( w_flag ) {
		//WatchDog
		if( !watchdog() ) goto clean_sec;
	}
	signal( SIGINT,  sig_handler );
	if (pidfile(cfg.pidfile))
		return -1;
#endif
	cfg.pid_child = getpid();

#ifdef __HAVE_ULOG
#ifdef __OS_LINUX_LIKE
	ifl_add( "ulog_iface0" );
	run_linux_ulog();
#endif
#endif

#ifdef __HAVE_BSD_DIVERT
#ifdef __OS_BSD_LIKE
	ifl_add("bsd_divert_iface0");
	run_bsd_divert();
#endif
#endif

	ifi_update();
	/*
	 * SETUP section end
	 */

	/*
	 * CALL section - worker calls
	 */
	init_scaner();
	/*
	 * CALL section end
	 */
	/*
	 * CLEAN section
	 */
#ifndef WIN32
clean_sec:
#endif

#ifndef WIN32
	unpidfile(getpid(), cfg.pidfile);
#endif
	closelog();
	delete cfg.file;
	delete cfg.log;
	delete cfg.bin;
	delete   nfpool;
	delete ifl_pool;
	return retval;
}
