/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementProblemDescriptorImpl
implements DomElementProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(DomElementProblemDescriptorImpl.class);
    private final DomElement myDomElement;
    private final HighlightSeverity mySeverity;
    private final @InspectionMessage String myMessage;
    private final LocalQuickFix[] myFixes;
    private Pair<TextRange, PsiElement> myPair;
    static final Pair<TextRange, PsiElement> NO_PROBLEM = new Pair(null, null);
    private final ProblemHighlightType myHighlightType;

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(0);
        }
        this(domElement, message, type, LocalQuickFix.EMPTY_ARRAY);
    }

    DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(1);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(2);
        }
        this(domElement, message, type, (TextRange)null, (ProblemHighlightType)null, fixes);
    }

    DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type, @Nullable TextRange textRange, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (domElement == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(4);
        }
        this.myDomElement = domElement;
        XmlElement element = domElement.getXmlElement();
        if (element == null || !ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        this.mySeverity = type;
        this.myMessage = message;
        LocalQuickFix[] localQuickFixArray = this.myFixes = ArrayUtil.contains(null, (Object[])fixes) ? (LocalQuickFix[])ContainerUtil.mapNotNull((Object[])fixes, (Function)FunctionUtil.id(), (Object[])LocalQuickFix.EMPTY_ARRAY) : fixes;
        if (textRange != null) {
            PsiElement psiElement = this.getPsiElement();
            LOG.assertTrue(psiElement != null, (Object)"Problems with explicit text range can't be created for DOM elements without underlying XML element");
            assert (psiElement.isValid());
            this.myPair = Pair.create((Object)textRange, (Object)psiElement);
        }
        this.myHighlightType = highlightType;
    }

    @NotNull
    public DomElement getDomElement() {
        DomElement domElement = this.myDomElement;
        if (domElement == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(5);
        }
        return domElement;
    }

    @NotNull
    public HighlightSeverity getHighlightSeverity() {
        HighlightSeverity highlightSeverity = this.mySeverity;
        if (highlightSeverity == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(6);
        }
        return highlightSeverity;
    }

    @NotNull
    public String getDescriptionTemplate() {
        String string = this.myMessage == null ? "" : this.myMessage;
        if (string == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    public @NotNull LocalQuickFix @Nullable [] getFixes() {
        return this.myFixes;
    }

    public void highlightWholeElement() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof XmlAttributeValue) {
            assert (psiElement.isValid()) : psiElement;
            PsiElement attr = psiElement.getParent();
            this.myPair = Pair.create((Object)new TextRange(0, attr.getTextLength()), (Object)attr);
        } else if (psiElement != null) {
            assert (psiElement.isValid()) : psiElement;
            XmlTag tag = (XmlTag)(psiElement instanceof XmlTag ? psiElement : psiElement.getParent());
            this.myPair = new Pair((Object)new TextRange(0, tag.getTextLength()), (Object)tag);
        }
    }

    Pair<TextRange, PsiElement> getProblemRange() {
        PsiElement element;
        if (this.myPair == null) {
            this.myPair = this.computeProblemRange();
        }
        if ((element = (PsiElement)this.myPair.second) != null) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        return this.myPair;
    }

    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiElement element = this.getPsiElement();
        if (element != null) {
            String value;
            assert (element.isValid()) : element;
            if (element instanceof XmlTag) {
                Pair pair = DomUtil.getProblemRange((XmlTag)((XmlTag)element));
                if (pair == null) {
                    DomElementProblemDescriptorImpl.$$$reportNull$$$0(8);
                }
                return pair;
            }
            TextRange range = TextRange.from((int)0, (int)element.getTextLength());
            if (element instanceof XmlAttributeValue && StringUtil.isNotEmpty((String)(value = ((XmlAttributeValue)element).getValue()))) {
                range = TextRange.from((int)element.getText().indexOf(value), (int)value.length());
            }
            Pair pair = Pair.create((Object)range, (Object)element);
            if (pair == null) {
                DomElementProblemDescriptorImpl.$$$reportNull$$$0(9);
            }
            return pair;
        }
        XmlTag tag = this.getParentXmlTag();
        if (tag != null) {
            Pair pair = DomUtil.getProblemRange((XmlTag)tag);
            if (pair == null) {
                DomElementProblemDescriptorImpl.$$$reportNull$$$0(10);
            }
            return pair;
        }
        Pair<TextRange, PsiElement> pair = NO_PROBLEM;
        if (pair == null) {
            DomElementProblemDescriptorImpl.$$$reportNull$$$0(11);
        }
        return pair;
    }

    public String toString() {
        return String.valueOf(this.myDomElement) + "; " + this.myMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomElementProblemDescriptorImpl that = (DomElementProblemDescriptorImpl)o;
        if (!Objects.equals(this.myDomElement, that.myDomElement)) {
            return false;
        }
        if (!this.myMessage.equals(that.myMessage)) {
            return false;
        }
        return this.mySeverity.equals((Object)that.mySeverity);
    }

    public int hashCode() {
        int result2 = this.myDomElement != null ? this.myDomElement.hashCode() : 0;
        result2 = 31 * result2 + this.mySeverity.hashCode();
        result2 = 31 * result2 + this.myMessage.hashCode();
        return result2;
    }

    @Nullable
    private PsiElement getPsiElement() {
        XmlText[] textElements;
        if (this.myDomElement instanceof DomFileElement) {
            return ((DomFileElement)this.myDomElement).getFile();
        }
        DomElement domElement = this.myDomElement;
        if (domElement instanceof GenericAttributeValue) {
            GenericAttributeValue attributeValue = (GenericAttributeValue)domElement;
            XmlAttributeValue value = attributeValue.getXmlAttributeValue();
            return value != null && StringUtil.isNotEmpty((String)value.getText()) ? value : attributeValue.getXmlElement();
        }
        XmlTag tag = this.myDomElement.getXmlTag();
        if (this.myDomElement instanceof GenericValue && tag != null && (textElements = tag.getValue().getTextElements()).length > 0) {
            return textElements[0];
        }
        return tag;
    }

    @Nullable
    private XmlTag getParentXmlTag() {
        for (DomElement parent = this.myDomElement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getXmlTag() == null) continue;
            return parent.getXmlTag();
        }
        return null;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/DomElementProblemDescriptorImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionTemplate";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeProblemRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

