/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl;

import com.intellij.codeInsight.inline.completion.logs.InlineCompletionLogsContainer;
import com.intellij.ml.inline.completion.impl.MLCompletionParameters;
import com.intellij.ml.inline.completion.impl.configuration.MLCompletionSettings;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionLanguageKit;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultiLinePolicies;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionMultiLinePolicy;
import com.intellij.ml.inline.completion.impl.kit.MultilinePolicyType;
import com.intellij.ml.inline.completion.impl.postprocessing.MLCompletionPipelineConfiguration;
import com.intellij.openapi.project.Project;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest;", "", "parameters", "Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;)V", "getParameters", "()Lcom/intellij/ml/inline/completion/impl/MLCompletionParameters;", "languageKit", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "getLanguageKit", "()Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionLanguageKit;", "pipelineConfiguration", "Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "getPipelineConfiguration", "()Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineConfiguration;", "pipelineConfiguration$delegate", "Lkotlin/Lazy;", "multiLinePolicy", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionMultiLinePolicy;", "type", "Lcom/intellij/ml/inline/completion/impl/kit/MultilinePolicyType;", "logsContainer", "Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsContainer;", "getLogsContainer", "()Lcom/intellij/codeInsight/inline/completion/logs/InlineCompletionLogsContainer;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "getSessionLogger", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "Snapshot", "intellij.fullLine.core.completion"})
public abstract class MLCompletionRequest {
    @NotNull
    private final MLCompletionParameters parameters;
    @NotNull
    private final Lazy pipelineConfiguration$delegate;
    @Nullable
    private final InlineCompletionLogsContainer logsContainer;
    @NotNull
    private final MLCompletionSessionEventsReporter sessionLogger;

    public MLCompletionRequest(@NotNull MLCompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        this.parameters = parameters;
        this.pipelineConfiguration$delegate = LazyKt.lazy(() -> MLCompletionRequest.pipelineConfiguration_delegate$lambda$0(this));
        this.logsContainer = InlineCompletionLogsContainer.Companion.get(this.parameters.getEditor());
        this.sessionLogger = new MLCompletionSessionEventsReporter(this.parameters.getInlineRequest().getRequestId(), this.logsContainer);
    }

    @NotNull
    public final MLCompletionParameters getParameters() {
        return this.parameters;
    }

    @NotNull
    public abstract MLCompletionLanguageKit getLanguageKit();

    @NotNull
    public final MLCompletionPipelineConfiguration getPipelineConfiguration() {
        Lazy lazy = this.pipelineConfiguration$delegate;
        return (MLCompletionPipelineConfiguration)lazy.getValue();
    }

    @NotNull
    public MLCompletionMultiLinePolicy multiLinePolicy(@NotNull MultilinePolicyType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        MLCompletionSettings.State settings = MLCompletionSettings.Companion.getInstance().getState();
        MultilinePolicyType policyType = !settings.getMultiLineAllowed() ? MultilinePolicyType.DISABLED : type;
        return MLCompletionMultiLinePolicies.INSTANCE.toPolicy(policyType, this);
    }

    @Nullable
    public final InlineCompletionLogsContainer getLogsContainer() {
        return this.logsContainer;
    }

    @NotNull
    public final MLCompletionSessionEventsReporter getSessionLogger() {
        return this.sessionLogger;
    }

    private static final MLCompletionPipelineConfiguration pipelineConfiguration_delegate$lambda$0(MLCompletionRequest this$0) {
        return this$0.getLanguageKit().getPipelineConfigurator().configure(this$0.parameters);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/inline/completion/impl/MLCompletionRequest$Snapshot;", "", "project", "Lcom/intellij/openapi/project/Project;", "sessionLogger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSessionLogger", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionSessionEventsReporter;", "intellij.fullLine.core.completion"})
    public static abstract class Snapshot {
        @NotNull
        private final Project project;
        @NotNull
        private final MLCompletionSessionEventsReporter sessionLogger;

        public Snapshot(@NotNull Project project, @NotNull MLCompletionSessionEventsReporter sessionLogger) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)sessionLogger, (String)"sessionLogger");
            this.project = project;
            this.sessionLogger = sessionLogger;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final MLCompletionSessionEventsReporter getSessionLogger() {
            return this.sessionLogger;
        }
    }
}

