/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.NativeCall;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "<init>", "()V", "fillTextInsideNode", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "fillNativeText", "Lcom/intellij/profiler/model/NativeCall;", "Companion", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nNativeCallStackElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeCallStackElementRenderer.kt\ncom/intellij/profiler/ui/NativeCallStackElementRenderer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n15#2:46\n*S KotlinDebug\n*F\n+ 1 NativeCallStackElementRenderer.kt\ncom/intellij/profiler/ui/NativeCallStackElementRenderer\n*L\n41#1:46\n*E\n"})
public class NativeCallStackElementRenderer
extends BaseCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final NativeCallStackElementRenderer INSTANCE;

    protected NativeCallStackElementRenderer() {
    }

    @Override
    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        if (node instanceof NativeCall) {
            try {
                return this.fillNativeText((NativeCall)node, rect, fontMetrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.fillTextInsideNode(node, rect, fontMetrics);
    }

    private final String fillNativeText(NativeCall node, Rectangle2D rect, FontMetrics fontMetrics) {
        double maxWidth = rect.getWidth() - 0.0;
        String text = this.getText(node);
        if ((double)fontMetrics.stringWidth(text) < maxWidth) {
            return text;
        }
        String methodWithClassOrFunction = node.methodWithClassOrFunction();
        if ((double)fontMetrics.stringWidth(methodWithClassOrFunction) < maxWidth) {
            return methodWithClassOrFunction;
        }
        String methodWithClassOrFunctionNoArgs = StringsKt.substringBefore$default((String)methodWithClassOrFunction, (String)"(", null, (int)2, null);
        if ((double)fontMetrics.stringWidth(methodWithClassOrFunctionNoArgs) < maxWidth) {
            return methodWithClassOrFunctionNoArgs;
        }
        Pair<List<String>, String> pair = this.classPartsAndMethod(methodWithClassOrFunctionNoArgs, "::");
        List classParts = (List)pair.component1();
        String method = (String)pair.component2();
        if (!((Collection)classParts).isEmpty()) {
            try {
                String abbrevClass = CollectionsKt.joinToString$default((Iterable)classParts, (CharSequence)"::", null, null, (int)0, null, NativeCallStackElementRenderer::fillNativeText$lambda$0, (int)30, null) + "::" + method;
                if ((double)fontMetrics.stringWidth(abbrevClass) < maxWidth) {
                    return abbrevClass;
                }
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
            }
        }
        if ((double)fontMetrics.stringWidth(method) < maxWidth) {
            return method;
        }
        return super.fillTextInsideNode(node, rect, fontMetrics);
    }

    private static final CharSequence fillNativeText$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(StringsKt.first((CharSequence)it));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NativeCallStackElementRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        INSTANCE = new NativeCallStackElementRenderer();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/profiler/ui/NativeCallStackElementRenderer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "INSTANCE", "Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "getINSTANCE", "()Lcom/intellij/profiler/ui/NativeCallStackElementRenderer;", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NativeCallStackElementRenderer getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

