/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project.roots;

import com.intellij.lang.puppet.project.PuppetProjectListener;
import com.intellij.lang.puppet.project.PuppetProjectManager;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.lang.puppet.project.roots.PuppetRootIndex;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PuppetDirectoryIndex
implements Disposable {
    private static final Logger LOG = Logger.getInstance(PuppetDirectoryIndex.class);
    private final Project myProject;
    private final MessageBusConnection myConnection;
    private volatile boolean myDisposed;
    private volatile PuppetRootIndex myRootIndex;

    public PuppetDirectoryIndex(Project project) {
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect((Disposable)this);
        this.subscribeToFileChanges();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myRootIndex = null;
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PuppetDirectoryIndex.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$1", "fileTypesChanged"));
            }
        });
        this.myConnection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PuppetDirectoryIndex.this.myRootIndex = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$2", "rootsChanged"));
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                PuppetRootIndex rootIndex;
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((rootIndex = PuppetDirectoryIndex.this.myRootIndex) != null && rootIndex.resetOnEvents(events)) {
                    PuppetDirectoryIndex.this.myRootIndex = null;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex$3", "after"));
            }
        });
        this.myConnection.subscribe(PuppetProjectManager.PUPPET_PROJECT_TOPIC, (Object)new PuppetProjectListener(){

            @Override
            public void projectUpdated() {
                PuppetDirectoryIndex.this.myRootIndex = null;
            }
        });
    }

    protected void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    @NotNull
    private PuppetRootIndex getRootIndex() {
        PuppetRootIndex rootIndex = this.myRootIndex;
        if (rootIndex == null) {
            this.myRootIndex = rootIndex = new PuppetRootIndex(this.myProject);
        }
        PuppetRootIndex puppetRootIndex = rootIndex;
        if (puppetRootIndex == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(0);
        }
        return puppetRootIndex;
    }

    @NotNull
    public PuppetDirectoryInfo getInfoForFile(@NotNull VirtualFile file) {
        if (file == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(1);
        }
        this.checkAvailability();
        this.dispatchPendingEvents();
        if (!(file instanceof NewVirtualFile)) {
            PuppetDirectoryInfo puppetDirectoryInfo = PuppetDirectoryInfo.UNAVAILABLE;
            if (puppetDirectoryInfo == null) {
                PuppetDirectoryIndex.$$$reportNull$$$0(2);
            }
            return puppetDirectoryInfo;
        }
        PuppetDirectoryInfo puppetDirectoryInfo = this.getRootIndex().getInfoForFile(file);
        if (puppetDirectoryInfo == null) {
            PuppetDirectoryIndex.$$$reportNull$$$0(3);
        }
        return puppetDirectoryInfo;
    }

    private void checkAvailability() {
        if (this.myDisposed) {
            ProgressManager.checkCanceled();
            LOG.error("Directory index is already disposed for " + String.valueOf(this.myProject));
        }
    }

    public static PuppetDirectoryIndex getInstance(Project project) {
        if (project.isDefault()) {
            throw new AssertionError((Object)"Must not call PuppetDirectoryIndex for default project");
        }
        return (PuppetDirectoryIndex)project.getService(PuppetDirectoryIndex.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/roots/PuppetDirectoryIndex";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInfoForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

