/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.FileHistoryLogUiProvider;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.history.VcsLogDirectoryHistoryProvider;
import com.intellij.vcs.log.history.VcsLogSingleFileHistoryProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.VisiblePack;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a4\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\u0001H\u0000\u001a*\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\b\u0010\u000e\u001a\u00020\u0001H\u0007\u001a\u001a\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u001a2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0001H\u0002\u001a,\u0010\u001c\u001a\u00020\u0013*\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0001H\u0002\u001a \u0010 \u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0001H\u0002\u001a(\u0010#\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006$"}, d2={"canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "selectProvider", "Lcom/intellij/vcs/log/history/FileHistoryLogUiProvider;", "isNewHistoryEnabled", "isNewFileHistoryAvailable", "logProvider", "Lcom/intellij/vcs/log/VcsLogProvider;", "selectRowWhenOpen", "", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "ui", "firstTime", "jumpToNearestCommit", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "silently", "getCorrectedPath", "path", "isRevisionHistory", "triggerFileHistoryUsage", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogFileHistoryProviderImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n295#2,2:204\n*S KotlinDebug\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogFileHistoryProviderImplKt\n*L\n45#1:204,2\n*E\n"})
public final class VcsLogFileHistoryProviderImplKt {
    public static final boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        return VcsLogFileHistoryProviderImplKt.selectProvider(project, paths, revisionNumber) != null;
    }

    @Nullable
    public static final VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber, boolean selectRow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        FileHistoryLogUiProvider fileHistoryLogUiProvider = VcsLogFileHistoryProviderImplKt.selectProvider(project, paths, revisionNumber);
        return fileHistoryLogUiProvider != null ? fileHistoryLogUiProvider.showFileHistoryUi(project, paths, revisionNumber, selectRow) : null;
    }

    public static /* synthetic */ VcsLogUiEx showFileHistoryUi$default(Project project, Collection collection, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return VcsLogFileHistoryProviderImplKt.showFileHistoryUi(project, collection, string, bl);
    }

    private static final FileHistoryLogUiProvider selectProvider(Project project, Collection<? extends FilePath> paths, String revisionNumber) {
        Object v0;
        block1: {
            Object[] objectArray = new FileHistoryLogUiProvider[]{VcsLogSingleFileHistoryProvider.INSTANCE, VcsLogDirectoryHistoryProvider.INSTANCE};
            Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FileHistoryLogUiProvider it = (FileHistoryLogUiProvider)element$iv;
                boolean bl = false;
                if (!it.canShowFileHistory(project, paths, revisionNumber)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @ApiStatus.Internal
    public static final boolean isNewHistoryEnabled() {
        return Registry.Companion.is("vcs.new.history");
    }

    @ApiStatus.Internal
    public static final boolean isNewFileHistoryAvailable(@NotNull Project project, @Nullable VcsLogProvider logProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VcsLogProvider vcsLogProvider = logProvider;
        return (vcsLogProvider != null ? vcsLogProvider.getDiffHandler() : null) != null && logProvider.getFileHistoryHandler(project) != null;
    }

    private static final void selectRowWhenOpen(VcsLogManager logManager2, Hash hash, VirtualFile root, VcsLogUiEx ui, boolean firstTime) {
        if (hash != null) {
            VcsLogStorage vcsLogStorage = logManager2.getDataManager().getStorage();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogStorage, (String)"getStorage(...)");
            VcsLogFileHistoryProviderImplKt.jumpToNearestCommit(ui, vcsLogStorage, hash, root, true);
        } else if (firstTime) {
            VcsLogNavigationUtil.jumpToGraphRow(ui, 0, true, true);
        }
    }

    private static final void jumpToNearestCommit(VcsLogUiEx $this$jumpToNearestCommit, VcsLogStorage storage, Hash hash, VirtualFile root, boolean silently) {
        $this$jumpToNearestCommit.jumpTo(hash, (arg_0, arg_1) -> VcsLogFileHistoryProviderImplKt.jumpToNearestCommit$lambda$2((arg_0, arg_1) -> VcsLogFileHistoryProviderImplKt.jumpToNearestCommit$lambda$1(storage, root, arg_0, arg_1), arg_0, arg_1), (SettableFuture<VcsLogUiEx.JumpResult>)SettableFuture.create(), silently, true);
    }

    private static final FilePath getCorrectedPath(Project project, FilePath path, boolean isRevisionHistory) {
        if (isRevisionHistory) {
            return path;
        }
        FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(...)");
        return filePath;
    }

    private static final void triggerFileHistoryUsage(Project project, Collection<? extends FilePath> paths, Hash hash) {
        String kind = paths.size() > 1 ? "multiple" : (((FilePath)CollectionsKt.first((Iterable)paths)).isDirectory() ? "folder" : "file");
        VcsLogUsageTriggerCollector.triggerFileHistoryUsage(project, kind, hash != null);
    }

    private static final Integer jumpToNearestCommit$lambda$1(VcsLogStorage $storage, VirtualFile $root, VisiblePack visiblePack, Hash h) {
        Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
        Hash hash = h;
        Intrinsics.checkNotNull((Object)hash);
        if (!$storage.containsCommit(new CommitId(hash, $root))) {
            return -1;
        }
        int commitIndex = $storage.getCommitIndex(h, $root);
        Integer rowIndex = visiblePack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
        if (rowIndex == null) {
            rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, visiblePack);
        }
        Integer n = rowIndex;
        return n != null ? n : -2;
    }

    private static final Integer jumpToNearestCommit$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ FileHistoryLogUiProvider access$selectProvider(Project project, Collection paths, String revisionNumber) {
        return VcsLogFileHistoryProviderImplKt.selectProvider(project, paths, revisionNumber);
    }

    public static final /* synthetic */ void access$triggerFileHistoryUsage(Project project, Collection paths, Hash hash) {
        VcsLogFileHistoryProviderImplKt.triggerFileHistoryUsage(project, paths, hash);
    }

    public static final /* synthetic */ void access$selectRowWhenOpen(VcsLogManager logManager2, Hash hash, VirtualFile root, VcsLogUiEx ui, boolean firstTime) {
        VcsLogFileHistoryProviderImplKt.selectRowWhenOpen(logManager2, hash, root, ui, firstTime);
    }

    public static final /* synthetic */ FilePath access$getCorrectedPath(Project project, FilePath path, boolean isRevisionHistory) {
        return VcsLogFileHistoryProviderImplKt.getCorrectedPath(project, path, isRevisionHistory);
    }
}

