/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a4\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a.\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u00a3\u0001\u0010\u0013\u001a\u00020\f\"\u0004\b\u0000\u0010\u00142\u0006\u0010\u0015\u001a\u0002H\u00142`\u0010\u0016\u001a\\\u0012\u0013\u0012\u0011H\u0014\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001b\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"computeNotSparseGroups", "", "Lcom/intellij/xdebugger/frame/XValueGroup;", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "context", "Lorg/jetbrains/debugger/VariableContext;", "_fromInclusive", "", "toExclusive", "bucketThreshold", "addRanges", "", "ranges", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "isLast", "", "addGroups", "T", "data", "groupFactory", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "start", "end", "groupList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "_from", "limit", "bucketSize", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function4;Lcom/intellij/xdebugger/frame/XValueChildrenList;IIILorg/jetbrains/debugger/VariableContext;)V", "intellij.javascript.debugger.ui"})
public final class LazyVariablesGroupKt {
    @NotNull
    public static final List<XValueGroup> computeNotSparseGroups(@NotNull ObjectValue value, @NotNull VariableContext context, int _fromInclusive, int toExclusive, int bucketThreshold) {
        int fromInclusive;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int size = toExclusive - fromInclusive;
        int bucketSize = (int)Math.pow(bucketThreshold, Math.ceil(Math.log(size) / Math.log(bucketThreshold)) - 1.0);
        ArrayList<LazyVariablesGroup> groupList = new ArrayList<LazyVariablesGroup>((int)Math.ceil(size / bucketSize));
        for (fromInclusive = _fromInclusive; fromInclusive < toExclusive; fromInclusive += bucketSize) {
            groupList.add(new LazyVariablesGroup(value, fromInclusive, fromInclusive + (Math.min(bucketSize, toExclusive - fromInclusive) - 1), context, ValueType.NUMBER, false));
        }
        return groupList;
    }

    public static final void addRanges(@NotNull ObjectValue value, @NotNull int[] ranges, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        XValueChildrenList groupList = new XValueChildrenList(ranges.length / 2);
        int n = ranges.length;
        for (int i = 0; i < n; i += 2) {
            groupList.addTopGroup((XValueGroup)new LazyVariablesGroup(value, ranges[i], ranges[i + 1], context, null, false, 48, null));
        }
        node.addChildren(groupList, isLast);
    }

    public static final <T> void addGroups(T data, @NotNull Function4<? super T, ? super Integer, ? super Integer, ? super VariableContext, ? extends XValueGroup> groupFactory, @NotNull XValueChildrenList groupList, int _from, int limit, int bucketSize, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter(groupFactory, (String)"groupFactory");
        Intrinsics.checkNotNullParameter((Object)groupList, (String)"groupList");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int from = _from;
        int to = Math.min(bucketSize, limit);
        boolean done = false;
        do {
            int groupFrom = from;
            int groupTo = to;
            if ((to = (from += bucketSize) + Math.min(bucketSize, limit - from)) - from == 1) {
                ++groupTo;
                done = true;
            }
            groupList.addTopGroup((XValueGroup)groupFactory.invoke(data, (Object)groupFrom, (Object)groupTo, (Object)context));
        } while (from < limit && !done);
    }
}

