/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ES6ChangeUtil {
    private ES6ChangeUtil() {
    }

    @Nullable
    public static JSProperty replaceWithShorthand(@NotNull JSProperty source) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(0);
        }
        if (source.collapseToShorthand()) {
            return source;
        }
        return null;
    }

    public static JSProperty expandShorthandProperty(@NotNull JSProperty source) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(1);
        }
        if (source.expandShorthand()) {
            return source;
        }
        return null;
    }

    public static JSProperty expandShorthandPropertyWithValue(@NotNull JSProperty source, @NotNull String value) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ES6ChangeUtil.$$$reportNull$$$0(3);
        }
        String text = String.format("{%s:%s}", source.getName(), value);
        return ES6ChangeUtil.replacePropertyWithText(source, text);
    }

    public static void expandShorthandPropertyWithName(@NotNull JSProperty source, @NotNull String name) {
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(4);
        }
        if (name == null) {
            ES6ChangeUtil.$$$reportNull$$$0(5);
        }
        String text = String.format("{%s:%s}", name, source.getName());
        ES6ChangeUtil.replacePropertyWithText(source, text);
    }

    @Nullable
    public static JSDestructuringProperty replaceWithShorthand(@NotNull JSDestructuringProperty property) {
        JSInitializerOwner element;
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(6);
        }
        if ((element = property.getDestructuringElement()) == null) {
            return null;
        }
        JSDestructuringProperty replacement = ES6ChangeUtil.destructuringPropertyFromText(element.getText(), property);
        return (JSDestructuringProperty)property.replace((PsiElement)replacement);
    }

    @Nullable
    public static JSDestructuringProperty expandDestructuringProperty(@NotNull JSDestructuringShorthandedProperty property) {
        String name;
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(7);
        }
        if ((name = property.getName()) == null) {
            return null;
        }
        return ES6ChangeUtil.expandDestructuringPropertyWithVariableName(property, name);
    }

    @NotNull
    public static JSDestructuringProperty expandDestructuringPropertyWithVariableName(@NotNull JSDestructuringShorthandedProperty property, @NotNull String variableName) {
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(8);
        }
        if (variableName == null) {
            ES6ChangeUtil.$$$reportNull$$$0(9);
        }
        Object text = String.format("%s : %s", property.getName(), variableName);
        JSVariable variable = property.getDestructuringElement();
        if (variable != null && variable.getInitializer() != null) {
            text = (String)text + "=" + variable.getInitializer().getText();
        }
        JSDestructuringProperty expanded = ES6ChangeUtil.destructuringPropertyFromText((String)text, property);
        JSDestructuringProperty jSDestructuringProperty = (JSDestructuringProperty)property.replace((PsiElement)expanded);
        if (jSDestructuringProperty == null) {
            ES6ChangeUtil.$$$reportNull$$$0(10);
        }
        return jSDestructuringProperty;
    }

    private static JSDestructuringProperty destructuringPropertyFromText(String text, @NotNull JSDestructuringProperty property) {
        if (property == null) {
            ES6ChangeUtil.$$$reportNull$$$0(11);
        }
        PsiElement container = JSDestructuringUtil.getParentSkippingDestructuring(property);
        JSDestructuringElement destructuringElement = (JSDestructuringElement)JSPsiElementFactory.createParameterOrVariableItem(String.format("{%s}", text), (PsiElement)property, container instanceof JSCatchBlock, container instanceof JSParameterList);
        return (JSDestructuringProperty)SyntaxTraverser.psiTraverser((PsiElement)destructuringElement).filter(JSDestructuringProperty.class).first();
    }

    private static JSProperty replacePropertyWithText(@NotNull JSProperty source, @NotNull String text) {
        JSObjectLiteralExpression jsObjectLiteralExpression;
        if (source == null) {
            ES6ChangeUtil.$$$reportNull$$$0(12);
        }
        if (text == null) {
            ES6ChangeUtil.$$$reportNull$$$0(13);
        }
        if ((jsObjectLiteralExpression = JSChangeUtil.createExpressionPsiWithContext(text, (PsiElement)source, JSObjectLiteralExpression.class)) == null) {
            return source;
        }
        return (JSProperty)source.replace((PsiElement)Objects.requireNonNull(jsObjectLiteralExpression.getFirstProperty()));
    }

    public static void addDestructuringProperty(@NotNull JSDestructuringObject destructuringObject, @NotNull String newName) {
        if (destructuringObject == null) {
            ES6ChangeUtil.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            ES6ChangeUtil.$$$reportNull$$$0(15);
        }
        JSDestructuringProperty[] properties2 = destructuringObject.getProperties();
        JSDestructuringProperty newProperty = ES6ChangeUtil.destructuringPropertyFromText(newName, properties2[0]);
        PsiElement comma = JSChangeUtil.createTokenElement((PsiElement)destructuringObject, JSTokenTypes.COMMA, ",");
        comma = destructuringObject.addAfter(comma, (PsiElement)properties2[properties2.length - 1]);
        destructuringObject.addAfter((PsiElement)newProperty, comma);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringObject";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/ES6ChangeUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDestructuringPropertyWithVariableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceWithShorthand";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "expandShorthandProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "expandShorthandPropertyWithValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "expandShorthandPropertyWithName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expandDestructuringProperty";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandDestructuringPropertyWithVariableName";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "destructuringPropertyFromText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replacePropertyWithText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addDestructuringProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

