/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementImpl
extends CompositePsiElement
implements JSElement {
    private static final Key<Language> LANGUAGE_KEY = Key.create((String)"js.element.language");

    public JSElementImpl(IElementType elementType) {
        super(elementType);
    }

    @NotNull
    public Language getLanguage() {
        Language language = (Language)this.getUserData(LANGUAGE_KEY);
        if (language == null) {
            language = DialectDetector.calculateJSLanguage((PsiElement)this);
            this.putUserData(LANGUAGE_KEY, language);
        }
        Language language2 = language;
        if (language2 == null) {
            JSElementImpl.$$$reportNull$$$0(0);
        }
        return language2;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSElementImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSElement(this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return JSElementImpl.toStringImpl(this);
    }

    @NotNull
    protected static String toStringImpl(JSElement element) {
        String classname = element.getClass().getName();
        classname = StringUtil.trimEnd((String)classname, (String)"Impl");
        classname = classname.substring(classname.lastIndexOf(".") + 1);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (element instanceof JSNamedElement) {
                classname = JSElementImpl.concatName(classname, element.getName());
            } else if (element instanceof JSPsiReferenceElement) {
                JSPsiReferenceElement referenceElement = (JSPsiReferenceElement)element;
                classname = JSElementImpl.concatName(classname, referenceElement.getReferenceName());
            } else if (element instanceof TypeScriptSingleType) {
                TypeScriptSingleType singleType = (TypeScriptSingleType)element;
                classname = JSElementImpl.concatName(classname, singleType.getQualifiedTypeName());
            }
        }
        String string = classname;
        if (string == null) {
            JSElementImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static String concatName(@NotNull String classname, @Nullable String name) {
        if (classname == null) {
            JSElementImpl.$$$reportNull$$$0(3);
        }
        classname = (String)classname + ":";
        Object object = classname = (String)classname + (name != null ? name : JSFormatUtil.getAnonymousElementPresentation());
        if (object == null) {
            JSElementImpl.$$$reportNull$$$0(4);
        }
        return object;
    }

    public ItemPresentation getPresentation() {
        if (this instanceof JSPsiElementBase) {
            return new JSItemPresentation((JSPsiElementBase)((Object)this));
        }
        return null;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = JSResolveUtil.getResolveScope((PsiElement)this);
        if (globalSearchScope == null) {
            JSElementImpl.$$$reportNull$$$0(5);
        }
        return globalSearchScope;
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(6);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddBefore((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddBefore(element, anchor);
            }
        }
        return super.addBefore(element, anchor);
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(7);
        }
        if (JSChangeUtil.isSourceElementOrComment(element)) {
            if (JSChangeUtil.isStatementContainer((PsiElement)this)) {
                return JSChangeUtil.doAddAfter((PsiElement)this, element, anchor);
            }
            if (JSChangeUtil.isBlockStatementContainer(this) && anchor != null) {
                return JSChangeUtil.blockDoAddAfter(element, anchor);
            }
        }
        return super.addAfter(element, anchor);
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(8);
        }
        return this.addAfter(element, null);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            JSElementImpl.$$$reportNull$$$0(9);
        }
        return JSElementImpl.replaceInParent((PsiElement)this, newElement);
    }

    public static PsiElement replaceInParent(@NotNull PsiElement element, @NotNull PsiElement newElement) {
        if (element == null) {
            JSElementImpl.$$$reportNull$$$0(10);
        }
        if (newElement == null) {
            JSElementImpl.$$$reportNull$$$0(11);
        }
        ASTNode myNode = element.getNode();
        ASTNode result2 = newElement.getNode().copyElement();
        myNode.getTreeParent().replaceChild(myNode, result2);
        return result2.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSElementImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classname";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSElementImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "concatName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "concatName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceInParent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

