/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLibraries {
    public static final String BUNDLED_LIB_VERSION = "5.7.3";
    @NotNull
    private final Set<VirtualFile> myAllLibsIncludeInvalid;
    @NotNull
    private final IntSet myAllIds;
    @NotNull
    private final Map<String, VirtualFile> myAllLibs;
    @NotNull
    private final Set<VirtualFile> myDefaultLibs;
    private final MultiMap<String, VirtualFile> myLibraryMappingsCache = MultiMap.createConcurrent();
    private final long myModificationId;
    private final boolean myBundled;
    @Nullable
    private final File myLibFolder;
    @Nullable
    private final VirtualFile myLibVirtualFile;
    private static final Pattern ES_YEAR_LIB_NAME_PATTERN = Pattern.compile("^es(\\d{4,})\\.([\\w.-]+)$");

    public TypeScriptLibraries() {
        this(TypeScriptUtil.getTypeScriptExternalFolderFile(), null, true);
    }

    public TypeScriptLibraries(@Nullable File libFolder, @Nullable VirtualFile libVirtualFile, boolean isBundled) {
        assert (libFolder != null || libVirtualFile != null);
        this.myLibVirtualFile = libVirtualFile;
        this.myBundled = isBundled;
        this.myLibFolder = libFolder;
        VirtualFile defaultLib = this.getTypeScriptPredefinedLibDTsFile();
        HashSet<VirtualFile> libsIncludeInvalid = new HashSet<VirtualFile>(this.buildAllLibs());
        this.myDefaultLibs = TypeScriptLibraries.createLibSetIfValid(defaultLib);
        this.myAllLibsIncludeInvalid = Collections.unmodifiableSet(libsIncludeInvalid);
        this.myAllIds = new IntOpenHashSet(libsIncludeInvalid.stream().mapToInt(this::getVirtualFileId).toArray());
        this.myAllLibs = new HashMap<String, VirtualFile>(this.myAllLibsIncludeInvalid.size());
        for (VirtualFile file : this.myAllLibsIncludeInvalid) {
            if (!file.isValid()) continue;
            this.myAllLibs.put(TypeScriptLibraries.getLibraryName(file.getName()), file);
        }
        this.myAllLibs.putAll(TypeScriptLibraries.getAdditionalEsnextShortcuts(this.myAllLibs));
        int topLevelLibStamp = this.myLibFolder == null ? this.myLibVirtualFile.getPath().hashCode() : this.myLibFolder.getPath().hashCode();
        this.myModificationId = this.myAllLibs.values().stream().mapToLong(el -> el.getModificationStamp()).reduce((el, res) -> el + 23L * res).orElse(0L) + 31L * (long)topLevelLibStamp;
    }

    private static Map<String, VirtualFile> getAdditionalEsnextShortcuts(Map<String, VirtualFile> originalLibs) {
        HashMap<String, Integer> apiNameToMostRecentYear = new HashMap<String, Integer>();
        for (Map.Entry<String, VirtualFile> originalEntry : originalLibs.entrySet()) {
            String apiName;
            Matcher m = ES_YEAR_LIB_NAME_PATTERN.matcher(originalEntry.getKey());
            if (!m.matches() || originalLibs.containsKey("esnext." + (apiName = m.group(2)))) continue;
            Integer year = Integer.valueOf(m.group(1));
            if (apiNameToMostRecentYear.containsKey(apiName) && year <= (Integer)apiNameToMostRecentYear.get(apiName)) continue;
            apiNameToMostRecentYear.put(apiName, year);
        }
        HashMap<String, VirtualFile> additionalEsnextShortcuts = new HashMap<String, VirtualFile>();
        for (Map.Entry apiNameToMostRecentYearEntry : apiNameToMostRecentYear.entrySet()) {
            Integer year = (Integer)apiNameToMostRecentYearEntry.getValue();
            String apiName = (String)apiNameToMostRecentYearEntry.getKey();
            VirtualFile libFile = originalLibs.get("es" + year + "." + apiName);
            additionalEsnextShortcuts.put("esnext." + apiName, libFile);
        }
        return additionalEsnextShortcuts;
    }

    public int getVirtualFileId(@NotNull VirtualFile el) {
        if (el == null) {
            TypeScriptLibraries.$$$reportNull$$$0(0);
        }
        return el instanceof VirtualFileWithId ? ((VirtualFileWithId)el).getId() : el.hashCode();
    }

    @NotNull
    public Set<VirtualFile> getLibraries(@NotNull Project project, @NotNull String libraryName) {
        Set files;
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(2);
        }
        boolean hasValue = this.myLibraryMappingsCache.containsKey((Object)libraryName);
        Collection raw = this.myLibraryMappingsCache.get((Object)libraryName);
        Set set = files = raw instanceof Set ? (Set)raw : new HashSet(raw);
        if (hasValue) {
            Set set2 = files;
            if (set2 == null) {
                TypeScriptLibraries.$$$reportNull$$$0(3);
            }
            return set2;
        }
        Set<VirtualFile> toCache = this.getLibrariesNoCache(project, libraryName);
        this.myLibraryMappingsCache.put((Object)libraryName, toCache);
        Set<VirtualFile> set3 = toCache;
        if (set3 == null) {
            TypeScriptLibraries.$$$reportNull$$$0(4);
        }
        return set3;
    }

    private Set<VirtualFile> getLibrariesNoCache(@NotNull Project project, @NotNull String libraryName) {
        VirtualFile startLibraryFile;
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(5);
        }
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(6);
        }
        if ((startLibraryFile = this.getLibraryByName(libraryName)) == null) {
            this.myLibraryMappingsCache.put((Object)libraryName, (Collection)ContainerUtil.emptyList());
            return Collections.emptySet();
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        return service.getIncludedFiles(startLibraryFile);
    }

    @Nullable
    public VirtualFile getLibraryByName(@NotNull String libraryName) {
        if (libraryName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(7);
        }
        return this.myAllLibs.get(libraryName);
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean includeFile(@NotNull VirtualFile file) {
        if (file == null) {
            TypeScriptLibraries.$$$reportNull$$$0(8);
        }
        return this.myAllLibsIncludeInvalid.contains(file);
    }

    @NotNull
    public IntSet getAllIds() {
        IntSet intSet = this.myAllIds;
        if (intSet == null) {
            TypeScriptLibraries.$$$reportNull$$$0(9);
        }
        return intSet;
    }

    public boolean includeFileWithName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(10);
        }
        if (!TypeScriptLibraries.isTypeScriptLibraryFile(fileName)) {
            return false;
        }
        return this.myAllLibs.containsKey(TypeScriptLibraries.getLibraryName(fileName));
    }

    @NotNull
    public Collection<VirtualFile> getAllLibs() {
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static boolean isValid(@Nullable VirtualFile file) {
        return file != null && file.isValid();
    }

    public Set<VirtualFile> getLibsForTarget(@NotNull Project project, @Nullable TypeScriptConfig.LanguageTarget target2) {
        if (project == null) {
            TypeScriptLibraries.$$$reportNull$$$0(12);
        }
        if (target2 == null) {
            return Collections.emptySet();
        }
        Set<VirtualFile> libraries = this.getLibraries(project, target2.libName);
        if (!libraries.isEmpty()) {
            return libraries;
        }
        return this.myDefaultLibs;
    }

    @NotNull
    private static Set<VirtualFile> createLibSetIfValid(@Nullable VirtualFile file) {
        Set<Object> set = TypeScriptLibraries.isValid(file) ? Set.of(file) : Collections.emptySet();
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    private Set<VirtualFile> buildAllLibs() {
        if (this.myLibFolder != null) {
            return new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getLibFilesByIO(this.myLibFolder, (Predicate<? super String>)Conditions.alwaysTrue(), true));
        }
        assert (this.myLibVirtualFile != null);
        HashSet hashSet = ContainerUtil.newHashSet((Object[])this.myLibVirtualFile.getChildren());
        if (hashSet == null) {
            TypeScriptLibraries.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    @Nullable
    private VirtualFile getTypeScriptPredefinedLibDTsFile() {
        if (this.myLibVirtualFile != null) {
            return this.myLibVirtualFile.findChild("lib.d.ts");
        }
        assert (this.myLibFolder != null);
        LocalFileSystem localFileSystem = TypeScriptLibraries.getFileSystem();
        if (localFileSystem == null) {
            return null;
        }
        File ioFile = new File(this.myLibFolder, "lib.d.ts");
        return JSLibraryUtil.findFileByIoFile(localFileSystem, ioFile);
    }

    @Nullable
    private static LocalFileSystem getFileSystem() {
        return LocalFileSystem.getInstance();
    }

    @NotNull
    public Collection<VirtualFile> getFilesToRefresh() {
        LocalFileSystem system;
        VirtualFile parent;
        VirtualFile defaultLib = (VirtualFile)ContainerUtil.getFirstItem(this.myDefaultLibs);
        if (defaultLib != null && (parent = defaultLib.getParent()) != null && parent.isValid()) {
            List<VirtualFile> list = Collections.singletonList(parent);
            if (list == null) {
                TypeScriptLibraries.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (this.myLibFolder != null && (system = TypeScriptLibraries.getFileSystem()) != null) {
            VirtualFile file = JSLibraryUtil.findFileByIoFile(system, this.myLibFolder);
            List<VirtualFile> list = Collections.singletonList(file);
            if (list == null) {
                TypeScriptLibraries.$$$reportNull$$$0(16);
            }
            return list;
        }
        Set<VirtualFile> set = this.myAllLibsIncludeInvalid;
        if (set == null) {
            TypeScriptLibraries.$$$reportNull$$$0(17);
        }
        return set;
    }

    public long getModificationId() {
        return this.myModificationId;
    }

    @NotNull
    public TypeScriptLibraries copy() {
        return new TypeScriptLibraries(this.myLibFolder, this.myLibVirtualFile, this.myBundled);
    }

    public boolean isValid() {
        return !this.myAllLibsIncludeInvalid.isEmpty() && this.myAllLibsIncludeInvalid.stream().allMatch(VirtualFile::isValid);
    }

    @NotNull
    public static String getLibraryName(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(18);
        }
        int end = fileName.length() - ".d.ts".length();
        int start = "lib.".length();
        String string = "lib.d.ts".equals(fileName) ? fileName : fileName.substring(start, end);
        if (string == null) {
            TypeScriptLibraries.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String wrapAsLibraryFile(@NotNull String name) {
        if (name == null) {
            TypeScriptLibraries.$$$reportNull$$$0(20);
        }
        String string = "lib." + name + ".d.ts";
        if (string == null) {
            TypeScriptLibraries.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static boolean isTypeScriptLibraryFile(@NotNull String fileName) {
        if (fileName == null) {
            TypeScriptLibraries.$$$reportNull$$$0(22);
        }
        return fileName.startsWith("lib.") && fileName.endsWith(".d.ts");
    }

    @NotNull
    public static String trimLibFileName(@NotNull String name) {
        if (name == null) {
            TypeScriptLibraries.$$$reportNull$$$0(23);
        }
        if (!TypeScriptLibraries.isTypeScriptLibraryFile(name)) {
            String string = name;
            if (string == null) {
                TypeScriptLibraries.$$$reportNull$$$0(24);
            }
            return string;
        }
        String string = StringUtil.trimStart((String)StringUtil.trimEnd((String)name, (String)".d.ts"), (String)"lib.");
        if (string == null) {
            TypeScriptLibraries.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 11, 13, 14, 15, 16, 17, 19, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 1: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/library/TypeScriptLibraries";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllIds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLibs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibSetIfValid";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllLibs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToRefresh";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAsLibraryFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLibFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFileId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibrariesNoCache";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "includeFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "includeFileWithName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLibsForTarget";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "wrapAsLibraryFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptLibraryFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "trimLibFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 11, 13, 14, 15, 16, 17, 19, 21, 24, 25 -> new IllegalStateException(string);
        };
    }
}

