/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyTypeVisitor;
import com.jetbrains.python.psi.types.PyTypeVisitorExt;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J+\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\n\b\u0000\u0010\u0014*\u0004\u0018\u00010\u00102\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/python/psi/types/PyLiteralType;", "Lcom/jetbrains/python/psi/types/PyClassTypeImpl;", "cls", "Lcom/jetbrains/python/psi/PyClass;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "<init>", "(Lcom/jetbrains/python/psi/PyClass;Lcom/jetbrains/python/psi/PyExpression;)V", "getExpression", "()Lcom/jetbrains/python/psi/PyExpression;", "getName", "", "toString", "equals", "", "other", "", "hashCode", "", "acceptTypeVisitor", "T", "visitor", "Lcom/jetbrains/python/psi/types/PyTypeVisitor;", "(Lcom/jetbrains/python/psi/types/PyTypeVisitor;)Ljava/lang/Object;", "Companion", "intellij.python.psi.impl"})
public final class PyLiteralType
extends PyClassTypeImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PyExpression expression;

    private PyLiteralType(PyClass cls, PyExpression expression) {
        super(cls, false);
        this.expression = expression;
    }

    @NotNull
    public final PyExpression getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public String getName() {
        return "Literal[" + this.expression.getText() + "]";
    }

    @Override
    @NotNull
    public String toString() {
        return "PyLiteralType: " + this.expression.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) return false;
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.types.PyLiteralType");
        if (!Companion.match(this, (PyLiteralType)other)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return 31 * this.getPyClass().hashCode();
    }

    @Override
    @Nullable
    public <T> T acceptTypeVisitor(@NotNull PyTypeVisitor<T> visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        if (visitor2 instanceof PyTypeVisitorExt) {
            return ((PyTypeVisitorExt)visitor2).visitPyLiteralType(this);
        }
        return visitor2.visitPyClassType(this);
    }

    @JvmStatic
    @NotNull
    public static final PyLiteralType enumMember(@NotNull PyClass enumClass, @NotNull String memberName) {
        return Companion.enumMember(enumClass, memberName);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final PyType upcastLiteralToClass(@Nullable PyType type2) {
        return Companion.upcastLiteralToClass(type2);
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean isNone(@NotNull PyExpression expression) {
        return Companion.isNone(expression);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final PyType getLiteralType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
        return Companion.getLiteralType(expression, context);
    }

    public /* synthetic */ PyLiteralType(PyClass cls, PyExpression expression, DefaultConstructorMarker $constructor_marker) {
        this(cls, expression);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0007J,\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J,\u0010!\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bJ,\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010)J\u0012\u0010*\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001a\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001a\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010.\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010/\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u00100\u001a\u00020\u0015H\u0002J\"\u00101\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u00100\u001a\u00020\u0015H\u0002J\u001f\u00102\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b32\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u00104\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u0002052\u0006\u00100\u001a\u00020\u0015H\u0002\u00a8\u00066"}, d2={"Lcom/jetbrains/python/psi/types/PyLiteralType$Companion;", "", "<init>", "()V", "fromLiteralParameter", "Lcom/jetbrains/python/psi/types/PyType;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "enumMember", "Lcom/jetbrains/python/psi/types/PyLiteralType;", "enumClass", "Lcom/jetbrains/python/psi/PyClass;", "memberName", "", "upcastLiteralToClass", "type", "promoteToType", "expectedType", "inferLiteralTypes", "", "promoteDictLiteral", "dictLiteral", "Lcom/jetbrains/python/psi/PyDictLiteralExpression;", "promoteTuple", "Lcom/jetbrains/python/psi/types/PyTupleType;", "tupleExpression", "Lcom/jetbrains/python/psi/PyTupleExpression;", "promoteSetLiteral", "Lcom/jetbrains/python/psi/types/PyCollectionTypeImpl;", "setLiteral", "Lcom/jetbrains/python/psi/PySetLiteralExpression;", "promoteListLiteral", "value", "Lcom/jetbrains/python/psi/PyListLiteralExpression;", "match", "expected", "actual", "promoteToLiteral", "substitutions", "Lcom/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions;", "containsLiteral", "isNone", "createFromLiteralParameter", "getLiteralType", "getLiteralOrLiteralStringType", "literalType", "index", "classOfAcceptableLiteral", "getPyClass", "Lorg/jetbrains/annotations/NotNull;", "isAcceptableStringLiteral", "Lcom/jetbrains/python/psi/PyStringLiteralExpression;", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyLiteralType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyLiteralType.kt\ncom/jetbrains/python/psi/types/PyLiteralType$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n11476#2,9:288\n13402#2:297\n13403#2:299\n11485#2:300\n11158#2:301\n11493#2,3:302\n11476#2,9:305\n13402#2:314\n13403#2:317\n11485#2:318\n11158#2:319\n11493#2,3:320\n11158#2:323\n11493#2,3:324\n11158#2:327\n11493#2,3:328\n1#3:298\n1#3:315\n1#3:316\n1#3:343\n1#3:372\n1#3:382\n1755#4,3:331\n1755#4,3:334\n1734#4,3:337\n1557#4:340\n1628#4,2:341\n1630#4:344\n808#4,11:345\n1368#4:356\n1454#4,5:357\n1611#4,9:362\n1863#4:371\n1864#4:373\n1620#4:374\n1557#4:375\n1628#4,3:376\n1734#4,3:379\n*S KotlinDebug\n*F\n+ 1 PyLiteralType.kt\ncom/jetbrains/python/psi/types/PyLiteralType$Companion\n*L\n46#1:288,9\n46#1:297\n46#1:299\n46#1:300\n117#1:301\n117#1:302,3\n119#1:305,9\n119#1:314\n119#1:317\n119#1:318\n129#1:319\n129#1:320,3\n145#1:323\n145#1:324,3\n161#1:327\n161#1:328,3\n46#1:298\n119#1:316\n236#1:372\n194#1:331,3\n195#1:334,3\n212#1:337,3\n223#1:340\n223#1:341,2\n223#1:344\n234#1:345,11\n235#1:356\n235#1:357,5\n236#1:362,9\n236#1:371\n236#1:373\n236#1:374\n237#1:375\n237#1:376,3\n238#1:379,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final PyType fromLiteralParameter(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
            PyType pyType;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (expression instanceof PyTupleExpression) {
                void $this$mapNotNullTo$iv$iv;
                PyExpression[] elements;
                PyAstExpression[] pyAstExpressionArray = ((PyTupleExpression)expression).getElements();
                Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
                PyExpression[] $this$mapNotNull$iv = elements = (PyExpression[])pyAstExpressionArray;
                boolean $i$f$mapNotNull = false;
                PyExpression[] pyExpressionArray = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    PyType it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (Companion.createFromLiteralParameter((PyExpression)it, context) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List classes = (List)destination$iv$iv;
                pyType = elements.length == classes.size() ? PyUnionType.union(classes) : null;
            } else {
                pyType = this.createFromLiteralParameter(expression, context);
            }
            return pyType;
        }

        @JvmStatic
        @NotNull
        public final PyLiteralType enumMember(@NotNull PyClass enumClass, @NotNull String memberName) {
            Intrinsics.checkNotNullParameter((Object)enumClass, (String)"enumClass");
            Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
            PyExpression pyExpression = PyElementGenerator.getInstance(enumClass.getProject()).createExpressionFromText(LanguageLevel.forElement((PsiElement)enumClass), enumClass.getName() + "." + memberName);
            Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"createExpressionFromText(...)");
            PyExpression expression = pyExpression;
            boolean bl = expression instanceof PyReferenceExpression;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return new PyLiteralType(enumClass, expression, null);
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final PyType upcastLiteralToClass(@Nullable PyType type2) {
            PyType pyType = type2;
            return pyType instanceof PyUnionType ? ((PyUnionType)type2).map(this::upcastLiteralToClass) : (pyType instanceof PyLiteralStringType ? (PyType)new PyClassTypeImpl(((PyLiteralStringType)type2).getCls(), false) : (pyType instanceof PyLiteralType ? (PyType)new PyClassTypeImpl(((PyLiteralType)type2).getPyClass(), false) : type2));
        }

        private final PyType promoteToType(PyType expectedType, PyExpression expression, TypeEvalContext context, boolean inferLiteralTypes) {
            PyType pyType;
            PyExpression pyExpression = PyUtil.peelArgument(expression);
            if (pyExpression == null) {
                return null;
            }
            PyExpression value = pyExpression;
            PyExpression pyExpression2 = value;
            if (pyExpression2 instanceof PyDictLiteralExpression) {
                pyType = this.promoteDictLiteral(expectedType, (PyDictLiteralExpression)value, context, inferLiteralTypes);
            } else if (pyExpression2 instanceof PyTupleExpression) {
                pyType = this.promoteTuple((PyTupleExpression)value, context, inferLiteralTypes);
            } else if (pyExpression2 instanceof PySetLiteralExpression) {
                pyType = this.promoteSetLiteral(expectedType, (PySetLiteralExpression)value, context, inferLiteralTypes);
            } else if (pyExpression2 instanceof PyListLiteralExpression) {
                pyType = this.promoteListLiteral(expectedType, (PyListLiteralExpression)value, context, inferLiteralTypes);
            } else {
                PyType type2 = inferLiteralTypes ? this.getLiteralOrLiteralStringType(value, context) : null;
                PyType pyType2 = type2;
                if (pyType2 == null) {
                    pyType2 = context.getType(value);
                }
                return pyType2;
            }
            return pyType;
        }

        /*
         * WARNING - void declaration
         */
        private final PyType promoteDictLiteral(PyType expectedType, PyDictLiteralExpression dictLiteral, TypeEvalContext context, boolean inferLiteralTypes) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            if (expectedType instanceof PyTypedDictType) {
                PyTypedDictType.TypeCheckingResult typeCheckingResult = new PyTypedDictType.TypeCheckingResult();
                PyTypedDictType.Companion.checkExpression((PyTypedDictType)expectedType, dictLiteral, context, typeCheckingResult);
                if (!typeCheckingResult.getHasErrors()) {
                    return expectedType;
                }
            }
            Pair pair = expectedType instanceof PyCollectionType && Intrinsics.areEqual((Object)((PyCollectionType)expectedType).getClassQName(), (Object)"dict") ? TuplesKt.to((Object)((PyCollectionType)expectedType).getElementTypes().get(0), (Object)((PyCollectionType)expectedType).getElementTypes().get(1)) : TuplesKt.to(null, null);
            PyType expectedKeyType = (PyType)pair.component1();
            PyType expectedValueType = (PyType)pair.component2();
            PyKeyValueExpression[] pyKeyValueExpressionArray = dictLiteral.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"getElements(...)");
            Object[] $this$map$iv = pyKeyValueExpressionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Object[] destination$iv$iv = (Object[])new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyKeyValueExpression pyKeyValueExpression = (PyKeyValueExpression)item$iv$iv;
                Object[] objectArray2 = destination$iv$iv;
                boolean bl = false;
                PyExpression pyExpression = it.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)pyExpression, (String)"getKey(...)");
                objectArray2.add(Companion.promoteToType(expectedKeyType, pyExpression, context, inferLiteralTypes));
            }
            PyType keyType = PyUnionType.union((List)destination$iv$iv);
            PyKeyValueExpression[] pyKeyValueExpressionArray2 = dictLiteral.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray2, (String)"getElements(...)");
            Object[] $this$mapNotNull$iv = pyKeyValueExpressionArray2;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PyType pyType;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                PyKeyValueExpression type2 = (PyKeyValueExpression)element$iv$iv;
                boolean bl2 = false;
                if (type2.getValue() != null) {
                    PyExpression it;
                    boolean bl3 = false;
                    pyType = Companion.promoteToType(expectedValueType, it, context, inferLiteralTypes);
                } else {
                    pyType = null;
                }
                if (pyType == null) continue;
                PyType it$iv$iv = pyType;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            PyType valueType = PyUnionType.union((List)destination$iv$iv2);
            Object[] objectArray3 = new PyType[]{keyType, valueType};
            return PyCollectionTypeImpl.createTypeByQName((PsiElement)dictLiteral, "dict", false, CollectionsKt.listOf((Object[])objectArray3));
        }

        /*
         * WARNING - void declaration
         */
        private final PyTupleType promoteTuple(PyTupleExpression tupleExpression, TypeEvalContext context, boolean inferLiteralTypes) {
            void $this$mapTo$iv$iv;
            PyAstExpression[] pyAstExpressionArray = tupleExpression.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
            Object[] $this$map$iv = pyAstExpressionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyExpression pyExpression = (PyExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(Companion.promoteToType(null, (PyExpression)it, context, inferLiteralTypes));
            }
            List elementTypes = (List)destination$iv$iv;
            return PyTupleType.create((PsiElement)tupleExpression, elementTypes);
        }

        /*
         * WARNING - void declaration
         */
        private final PyCollectionTypeImpl promoteSetLiteral(PyType expectedType, PySetLiteralExpression setLiteral, TypeEvalContext context, boolean inferLiteralTypes) {
            void $this$mapTo$iv$iv;
            PyType pyType;
            if (expectedType instanceof PyCollectionType && Intrinsics.areEqual((Object)((PyCollectionType)expectedType).getClassQName(), (Object)"set")) {
                List<PyType> list = ((PyCollectionType)expectedType).getElementTypes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
                pyType = (PyType)CollectionsKt.firstOrNull(list);
            } else {
                pyType = null;
            }
            PyType expectedElementType = pyType;
            PyAstExpression[] pyAstExpressionArray = setLiteral.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
            Object[] $this$map$iv = pyAstExpressionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyExpression pyExpression = (PyExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(Companion.promoteToType(expectedElementType, (PyExpression)it, context, inferLiteralTypes));
            }
            PyType elementType = PyUnionType.union((List)destination$iv$iv);
            return PyCollectionTypeImpl.createTypeByQName((PsiElement)setLiteral, "set", false, CollectionsKt.listOf((Object)elementType));
        }

        /*
         * WARNING - void declaration
         */
        private final PyCollectionTypeImpl promoteListLiteral(PyType expectedType, PyListLiteralExpression value, TypeEvalContext context, boolean inferLiteralTypes) {
            void $this$mapTo$iv$iv;
            PyType pyType;
            if (expectedType instanceof PyCollectionType && Intrinsics.areEqual((Object)((PyCollectionType)expectedType).getClassQName(), (Object)"list")) {
                List<PyType> list = ((PyCollectionType)expectedType).getElementTypes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
                pyType = (PyType)CollectionsKt.firstOrNull(list);
            } else {
                pyType = null;
            }
            PyType expectedElementType = pyType;
            PyAstExpression[] pyAstExpressionArray = value.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
            Object[] $this$map$iv = pyAstExpressionArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyExpression pyExpression = (PyExpression)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(Companion.promoteToType(expectedElementType, (PyExpression)it, context, inferLiteralTypes));
            }
            PyType elementType = PyUnionType.union((List)destination$iv$iv);
            return PyCollectionTypeImpl.createTypeByQName((PsiElement)value, "list", false, CollectionsKt.listOf((Object)elementType));
        }

        public final boolean match(@NotNull PyLiteralType expected, @NotNull PyLiteralType actual) {
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
            if (!Intrinsics.areEqual((Object)expected.getPyClass(), (Object)actual.getPyClass())) {
                return false;
            }
            if (expected.getExpression() instanceof PyReferenceExpression && actual.getExpression() instanceof PyReferenceExpression) {
                return Intrinsics.areEqual((Object)((PyReferenceExpression)expected.getExpression()).getName(), (Object)((PyReferenceExpression)actual.getExpression()).getName());
            }
            return Intrinsics.areEqual((Object)PyEvaluator.evaluateNoResolve(expected.getExpression(), Object.class), (Object)PyEvaluator.evaluateNoResolve(actual.getExpression(), Object.class));
        }

        @Nullable
        public final PyType promoteToLiteral(@NotNull PyExpression expression, @Nullable PyType expected, @NotNull TypeEvalContext context, @Nullable PyTypeChecker.GenericSubstitutions substitutions) {
            PyType substitutionOrBound;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PyTypeChecker.GenericSubstitutions genericSubstitutions = substitutions;
            PyType substitution = genericSubstitutions != null ? PyTypeChecker.substitute(expected, genericSubstitutions, context) : expected;
            PyType pyType = substitutionOrBound = substitution instanceof PyTypeVarType ? PyTypeUtil.getEffectiveBound((PyTypeVarType)substitution) : substitution;
            if (substitutionOrBound == null) {
                return null;
            }
            return this.promoteToType(substitutionOrBound, expression, context, this.containsLiteral(substitutionOrBound));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean containsLiteral(PyType type2) {
            PyType it;
            boolean $i$f$any;
            Iterable $this$any$iv;
            if (type2 instanceof PyLiteralType) return true;
            if (type2 instanceof PyLiteralStringType) return true;
            if (type2 instanceof PyUnionType) {
                boolean bl;
                Collection<PyType> collection = ((PyUnionType)type2).getMembers();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getMembers(...)");
                $this$any$iv = collection;
                $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PyType)element$iv;
                        boolean bl2 = false;
                        if (!Companion.containsLiteral(it)) continue;
                        return true;
                    }
                    bl = false;
                }
                if (bl) return true;
            }
            if (!(type2 instanceof PyCollectionType)) return false;
            List<PyType> list = ((PyCollectionType)type2).getElementTypes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
            $this$any$iv = list;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return false;
                element$iv = iterator.next();
                it = (PyType)element$iv;
                boolean bl = false;
            } while (!Companion.containsLiteral(it));
            return true;
        }

        @JvmStatic
        @ApiStatus.Internal
        public final boolean isNone(@NotNull PyExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            return expression instanceof PyNoneLiteralExpression && !((PyNoneLiteralExpression)expression).isEllipsis() || expression instanceof PyReferenceExpression && Intrinsics.areEqual((Object)((PyReferenceExpression)expression).getName(), (Object)"None") && LanguageLevel.forElement((PsiElement)((PsiElement)expression)).isPython2();
        }

        private final PyType createFromLiteralParameter(PyExpression expression, TypeEvalContext context) {
            if (this.isNone(expression)) {
                return PyNoneType.INSTANCE;
            }
            if (expression instanceof PyReferenceExpression || expression instanceof PySubscriptionExpression) {
                boolean bl;
                PyType subLiteralType;
                block6: {
                    subLiteralType = (PyType)Ref.deref(PyTypingTypeProvider.getType(expression, context));
                    StreamEx<PyType> streamEx = PyTypeUtil.toStream(subLiteralType);
                    Intrinsics.checkNotNullExpressionValue(streamEx, (String)"toStream(...)");
                    Iterable $this$all$iv = (Iterable)streamEx;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PyType it = (PyType)element$iv;
                            boolean bl2 = false;
                            if (it instanceof PyLiteralType) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return subLiteralType;
                }
            }
            return this.literalType(expression, context, true);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final PyType getLiteralType(@NotNull PyExpression expression, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (expression instanceof PyConditionalExpression) {
                void $this$mapTo$iv$iv;
                Object[] objectArray = new PyExpression[]{((PyConditionalExpression)expression).getTruePart(), ((PyConditionalExpression)expression).getFalsePart()};
                Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PyType pyType;
                    void it;
                    PyExpression pyExpression = (PyExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (it != null) {
                        void it2;
                        boolean bl2 = false;
                        pyType = Companion.getLiteralType((PyExpression)it2, context);
                    } else {
                        pyType = null;
                    }
                    collection.add(pyType);
                }
                return PyUnionType.union((List)destination$iv$iv);
            }
            return this.literalType(expression, context, false);
        }

        /*
         * WARNING - void declaration
         */
        private final PyType getLiteralOrLiteralStringType(PyExpression expression, TypeEvalContext context) {
            if (expression instanceof PyStringLiteralExpression && ((PyStringLiteralExpression)expression).isInterpolated()) {
                boolean allLiteralStringFragments;
                block9: {
                    void $this$all$iv;
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object list$iv$iv;
                    PyFormattedStringElement it;
                    void $this$flatMapTo$iv$iv;
                    Iterable $this$flatMap$iv;
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv;
                    List<PyStringElement> list = ((PyStringLiteralExpression)expression).getStringElements();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getStringElements(...)");
                    Iterable iterable = list;
                    boolean $i$f$filterIsInstance = false;
                    Iterator iterator = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof PyFormattedStringElement)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$flatMap = false;
                    $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (PyFormattedStringElement)element$iv$iv;
                        boolean bl = false;
                        List<PyFStringFragment> list2 = it.getFragments();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFragments(...)");
                        list$iv$iv = list2;
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    list$iv$iv = $this$forEach$iv$iv$iv.iterator();
                    while (list$iv$iv.hasNext()) {
                        PyExpression it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = list$iv$iv.next();
                        boolean bl = false;
                        PyFStringFragment it2 = (PyFStringFragment)element$iv$iv;
                        boolean bl2 = false;
                        if (it2.getExpression() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    $this$mapNotNullTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        list$iv$iv = (PyExpression)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(context.getType((PyTypedElement)((Object)it)));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        v2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PyType it3 = (PyType)element$iv;
                            boolean bl = false;
                            if (it3 instanceof PyLiteralStringType) continue;
                            v2 = false;
                            break block9;
                        }
                        v2 = allLiteralStringFragments = true;
                    }
                }
                if (allLiteralStringFragments) {
                    return PyLiteralStringType.Companion.create((PsiElement)expression);
                }
            }
            return this.getLiteralType(expression, context);
        }

        private final PyLiteralType literalType(PyExpression expression, TypeEvalContext context, boolean index) {
            PyLiteralType pyLiteralType;
            if (expression instanceof PyReferenceExpression && ((PyReferenceExpression)expression).isQualified()) {
                Object type2;
                block5: {
                    Object object;
                    List<PsiElement> list = PyUtil.multiResolveTopPriority((PsiElement)expression, PyResolveContext.defaultContext(context));
                    Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveTopPriority(...)");
                    for (Object it : (Iterable)list) {
                        boolean bl = false;
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNull((Object)psiElement);
                        it = PyStdlibTypeProvider.getEnumMemberType(psiElement, context);
                        if (it == null) continue;
                        object = it;
                        break block5;
                    }
                    object = type2 = null;
                }
                if (type2 != null) {
                    return type2;
                }
            }
            PyClass pyClass = this.classOfAcceptableLiteral(expression, context, index);
            if (pyClass != null) {
                PyClass it = pyClass;
                boolean bl = false;
                pyLiteralType = new PyLiteralType(it, expression, null);
            } else {
                pyLiteralType = null;
            }
            return pyLiteralType;
        }

        private final PyClass classOfAcceptableLiteral(PyExpression expression, TypeEvalContext context, boolean index) {
            PyExpression operand;
            PyClass pyClass = expression instanceof PyNumericLiteralExpression ? (((PyNumericLiteralExpression)expression).isIntegerLiteral() ? this.getPyClass(expression, context) : null) : (expression instanceof PyStringLiteralExpression ? (this.isAcceptableStringLiteral((PyStringLiteralExpression)expression, index) ? this.getPyClass(expression, context) : null) : (expression instanceof PyLiteralExpression ? this.getPyClass(expression, context) : (expression instanceof PyPrefixExpression && (Intrinsics.areEqual((Object)((PyPrefixExpression)expression).getOperator(), (Object)PyTokenTypes.PLUS) || Intrinsics.areEqual((Object)((PyPrefixExpression)expression).getOperator(), (Object)PyTokenTypes.MINUS)) ? ((operand = ((PyPrefixExpression)expression).getOperand()) instanceof PyNumericLiteralExpression && ((PyNumericLiteralExpression)operand).isIntegerLiteral() ? this.getPyClass(operand, context) : null) : (PyEvaluator.getBooleanLiteralValue((PsiElement)expression) != null ? this.getPyClass(expression, context) : null))));
            return pyClass;
        }

        private final PyClass getPyClass(PyExpression expression, TypeEvalContext context) {
            PyType pyType = context.getType(expression);
            PyClassType pyClassType = pyType instanceof PyClassType ? (PyClassType)pyType : null;
            return pyClassType != null ? pyClassType.getPyClass() : null;
        }

        private final boolean isAcceptableStringLiteral(PyStringLiteralExpression expression, boolean index) {
            List<PyStringElement> list = expression.getStringElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStringElements(...)");
            PyStringElement pyStringElement = (PyStringElement)CollectionsKt.singleOrNull(list);
            if (pyStringElement == null) {
                return false;
            }
            PyStringElement singleElement = pyStringElement;
            return !index && singleElement instanceof PyFormattedStringElement ? ((PyFormattedStringElement)singleElement).getFragments().isEmpty() : singleElement instanceof PyPlainStringElement;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

