/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyTypeUtil {
    private PyTypeUtil() {
    }

    @NotNull
    public static <T extends PsiElement> List<T> getMembersOfType(@NotNull PyClassLikeType type2, @NotNull Class<T> expectedMemberType, boolean inherited, @NotNull TypeEvalContext context) {
        if (type2 == null) {
            PyTypeUtil.$$$reportNull$$$0(0);
        }
        if (expectedMemberType == null) {
            PyTypeUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(2);
        }
        ArrayList result2 = new ArrayList();
        type2.visitMembers((Processor<? super PsiElement>)((Processor)t -> {
            if (expectedMemberType.isInstance(t)) {
                PsiElement castedElement = t;
                result2.add(castedElement);
            }
            return true;
        }), inherited, context);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            PyTypeUtil.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T findData(@NotNull PyType type2, @NotNull Key<T> key) {
        if (type2 == null) {
            PyTypeUtil.$$$reportNull$$$0(4);
        }
        if (key == null) {
            PyTypeUtil.$$$reportNull$$$0(5);
        }
        if (type2 instanceof UserDataHolder) {
            return (T)((UserDataHolder)type2).getUserData(key);
        }
        if (type2 instanceof PyUnionType) {
            for (PyType memberType : ((PyUnionType)type2).getMembers()) {
                T result2;
                if (memberType == null || (result2 = PyTypeUtil.findData(memberType, key)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    @Nullable
    public static PyTupleType toPositionalContainerType(@NotNull PsiElement anchor, @Nullable PyType elementType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(6);
        }
        if (elementType instanceof PyUnpackedTupleTypeImpl) {
            PyUnpackedTupleTypeImpl unpackedTupleType = (PyUnpackedTupleTypeImpl)elementType;
            return unpackedTupleType.asTupleType(anchor);
        }
        if (elementType instanceof PyTypeVarTupleType) {
            return PyTupleType.create(anchor, Collections.singletonList(elementType));
        }
        return PyTupleType.createHomogeneous(anchor, elementType);
    }

    @Nullable
    public static PyCollectionType toKeywordContainerType(@NotNull PsiElement anchor, @Nullable PyType valueType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(7);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(anchor);
        return Optional.ofNullable(builtinCache.getDictType()).map(PyClassType::getPyClass).map(dictClass -> new PyCollectionTypeImpl((PyClass)dictClass, false, (List<? extends PyType>)Arrays.asList(builtinCache.getStrType(), valueType))).orElse(null);
    }

    @NotNull
    public static StreamEx<PyType> toStream(@Nullable PyType type2) {
        if (type2 instanceof PyUnionType) {
            StreamEx streamEx = StreamEx.of(((PyUnionType)type2).getMembers());
            if (streamEx == null) {
                PyTypeUtil.$$$reportNull$$$0(8);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Object)type2);
        if (streamEx == null) {
            PyTypeUtil.$$$reportNull$$$0(9);
        }
        return streamEx;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static Ref<PyType> notNullToRef(@Nullable PyType type2) {
        return type2 == null ? null : Ref.create((Object)type2);
    }

    @NotNull
    public static Collector<Ref<PyType>, ?, Ref<PyType>> toUnionFromRef() {
        Collector<Object, ?, Object> collector = Collectors.reducing(null, (accType, hintType) -> {
            if (hintType == null) {
                return accType;
            }
            if (accType == null) {
                return hintType;
            }
            return Ref.create((Object)PyUnionType.union((PyType)accType.get(), (PyType)hintType.get()));
        });
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(10);
        }
        return collector;
    }

    public static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toUnion() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), PyUnionType::union);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(11);
        }
        return collector;
    }

    public static boolean isDict(@Nullable PyType type2) {
        return type2 instanceof PyCollectionType && "dict".equals(type2.getName());
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType getEffectiveBound(@NotNull PyTypeVarType typeVarType) {
        if (typeVarType == null) {
            PyTypeUtil.$$$reportNull$$$0(12);
        }
        return typeVarType.getConstraints().isEmpty() ? typeVarType.getBound() : PyUnionType.union(typeVarType.getConstraints());
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType convertToType(@Nullable PyType type2, @NotNull String superTypeName, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyClass superClass;
        if (superTypeName == null) {
            PyTypeUtil.$$$reportNull$$$0(13);
        }
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(15);
        }
        if ((superClass = PyPsiFacade.getInstance(anchor.getProject()).createClassByQName(superTypeName, anchor)) == null) {
            return null;
        }
        PyClassType superClassType = (PyClassType)ObjectUtils.notNull((Object)PyTypeChecker.findGenericDefinitionType(superClass, context), (Object)new PyClassTypeImpl(superClass, false));
        return PyTypeChecker.convertToType(type2, superClassType, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMemberType";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersOfType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnionFromRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMembersOfType";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toPositionalContainerType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toKeywordContainerType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveBound";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertToType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

