/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPrefixExpression;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public final class PyAsyncAwaitAnnotator
extends PyAnnotator {
    @Override
    public void visitPyPrefixExpression(@NotNull PyPrefixExpression node) {
        PyFunction pyFunction;
        ScopeOwner scopeOwner;
        if (node == null) {
            PyAsyncAwaitAnnotator.$$$reportNull$$$0(0);
        }
        super.visitPyPrefixExpression(node);
        if (!(node.getOperator() != PyTokenTypes.AWAIT_KEYWORD || (scopeOwner = ScopeUtil.getScopeOwner((PsiElement)node)) instanceof PyFunction && (pyFunction = (PyFunction)scopeOwner).isAsync())) {
            AnnotationBuilder annotation = this.getHolder().newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.await.outside.async.function", new Object[0])).range(node.getFirstChild());
            if (scopeOwner instanceof PyFunction) {
                PyFunction pyFunction2 = (PyFunction)scopeOwner;
                annotation = annotation.newFix((CommonIntentionAction)new ConvertIntoAsyncFunctionFix(pyFunction2)).registerFix();
            }
            annotation.create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/validation/PyAsyncAwaitAnnotator", "visitPyPrefixExpression"));
    }

    private static class ConvertIntoAsyncFunctionFix
    extends PsiUpdateModCommandAction<PyFunction> {
        protected ConvertIntoAsyncFunctionFix(@NotNull PyFunction element) {
            if (element == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PyFunction element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(3);
            }
            ASTNode defKeyword = element.getNode().findChildByType((IElementType)PyTokenTypes.DEF_KEYWORD);
            element.getNode().addLeaf((IElementType)PyTokenTypes.ASYNC_KEYWORD, (CharSequence)"async ", defKeyword);
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("QFIX.convert.into.async.function", new Object[0]);
            if (string == null) {
                ConvertIntoAsyncFunctionFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/validation/PyAsyncAwaitAnnotator$ConvertIntoAsyncFunctionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/validation/PyAsyncAwaitAnnotator$ConvertIntoAsyncFunctionFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

