/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ui.BundleAccessor;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshConfigProjectLevelSetupForm {
    private static final Logger LOG = Logger.getInstance(SshConfigProjectLevelSetupForm.class);
    private JPanel myMainPanel;
    private JPanel myProjectLevelSshConfigSetupPanel;
    private HyperlinkLabel mySshLevelWarningLabel;
    private HyperlinkLabel myMoveSshConfigLink;
    private HyperlinkLabel myMoveInterpreterLink;
    @Nullable
    private Project myProject;
    @NotNull
    private final Listener myListener;
    @Nullable
    private String mySshConfigName;
    @Nullable
    private final BundleAccessor myBundleAccessor;
    @NotNull
    private final SdkScopeController mySdkScopeController;

    public SshConfigProjectLevelSetupForm(@Nullable Project project, @Nullable BundleAccessor bundleAccessor, @NotNull Listener listener, @NotNull SdkScopeController sdkScopeController) {
        if (listener == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(0);
        }
        if (sdkScopeController == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myBundleAccessor = bundleAccessor;
        this.myListener = listener;
        this.mySdkScopeController = sdkScopeController;
        this.$$$setupUI$$$();
        this.myProjectLevelSshConfigSetupPanel.setBorder((Border)JBUI.Borders.emptyTop((int)JBUIScale.scale((int)10)));
        this.configureSshLevelWarning();
        this.configureMoveSshConfigAction(bundleAccessor);
        this.configureMoveInterpreterAction(sdkScopeController.isProjectLevelSupported());
    }

    private void configureSshLevelWarning() {
        String warningMessage;
        String customMessage;
        String string = customMessage = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.ssh.level.incompatibility", new Object[0]);
        if (customMessage != null) {
            warningMessage = customMessage;
        } else {
            String message = this.myBundleAccessor == null ? null : this.myBundleAccessor.messageOrNull("remote.interpreter.entity.name", new Object[0]);
            warningMessage = RemoteSdkBundle.message("0.is.saved.in.a.href.ide.settings.a.so.it.needs.the.ssh.config.to.be.saved.there.too", StringUtil.notNullize((String)message, (String)RemoteSdkBundle.message("remote.sdk", new Object[0])));
        }
        this.mySshLevelWarningLabel.setHtmlText(warningMessage);
        this.mySshLevelWarningLabel.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HelpManager.getInstance().invokeHelp("concepts.project.settings");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm$1", "hyperlinkActivated"));
            }
        });
    }

    private void configureMoveSshConfigAction(@Nullable BundleAccessor bundleAccessor) {
        this.myMoveSshConfigLink.setToolTipText(RemoteSdkBundle.message("ssh.config.will.be.visible.for.all.projects", new Object[0]));
        this.myMoveSshConfigLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                SshConfigManager instance = SshConfigManager.getInstance((Project)SshConfigProjectLevelSetupForm.this.myProject);
                SshUiData data = instance.findCurrentDataByName(SshConfigProjectLevelSetupForm.this.mySshConfigName);
                LOG.assertTrue(data != null, (Object)("SSH configuration with name " + SshConfigProjectLevelSetupForm.this.mySshConfigName + " not found"));
                LOG.assertTrue(data.getConfig().isProjectLevel(), (Object)"IDE-level SSH configuration with actions shown");
                SshUiData movedData = instance.moveDataConfig(data);
                SshConfigProjectLevelSetupForm.this.myListener.onConfigMoved(movedData.getConfig());
            }
        });
        String moveSshMessage = null;
        if (bundleAccessor != null) {
            moveSshMessage = bundleAccessor.messageOrNull("remote.interpreter.move.ssh.config.hyperlink.label", new Object[0]);
        }
        moveSshMessage = StringUtil.notNullize((String)moveSshMessage, (String)RemoteSdkBundle.message("move.config.to.app.level.label", new Object[0]));
        this.myMoveSshConfigLink.setHtmlText(moveSshMessage);
    }

    private void configureMoveInterpreterAction(boolean isProjectLevelInterpreterSupported) {
        this.myMoveInterpreterLink.setVisible(isProjectLevelInterpreterSupported);
        if (!isProjectLevelInterpreterSupported) {
            return;
        }
        this.myMoveInterpreterLink.addHyperlinkListener(e -> this.mySdkScopeController.setProjectLevel(true));
        this.myMoveInterpreterLink.setToolTipText(RemoteSdkBundle.message("remote.interpreter.move.interpreter.tooltip", new Object[0]));
        this.myMoveInterpreterLink.setHtmlText(RemoteSdkBundle.message("remote.interpreter.move.interpreter.to.app.level.label", new Object[0]));
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshConfigProjectLevelSetupForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void setSshConfigName(@Nullable String sshConfigName) {
        this.mySshConfigName = sshConfigName;
    }

    public void setProject(@Nullable Project project) {
        this.myProject = project;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel hyperlinkLabel2;
        HyperlinkLabel hyperlinkLabel3;
        JPanel jPanel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myProjectLevelSshConfigSetupPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        this.myMoveSshConfigLink = hyperlinkLabel3 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMoveInterpreterLink = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel.add((Component)hyperlinkLabel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySshLevelWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        hyperlinkLabel.setText("");
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkScopeController";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/SshConfigProjectLevelSetupForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static interface Listener {
        public void onConfigMoved(@NotNull SshConfig var1);
    }
}

